/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pxrend.h,v 1.2.22.1 2004/07/09 01:51:43 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PXREND_H
#define PXREND_H

// Forward declarations
typedef _INTERFACE IHXValues       IHXValues;
typedef _INTERFACE IHXPacket       IHXPacket;
typedef _INTERFACE IHXBuffer       IHXBuffer;
typedef _INTERFACE IHXVideoSurface IHXVideoSurface;
typedef _INTERFACE IHXDrawFocus    IHXDrawFocus;
class PXRenderCodecManager;
class PXImageManager;
class PXEffectsManager;
class PXWireFormatManager;
class PXHyperlinkManager;
class PXEffectsPackageManager;
class PXCallback;


class CRealPixRenderer : public CRNVisualBaseRenderer,
                         public PXCallbackResponse,
                         public IHXFocusNavigation
{
public:
    CRealPixRenderer();
    virtual ~CRealPixRenderer();

    // IUnknown Methods
    STDMETHOD (QueryInterface)  (THIS_ REFIID ID, void** ppObj);
    STDMETHOD_(UINT32, AddRef)  (THIS);
    STDMETHOD_(UINT32, Release) (THIS);

    // Methods required for CRNBaseRenderer
    STDMETHOD(OnHeader)         (THIS_ IHXValues *pHeader);
    STDMETHOD(OnPacketNoOffset) (THIS_ IHXPacket *pPacket);
    STDMETHOD(OnTimeSyncOffset) (THIS_ UINT32 ulTime);
    
    // CRNBaseRenderer methods we will override
    STDMETHOD(OnPreSeek)        (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime);
    STDMETHOD(OnPostSeek)       (THIS_ ULONG32 ulOldTime, ULONG32 ulNewTime);
    STDMETHOD(EndStream)        (THIS);

    // Methods required for CRNVisualBaseRenderer
    STDMETHOD(GetWindowSize)         (THIS_ REF(HXxSize) rSize);
    STDMETHOD(IsMouseOverActiveLink) (THIS_ INT16 x, INT16 y, REF(BOOL) rbActive, REF(IHXBuffer*) rpLink);
    STDMETHOD(RMASurfaceUpdate)      (THIS_ IHXVideoSurface* pSurface);
    STDMETHOD(HandleClick)           (THIS_ INT16 x, INT16 y);

    // CRNVisualBaseRenderer methods we will override
    STDMETHOD(DetachSite)            (THIS);
#if 0 // XXXMEH - for testing
    STDMETHOD(HandleEvent)           (THIS_ HXxEvent *pEvent);
#endif

    // PXCallbackResponse methods
    STDMETHOD(HandleCallback) (THIS_ UINT32 ulSchedulerTime,
                                     UINT32 ulInstance);

    // IHXFocusNavigation methods
    STDMETHOD(SetFocus)                    (THIS_ HXFocusContext eFocus);
    STDMETHOD(ClearFocus)                  (THIS);
    STDMETHOD(ActivateFocus)               (THIS);
    STDMETHOD_(HXFocusState,GetFocusState) (THIS);

    // CRealPixRenderer methods
    static HX_RESULT STDAPICALLTYPE HXCreateInstance(IUnknown** ppIUnknown);
protected:
    enum
    {
        kCallbackInterval    = 50,
#ifdef _WINDOWS
        kDefaultRowsInverted = TRUE
#else
        kDefaultRowsInverted = FALSE
#endif
    };

    PXRenderCodecManager*    m_pCodecManager;
    PXImageManager*          m_pImageManager;
    PXEffectsManager*        m_pEffectsManager;
    PXWireFormatManager*     m_pWireFormatManager;
    PXHyperlinkManager*      m_pHyperlinkManager;
    PXEffectsPackageManager* m_pEffectsPackageManager;
    PXCallback*              m_pCallback;
    IHXDrawFocus*            m_pDrawFocus;
    BOOL                     m_bPaused;
    BOOL                     m_bSeeking;
    UINT32                   m_ulPerformanceScale;
    UINT32                   m_ulPerformanceAdjustedDelay;
    UINT32                   m_ulLastDrawTime;
    BOOL                     m_bIsLive;
    BOOL                     m_bBltSubRects;

    void                     Reset();
    void                     Deallocate();
    HX_RESULT                CreateObjects();
    HX_RESULT                SetupObjects(IHXValues* pHeader);
    HX_RESULT                SetupCodecsAndFXPackages();
    HX_RESULT                UpdateDisplay(UINT32 ulTime);
    BOOL                     IsStreamLive();
    virtual HX_RESULT RMASurfaceUpdate2(IHXSubRectVideoSurface* pSurface,
                                        HXxRect*                 pExtens,
                                        HXxBoxRegion*              pDirtyRegion);
    virtual void      _AttachSite();

    STDMETHOD(GetName)                                   (THIS_ REF(const char*) rpszName);
    STDMETHOD(GetDescription)                            (THIS_ REF(const char*) rpszDescription);
    STDMETHOD(GetMimeTypes)                              (THIS_ REF(const char**) rppszMimeType);
    STDMETHOD_(UINT32,GetPluginVersion)                  (THIS);
    STDMETHOD_(UINT32,GetHighestSupportedContentVersion) (THIS);
    STDMETHOD_(UINT32,GetHighestSupportedStreamVersion)  (THIS);

    static const char* m_pszName;
    static const char* m_pszDescription;
    static const char* m_ppszMimeType[];
};

#endif

