/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: imagemgr.h,v 1.1.24.1 2004/07/09 01:51:43 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _IMAGEMGR_H
#define _IMAGEMGR_H

class PXImageManager : public CHXBaseCountingObject,
                       public CUnknownIMP
{
    DECLARE_UNKNOWN(PXImageManager)
public:
    HX_RESULT        Init(PXRenderCodecManager* pCodecMgr,
                          IHXErrorMessages*    pErrorMessages,
                          UINT32 ulW, UINT32 ulH,
                          UINT32 ulBpp, UINT32 ulFormat, BOOL bInvert,
                          UINT32 ulBackgroundColor, UINT32 ulBackgroundOpacity);
    HX_RESULT        CreateImage(UINT32 ulHandle, UINT32 ulLength, const char* pszMimeType,
                                 UINT32 ulOpaqueSize);
    HX_RESULT        DeleteImage(UINT32 ulHandle);
    HX_RESULT        OnImageDataPacket(UINT32 ulHandle, IHXBuffer* pOpaque, IHXBuffer* pData);
    void             ReleasePresentationImages();
    HX_RESULT        GetImage(UINT32 ulHandle, PXImage** ppImage) const;
    HX_RESULT        IsImagePresent(UINT32 ulHandle, BOOL* pbPresent) const;
    BOOL             IsImagePresent(UINT32 ulHandle) const;
    HX_RESULT        IsImageCompletelyDecoded(UINT32 ulHandle, BOOL* pbComplete);
    HX_RESULT        GetNumImages(UINT32* pulNumImages) const;
    UINT32           GetNumImages() const;
    HX_RESULT        GetImageHelper(UINT32 ulHandle, PXImageHelper** ppHelper);
    HX_RESULT        GetDisplayImage(PXImage** ppImage);
    HX_RESULT        GetDisplaySubImage(PXImage** ppImage, UINT32 ulX = 0, UINT32 ulY = 0,
                                        UINT32 ulW = 0, UINT32 ulH = 0, BOOL bCopy = FALSE);
    HX_RESULT        GetDisplaySubImage(PXImage** ppImage, const PXRect& rSubRect, BOOL bCopy = FALSE);
    HX_RESULT        GetDisplaySubImage(PXImage** ppImage, const HXxRect& rSubRect, BOOL bCopy = FALSE);
    HX_RESULT        GetPresentationSubImage(PXImage** ppImage, UINT32 ulHandle,
                                             const PXRect& rSrcRect, const PXRect& rDstRect,
                                             BOOL bPreserveAspect);
    HX_RESULT        GetPresentationSubImage(PXImage** ppImage, UINT32 ulHandle, const PXRect& rSrcRect);
    UINT32           GetMaxChannelDepth() const;
    HX_RESULT        GetScratchImage(PXImage** ppImage, UINT32 ulW, UINT32 ulH);
    HX_RESULT        GetOpaqueDataSize(UINT32 ulHandle, REF(UINT32) ulOpaqueSize);
    HX_RESULT        PacketLost();
    UINT32           GetDisplayWidth()         const { return m_ulDisplayWidth;         }
    UINT32           GetDisplayHeight()        const { return m_ulDisplayHeight;        }
    UINT32           GetDefaultBitsPerPixel()  const { return m_ulDefaultBitsPerPixel;  }
    UINT32           GetDefaultBytesPerPixel() const { return m_ulDefaultBytesPerPixel; }
    UINT32           GetDefaultPixelFormat()   const { return m_ulDefaultPixelFormat;   }
    BOOL             GetDefaultRowsInverted()  const { return m_bDefaultRowsInverted;   }
    UINT32           GetBackgroundColor()      const { return m_ulBackgroundColor;      }

    static HX_RESULT ResolveAspectRatio(const PXRect& rSrc, const PXRect& rDst,
                                        PXRect& rNewDst, PXRect& rEmpty1, PXRect& rEmpty2,
                                        BOOL bRelativeToDst);
    static HX_RESULT ResolveAspectRatio(const HXxRect& rSrc, const HXxRect& rDst,
                                        HXxRect& rNewDst, HXxRect& rEmpty1, HXxRect& rEmpty2,
                                        BOOL bRelativeToDst);
protected:
    PXImageManager();
    virtual ~PXImageManager();

    PXRenderCodecManager*   m_pCodecManager;
    IHXErrorMessages*      m_pErrorMessages;
    IHXCommonClassFactory* m_pCCF;
    UINT32                  m_ulDisplayWidth;
    UINT32                  m_ulDisplayHeight;
    UINT32                  m_ulDefaultBitsPerPixel;
    UINT32                  m_ulDefaultBytesPerPixel;
    UINT32                  m_ulDefaultPixelFormat;
    BOOL                    m_bDefaultRowsInverted;
    PXImage*                m_pDisplayImage;
    CHXMapLongToObj*        m_pHandleToImageMap;
    CHXSimpleList*          m_pScratchBufferList;
    UINT32                  m_ulBackgroundColor;
    UINT32                  m_ulBackgroundOpacity;

    HX_RESULT             GetScratchBuffer(UINT32 ulNumBytesNeeded, IHXBuffer** ppBuffer);
    HX_RESULT             ChooseScratchBuffer(UINT32 ulMinBytes, IHXBuffer** ppBuffer, BOOL* pbFound);
    void                  ReleaseScratchBuffers();
    void                  Reset();
    void                  Deallocate();
};

#define GET_REFCOUNT(x) ((x) ? ((x)->AddRef(), (x)->Release()) : 0)

#define CONVERT_PNxRECT_TO_PXRECT(px, pnx) ((px).Set((pnx).left, (pnx).top, HXxRECT_WIDTH(pnx), HXxRECT_HEIGHT(pnx)))

#define CONVERT_PXRECT_TO_PNxRECT(px, pnx)         \
    (pnx).left   = (px).GetX();                    \
    (pnx).top    = (px).GetY();                    \
    (pnx).right  = (px).GetX() + (px).GetWidth();  \
    (pnx).bottom = (px).GetY() + (px).GetHeight();

#endif
