/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: fxmanagr.h,v 1.1.24.1 2004/07/09 01:51:43 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _FXMANAGR_H
#define _FXMANAGR_H

typedef _INTERFACE IHXErrorMessages IHXErrorMessages;
class PXEffectSession;
class CHXSimpleList;


class PXEffectsManager : public CHXBaseCountingObject,
                         public CUnknownIMP
{
    DECLARE_UNKNOWN(PXEffectsManager)
public:
    PXEffectsManager();

    ~PXEffectsManager();

    HX_RESULT       Init(IHXErrorMessages*       pErrorMessages,
                         PXImageManager*          pImageManager,
                         PXEffectsPackageManager* pEffectsPackageManager,
                         PXHyperlinkManager*      pHyperlinkManager);
    void            ClearEffects();
    HX_RESULT       AddEffect(PXEffect *pEffect);
    HX_RESULT       OnTimeSync(UINT32 ulTime);
    HX_RESULT       GetNormalFadeLUT(UINT32 ulStart, UINT32 ulEnd, UINT32 ulTime,
                                     BYTE** ppStartImageLUT, BYTE** ppEndImageLUT);
    HX_RESULT       GetRecursiveFadeLUT(UINT32 ulStart, UINT32 ulEnd, UINT32 ulTime, UINT32 ulLastTime,
                                        BYTE** ppStartImageLUT, BYTE** ppEndImageLUT);
    BYTE*           GetAlphaLUT() const { return m_pAlphaLUT; }
    HX_RESULT       CanUseRecursive(PXEffect* pEffect, BOOL& rbRecursive);
    HX_RESULT       PacketLost();
    HX_RESULT       GetEffectsPackageManager(PXEffectsPackageManager** ppEffectsPackageManager);
    void            GetDamageRect(HXxRect& rDamageRect) const { rDamageRect = m_cDamageRect;     }
    BOOL            IsDisplayDamaged()                  const { return m_bDisplayDamaged;        }
    void            ResetDamage();
    void            SetRedrawForced(BOOL bRedrawForced)       { m_bRedrawForced = bRedrawForced; }
    BOOL            WasRedrawForced()                   const { return m_bRedrawForced;          }
    HX_RESULT       CheckPostDurationPacket(UINT32 ulHandle);
    HX_RESULT       UpdatePostDurationExpirationTimes();
    BOOL            GetCheckIndefiniteDuration() const      { return m_bCheckIndefiniteDuration;   }
    void            SetCheckIndefiniteDuration(BOOL bCheck) { m_bCheckIndefiniteDuration = bCheck; }
    void            CheckIndefiniteDuration(PXEffect* pEffect);
    void            CheckClearIndefiniteDuration();
    void            SetBackChannelNotify(BOOL bFlag) { m_bBackChannelNotify = bFlag; }
    BOOL            GetBackChannelNotify() const     { return m_bBackChannelNotify;  }
    UINT32          GetBackChannelHandle() const     { return m_ulBackChannelHandle; }
    BOOL            GetLive()              const     { return m_bIsLive;             }
    void            SetLive(BOOL bFlag)              { m_bIsLive = bFlag;            }
private:
    enum
    {
        kEffectLUTGranularity = 100
    };

    IHXErrorMessages*        m_pErrorMessages;
    PXImageManager*          m_pImageManager;
    PXEffectsPackageManager* m_pEffectsPackageManager;
    PXHyperlinkManager*      m_pHyperlinkManager;
    CHXSimpleList*           m_pEffectsList;
    CHXSimpleList*           m_pEffectSessionList;
    CHXSimpleList*           m_pPostDurationList;
    UINT32                   m_ulLUTWidth;
    BYTE*                    m_pFadeLUT;
    BYTE*                    m_pAlphaLUT;
    BOOL                     m_bInitialized;
    HXxRect                  m_cDamageRect;
    BOOL                     m_bDisplayDamaged;
    BOOL                     m_bRedrawForced;
    UINT32                   m_ulNextEffectHandle;
    PXEffect*                m_pLastEffect;
    BOOL                     m_bCheckIndefiniteDuration;
    BOOL                     m_bBackChannelNotify;
    UINT32                   m_ulBackChannelHandle;
    BOOL                     m_bIsLive;
#ifdef DEBUG_LOG
    FILE*                    m_pDebugFile;
#endif

    void                     DeleteEffectsList();
    void                     DeleteEffectSessionList();
    void                     DeletePostDurationList();
    HX_RESULT                ScanForNewEffects(UINT32 ulTime);
    HX_RESULT                CreateEffectSession(PXEffect* pEffect, PXEffectSession** ppSession);
    HX_RESULT                ExecuteAllSessions(UINT32 ulTime);
    HX_RESULT                UpdateSessionList(UINT32 ulTime);
    HX_RESULT                UpdatePostDurationList(UINT32 ulTime);
    HX_RESULT                AnySpaceTimeOverlap(PXEffect* pQueryEffect, BOOL* pbOverlap);
    HX_RESULT                ComputeExpirationTime(PXEffectSession* pSession, UINT32* pulTime);
};

#define PXMIN(a, b) ((a) < (b) ? (a) : (b))
#define PXMAX(a, b) ((a) > (b) ? (a) : (b))

#endif
