/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: image.h,v 1.2.24.1 2004/07/09 01:51:59 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _CIMFIMAGE_H
#define _CIMFIMAGE_H

#include "gstring.h"

class CIMFImage : public CHXBaseCountingObject
{
public:
    static char m_pszImageTag[];
	INT32       m_lCurrentSequenceNumber;
protected:
    ULONG32 m_ulHandle;
    GString m_cName;
    ULONG32 m_ulImageSize;
    GString m_cFileMimeType;
    BOOL    m_bSizeSet;
	BOOL    m_bScheduled;
    GString m_cErrorMessage;
	
    static char m_pszHandleAttr[];
    static char m_pszNameAttr[];
    static char m_pszSizeAttr[];
    static char m_pszMimeAttr[];
public:
    CIMFImage();

    CIMFImage(const CIMFImage &rImage);

    ~CIMFImage();

    void SetScheduled(BOOL bVal){m_bScheduled = bVal;};
    BOOL IsScheduled(){return m_bScheduled;};

    const CIMFImage & operator = (const CIMFImage &rImage)
    {
        m_ulHandle    = rImage.m_ulHandle;
        m_cName       = rImage.m_cName;
        m_ulImageSize = rImage.m_ulImageSize;

        return *this;
    };

    ULONG32         GetHandle()       const { return m_ulHandle; }
    GString&	    GetName()		    { return m_cName; }
    ULONG32         GetImageSize()    const { return m_ulImageSize; }
    BOOL            IsImageSizeSet()	    { return m_bSizeSet; }
    GString&	    GetFileMimeType()	    { return m_cFileMimeType; }
    GString&	    GetErrorMessage()	    { return m_cErrorMessage; }

    void SetHandle(ULONG32 ulHandle)          { m_ulHandle    = ulHandle; }
    void SetFileName(GString &rName)    { m_cName       = rName; }
    void SetImageSize(ULONG32 ulImageSize)    { m_ulImageSize = ulImageSize; }

    void    RenderText(GString &rStr);
    BOOL    InitFromText(GString &rStr, UINT32& rulErrorID, CHXString& rErrText);
	ULONG32 ComputeTransmissionDuration(ULONG32 ulBitRate);
};

#endif
