/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: color.h,v 1.2.24.1 2004/07/09 01:51:59 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _CIMFCOLOR_H
#define _CIMFCOLOR_H

#include "gstring.h"

class CIMFColor : public CHXBaseCountingObject
{
public:
    enum {kColorStrLen = 12};
protected:
    unsigned char m_ucRed;
    unsigned char m_ucGreen;
    unsigned char m_ucBlue;

    enum {kNumPredefinedColors = 16, kDefaultColor = 0x000000};

    struct ColorPair
    {
        char    m_pszColorName[kColorStrLen];
        ULONG32 m_ulColorValue;
    };

    static char      m_pszColorAttribute[];
    static ColorPair m_cPredefinedColorPair[kNumPredefinedColors];
public:
    CIMFColor();

    CIMFColor(unsigned char ucRed, unsigned char ucGreen, unsigned char ucBlue);

    CIMFColor(const CIMFColor &rColor);

    CIMFColor(ULONG32 ulColor);

    ~CIMFColor();

    const CIMFColor & operator = (const CIMFColor &rColor)
    {
        m_ucRed   = rColor.m_ucRed;
        m_ucGreen = rColor.m_ucGreen;
        m_ucBlue  = rColor.m_ucBlue;

        return *this;
	};

    ULONG32 GetBinaryLength() { return 4; };

    ULONG32 RenderBinary(unsigned char *pBuffer)
    {
        pBuffer[0] = m_ucRed;
        pBuffer[1] = m_ucGreen;
        pBuffer[2] = m_ucBlue;
        pBuffer[3] = (unsigned char) 0;

        return 4;
    };

    ULONG32 InitFromBinary(unsigned char *pBuffer)
    {
        m_ucRed   = pBuffer[0];
        m_ucGreen = pBuffer[1];
        m_ucBlue  = pBuffer[2];

        return 4;
    };

    void RenderText(GString &rText);
    BOOL InitFromText(GString &rText);

    BYTE GetRed()   const { return m_ucRed;   }
    BYTE GetGreen() const { return m_ucGreen; }
    BYTE GetBlue()  const { return m_ucBlue;  }
};

#endif
