/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: pximgfil.h,v 1.1.26.1 2004/07/09 01:54:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef PXIMGFIL_H
#define PXIMGFIL_H

// Forward declarations of interfaces
typedef _INTERFACE IUnknown              IUnknown;
typedef _INTERFACE IHXBuffer             IHXBuffer;
typedef _INTERFACE IHXPacket             IHXPacket;
typedef _INTERFACE IHXCommonClassFactory IHXCommonClassFactory;

// Forward declarations of classes
class CHXBaseCountingObject;
class PXWireFormatManager;
class PXFileFormatCodecManager;
class CHXSimpleList;

class PXImageFile : public CHXBaseCountingObject,
                    public IUnknown
{
public:
    PXImageFile(PXWireFormatManager*      pWireFormatManager,
                PXFileFormatCodecManager* pCodecManager,
                IHXCommonClassFactory*   pCommonClassFactory);
    virtual ~PXImageFile();

    // IUnknown methods
    STDMETHOD(QueryInterface)  (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(UINT32,AddRef)  (THIS);
    STDMETHOD_(UINT32,Release) (THIS);

    HX_RESULT         AddCookie(IHXBuffer* pURLStr, IHXBuffer* pCookie);
    HX_RESULT         EnqueueCookiePacket();
    HX_RESULT         EnqueueImagePackets(UINT32      ulHandle,
                                          IHXBuffer* pFileBuffer);
    HX_RESULT         EnqueueEffectPacket(UINT32      ulEffectType,
                                          UINT32      ulStart,
                                          UINT32      ulDuration,
                                          UINT32      ulTarget,
                                          const char* pszURL,
                                          UINT32      ulFillColor = 0,
                                          BOOL        bBackChannel = FALSE,
                                          BOOL        bLastUse = TRUE,
                                          BOOL        bDisplayImmediately = FALSE);
    void              ComputeStatistics();
    HX_RESULT         DequeuePacket(REF(IHXPacket*) rpPacket,
                                    UINT32           ulBitrate,
                                    REF(INT32)       rlCurrentTimeStamp);
    HX_RESULT         GetFirstPacket(REF(IHXPacket*) rpPacket);
    HX_RESULT         GetNextPacket(REF(IHXPacket*) rpPacket);
    UINT32            GetHandle() const;
    UINT32            GetTotalBytes() const;
    UINT32            GetNumPackets() const;
    UINT32            GetWidth() const;
    UINT32            GetHeight() const;
    UINT32            GetNumPacketsLeft() const;
    UINT32            GetTotalSendTime(UINT32 ulBitrate) const;
    HX_RESULT         SetPacketTimeStamp(IHXPacket*      pPacket,
                                         UINT32           ulTimeStamp,
                                         REF(UINT32)      rulPacketSize,
                                         REF(IHXPacket*) rpPacket);
    static HX_RESULT  FactorySetTimeStamp(IHXPacket*             pPacket,
                                          IHXCommonClassFactory* pFactory,
                                          UINT32                  ulTimeStamp,
                                          REF(UINT32)             rulPacketSize,
                                          REF(IHXPacket*)        rpPacket);
    static UINT32     GetPacketSendTime(IHXPacket* pPacket, UINT32 ulBitrate);
protected:
    struct CookiePair
    {
        IHXBuffer* m_pURLStr;
        IHXBuffer* m_pCookie;
    };

    INT32                     m_lRefCount;
    PXWireFormatManager*      m_pWireFormatManager;
    PXFileFormatCodecManager* m_pCodecManager;
    IHXCommonClassFactory*    m_pCommonClassFactory;
    UINT32                    m_ulHandle;
    UINT32                    m_ulNumPackets;
    UINT32                    m_ulTotalBytes;
    UINT32                    m_ulImageWidth;
    UINT32                    m_ulImageHeight;
    CHXSimpleList*            m_pPacketList;
    CHXSimpleList*            m_pCookieList;
    void*                     m_pListItr;

    void                      Deallocate();
    void                      ReleaseAllPackets();
    void                      ClearCookieList();
    HX_RESULT                 AddPacket(IHXPacket* pPacket, BOOL bTail = TRUE);
};

inline UINT32 PXImageFile::GetHandle()     const { return m_ulHandle;      }
inline UINT32 PXImageFile::GetTotalBytes() const { return m_ulTotalBytes;  }
inline UINT32 PXImageFile::GetNumPackets() const { return m_ulNumPackets;  }
inline UINT32 PXImageFile::GetWidth()      const { return m_ulImageWidth;  }
inline UINT32 PXImageFile::GetHeight()     const { return m_ulImageHeight; }

#endif
