/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: audio_svr.cpp,v 1.1.4.3 2004/07/09 02:01:36 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "hlxclib/memory.h"
#include "audio_svr.h"

#if defined (HELIX_CONFIG_DEVSOUND)
#include "mmf/audio_session-mmf.h"
#else
#include "mda/audio_session-mda.h"
#endif

_LIT(kHXSymbianAudioServer, "HelixAudioServer");

static const TUint KDefaultMessageSlots = 2;

// class HXSymbianAudioServer:

HXSymbianAudioServer::HXSymbianAudioServer()
: CServer(CActive::EPriorityStandard, ESharableSessions),
  m_sessionCount(0)
{
}

HXSymbianAudioServer::~HXSymbianAudioServer()
{
    Cancel();
}

CSharableSession* HXSymbianAudioServer::NewSessionL(const TVersion& aVersion) const
{
    RThread client = Message().Client();
    return HXSymbianAudioSession::NewL(client, (HXSymbianAudioServer*)this);
}

void HXSymbianAudioServer::AddSession()
{
    ++m_sessionCount;
}

void HXSymbianAudioServer::DelSession()
{
    --m_sessionCount;

    if (m_sessionCount <= 0)
    {
        // exit the server
	CActiveScheduler::Stop();
    }
}

// in leave handler for active object (CServer::RunL())
TInt HXSymbianAudioServer::RunError(TInt aError)
{
    Message().Complete(aError);
    
    //
    // Leaving from CServer::RunL() results in skipping the call to request
    // another message; ReStart() keeps the server running
    //
    ReStart();

    // handled the error fully (must return KErrNone to keep active
    // scheduler running)
    return KErrNone;    
}

void HXSymbianAudioServer::NotifyDeviceTaken()
{
    // loop over session and notify them the device has been taken
    HXSymbianAudioSession* pSession;

    iSessionIter.SetToFirst();
    while ((pSession = (HXSymbianAudioSession*)iSessionIter++) != NULL)
	pSession->NotifyDeviceTaken();
}

HBufC* HXSymbianAudioServer::AllocServerName()
{
    HBufC* pName = HBufC::New(kHXSymbianAudioServer().Length() + 16);

    // create a name that is unique to this process
    TPtr p = pName->Des();
    p.Copy(kHXSymbianAudioServer);
    p.AppendNum(TInt(RProcess().Id()));

    return pName;
}

//
// HXSymbianAudioClient
//

HXSymbianAudioClient::HXSymbianAudioClient()
    : m_stopped(true)
{}

TInt HXSymbianAudioClient::Init(int sampleRate, int channels)

{
    TAny* p[KMaxMessageArguments];
    
    p[0] = (TAny*)sampleRate;
    p[1] = (TAny*)channels;

    return (SendReceive(HXSymbianAudioServer::EAS_Init, &p[0]));
}

TInt HXSymbianAudioClient::Play()
{
    m_stopped = false;
    return SendReceive(HXSymbianAudioServer::EAS_Play, 0);
}

void HXSymbianAudioClient::Pause()
{
    SendReceive(HXSymbianAudioServer::EAS_Pause, 0);
}

void HXSymbianAudioClient::Stop()
{
    SendReceive(HXSymbianAudioServer::EAS_Stop, 0);
    m_stopped = true;
}

bool HXSymbianAudioClient::Stopped()
{
    return m_stopped;
}

void HXSymbianAudioClient::SetVolume(const TInt aNewVolume)
{
    TAny* p[KMaxMessageArguments];
    
    p[0] = (TAny*)aNewVolume;

    SendReceive(HXSymbianAudioServer::EAS_SetVolume, &p[0]);
}

TInt HXSymbianAudioClient::GetVolume() const
{
    return SendReceive(HXSymbianAudioServer::EAS_GetVolume, 0);
}

TInt HXSymbianAudioClient::GetMaxVolume() const
{
    return SendReceive(HXSymbianAudioServer::EAS_GetMaxVolume, 0);
}

TInt HXSymbianAudioClient::GetMinVolume() const
{
    return SendReceive(HXSymbianAudioServer::EAS_GetMinVolume, 0);
}

void HXSymbianAudioClient::Write(const IHXBuffer* pAudioBuf,
				 TRequestStatus& aStatus)
{
    TAny* p[KMaxMessageArguments];
    
    p[0] = (TAny*)(pAudioBuf);

    SendReceive(HXSymbianAudioServer::EAS_Write, &p[0], aStatus);
}

TInt HXSymbianAudioClient::Write(const IHXBuffer* pAudioBuf)
{
    TAny* p[KMaxMessageArguments];
    
    p[0] = (TAny*)(pAudioBuf);

    return (SendReceive(HXSymbianAudioServer::EAS_Write, &p[0]));
}

void HXSymbianAudioClient::CancelWrite()
{
    SendReceive(HXSymbianAudioServer::EAS_CancelWrite, 0);
}


TUint HXSymbianAudioClient::GetTime()
{
    return TUint(SendReceive(HXSymbianAudioServer::EAS_GetTime, 0));
}

TUint HXSymbianAudioClient::GetBlocksBuffered()
{
    return TUint(SendReceive(HXSymbianAudioServer::EAS_GetBlocksBuffered, 0));
}

TInt HXSymbianAudioClient::Connect()
{
    TInt status = KErrNoMemory;

    HBufC* pName = HXSymbianAudioServer::AllocServerName();
    if (pName)
    {
	status = CreateSession(*pName, TVersion(0,0,0), KDefaultMessageSlots);
	delete pName;
    }

    return status;
}
    
void HXSymbianAudioClient::RequestDeviceTakenNotification(TRequestStatus& status)
{

    SendReceive(HXSymbianAudioServer::EAS_RequestDeviceTakenNotification,
		0, status);
}

void HXSymbianAudioClient::CancelDeviceTakenNotification()
{
    SendReceive(HXSymbianAudioServer::EAS_CancelDeviceTakenNotification, 0);
}
