{-# OPTIONS_GHC -optc-D__GLASGOW_HASKELL__=606 #-}
{-# INCLUDE <sqlite3.h> #-}
{-# LINE 1 "Database/HDBC/Sqlite3/Consts.hsc" #-}
{- -*- mode: haskell; -*- 
{-# LINE 2 "Database/HDBC/Sqlite3/Consts.hsc" #-}
   vim: set filetype=haskell:
Copyright (C) 2005-2007 John Goerzen <jgoerzen@complete.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

-}

module Database.HDBC.Sqlite3.Consts
 (sqlite_OK,
  sqlite_ERROR,
  sqlite_INTERNAL,
  sqlite_PERM,
  sqlite_ABORT,
  sqlite_BUSY,
  sqlite_LOCKED,
  sqlite_NOMEM,
  sqlite_READONLY,
  sqlite_INTERRUPT,
  sqlite_IOERR,
  sqlite_CORRUPT,
  sqlite_NOTFOUND,
  sqlite_FULL,
  sqlite_CANTOPEN,
  sqlite_PROTOCOL,
  sqlite_EMPTY,
  sqlite_SCHEMA,
  sqlite_TOOBIG,
  sqlite_CONSTRAINT,
  sqlite_MISMATCH,
  sqlite_MISUSE,
  sqlite_NOLFS,
  sqlite_AUTH,
  sqlite_ROW,
  sqlite_DONE)
where

import Foreign.C.Types


{-# LINE 53 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Successful result
sqlite_OK :: Int
sqlite_OK = 0
{-# LINE 57 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | SQL error or missing database
sqlite_ERROR :: Int
sqlite_ERROR = 1
{-# LINE 61 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | An internal logic error in SQLite
sqlite_INTERNAL :: Int
sqlite_INTERNAL = 2
{-# LINE 65 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Access permission denied
sqlite_PERM :: Int
sqlite_PERM = 3
{-# LINE 69 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Callback routine requested an abort
sqlite_ABORT :: Int
sqlite_ABORT = 4
{-# LINE 73 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | The database file is locked
sqlite_BUSY :: Int
sqlite_BUSY = 5
{-# LINE 77 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | A table in the database is locked
sqlite_LOCKED :: Int
sqlite_LOCKED = 6
{-# LINE 81 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | A malloc() failed
sqlite_NOMEM :: Int
sqlite_NOMEM = 7
{-# LINE 85 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Attempt to write a readonly database
sqlite_READONLY :: Int
sqlite_READONLY = 8
{-# LINE 89 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Operation terminated by sqlite_interrupt()
sqlite_INTERRUPT :: Int
sqlite_INTERRUPT = 9
{-# LINE 93 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Some kind of disk I\/O error occurred
sqlite_IOERR :: Int
sqlite_IOERR = 10
{-# LINE 97 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | The database disk image is malformed
sqlite_CORRUPT :: Int
sqlite_CORRUPT = 11
{-# LINE 101 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | (Internal Only) Table or record not found
sqlite_NOTFOUND :: Int
sqlite_NOTFOUND = 12
{-# LINE 105 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Insertion failed because database is full
sqlite_FULL :: Int
sqlite_FULL = 13
{-# LINE 109 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Unable to open the database file
sqlite_CANTOPEN :: Int
sqlite_CANTOPEN = 14
{-# LINE 113 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Database lock protocol error
sqlite_PROTOCOL :: Int
sqlite_PROTOCOL = 15
{-# LINE 117 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | (Internal Only) Database table is empty
sqlite_EMPTY :: Int
sqlite_EMPTY = 16
{-# LINE 121 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | The database schema changed
sqlite_SCHEMA :: Int
sqlite_SCHEMA = 17
{-# LINE 125 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Too much data for one row of a table
sqlite_TOOBIG :: Int
sqlite_TOOBIG = 18
{-# LINE 129 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Abort due to constraint violation
sqlite_CONSTRAINT :: Int
sqlite_CONSTRAINT = 19
{-# LINE 133 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Data type mismatch
sqlite_MISMATCH :: Int
sqlite_MISMATCH = 20
{-# LINE 137 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Library used incorrectly
sqlite_MISUSE :: Int
sqlite_MISUSE = 21
{-# LINE 141 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Uses OS features not supported on host
sqlite_NOLFS :: Int
sqlite_NOLFS = 22
{-# LINE 145 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | Authorization denied
sqlite_AUTH :: Int
sqlite_AUTH = 23
{-# LINE 149 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | sqlite_step() has another row ready
sqlite_ROW :: Int
sqlite_ROW = 100
{-# LINE 153 "Database/HDBC/Sqlite3/Consts.hsc" #-}

-- | sqlite_step() has finished executing
sqlite_DONE :: Int
sqlite_DONE = 101
{-# LINE 157 "Database/HDBC/Sqlite3/Consts.hsc" #-}

