{-# OPTIONS -cpp #-}
#if ( defined(__GLASGOW_HASKELL__) && __GLASGOW_HASKELL__ >= 600 ) \
    || ( defined(__NHC__) && __NHC__ >= 117 )
#define FINALIZERPTR
#endif
module Hat.Foreign.BuiltinTypes
  ( Ptr,          aPtr,          toPtr,          fromPtr
  , FunPtr,       aFunPtr,       toFunPtr,       fromFunPtr
  , StablePtr,    aStablePtr,    toStablePtr,    fromStablePtr
  , ForeignPtr,   aForeignPtr,   toForeignPtr,   fromForeignPtr
#ifdef FINALIZERPTR
  , FinalizerPtr, aFinalizerPtr, toFinalizerPtr, fromFinalizerPtr
#endif
  ) where

import qualified Foreign.Ptr
import qualified Foreign.StablePtr
import qualified Foreign.ForeignPtr
import Hat.Hat as T
import Hat.Prelude
#if __GLASGOW_HASKELL__
import GHC.Base (unsafeCoerce#)
unsafeCoerce = GHC.Base.unsafeCoerce#
#elif __NHC__
import NonStdUnsafeCoerce (unsafeCoerce)
#endif


newtype Ptr a          = Ptr          (Foreign.Ptr.Ptr                 (R a))
newtype FunPtr a       = FunPtr       (Foreign.Ptr.FunPtr              (R a))
newtype StablePtr a    = StablePtr    (Foreign.StablePtr.StablePtr     (R a))
newtype ForeignPtr a   = ForeignPtr   (Foreign.ForeignPtr.ForeignPtr   (R a))
#ifdef FINALIZERPTR
newtype FinalizerPtr a = FinalizerPtr (Foreign.ForeignPtr.FinalizerPtr (R a))
--type FinalizerPtr a = FunPtr (T.Fun (Foreign.Ptr.Ptr (R a)) (T.IO ()))
#endif

aPtr, aFunPtr, aStablePtr, aForeignPtr, aFinalizerPtr :: RefAtom
aPtr          = mkAbstract "Ptr"
aFunPtr       = mkAbstract "FunPtr"
aStablePtr    = mkAbstract "StablePtr"
aForeignPtr   = mkAbstract "ForeignPtr"
aFinalizerPtr = mkAbstract "FinalizerPtr"

toPtr :: (RefExp -> R a -> b) -> RefExp -> R (Ptr a) -> Foreign.Ptr.Ptr b
toPtr f h (R (Ptr e) _) = fakemap (f h) e

fromPtr :: (RefExp -> a -> R b) -> RefExp -> Foreign.Ptr.Ptr a -> R (Ptr b)
fromPtr f h e = R (Ptr (fakemap (f h) e))
                  (T.mkValueUse h mkNoSrcPos aPtr)

toFunPtr :: (RefExp -> R a -> b)
            -> RefExp -> R (FunPtr a) -> Foreign.Ptr.FunPtr b
toFunPtr f h (R (FunPtr e) _) = fakemap (f h) e

fromFunPtr :: (RefExp -> a -> R b)
              -> RefExp -> Foreign.Ptr.FunPtr a -> R (FunPtr b)
fromFunPtr f h e = R (FunPtr (fakemap (f h) e))
                  (T.mkValueUse h mkNoSrcPos aFunPtr)

toStablePtr :: (RefExp -> R a -> b)
               -> RefExp -> R (StablePtr a) -> Foreign.StablePtr.StablePtr b
toStablePtr f h (R (StablePtr e) _) = fakemap (f h) e

fromStablePtr :: (RefExp -> a -> R b)
                 -> RefExp -> Foreign.StablePtr.StablePtr a -> R (StablePtr b)
fromStablePtr f h e = R (StablePtr (fakemap (f h) e))
                  (T.mkValueUse h mkNoSrcPos aStablePtr)

toForeignPtr :: (RefExp -> R a -> b)
                -> RefExp -> R (ForeignPtr a) -> Foreign.ForeignPtr.ForeignPtr b
toForeignPtr f h (R (ForeignPtr e) _) = fakemap (f h) e

fromForeignPtr :: (RefExp -> a -> R b) -> RefExp
                  -> Foreign.ForeignPtr.ForeignPtr a -> R (ForeignPtr b)
fromForeignPtr f h e = R (ForeignPtr (fakemap (f h) e))
                         (T.mkValueUse h mkNoSrcPos aForeignPtr)

#ifdef FINALIZERPTR
toFinalizerPtr :: (RefExp -> R a -> b)
                -> RefExp -> R (FinalizerPtr a)
                -> Foreign.ForeignPtr.FinalizerPtr b
toFinalizerPtr f h (R (FinalizerPtr e) _) = unsafeCoerce e
--toFinalizerPtr f h (R (FinalizerPtr e) _) = fakemap (f h) (unsafeCoerce e)
--toFinalizerPtr f h (R e _) = fakemap (f h) (toFunPtr f h (unsafeCoerce e))

fromFinalizerPtr :: (RefExp -> a -> R b) -> RefExp
                  -> Foreign.ForeignPtr.FinalizerPtr a -> R (FinalizerPtr b)
fromFinalizerPtr f h e = R (FinalizerPtr (unsafeCoerce e))
                           (T.mkValueUse h mkNoSrcPos aFinalizerPtr)
--fromFinalizerPtr f h e = R (FinalizerPtr (fakemap (f h) (unsafeCoerce e)))
--                           (T.mkValueUse h mkNoSrcPos aFinalizerPtr)
--fromFinalizerPtr f h e = R (fakemap (f h) (unsafeCoerce e))
--                           (T.mkValueUse h mkNoSrcPos aFinalizerPtr)
#endif

fakemap :: (a -> b) -> c a -> c b
fakemap f e = unsafeCoerce e

