{-# OPTIONS_GHC -fglasgow-exts #-}

module QIO.Heap where

import qualified Data.Map as Map
import Data.Maybe as Maybe
import QIO.QioSyn

class Eq h => Heap h where
      initial :: h
      update :: h -> Qbit -> Bool -> h
      (?) :: h -> Qbit -> Maybe Bool
      forget :: h -> Qbit -> h
      hswap :: h -> Qbit -> Qbit -> h
      hswap h x y = update (update h y (fromJust (h ? x))) x (fromJust (h ? y)) 
type HeapMap = Map.Map Qbit Bool

instance Heap HeapMap where
       initial = Map.empty
       update h q b = Map.insert q b h
       h ? q = Map.lookup q h
       forget h q = Map.delete q h


    


