{-# OPTIONS_HADDOCK hide #-}
-- -*-haskell-*-
-- -------------------- automatically generated file - do not edit ----------
--  Object hierarchy for the GIMP Toolkit (GTK) Binding for Haskell
--
--  Author : Axel Simon
--
--  Copyright (C) 2001-2005 Axel Simon
--
--  This library is free software; you can redistribute it and/or
--  modify it under the terms of the GNU Lesser General Public
--  License as published by the Free Software Foundation; either
--  version 2.1 of the License, or (at your option) any later version.
--
--  This library is distributed in the hope that it will be useful,
--  but WITHOUT ANY WARRANTY; without even the implied warranty of
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
--  Lesser General Public License for more details.
--
-- #hide

-- |
-- Maintainer  : gtk2hs-users@lists.sourceforge.net
-- Stability   : provisional
-- Portability : portable (depends on GHC)
--
-- This file reflects the Gtk+ object hierarchy in terms of Haskell classes.
--
-- Note: the mk... functions were originally meant to simply be an alias
-- for the constructor. However, in order to communicate the destructor
-- of an object to objectNew, the mk... functions are now a tuple containing
-- Haskell constructor and the destructor function pointer. This hack avoids
-- changing all modules that simply pass mk... to objectNew.
--
module Media.Streaming.GStreamer.Core.Hierarchy (

  module System.Glib.GObject,
  Object(Object), ObjectClass,
  toObject, 
  mkObject, unObject,
  castToObject, gTypeObject,
  Pad(Pad), PadClass,
  toPad, 
  mkPad, unPad,
  castToPad, gTypePad,
  GhostPad(GhostPad), GhostPadClass,
  toGhostPad, 
  mkGhostPad, unGhostPad,
  castToGhostPad, gTypeGhostPad,
  PluginFeature(PluginFeature), PluginFeatureClass,
  toPluginFeature, 
  mkPluginFeature, unPluginFeature,
  castToPluginFeature, gTypePluginFeature,
  ElementFactory(ElementFactory), ElementFactoryClass,
  toElementFactory, 
  mkElementFactory, unElementFactory,
  castToElementFactory, gTypeElementFactory,
  TypeFindFactory(TypeFindFactory), TypeFindFactoryClass,
  toTypeFindFactory, 
  mkTypeFindFactory, unTypeFindFactory,
  castToTypeFindFactory, gTypeTypeFindFactory,
  IndexFactory(IndexFactory), IndexFactoryClass,
  toIndexFactory, 
  mkIndexFactory, unIndexFactory,
  castToIndexFactory, gTypeIndexFactory,
  Element(Element), ElementClass,
  toElement, 
  mkElement, unElement,
  castToElement, gTypeElement,
  Bin(Bin), BinClass,
  toBin, 
  mkBin, unBin,
  castToBin, gTypeBin,
  Pipeline(Pipeline), PipelineClass,
  toPipeline, 
  mkPipeline, unPipeline,
  castToPipeline, gTypePipeline,
  ImplementsInterface(ImplementsInterface), ImplementsInterfaceClass,
  toImplementsInterface, 
  mkImplementsInterface, unImplementsInterface,
  castToImplementsInterface, gTypeImplementsInterface,
  TagSetter(TagSetter), TagSetterClass,
  toTagSetter, 
  mkTagSetter, unTagSetter,
  castToTagSetter, gTypeTagSetter,
  BaseSrc(BaseSrc), BaseSrcClass,
  toBaseSrc, 
  mkBaseSrc, unBaseSrc,
  castToBaseSrc, gTypeBaseSrc,
  PushSrc(PushSrc), PushSrcClass,
  toPushSrc, 
  mkPushSrc, unPushSrc,
  castToPushSrc, gTypePushSrc,
  BaseSink(BaseSink), BaseSinkClass,
  toBaseSink, 
  mkBaseSink, unBaseSink,
  castToBaseSink, gTypeBaseSink,
  BaseTransform(BaseTransform), BaseTransformClass,
  toBaseTransform, 
  mkBaseTransform, unBaseTransform,
  castToBaseTransform, gTypeBaseTransform,
  Plugin(Plugin), PluginClass,
  toPlugin, 
  mkPlugin, unPlugin,
  castToPlugin, gTypePlugin,
  Registry(Registry), RegistryClass,
  toRegistry, 
  mkRegistry, unRegistry,
  castToRegistry, gTypeRegistry,
  Bus(Bus), BusClass,
  toBus, 
  mkBus, unBus,
  castToBus, gTypeBus,
  Clock(Clock), ClockClass,
  toClock, 
  mkClock, unClock,
  castToClock, gTypeClock,
  AudioClock(AudioClock), AudioClockClass,
  toAudioClock, 
  mkAudioClock, unAudioClock,
  castToAudioClock, gTypeAudioClock,
  SystemClock(SystemClock), SystemClockClass,
  toSystemClock, 
  mkSystemClock, unSystemClock,
  castToSystemClock, gTypeSystemClock,
  NetClientClock(NetClientClock), NetClientClockClass,
  toNetClientClock, 
  mkNetClientClock, unNetClientClock,
  castToNetClientClock, gTypeNetClientClock,
  Index(Index), IndexClass,
  toIndex, 
  mkIndex, unIndex,
  castToIndex, gTypeIndex,
  PadTemplate(PadTemplate), PadTemplateClass,
  toPadTemplate, 
  mkPadTemplate, unPadTemplate,
  castToPadTemplate, gTypePadTemplate,
  Task(Task), TaskClass,
  toTask, 
  mkTask, unTask,
  castToTask, gTypeTask,
  XML(XML), XMLClass,
  toXML, 
  mkXML, unXML,
  castToXML, gTypeXML,
  ChildProxy(ChildProxy), ChildProxyClass,
  toChildProxy, 
  mkChildProxy, unChildProxy,
  castToChildProxy, gTypeChildProxy,
  CollectPads(CollectPads), CollectPadsClass,
  toCollectPads, 
  mkCollectPads, unCollectPads,
  castToCollectPads, gTypeCollectPads,
  URIHandler(URIHandler), URIHandlerClass,
  toURIHandler, 
  mkURIHandler, unURIHandler,
  castToURIHandler, gTypeURIHandler,
  Adapter(Adapter), AdapterClass,
  toAdapter, 
  mkAdapter, unAdapter,
  castToAdapter, gTypeAdapter,
  Controller(Controller), ControllerClass,
  toController, 
  mkController, unController,
  castToController, gTypeController
  ) where

import Foreign.ForeignPtr (ForeignPtr, castForeignPtr, unsafeForeignPtrToPtr)
import Foreign.C.Types    (CULong, CUInt)
import System.Glib.GType	(GType, typeInstanceIsA)
{#import System.Glib.GObject#}

{# context lib="gstreamer" prefix="gtk" #}

-- The usage of foreignPtrToPtr should be safe as the evaluation will only be
-- forced if the object is used afterwards
--
castTo :: (GObjectClass obj, GObjectClass obj') => GType -> String
                                                -> (obj -> obj')
castTo gtype objTypeName obj =
  case toGObject obj of
    gobj@(GObject objFPtr)
      | typeInstanceIsA ((unsafeForeignPtrToPtr.castForeignPtr) objFPtr) gtype
                  -> unsafeCastGObject gobj
      | otherwise -> error $ "Cannot cast object to " ++ objTypeName


-- ********************************************************************* Object

{#pointer *GstObject as Object foreign newtype #} deriving (Eq,Ord)

mkObject = (Object, objectUnref)
unObject (Object o) = o

class GObjectClass o => ObjectClass o
toObject :: ObjectClass o => o -> Object
toObject = unsafeCastGObject . toGObject

instance ObjectClass Object
instance GObjectClass Object where
  toGObject = GObject . castForeignPtr . unObject
  unsafeCastGObject = Object . castForeignPtr . unGObject

castToObject :: GObjectClass obj => obj -> Object
castToObject = castTo gTypeObject "Object"

gTypeObject :: GType
gTypeObject =
  {# call fun unsafe gst_object_get_type #}

-- ************************************************************************ Pad

{#pointer *GstPad as Pad foreign newtype #} deriving (Eq,Ord)

mkPad = (Pad, objectUnref)
unPad (Pad o) = o

class ObjectClass o => PadClass o
toPad :: PadClass o => o -> Pad
toPad = unsafeCastGObject . toGObject

instance PadClass Pad
instance ObjectClass Pad
instance GObjectClass Pad where
  toGObject = GObject . castForeignPtr . unPad
  unsafeCastGObject = Pad . castForeignPtr . unGObject

castToPad :: GObjectClass obj => obj -> Pad
castToPad = castTo gTypePad "Pad"

gTypePad :: GType
gTypePad =
  {# call fun unsafe gst_pad_get_type #}

-- ******************************************************************* GhostPad

{#pointer *GstGhostPad as GhostPad foreign newtype #} deriving (Eq,Ord)

mkGhostPad = (GhostPad, objectUnref)
unGhostPad (GhostPad o) = o

class PadClass o => GhostPadClass o
toGhostPad :: GhostPadClass o => o -> GhostPad
toGhostPad = unsafeCastGObject . toGObject

instance GhostPadClass GhostPad
instance PadClass GhostPad
instance ObjectClass GhostPad
instance GObjectClass GhostPad where
  toGObject = GObject . castForeignPtr . unGhostPad
  unsafeCastGObject = GhostPad . castForeignPtr . unGObject

castToGhostPad :: GObjectClass obj => obj -> GhostPad
castToGhostPad = castTo gTypeGhostPad "GhostPad"

gTypeGhostPad :: GType
gTypeGhostPad =
  {# call fun unsafe gst_ghost_pad_get_type #}

-- ************************************************************** PluginFeature

{#pointer *GstPluginFeature as PluginFeature foreign newtype #} deriving (Eq,Ord)

mkPluginFeature = (PluginFeature, objectUnref)
unPluginFeature (PluginFeature o) = o

class ObjectClass o => PluginFeatureClass o
toPluginFeature :: PluginFeatureClass o => o -> PluginFeature
toPluginFeature = unsafeCastGObject . toGObject

instance PluginFeatureClass PluginFeature
instance ObjectClass PluginFeature
instance GObjectClass PluginFeature where
  toGObject = GObject . castForeignPtr . unPluginFeature
  unsafeCastGObject = PluginFeature . castForeignPtr . unGObject

castToPluginFeature :: GObjectClass obj => obj -> PluginFeature
castToPluginFeature = castTo gTypePluginFeature "PluginFeature"

gTypePluginFeature :: GType
gTypePluginFeature =
  {# call fun unsafe gst_plugin_feature_get_type #}

-- ************************************************************* ElementFactory

{#pointer *GstElementFactory as ElementFactory foreign newtype #} deriving (Eq,Ord)

mkElementFactory = (ElementFactory, objectUnref)
unElementFactory (ElementFactory o) = o

class PluginFeatureClass o => ElementFactoryClass o
toElementFactory :: ElementFactoryClass o => o -> ElementFactory
toElementFactory = unsafeCastGObject . toGObject

instance ElementFactoryClass ElementFactory
instance PluginFeatureClass ElementFactory
instance ObjectClass ElementFactory
instance GObjectClass ElementFactory where
  toGObject = GObject . castForeignPtr . unElementFactory
  unsafeCastGObject = ElementFactory . castForeignPtr . unGObject

castToElementFactory :: GObjectClass obj => obj -> ElementFactory
castToElementFactory = castTo gTypeElementFactory "ElementFactory"

gTypeElementFactory :: GType
gTypeElementFactory =
  {# call fun unsafe gst_element_factory_get_type #}

-- ************************************************************ TypeFindFactory

{#pointer *GstTypeFindFactory as TypeFindFactory foreign newtype #} deriving (Eq,Ord)

mkTypeFindFactory = (TypeFindFactory, objectUnref)
unTypeFindFactory (TypeFindFactory o) = o

class PluginFeatureClass o => TypeFindFactoryClass o
toTypeFindFactory :: TypeFindFactoryClass o => o -> TypeFindFactory
toTypeFindFactory = unsafeCastGObject . toGObject

instance TypeFindFactoryClass TypeFindFactory
instance PluginFeatureClass TypeFindFactory
instance ObjectClass TypeFindFactory
instance GObjectClass TypeFindFactory where
  toGObject = GObject . castForeignPtr . unTypeFindFactory
  unsafeCastGObject = TypeFindFactory . castForeignPtr . unGObject

castToTypeFindFactory :: GObjectClass obj => obj -> TypeFindFactory
castToTypeFindFactory = castTo gTypeTypeFindFactory "TypeFindFactory"

gTypeTypeFindFactory :: GType
gTypeTypeFindFactory =
  {# call fun unsafe gst_type_find_factory_get_type #}

-- *************************************************************** IndexFactory

{#pointer *GstIndexFactory as IndexFactory foreign newtype #} deriving (Eq,Ord)

mkIndexFactory = (IndexFactory, objectUnref)
unIndexFactory (IndexFactory o) = o

class PluginFeatureClass o => IndexFactoryClass o
toIndexFactory :: IndexFactoryClass o => o -> IndexFactory
toIndexFactory = unsafeCastGObject . toGObject

instance IndexFactoryClass IndexFactory
instance PluginFeatureClass IndexFactory
instance ObjectClass IndexFactory
instance GObjectClass IndexFactory where
  toGObject = GObject . castForeignPtr . unIndexFactory
  unsafeCastGObject = IndexFactory . castForeignPtr . unGObject

castToIndexFactory :: GObjectClass obj => obj -> IndexFactory
castToIndexFactory = castTo gTypeIndexFactory "IndexFactory"

gTypeIndexFactory :: GType
gTypeIndexFactory =
  {# call fun unsafe gst_index_factory_get_type #}

-- ******************************************************************** Element

{#pointer *GstElement as Element foreign newtype #} deriving (Eq,Ord)

mkElement = (Element, objectUnref)
unElement (Element o) = o

class ObjectClass o => ElementClass o
toElement :: ElementClass o => o -> Element
toElement = unsafeCastGObject . toGObject

instance ElementClass Element
instance ObjectClass Element
instance GObjectClass Element where
  toGObject = GObject . castForeignPtr . unElement
  unsafeCastGObject = Element . castForeignPtr . unGObject

castToElement :: GObjectClass obj => obj -> Element
castToElement = castTo gTypeElement "Element"

gTypeElement :: GType
gTypeElement =
  {# call fun unsafe gst_element_get_type #}

-- ************************************************************************ Bin

{#pointer *GstBin as Bin foreign newtype #} deriving (Eq,Ord)

mkBin = (Bin, objectUnref)
unBin (Bin o) = o

class ElementClass o => BinClass o
toBin :: BinClass o => o -> Bin
toBin = unsafeCastGObject . toGObject

instance BinClass Bin
instance ElementClass Bin
instance ObjectClass Bin
instance GObjectClass Bin where
  toGObject = GObject . castForeignPtr . unBin
  unsafeCastGObject = Bin . castForeignPtr . unGObject

castToBin :: GObjectClass obj => obj -> Bin
castToBin = castTo gTypeBin "Bin"

gTypeBin :: GType
gTypeBin =
  {# call fun unsafe gst_bin_get_type #}

-- ******************************************************************* Pipeline

{#pointer *GstPipeline as Pipeline foreign newtype #} deriving (Eq,Ord)

mkPipeline = (Pipeline, objectUnref)
unPipeline (Pipeline o) = o

class BinClass o => PipelineClass o
toPipeline :: PipelineClass o => o -> Pipeline
toPipeline = unsafeCastGObject . toGObject

instance PipelineClass Pipeline
instance BinClass Pipeline
instance ElementClass Pipeline
instance ObjectClass Pipeline
instance GObjectClass Pipeline where
  toGObject = GObject . castForeignPtr . unPipeline
  unsafeCastGObject = Pipeline . castForeignPtr . unGObject

castToPipeline :: GObjectClass obj => obj -> Pipeline
castToPipeline = castTo gTypePipeline "Pipeline"

gTypePipeline :: GType
gTypePipeline =
  {# call fun unsafe gst_pipeline_get_type #}

-- ******************************************************** ImplementsInterface

{#pointer *GstImplementsInterface as ImplementsInterface foreign newtype #} deriving (Eq,Ord)

mkImplementsInterface = (ImplementsInterface, objectUnref)
unImplementsInterface (ImplementsInterface o) = o

class ElementClass o => ImplementsInterfaceClass o
toImplementsInterface :: ImplementsInterfaceClass o => o -> ImplementsInterface
toImplementsInterface = unsafeCastGObject . toGObject

instance ImplementsInterfaceClass ImplementsInterface
instance ElementClass ImplementsInterface
instance ObjectClass ImplementsInterface
instance GObjectClass ImplementsInterface where
  toGObject = GObject . castForeignPtr . unImplementsInterface
  unsafeCastGObject = ImplementsInterface . castForeignPtr . unGObject

castToImplementsInterface :: GObjectClass obj => obj -> ImplementsInterface
castToImplementsInterface = castTo gTypeImplementsInterface "ImplementsInterface"

gTypeImplementsInterface :: GType
gTypeImplementsInterface =
  {# call fun unsafe gst_implements_interface_get_type #}

-- ****************************************************************** TagSetter

{#pointer *GstTagSetter as TagSetter foreign newtype #} deriving (Eq,Ord)

mkTagSetter = (TagSetter, objectUnref)
unTagSetter (TagSetter o) = o

class ElementClass o => TagSetterClass o
toTagSetter :: TagSetterClass o => o -> TagSetter
toTagSetter = unsafeCastGObject . toGObject

instance TagSetterClass TagSetter
instance ElementClass TagSetter
instance ObjectClass TagSetter
instance GObjectClass TagSetter where
  toGObject = GObject . castForeignPtr . unTagSetter
  unsafeCastGObject = TagSetter . castForeignPtr . unGObject

castToTagSetter :: GObjectClass obj => obj -> TagSetter
castToTagSetter = castTo gTypeTagSetter "TagSetter"

gTypeTagSetter :: GType
gTypeTagSetter =
  {# call fun unsafe gst_tag_setter_get_type #}

-- ******************************************************************** BaseSrc

{#pointer *GstBaseSrc as BaseSrc foreign newtype #} deriving (Eq,Ord)

mkBaseSrc = (BaseSrc, objectUnref)
unBaseSrc (BaseSrc o) = o

class ElementClass o => BaseSrcClass o
toBaseSrc :: BaseSrcClass o => o -> BaseSrc
toBaseSrc = unsafeCastGObject . toGObject

instance BaseSrcClass BaseSrc
instance ElementClass BaseSrc
instance ObjectClass BaseSrc
instance GObjectClass BaseSrc where
  toGObject = GObject . castForeignPtr . unBaseSrc
  unsafeCastGObject = BaseSrc . castForeignPtr . unGObject

castToBaseSrc :: GObjectClass obj => obj -> BaseSrc
castToBaseSrc = castTo gTypeBaseSrc "BaseSrc"

gTypeBaseSrc :: GType
gTypeBaseSrc =
  {# call fun unsafe gst_base_src_get_type #}

-- ******************************************************************** PushSrc

{#pointer *GstPushSrc as PushSrc foreign newtype #} deriving (Eq,Ord)

mkPushSrc = (PushSrc, objectUnref)
unPushSrc (PushSrc o) = o

class BaseSrcClass o => PushSrcClass o
toPushSrc :: PushSrcClass o => o -> PushSrc
toPushSrc = unsafeCastGObject . toGObject

instance PushSrcClass PushSrc
instance BaseSrcClass PushSrc
instance ElementClass PushSrc
instance ObjectClass PushSrc
instance GObjectClass PushSrc where
  toGObject = GObject . castForeignPtr . unPushSrc
  unsafeCastGObject = PushSrc . castForeignPtr . unGObject

castToPushSrc :: GObjectClass obj => obj -> PushSrc
castToPushSrc = castTo gTypePushSrc "PushSrc"

gTypePushSrc :: GType
gTypePushSrc =
  {# call fun unsafe gst_push_src_get_type #}

-- ******************************************************************* BaseSink

{#pointer *GstBaseSink as BaseSink foreign newtype #} deriving (Eq,Ord)

mkBaseSink = (BaseSink, objectUnref)
unBaseSink (BaseSink o) = o

class ElementClass o => BaseSinkClass o
toBaseSink :: BaseSinkClass o => o -> BaseSink
toBaseSink = unsafeCastGObject . toGObject

instance BaseSinkClass BaseSink
instance ElementClass BaseSink
instance ObjectClass BaseSink
instance GObjectClass BaseSink where
  toGObject = GObject . castForeignPtr . unBaseSink
  unsafeCastGObject = BaseSink . castForeignPtr . unGObject

castToBaseSink :: GObjectClass obj => obj -> BaseSink
castToBaseSink = castTo gTypeBaseSink "BaseSink"

gTypeBaseSink :: GType
gTypeBaseSink =
  {# call fun unsafe gst_base_sink_get_type #}

-- ************************************************************** BaseTransform

{#pointer *GstBaseTransform as BaseTransform foreign newtype #} deriving (Eq,Ord)

mkBaseTransform = (BaseTransform, objectUnref)
unBaseTransform (BaseTransform o) = o

class ElementClass o => BaseTransformClass o
toBaseTransform :: BaseTransformClass o => o -> BaseTransform
toBaseTransform = unsafeCastGObject . toGObject

instance BaseTransformClass BaseTransform
instance ElementClass BaseTransform
instance ObjectClass BaseTransform
instance GObjectClass BaseTransform where
  toGObject = GObject . castForeignPtr . unBaseTransform
  unsafeCastGObject = BaseTransform . castForeignPtr . unGObject

castToBaseTransform :: GObjectClass obj => obj -> BaseTransform
castToBaseTransform = castTo gTypeBaseTransform "BaseTransform"

gTypeBaseTransform :: GType
gTypeBaseTransform =
  {# call fun unsafe gst_base_transform_get_type #}

-- ********************************************************************* Plugin

{#pointer *GstPlugin as Plugin foreign newtype #} deriving (Eq,Ord)

mkPlugin = (Plugin, objectUnref)
unPlugin (Plugin o) = o

class ObjectClass o => PluginClass o
toPlugin :: PluginClass o => o -> Plugin
toPlugin = unsafeCastGObject . toGObject

instance PluginClass Plugin
instance ObjectClass Plugin
instance GObjectClass Plugin where
  toGObject = GObject . castForeignPtr . unPlugin
  unsafeCastGObject = Plugin . castForeignPtr . unGObject

castToPlugin :: GObjectClass obj => obj -> Plugin
castToPlugin = castTo gTypePlugin "Plugin"

gTypePlugin :: GType
gTypePlugin =
  {# call fun unsafe gst_plugin_get_type #}

-- ******************************************************************* Registry

{#pointer *GstRegistry as Registry foreign newtype #} deriving (Eq,Ord)

mkRegistry = (Registry, objectUnref)
unRegistry (Registry o) = o

class ObjectClass o => RegistryClass o
toRegistry :: RegistryClass o => o -> Registry
toRegistry = unsafeCastGObject . toGObject

instance RegistryClass Registry
instance ObjectClass Registry
instance GObjectClass Registry where
  toGObject = GObject . castForeignPtr . unRegistry
  unsafeCastGObject = Registry . castForeignPtr . unGObject

castToRegistry :: GObjectClass obj => obj -> Registry
castToRegistry = castTo gTypeRegistry "Registry"

gTypeRegistry :: GType
gTypeRegistry =
  {# call fun unsafe gst_registry_get_type #}

-- ************************************************************************ Bus

{#pointer *GstBus as Bus foreign newtype #} deriving (Eq,Ord)

mkBus = (Bus, objectUnref)
unBus (Bus o) = o

class ObjectClass o => BusClass o
toBus :: BusClass o => o -> Bus
toBus = unsafeCastGObject . toGObject

instance BusClass Bus
instance ObjectClass Bus
instance GObjectClass Bus where
  toGObject = GObject . castForeignPtr . unBus
  unsafeCastGObject = Bus . castForeignPtr . unGObject

castToBus :: GObjectClass obj => obj -> Bus
castToBus = castTo gTypeBus "Bus"

gTypeBus :: GType
gTypeBus =
  {# call fun unsafe gst_bus_get_type #}

-- ********************************************************************** Clock

{#pointer *GstClock as Clock foreign newtype #} deriving (Eq,Ord)

mkClock = (Clock, objectUnref)
unClock (Clock o) = o

class ObjectClass o => ClockClass o
toClock :: ClockClass o => o -> Clock
toClock = unsafeCastGObject . toGObject

instance ClockClass Clock
instance ObjectClass Clock
instance GObjectClass Clock where
  toGObject = GObject . castForeignPtr . unClock
  unsafeCastGObject = Clock . castForeignPtr . unGObject

castToClock :: GObjectClass obj => obj -> Clock
castToClock = castTo gTypeClock "Clock"

gTypeClock :: GType
gTypeClock =
  {# call fun unsafe gst_clock_get_type #}

-- ***************************************************************** AudioClock

{#pointer *GstAudioClock as AudioClock foreign newtype #} deriving (Eq,Ord)

mkAudioClock = (AudioClock, objectUnref)
unAudioClock (AudioClock o) = o

class ClockClass o => AudioClockClass o
toAudioClock :: AudioClockClass o => o -> AudioClock
toAudioClock = unsafeCastGObject . toGObject

instance AudioClockClass AudioClock
instance ClockClass AudioClock
instance ObjectClass AudioClock
instance GObjectClass AudioClock where
  toGObject = GObject . castForeignPtr . unAudioClock
  unsafeCastGObject = AudioClock . castForeignPtr . unGObject

castToAudioClock :: GObjectClass obj => obj -> AudioClock
castToAudioClock = castTo gTypeAudioClock "AudioClock"

gTypeAudioClock :: GType
gTypeAudioClock =
  {# call fun unsafe gst_audio_clock_get_type #}

-- **************************************************************** SystemClock

{#pointer *GstSystemClock as SystemClock foreign newtype #} deriving (Eq,Ord)

mkSystemClock = (SystemClock, objectUnref)
unSystemClock (SystemClock o) = o

class ClockClass o => SystemClockClass o
toSystemClock :: SystemClockClass o => o -> SystemClock
toSystemClock = unsafeCastGObject . toGObject

instance SystemClockClass SystemClock
instance ClockClass SystemClock
instance ObjectClass SystemClock
instance GObjectClass SystemClock where
  toGObject = GObject . castForeignPtr . unSystemClock
  unsafeCastGObject = SystemClock . castForeignPtr . unGObject

castToSystemClock :: GObjectClass obj => obj -> SystemClock
castToSystemClock = castTo gTypeSystemClock "SystemClock"

gTypeSystemClock :: GType
gTypeSystemClock =
  {# call fun unsafe gst_system_clock_get_type #}

-- ************************************************************* NetClientClock

{#pointer *GstNetClientClock as NetClientClock foreign newtype #} deriving (Eq,Ord)

mkNetClientClock = (NetClientClock, objectUnref)
unNetClientClock (NetClientClock o) = o

class ClockClass o => NetClientClockClass o
toNetClientClock :: NetClientClockClass o => o -> NetClientClock
toNetClientClock = unsafeCastGObject . toGObject

instance NetClientClockClass NetClientClock
instance ClockClass NetClientClock
instance ObjectClass NetClientClock
instance GObjectClass NetClientClock where
  toGObject = GObject . castForeignPtr . unNetClientClock
  unsafeCastGObject = NetClientClock . castForeignPtr . unGObject

castToNetClientClock :: GObjectClass obj => obj -> NetClientClock
castToNetClientClock = castTo gTypeNetClientClock "NetClientClock"

gTypeNetClientClock :: GType
gTypeNetClientClock =
  {# call fun unsafe gst_net_client_clock_get_type #}

-- ********************************************************************** Index

{#pointer *GstIndex as Index foreign newtype #} deriving (Eq,Ord)

mkIndex = (Index, objectUnref)
unIndex (Index o) = o

class ObjectClass o => IndexClass o
toIndex :: IndexClass o => o -> Index
toIndex = unsafeCastGObject . toGObject

instance IndexClass Index
instance ObjectClass Index
instance GObjectClass Index where
  toGObject = GObject . castForeignPtr . unIndex
  unsafeCastGObject = Index . castForeignPtr . unGObject

castToIndex :: GObjectClass obj => obj -> Index
castToIndex = castTo gTypeIndex "Index"

gTypeIndex :: GType
gTypeIndex =
  {# call fun unsafe gst_index_get_type #}

-- **************************************************************** PadTemplate

{#pointer *GstPadTemplate as PadTemplate foreign newtype #} deriving (Eq,Ord)

mkPadTemplate = (PadTemplate, objectUnref)
unPadTemplate (PadTemplate o) = o

class ObjectClass o => PadTemplateClass o
toPadTemplate :: PadTemplateClass o => o -> PadTemplate
toPadTemplate = unsafeCastGObject . toGObject

instance PadTemplateClass PadTemplate
instance ObjectClass PadTemplate
instance GObjectClass PadTemplate where
  toGObject = GObject . castForeignPtr . unPadTemplate
  unsafeCastGObject = PadTemplate . castForeignPtr . unGObject

castToPadTemplate :: GObjectClass obj => obj -> PadTemplate
castToPadTemplate = castTo gTypePadTemplate "PadTemplate"

gTypePadTemplate :: GType
gTypePadTemplate =
  {# call fun unsafe gst_pad_template_get_type #}

-- *********************************************************************** Task

{#pointer *GstTask as Task foreign newtype #} deriving (Eq,Ord)

mkTask = (Task, objectUnref)
unTask (Task o) = o

class ObjectClass o => TaskClass o
toTask :: TaskClass o => o -> Task
toTask = unsafeCastGObject . toGObject

instance TaskClass Task
instance ObjectClass Task
instance GObjectClass Task where
  toGObject = GObject . castForeignPtr . unTask
  unsafeCastGObject = Task . castForeignPtr . unGObject

castToTask :: GObjectClass obj => obj -> Task
castToTask = castTo gTypeTask "Task"

gTypeTask :: GType
gTypeTask =
  {# call fun unsafe gst_task_get_type #}

-- ************************************************************************ XML

{#pointer *GstXML as XML foreign newtype #} deriving (Eq,Ord)

mkXML = (XML, objectUnref)
unXML (XML o) = o

class ObjectClass o => XMLClass o
toXML :: XMLClass o => o -> XML
toXML = unsafeCastGObject . toGObject

instance XMLClass XML
instance ObjectClass XML
instance GObjectClass XML where
  toGObject = GObject . castForeignPtr . unXML
  unsafeCastGObject = XML . castForeignPtr . unGObject

castToXML :: GObjectClass obj => obj -> XML
castToXML = castTo gTypeXML "XML"

gTypeXML :: GType
gTypeXML =
  {# call fun unsafe gst_xml_get_type #}

-- ***************************************************************** ChildProxy

{#pointer *GstChildProxy as ChildProxy foreign newtype #} deriving (Eq,Ord)

mkChildProxy = (ChildProxy, objectUnref)
unChildProxy (ChildProxy o) = o

class ObjectClass o => ChildProxyClass o
toChildProxy :: ChildProxyClass o => o -> ChildProxy
toChildProxy = unsafeCastGObject . toGObject

instance ChildProxyClass ChildProxy
instance ObjectClass ChildProxy
instance GObjectClass ChildProxy where
  toGObject = GObject . castForeignPtr . unChildProxy
  unsafeCastGObject = ChildProxy . castForeignPtr . unGObject

castToChildProxy :: GObjectClass obj => obj -> ChildProxy
castToChildProxy = castTo gTypeChildProxy "ChildProxy"

gTypeChildProxy :: GType
gTypeChildProxy =
  {# call fun unsafe gst_child_proxy_get_type #}

-- **************************************************************** CollectPads

{#pointer *GstCollectPads as CollectPads foreign newtype #} deriving (Eq,Ord)

mkCollectPads = (CollectPads, objectUnref)
unCollectPads (CollectPads o) = o

class ObjectClass o => CollectPadsClass o
toCollectPads :: CollectPadsClass o => o -> CollectPads
toCollectPads = unsafeCastGObject . toGObject

instance CollectPadsClass CollectPads
instance ObjectClass CollectPads
instance GObjectClass CollectPads where
  toGObject = GObject . castForeignPtr . unCollectPads
  unsafeCastGObject = CollectPads . castForeignPtr . unGObject

castToCollectPads :: GObjectClass obj => obj -> CollectPads
castToCollectPads = castTo gTypeCollectPads "CollectPads"

gTypeCollectPads :: GType
gTypeCollectPads =
  {# call fun unsafe gst_collect_pads_get_type #}

-- ***************************************************************** URIHandler

{#pointer *GstURIHandler as URIHandler foreign newtype #} deriving (Eq,Ord)

mkURIHandler = (URIHandler, objectUnref)
unURIHandler (URIHandler o) = o

class GObjectClass o => URIHandlerClass o
toURIHandler :: URIHandlerClass o => o -> URIHandler
toURIHandler = unsafeCastGObject . toGObject

instance URIHandlerClass URIHandler
instance GObjectClass URIHandler where
  toGObject = GObject . castForeignPtr . unURIHandler
  unsafeCastGObject = URIHandler . castForeignPtr . unGObject

castToURIHandler :: GObjectClass obj => obj -> URIHandler
castToURIHandler = castTo gTypeURIHandler "URIHandler"

gTypeURIHandler :: GType
gTypeURIHandler =
  {# call fun unsafe gst_uri_handler_get_type #}

-- ******************************************************************** Adapter

{#pointer *GstAdapter as Adapter foreign newtype #} deriving (Eq,Ord)

mkAdapter = (Adapter, objectUnref)
unAdapter (Adapter o) = o

class GObjectClass o => AdapterClass o
toAdapter :: AdapterClass o => o -> Adapter
toAdapter = unsafeCastGObject . toGObject

instance AdapterClass Adapter
instance GObjectClass Adapter where
  toGObject = GObject . castForeignPtr . unAdapter
  unsafeCastGObject = Adapter . castForeignPtr . unGObject

castToAdapter :: GObjectClass obj => obj -> Adapter
castToAdapter = castTo gTypeAdapter "Adapter"

gTypeAdapter :: GType
gTypeAdapter =
  {# call fun unsafe gst_adapter_get_type #}

-- ***************************************************************** Controller

{#pointer *GstController as Controller foreign newtype #} deriving (Eq,Ord)

mkController = (Controller, objectUnref)
unController (Controller o) = o

class GObjectClass o => ControllerClass o
toController :: ControllerClass o => o -> Controller
toController = unsafeCastGObject . toGObject

instance ControllerClass Controller
instance GObjectClass Controller where
  toGObject = GObject . castForeignPtr . unController
  unsafeCastGObject = Controller . castForeignPtr . unGObject

castToController :: GObjectClass obj => obj -> Controller
castToController = castTo gTypeController "Controller"

gTypeController :: GType
gTypeController =
  {# call fun unsafe gst_controller_get_type #}

