{-# OPTIONS -fglasgow-exts #-}
module HAppS.Util.Cron
    (Seconds, CronEvent(..), everyNthSecond,runBackground)
    where

import Control.Concurrent
import Data.Typeable
import HAppS.MACID
import HAppS.MACID.Logger
import HAppS.Util.Concurrent


data CronEvent = CronEvent deriving(Read,Show,Typeable)
instance Serialize CronEvent where
    typeString _  = "CronEvent"
    encodeStringM = defaultEncodeStringM
    decodeStringM = defaultDecodeStringM
instance LogFormat CronEvent where
    logFormat _ = show

-- | Send a pulse to the event handler every N seconds.
everyNthSecond :: Seconds -> Ev st CronEvent res -> Handler st
everyNthSecond sec run = ior :=> run
    where ior = do mv <- newEmptyMVar
                   forkIO $ let loop = sleep sec >> putMVar mv CronEvent >> loop in loop
                   return (takeMVar mv, \_ -> return ())

-- | Run a task in background. For internal uses mostly.
runBackground :: (LogFormat query, Serialize query) => 
                 Seconds
              -> (result -> IO query)
              -> query
              -> Ev st query result
              -> Handler st
runBackground sec back q0 run = ior :=> run
    where ior = do outmv <- newEmptyMVar
                   inpmv <- newEmptyMVar
                   let loop q = do sleep sec
                                   putMVar inpmv q
                                   loop =<< back =<< takeMVar outmv
                   forkIO $ loop q0
                   return (takeMVar inpmv, putMVar outmv)

{-
runBackgroundState :: Seconds
                   -> (state -> result -> IO (state,irequest))
                   -> irequest
                   -> state
                   -> (irequest -> MVar result -> orequest)
                   -> App any_ orequest
                   -> IO ()
runBackgroundState sec fun ireq st0 con app = loop ireq st0
    where sendEvent x = app (\_ -> return (), x)
          loop ir st = do sleep sec
                          mv <- newEmptyMVar
                          sendEvent $ con ir mv
                          (s,i) <- fun st =<< takeMVar mv
                          loop i s
-}
