module HAppS.Protocols.HTTP.LowLevel
    (-- * HTTP Implementation
     -- $impl

     -- * Problems
     -- $problems

     -- * API
     module HAppS.Protocols.HTTP.Handler,
     module HAppS.Protocols.HTTP.Listen,
     module HAppS.Protocols.HTTP.ServerPart,
     module HAppS.Protocols.HTTP.Types
    ) where

import HAppS.Protocols.HTTP.Handler
import HAppS.Protocols.HTTP.Listen
import HAppS.Protocols.HTTP.ServerPart
import HAppS.Protocols.HTTP.Types

-- $impl
-- The HAppS HTTP implementation supports HTTP 1.0 and 1.1.
-- Multiple request on a connection including pipelining is supported.

-- $problems
-- Currently if a client sends an invalid HTTP request the whole
-- connection is aborted and no further processing is done.
--
-- When the connection times out HAppS closes it. In future it could
-- send a 408 response but this may be problematic if the sending
-- of a response caused the problem.
