-----------------------------------------------------------------------------
-- |
-- Module      :  HAppS.Protocols.DNS.ChooseMethod
-- Copyright   :  (c) HAppS.org, 2006
-- License     :  BSD3
-- Portability :  portable
--
-- DNS resolving works as follows:
--
-- * if environment variable @NAMESERVER@ is not defined use global name servers
--
-- * if environment variable @NAMESERVER@ is defined and has the value \"resolv\" use @\/etc\/resolv.conf@.
--
-- * if environment variable @NAMESERVER@ is defined and has a list of IP-addresses separated by space, use them as proxys
--
-----------------------------------------------------------------------------
module HAppS.Protocols.DNS
  (
   -- * Lookups
   module HAppS.Protocols.DNS.NSTree,
   -- * Mail (MX records)
   module HAppS.Protocols.DNS.MXClient,
   -- * Utilities
   module HAppS.Protocols.DNS.Type,
   initDNS
  ) where
  
import HAppS.Protocols.DNS.ChooseMethod(initDNS)
import HAppS.Protocols.DNS.MXClient
import HAppS.Protocols.DNS.NSTree
import HAppS.Protocols.DNS.Type(Packet(..), RR(..), RRVal(..), emptyPacket, enc, qd, question, rquestion, rname, rrval, rttl, rtype, encIP, decIP)

