module HAppS.MACID.Saver.Impl.Queue (queueSaver) where

import HAppS.MACID.Saver.Types

import Control.Concurrent
import Control.Monad
import qualified Data.ByteString.Char8 as P

data Item = Close (IO ())
          | Add [P.ByteString] (IO ())

-- | A saver that bunches writes. Writes are propagated no ofter
--   than the given timeout in microseconds (same as threadDelay).
queueSaver :: Int -> SaverImpl -> IO SaverImpl
queueSaver autoInterval (Saver open close add get replace archive) = do
  ch   <- newCh
  pvar <- newEmptyMVar
  ptid <- forkIO $ permission autoInterval pvar
  let handler = do
        input <- getChs ch
        let il (Add p f : rest) a0 a1 = il rest (p:a0) (f:a1)
            il something        a0 a1 = (concat $ reverse a0, sequence_ $ reverse a1, something)
        let (ps,io,rest) = il input [] []
        when (not (null ps)) $ do add ps io
        case rest of
          []           -> takeMVar pvar >> handler
          (Close io:_) -> killThread ptid >> close >> io
          _            -> fail "queueSaver: Invalid saver bunch!"

  forkIO handler
  return $ Saver
    { saverOpen  = \fp -> queueSaver autoInterval =<< open fp
    , saverClose = do
        mv <- newEmptyMVar
        writeCh ch $ Close (close >> putMVar mv ())
        takeMVar mv
    , saverAdd   = \ps fin -> writeCh ch $ Add ps fin
    , saverGet   = get
    , saverAtomicReplace = replace
    , saverArchive = \_ -> return ()
    }

-- Give permission every Nth time-span
permission time mv = threadDelay time >> tryPutMVar mv () >> permission time mv


-- Sample variables/queues
-- int: <0, num of waiters,
--       0, empty
--       1, full
newtype Ch a = Ch (MVar (Int, MVar [a]))
newCh = do mv <- newEmptyMVar
           fmap Ch $ newMVar (0,mv)
writeCh :: Ch a -> a -> IO ()
writeCh (Ch ch) x = modifyMVar_ ch $ \(iv,mv) -> do
  case iv of
    1 -> modifyMVar_ mv (\xs -> return (x:xs)) >> return (1,mv)
    _ -> putMVar mv [x] >> return (iv+1,mv)
getChs :: Ch a -> IO [a]
getChs (Ch ch) = fmap reverse (takeMVar =<< modifyMVar ch (\(iv,mv) -> return ((iv-1,mv),mv)))


