{-# OPTIONS -fglasgow-exts #-}
-- | Monadic ACID
module HAppS.MACID
    (-- * ACID monad
     Ev, AnyEv,
     -- * Handler
     Handler(..), runTxSystem, TxControl(..),
     -- * Types
     TxId, EpochTime, MutVar,Proxy,Seconds,TxConfig(..),nullTxConfig,Saver(..),
     -- * Misc utilities
     module HAppS.MACID.Monad,
     getEvent, getEventId, getTime, -- evCreateEvent,
     module HAppS.MACID.Util,
     -- * Serialization
     module HAppS.MACID.Serialize,
     -- * Mutable Variables
     module HAppS.MACID.Var,
     -- * Unsafe things
     unsafeIOToEv
    ) where

import System.Log.Logger

import Control.Concurrent
import qualified Data.Map as M

import HAppS.MACID.Checkpoint
import HAppS.MACID.Logger
import HAppS.MACID.Monad
import HAppS.MACID.Saver
import HAppS.MACID.Serialize
import HAppS.MACID.SideEffect
import HAppS.MACID.Transaction
import HAppS.MACID.Types
import HAppS.MACID.Util
import HAppS.MACID.Var


data TxControl = TxControl
    { txCheckpointAndExit :: IO ()
    , txTerminationMVar :: MVar () -- Empty until the tx system has terminated.
    }

logMM = logM "HAppS.MACID.MACID"

-- | Run a transaction system 
runTxSystem :: Serialize st => TxConfig -> st -> [Handler st] -> IO TxControl
runTxSystem conf0 st0 hs = do
  queue <- newEmptyMVar
  tisrc <- newEmptyMVar
  logMM INFO "Starting initialization"
  side  <- startSideRunner (txcSideEffectThreads conf0) =<< createSaverImpl NullSaver
  logMM INFO "> starting logger"
  let lof s = saverOpen s "log"
  logger<- newLogChan =<< lof =<< createSaverImpl (txcLogger conf0)
  let txrun = TxRun queue side tisrc logger
  logMM INFO "> handlerToI"
  ihs   <- mapM handlerToI hs
  logMM INFO "> createEventLoaders"
  evl0  <- createEventLoaders txrun ihs
  let evl  = M.insert (typeString x) (\s _ -> do (CheckpointEvent,r) <- decodeStringM s; return (0,r)) evl0
      x    = proxy CheckpointEvent
  loadState txrun conf0 evl st0 (runTxLoop queue)
  logMM INFO "> Loading state and events ok - starting App"
  sequence_ [forkIO $ runHandler txrun h | h <- ihs]
  periodicCheckpoints txrun (txcCheckpointSeconds conf0) (txcCheckpointEvents conf0)
  termination <- newEmptyMVar
  return $ TxControl { txCheckpointAndExit = checkpointAndExit txrun >> putMVar termination (), txTerminationMVar = termination }

