{-# OPTIONS -fglasgow-exts -fallow-undecidable-instances #-}
--Copyright (C) 2005 HAppS.org.  All Rights Reserved.
module HAppS.DBMS.Table where

import qualified Prelude
import Prelude hiding (elem,lookup)
import qualified Data.List as List
-- import qualified Data.Map as Map
import qualified Data.Set as Set

import Data.Maybe
import Control.Monad
import Data.Monoid

--import qualified HAppS.DBMS.Index as Index
import qualified HAppS.DBMS.Index as Index
-- import HAppS.DBMS.IndexVal as IndexVal
import HAppS.Util.Common

newtype Id= MakeId Integer deriving (Ord,Eq,Read,Show)

--type Prop index key elt = IndexVal.Prop index key elt
data IV index item elt = Val elt | Fn (index item elt->Set.Set item)
nullIV = Fn (\_->Set.empty)

type Prop index item elt =IV index item elt
type Property index item elt = Prop index item elt
type IndexOrd = Index.Ord
type StdProp item elt = Property IndexOrd item elt

{--
decide how to handle updateIndex 
do I want to make it a part of the Item class?
--}

class Record item indexVal | item ->indexVal  
	where	index::[item -> indexVal item ]

class (Ord x)=>Listable col x where toList::col x->[x]

instance (Ord x)=>Listable Set.Set x where toList=Set.toList
instance (Ord x) => Listable [] x where toList=id

--instance (Table t a b)=>Listable t where toList=toList'


--(item->elt->index item elt->index item elt)

--use TH to make one of these for your set of indices
-- 
--instance (Table a b c)=>Listable a where

--class Null x where null::x->Bool
--instance Null [x] where null x = List.null x



class Empty x where empty::x

instance Empty [x] where empty=[]
instance Empty (Set.Set x) where empty=Set.empty
instance (Ord x,Ord y)=>Empty (Index.Ord x y) where empty=Index.empty
instance (Ord x,Ord y,Index.Wordable y)=>Empty (Index.Text x y) where empty=Index.empty

class (Ord item)=> 
	Table table item indexVal | table->indexVal, indexVal->table where
	--empty::table item
	toSet::table item -> Set.Set item

	setSet::Set.Set	item -> table item -> table item
	insertIndex::item->indexVal item -> table item ->table item
	deleteIndex::item->indexVal item -> table item ->table item
	queryFn::indexVal item -> table item -> Set.Set item

	groupByImpl::indexVal item -> table item ->[Set.Set item]

    --default implementations just for typechecking
	toSet _    = Set.empty
	setSet _ t = t
	insertIndex _ _ t = t
	deleteIndex _ _ t = t
	queryFn _ _ = Set.empty
	groupByImpl _ _ = []
	--getValsImpl v t = Set.empty



	--orderBy::table->indexVal->[Item]


{--
  we want to be able to do a simple query and join it with entries in another table
  the result of the join is ... a tuple?  a heterogenous list?  a list.
--}

outerJoin table ix fn fn2 items = concat $ map f $ toList items
	where
	f item = if Prelude.null matches then [(mzero,fn2 item)] 
			 else zip matches (repeat $ fn2 item)
		where
		matches = map return $ toList $ table // (ix.==.fn item)

innerJoin t ix f fn2 is= map (\ (x,y)->(fromJust x,y)) $ filter (isJust.fst) $
		  outerJoin t ix f fn2 is

outerGroupJoin table ix fn fn2 items = 
	outerJoin table ix (fn.head.toList) (fn2.toList) items
innerGroupJoin table ix fn fn2 items = 
	innerJoin table ix (fn.head.toList) (fn2.toList) items

sortBy f l= List.sortBy (comp f) (toList l)
groupBy f l= List.groupBy (\x y->f x==f y) (toList l)

groupByIx v t = groupByImpl (v nullIV) t

orderGroupsBy sort group list= (sortBy sort . groupBy group) $ sortBy group list

--flatGroupsBy f sort group list = concatMap f $ orderGroupsBy sort group list
--nestOrders [] items = concat items
--nestOrders (f:fs) items = concatMap (f . nestOrders fs) items

--getVals prop table= getValsImpl (prop $ Fn (\_->Set.emptySet

-- needs to be implemented
{--
takes a prop and returns a bunch of (Id Val val)
then we need a way to look up all the things that match that

--}

intersection t1 t2 = setOp Set.intersection t1 t2
union t1 t2 = setOp Set.union t1 t2
difference t1 t2 = setOp Set.difference t1 t2

size t =Set.size $ toSet t
null t =Set.null $ toSet t

fromSet s= Set.fold insert' empty s
--fromList list= foldlStrict insert empty list
fromList list = insert list empty
toList' t = Set.toList $ toSet t

from table q = q table
getOne table q =  if size r==0 then mzero else return $ head $ toList r
	where r=q table


insDelSet f i t = setSet (f i $ toSet t) t
setInsert i t= insDelSet Set.insert i t
setDelete i t= insDelSet Set.delete i t


update fn item table = foldlStrict (fn item) table ix
	where ix = revmap item index


insert1 i t = insert' i t
delete1 i t = delete' i t
replace1 old new = replace' old new
insert' i t = update insertIndex i $ setInsert i t
delete' i t = update deleteIndex i $ setDelete i t
replace' oldItem newItem = insert1 newItem . delete1 oldItem


insertList is t = foldlStrict insert' t  is
insert is t = foldlStrict insert' t $ toList is
delete is t = foldlStrict delete' t $ toList is
replace olds news = insert news . delete olds

name =: valFn = name . Val . valFn
obj // fn = fn obj
fn /. fn2 = fn2 . fn
ifZero c v = if c then return v else Nothing

setOp op table1 table2 = fromSet $ op (toSet table1) (toSet table2)


mkSet1 &&& mkSet2 = \db -> intersection (mkSet1 db) (mkSet2 db)
mkSet1 ||| mkSet2 = \db -> union (mkSet1 db) (mkSet2 db)
infixr 3 &&&
infixr 2 |||

--name .==. val = queryFn $ name $ Fn $ Index.eq val 
applyFn fn name = \table-> fromSet $ queryFn (name (Fn fn)) table

name .==. val = applyFn (Index.eq val) name
--name .==. val = \table-> fromSet $ queryFn (name (Fn $ Index.eq val)) table
name .<. val = applyFn (Index.lt val) name
name .<=. val = applyFn (Index.lte val) name
name .>. val = applyFn (Index.gt val) name
name .>=. val = applyFn (Index.gte val) name

--name .<. val = name `Index.lt` val
--name .>. val = name `Index.gt` val
name .~. val = \table-> fromSet $ queryFn (name (Fn $ Index.contains val)) table
name <? val = name elem val

t_AnyAll _  _  _     []        = const empty
t_AnyAll aa op name (val:vals) = aa (op name val) (t_AnyAll aa op name vals)

t_any op name vals = t_AnyAll (|||) op name vals
t_all op name vals = t_AnyAll (&&&) op name vals
--t_any op name [] = \table -> empty
--t_any op name (val:vals) = (op name val) ||| (t_any op name vals)


elem name vals= t_any (.==.) name vals
any op name vals=t_any op name vals
all op name vals=t_all op name vals
--elem name [] = \table -> empty
--elem name (val:vals) = --if List.null vals then name.==.val 
					   --else
--					   (name.==.val) ||| (elem name vals)


contains _    []         = id
contains name (val:vals) = if List.null vals then name .~. val 
			      else name .~. val ||| (contains name vals)


foldlStrict f x xs = List.foldl' (flip f) x xs

infix 4 .==.
infix 4 <?
--infixl 6 !
--a // b= a ! b
(??)=($)

infixl 6 //
infixl 6 /.
infixr 0 ??
infixr 0 =:


--type TextIndex k = IV Index.Text k String
--type OrdIndex k e = IV Index.OrdIndex k e

--utility stuff simple join

--join f tables = 
----Useful instances
