{-# OPTIONS -fglasgow-exts -fallow-overlapping-instances -fth #-}
-- Example of SessionKeeperEx

import HAppS hiding(simpleHTTP)
import HAppS.Agents.SessionKeeperEx as S
import HAppS.Protocols.MessageWrap.W hiding(w)
import HAppS.Protocols.SimpleHTTP
import HAppS.Util.EventHandler

type UEv a = Ev MyState Request a

data Foo

instance EventHandler Foo MyState String () where
  eventHandler _ = do ev <- getEvent
                      addSideEffect 30 $ putStrLn ("session expired Foo: "++show ev)

data Bar

instance EventHandler Bar MyState String () where
  eventHandler _ = do ev <- getEvent
                      addSideEffect 30 $ putStrLn ("session expired Bar: "++show ev)

data MyState = My { users   :: SessionStateEx Foo String
                  , other   :: SessionStateEx Bar String
                  } deriving(Read,Show)

$(inferRecordUpdaters ''MyState)
$(inferStartState ''MyState)

instance Serialize MyState where
    typeString _  = "MyState"
    encodeStringM = defaultEncodeStringM
    decodeStringM = defaultDecodeStringM


a :: Method -> Host -> [String] -> UEv Result
a _ _ ["n",k] = w $ withUsers $ S.newSession 30 k
a _ _ ["o",k] = w $ withOther $ S.newSession 30 k
a _ _ ["s",k] = w $ withUsers $ S.getSession $ read k
a _   _ p     = text $ sresult 403 ("Unknown path: "++show p)

w :: Show t => UEv t -> UEv Result
w c = wPure ehShow (\() -> text ((sresult 200 =<< fmap show c)))

text = fmap $ setHeader "Content-Type" "text/plain"

main = stdMain $ simpleHTTP "" [] a :*: End
