-- This is used for happs.org http server.
import Data.ByteString.Char8
import HAppS.Protocols.HTTP
import HAppS.Protocols.HTTP.LowLevel
import HAppS.Protocols.HTTP.FileServe
import HAppS.Protocols.SURI
import Text.Printf

config      = nullConf { port = 5000 }
serverParts = [logH, "/HAppS" `handleWith` [fileServ], rootH]
fileServ    = fileServe mimeTypes "HAppS" "/HAppS"
main = listen config $ compileServerParts (sresult 404 []) serverParts


rootH = MaybeHandle $ \req -> do
          case path (rqURI req) of
            "/" -> fmap Just $ redirect "/HAppS/README.html"
            _   -> return Nothing

logH = MaybeHandle $ \req -> do
  let mg x = maybe "unknown" unpack $ getHeader x req
  printf "%15s\t%25s\t%s\n" (mg "X-Forwarded-For") (mg "User-Agent") (render (rqURI req))
  return Nothing
