{-# OPTIONS -fglasgow-exts -fallow-overlapping-instances -fth #-}
-- Example of SessionKeeperEx

import Control.Monad.State
import HAppS
import HAppS.Agents.WithBlockingIO
import HAppS.Protocols.MessageWrap.W hiding(w)
import HAppS.Protocols.SimpleHTTP
import HAppS.Util.EventHandler
import HAppS.Util.Concurrent

type UEv a = Ev MyState Request a

data Foo
instance EventHandler Foo MyState String () where
  eventHandler _ = do ev <- getEvent
                      addSideEffect 30 $ putStrLn ("Foo: setting msg to: "++show ev)
                      modify $ \st -> st { msg = ev }

data Bar
instance EventHandler Bar MyState Int Int where
  eventHandler _ = do ev <- getEvent
                      addSideEffect 30 $ putStrLn ("Bar: setting msg to: "++show ev)
                      modify $ \st -> st { msg = show ev }
                      return (2*ev)

data MyState = My { foo     :: BlockingIOState Foo
                  , bar     :: BlockingIOState Bar
                  , msg     :: String
                  }

$(inferRecordUpdaters ''MyState)
$(inferStartState ''MyState)

instance Serialize MyState where
    typeString _  = "MyState"
    encodeStringM (My a b c) = liftM concat $ sequence [encodeStringM a, encodeStringM b, encodeStringM c]
    decodeStringM s0 = do (a,s1) <- decodeStringM s0
                          (b,s2) <- decodeStringM s1
                          (c,s3) <- decodeStringM s2
                          return (My a b c,s3)


a :: Method -> Host -> [String] -> UEv (IO Result)
a _ _ ["a",k] = w $ withFoo $ withBlockingIO_ 50 $ do
                  putStrLn ("0 running IO for "++show k)
                  sleep 10
                  putStrLn ("E running IO for "++show k)
                  return k
a _ _ ["b",k] = w $ withBar $ withBlockingIO 50 $ do
                  putStrLn ("0 running IO for "++show k)
                  sleep 1
                  putStrLn ("E running IO for "++show k)
                  return $ read k
a _   _ ["a"] = w $ gets msg
a _   _ p     = return $ tres 403 ("Unknown path: "++show p)

class ResultM a where res :: a -> UEv (IO Result)
instance Show a => ResultM (Wrap (IO a)) where res x = return  (unWrap x >>= tres 200 . show)
instance Show a => ResultM (Wrap a)      where res x = return $ tres 200 $ show (unWrap x)


w :: forall t. ResultM (Wrap t) => UEv t -> UEv (IO Result)
w c = wIO ehShow (\() -> c >>= resM)

resM :: ResultM (Wrap t) => t -> UEv (IO Result)
resM x = res $ Wrap x

tres :: Monad m => Int -> String -> m Result
tres c x = return . setHeader "Content-Type" "text/plain" =<< sresult c x

main = stdMain $ simpleHTTPIO "" [] a :*: End

