/* gxset - GTK interface to xset(1)

   Copyright (C) 1999 Ren Seindal (rene@seindal.dk)

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 
 */

#ifndef _GUISTUFF_H
#define _GUISTUFF_H 1

#include "main.h"

#include <gtk/gtk.h>

/* 
 * This struct holds all the interesting widgets in the GUI
 */
struct GUI {
    GtkWidget *gxset;

    GtkWidget *keyrepeat_onoff;
    GtkWidget *keyrepeat_delay;
    GtkWidget *keyrepeat_rate;

    GtkWidget *keyclick_onoff;
    GtkWidget *keyclick_volume;

    GtkWidget *bell_onoff;
    GtkWidget *bell_pitch;
    GtkWidget *bell_volume;
    GtkWidget *bell_duration;
    GtkWidget *beep_button;

    GtkWidget *mouse_accel;
    GtkWidget *mouse_threshold;

    GtkWidget *scrsaver_onoff;
    GtkWidget *scrsaver_delay;
    GtkWidget *scrsaver_cycle;
    GtkWidget *scrsaver_blank;
    GtkWidget *scrsaver_expose;

    GtkWidget *dpms_onoff;
    GtkWidget *dpms_standby;
    GtkWidget *dpms_off;
    GtkWidget *dpms_suspend;

    GtkWidget *font_path;
    GtkWidget *font_button_new;
    GtkWidget *font_button_edit;
    GtkWidget *font_button_up;
    GtkWidget *font_button_down;
    GtkWidget *font_button_remove;

    GtkWidget *button_ok;
    GtkWidget *button_apply;
    GtkWidget *button_save;
    GtkWidget *button_cancel;
};
typedef struct GUI GUI;

GtkWidget *find_widget(GtkWidget *w, const char *name);

void make_gui(GtkWidget *w);
GUI *get_widget_gui(GtkWidget *w);

ApplicationState *get_application_state(GtkWidget *w);

void adjust_font_buttons(GtkWidget *, ApplicationState *);
void set_font_path(GtkWidget *, ApplicationState *);

void set_gui_state(GtkWidget *, ApplicationState *);
void get_gui_state(GtkWidget *, ApplicationState *);

/* Font input dialog - gives font spec for xset */

GtkWidget *font_dialog_new(gchar *old_path);
gchar *font_dialog_get_data(GtkWidget *);

#endif
