/***************************************************************************
                          helpme.cpp  -  description
                             -------------------
    begin                : Tue Jul 25 2000
    begin                : Sat Dec 4 1999
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "helpme.h"
//#include <kurllabel.h>
#include <qprogressdialog.h>
#include <sys/stat.h>
#if defined(Q_WS_X11_)
#include <unistd.h>
#endif
#if defined(Q_WS_WIN)
#include <windows.h>
#endif
#include "helpwindow.h"

HelpMe::HelpMe(QWidget *parent,  QString name ) : QDialog(parent,name) {
#if defined(Q_WS_WIN)
    this->setIcon(QPixmap(local_library+"pix/gutenbrowser.png"));
#else
    this->setIcon(QPixmap("/usr/share/gutenbrowser/pix/gutenbrowser.png"));
#endif
#ifdef Q_WS_QWS
    local_library = (QDir::homeDirPath ()) +"/gutenbrowser/";
    resize(240,320);
    setMinimumSize(240,320);
    setMaximumSize(240,320);
#else
    local_library = (QDir::homeDirPath ()) +"/.gutenbrowser";
    resize(500,400);
#endif
    setCaption(tr("Gutenbrowser version " VERSION));

    QLabel *Edit;
    Edit = new QLabel(this, "");

    Edit->setText(tr("<p>Gutenbrowser " VERSION " (Phoenix)"
	                  "<p>Based on gutenbook.pl, available from <br><b>http://www.gutenbook.org</b><br>"
                     "Much appreciation to Lee Burgess, for the original idea and concept of gutenbook.</p>"
                     "<p>A list of current Gutenberg ftp sites is at <br><b>http://promo.net/pg/index.html</p>"
                     "<p>For bug reports, comments or questions about Gutenbrowser, email<br>"
                     "<b>Lorn Potter &lt;lpotter@trolltech.com&gt;</b></p>"
                     "<p>Made using QT, a cross platform development API<br><b>http://www.trolltech.com</b></p>"
                     "Copyright 2000-2004 by L. Potter<br>Licensed on linux by the GPL and QPL<br>"
                     "Licensed on windows with the Qt Non Comemrcial license"
                    ));
    QString pixDir;
#if defined(Q_WS_X11_)
    pixDir = "/usr/share/gutenbrowser";
#endif
#if defined(Q_WS_WIN)
    pixDir = local_library;
#endif
#ifdef Q_WS_QWS
    pixDir="/usr/share/gutenbrowser"; //or wherever this ends up to be
#endif

    QPushButton *help;
    help = new QPushButton(this);
    help->setPixmap( QPixmap( pixDir+"/pix/help.png"));
    help->setText("Help");
    connect( help,SIGNAL(clicked()),this,SLOT( help() ));

    QPushButton *ok;
    ok = new QPushButton(this);
    ok->setPixmap(  QPixmap( pixDir+"/pix/exit.png"));
    ok->setText("ok");
    connect(ok,SIGNAL(clicked()),this,SLOT(accept()));

#ifdef Q_WS_QWS
    //    StatusBar->setGeometry(10,10,220,20);
    Edit->setGeometry(10,30,230,280);
    help->setGeometry(165,3,30,25);
    ok->setGeometry(200,3,30,25);
    //    QTlabel->setGeometry(10,300,320,50);
#else
    //      StatusBar->setGeometry(10,10,220,20);
    Edit->setGeometry(10,40,480,360);
    help->setGeometry(360,10,60,28);
    ok->setGeometry(430,10,60,28);
    //      QTlabel->setGeometry(10,300,420,50);
#endif
}

HelpMe::~HelpMe() {
    //delete Edit;

}

void HelpMe::goToURL() {

    url = "http://www.llornkcor.com/";
    goGetit( url);
}

void HelpMe::goToURL2() {
    url = "http://www.gutenberg.org";
    goGetit( url);
}

void HelpMe::goToURL3() {
    url = "http://www.gutenbook.org";
    goGetit( url);
}

void HelpMe::goGetit( QString url) {
    HelpWindow *help = new HelpWindow( url, ".", 0, "gutenbrowser");
    //    help->setCaption("Qt Example - Helpviewer");
    help->show();
}

void HelpMe::help() {
    QString msg ;
#if defined(Q_WS_X11_)

    msg="/usr/share/doc/gutenbrowser/index.html";
#endif

#if defined(Q_WS_WIN)

    msg=local_library+"/doc/index.html";
    if( msg.find( "//", 0, true) != -1)
        msg.replace( msg.find( "//", 0, true) , 2, "/");
    // can use url translate function here I think
#endif
#ifdef Q_WS_QWS

    msg="/usr/share/doc/gutenbrowser/index.html"; // or where ever this ends up to be
#endif
    //    QString url = "file://"+msg;
    //    goGetit( url);
    goGetit( msg);
}
