/***************************************************************************
                          gutenbrowser.cpp  -  description
                             -------------------
    begin                : Mon Jul 24 22:33:12 MDT 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
***************************************************************************/
/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
//#include "gutenbrowserData.h"
#include "gutenbrowser.h"
void Gutenbrowser::initSlots() {
    qDebug("Setting up slots.");
    connect(LibraryButton,SIGNAL(clicked()),SLOT(LibraryBtn()));
    connect(OpenButton,SIGNAL(clicked()),SLOT(OpenBtn()));
    connect(ForwardButton,SIGNAL(clicked()),SLOT(ForwardBtn()));
    connect(BackButton,SIGNAL(clicked()),SLOT(BackBtn()));
    connect(PrintButton,SIGNAL(clicked()),SLOT(PrintBtn()));
    connect(SearchButton,SIGNAL(clicked()),SLOT(SearchBtn()));

    connect(lastBmkButton, SIGNAL(released()),SLOT(Bookmark()));
    //      connect( lastBmkButton, SIGNAL(pressed()), SLOT( annotations() ) );
    //      lastBmkButton-> setAutoRepeat(true);
    connect(setBookmarkButton,SIGNAL(released()),SLOT(setBookmark()));
    connect(FontButton,SIGNAL(clicked()),SLOT(ChangeFont()));
    connect(ClearButton,SIGNAL(clicked()),SLOT(ClearEdit()));
    connect(OptionsButton,SIGNAL(clicked()),SLOT(doOptions()));
    connect(HelpButton,SIGNAL(clicked()),SLOT(HelpBtn()));
    connect(dictionaryButton,SIGNAL(clicked()),SLOT(LookupBtn()));
    connect(beginButton,SIGNAL(clicked()),SLOT(BeginBtn()));
    connect(InfoBar,SIGNAL(clicked()),SLOT(InfoBarClick()));

}

void Gutenbrowser::initConfig() {
    //qDebug("Starting configuration.");
    QDir library(local_library);
    if ( !library.exists()) {
        library.mkdir(local_library, true);
        QString msg;
    }
    //    qDebug( "init file is %s",iniFile.latin1());

    config->setGroup( "General" );
    QString s_Split = config->readEntry("Splitter", "true" );
    QWidget *d = QApplication::desktop();
    int width = d->width();
    int height = d->height();
    int w = 0, h = 0;
    QString str, str2;

    if(s_Split == "true")
        useSplitter = true;
    else
        useSplitter = false;

    config->setGroup( "Geometry" );
    if(width < 1030) {
        str = config->readEntry("Frame", "700,500");
        if(  !str.isEmpty() && str.find(',') >= 0) {
            sscanf(str,"%d,%d",&w,&h);
            resize(w,h);
            str2.sprintf("%d,%d", (width - w) / 2,(height - h) / 2);
            str = config->readEntry( "Position", str2);
        } else {
            resize( 740,510 );
            str2.sprintf("%d,%d", (width - w) / 2,(height - h) / 2);
            str = config->readEntry( "Position",str2);
        }
    } else {// desktop is high res
				QString idealWidth, idealHeight;
				bool ok;
				idealWidth.toInt( &ok,width);
				idealHeight.toInt( &ok,height);
        str = config->readEntry("Frame", idealWidth +","+ idealHeight );
        if(  !str.isEmpty() && str.find(',')>=0) {
            sscanf(str,"%d,%d",&w,&h);
            resize(w,h);
            str2.sprintf("%d,%d", (width-w)/2,(height-h)/2);
            str = config->readEntry( "Position", str2);
        } else {
            resize( 990,640 );
            str2.sprintf("%d,%d", (width-w)/2,(height-h)/2);
            str = config->readEntry( "Position", str2);
        }
    }
    int posX, posY;
    bool ok;
    QString goober;
    goober = str.left( str.find(",", 0, true) );
    posX = goober.toInt( &ok, 10);
    goober = str.right( str.findRev(",", -1, true) );
    posY = goober.toInt( &ok, 10);

    move( posX, posY);

    str = config->readEntry("Icons", "true");
    if(str == "true")
        useIcons = true;
    else
        useIcons = false;
#if defined(Q_WS_WIN)

//    move( posX-4, posY-20);
#endif

    QString copying;
#if defined(Q_WS_WIN)

    copying = "C://.gutenbrowser/COPYING";
#else

    copying="/usr/share/gutenbrowser/COPYING";
#endif

    config->setGroup( "Bookmarks" );
    file_name=config->readEntry("File Name",copying);
    QString s_pageNum = config->readEntry("Page Number", "0");
    QString s_Bmrkrow;
    s_Bmrkrow = config->readEntry("LineNumber","0");

    config->setGroup("General");
    QString qExit;
    qExit = config->readEntry("queryExit","true");

    if(qExit == "true") {
        b_queryExit = true;
    } else {
        b_queryExit = false;
    }

}//// end initConfig()

void Gutenbrowser::initMenuBar() {
    //    qDebug("Starting menu init.");
    // menuBar entry fileMenu
    QString pixDir;
#if defined(Q_WS_WIN)
    pixDir = local_library;
#else
    pixDir = "/usr/share/gutenbrowser";
    if(!QDir(pixDir).exists())
        pixDir = local_library;
#endif

    menubar = new QMenuBar(this);
    // menubar->setMinimumWidth(200);

    fileMenu = new QPopupMenu(this);
    fileMenu->insertItem( QPixmap( pixDir+"/pix/openbook.png"),"&Open Local Library...", this, SLOT( OpenBtn()) );
    fileMenu->insertItem( QPixmap( pixDir+"/pix/exit.png"), "&Quit Gutenbrowser...", this, SLOT( ByeBye()) );
    // menuBar entry editMenu
    editMenu = new QPopupMenu(this);
    editMenu->insertItem( QPixmap( pixDir+"/pix/up.png"),"&Begin", this, SLOT(BeginBtn()) );
    editMenu->insertItem( QPixmap( pixDir+"/pix/forward.png"),"&Forward", this, SLOT(ForwardBtn()) );
    editMenu->insertItem( QPixmap( pixDir+"/pix/back.png"), "&Backward", this, SLOT(BackBtn()) );
    editMenu->insertItem( QPixmap( pixDir+"/pix/up.png"), "&Top", this, SLOT(TopBtn()) );
    editMenu->insertItem( QPixmap( pixDir+"/pix/search.png"), "&Search", this, SLOT(SearchBtn()) );
    editMenu->insertItem( QPixmap( pixDir+"/pix/eraser.png"), "Clea&r", this, SLOT(ClearEdit()) );
    editMenu->insertItem( QPixmap( pixDir+"/pix/fileprint.png"),"&Print", this, SLOT(PrintBtn()) );

    // menuBar entry viewMenu
    viewMenu = new QPopupMenu(this);
    viewMenu->insertItem( QPixmap( pixDir+"/pix/openbook.png"), "&Local", this, SLOT(OpenBtn()) );
    viewMenu->insertItem( QPixmap( pixDir+"/pix/home.png"),"&Gutenberg", this, SLOT(LibraryBtn()) );

    optionsMenu= new QPopupMenu(this);
    optionsMenu->insertItem( QPixmap( pixDir+"/pix/configure.png"),"&Configure", this, SLOT(doOptions()) );

    optionsMenu->insertItem( QPixmap( pixDir+"/pix/text.png"),"Change& Font", this, SLOT(ChangeFont()) );
    bookmarksMenu = new QPopupMenu(this);
    bookmarksMenu->insertItem( QPixmap(pixDir+"/pix/flag.png"),"&Goto", this, SLOT(Bookmark() ));
    bookmarksMenu->insertItem( QPixmap( pixDir+"/pix/tick.png"),"Se&t", this, SLOT(setBookmark()) );

    // menuBar entry helpMenu
    helpMenu = new QPopupMenu(this);
    helpMenu->insertItem(QPixmap( pixDir+"/pix/help.png"),"&About...", this, SLOT(HelpBtn()) );

    menubar->insertItem("&File", fileMenu);
    menubar->insertItem("&Page", editMenu);

    if(useSplitter)
        menubar->insertItem("&Library", viewMenu);
    menubar->insertItem("&Options", optionsMenu);
    if(useSplitter)
        menubar->insertItem("&Bookmarks", bookmarksMenu);

    menubar->insertSeparator();
    menubar->insertItem("&Help", helpMenu);

    menu->addWidget( menubar,0);

    topLayout->addLayout( menu, 0);

    topLayout->setResizeMode(QLayout::FreeResize);

    setMinimumSize(240,320);
}

void Gutenbrowser::initButtonBar() {

    OpenButton = new QPushButton( this, "OpenButton" );
    OpenButton->setFocusPolicy( QWidget::TabFocus );
    OpenButton->setBackgroundMode( QWidget::PaletteBackground );
//    OpenButton->setFlat(true);

    LibraryButton = new QPushButton( this, "LibraryButton" );
    LibraryButton->setFocusPolicy( QWidget::TabFocus );
    LibraryButton->setBackgroundMode( QWidget::PaletteBackground );
//    LibraryButton->setFlat(true);

    BackButton = new QPushButton( this, "BackButton" );
    BackButton->setFocusPolicy( QWidget::TabFocus );
    BackButton->setBackgroundMode( QWidget::PaletteBackground );
//    BackButton->setFlat(true);

    ForwardButton = new QPushButton( this, "ForwardButton" );
    ForwardButton->setFocusPolicy( QWidget::TabFocus );
    ForwardButton->setBackgroundMode( QWidget::PaletteBackground );
//    ForwardButton->setFlat(true);

    PrintButton = new QPushButton( this, "PrintButton" );
    PrintButton->setFocusPolicy( QWidget::TabFocus );
    PrintButton->setBackgroundMode( QWidget::PaletteBackground );
//    PrintButton->setFlat(true);

    FontButton = new QPushButton( this, "FontButton" );
    FontButton->setFocusPolicy( QWidget::TabFocus );
    FontButton->setBackgroundMode( QWidget::PaletteBackground );
//    FontButton->setFlat(true);

    ClearButton = new QPushButton( this, "ClearButton" );
    ClearButton->setFocusPolicy( QWidget::TabFocus );
    ClearButton->setBackgroundMode( QWidget::PaletteBackground );
//    ClearButton->setFlat(true);

    OptionsButton = new QPushButton( this, "OptionsButton" );
    OptionsButton->setFocusPolicy( QWidget::TabFocus );
    OptionsButton->setBackgroundMode( QWidget::PaletteBackground );
//    OptionsButton->setFlat(true);

    HelpButton = new QPushButton( this, "AboutButton" );
    HelpButton->setFocusPolicy( QWidget::TabFocus );
    HelpButton->setBackgroundMode( QWidget::PaletteBackground );
//    HelpButton->setFlat(true);
    //  beginButton
    beginButton = new QPushButton( this, "beginButton" );
    beginButton->setFocusPolicy( QWidget::TabFocus );
    beginButton->setBackgroundMode( QWidget::PaletteBackground );
    beginButton->setText("^");
    beginButton->setMaximumHeight(24);
//    beginButton->setFlat(true);

    SearchButton = new QPushButton( this, "SearchButton" );
    SearchButton->setFocusPolicy( QWidget::TabFocus );
    SearchButton->setBackgroundMode( QWidget::PaletteBackground );
//    SearchButton->setFlat(true);

    setBookmarkButton = new QPushButton( this, "setBookmark" );
    setBookmarkButton->setFocusPolicy( QWidget::TabFocus );
    setBookmarkButton->setBackgroundMode( QWidget::PaletteBackground );
    setBookmarkButton->setFlat(true);

    lastBmkButton = new QPushButton( this, "lastBmkButton" );
    lastBmkButton->setFocusPolicy( QWidget::TabFocus );
    lastBmkButton->setBackgroundMode( QWidget::PaletteBackground );
//    lastBmkButton->setFlat(true);

    dictionaryButton = new QPushButton( this, "dictionaryButton" );
    dictionaryButton->setFocusPolicy( QWidget::TabFocus );
    dictionaryButton->setBackgroundMode( QWidget::PaletteBackground );
//    dictionaryButton->setFlat(true);

    InfoBar = new QPushButton( this, "Info_Bar" );
    InfoBar->setText( " ");
//    InfoBar->setFlat(true);
    InfoBar->setMaximumHeight(24);
    buttonsHidden = false;

    buttons->addWidget( OpenButton, 0, AlignTop);
    buttons->addWidget( LibraryButton, 0, AlignTop);
    buttons->addWidget( BackButton, 0, AlignTop);
    buttons->addWidget( ForwardButton, 0, AlignTop);
    buttons->addWidget( SearchButton, 0, AlignTop);
    buttons->addWidget( setBookmarkButton, 0, AlignTop);
    buttons->addWidget( lastBmkButton, 0, AlignTop);
    buttons->addWidget( ClearButton, 0, AlignTop);
    buttons->addWidget( PrintButton, 0, AlignTop);
    buttons->addWidget( OptionsButton, 0, AlignTop);

    buttons->addWidget( FontButton, 0, AlignTop);
    buttons->addWidget( beginButton, 0, AlignTop);

    buttons->addWidget( dictionaryButton, 10, AlignTop);
    buttons->addStretch(5);
    buttons->addWidget( InfoBar, 10, AlignTop);

    buttons->addStretch(5);
    buttons->addWidget( HelpButton, 0, AlignRight);

    topLayout->addLayout( buttons, 10);

    QToolTip::add
        ( PrintButton, ("Prints the document" ));
    QToolTip::add
        ( FontButton, ("Change the current font" ));
    QToolTip::add
        ( ClearButton, ("Clears the text" ));
    QToolTip::add
        ( OptionsButton, ("Opens options configuration dialog" ));
    QToolTip::add
        ( beginButton, ("scrolls text to the beginning" ));
    QToolTip::add
        ( HelpButton, ("Help/About info" ));


    QToolTip::add
        ( LibraryButton, ("Opens the gutenberg library to download from" ));
    QToolTip::add
        ( OpenButton, ("Open a book from your local library" ));
    QToolTip::add
        ( ForwardButton, ("Page forward" ));
    QToolTip::add
        ( BackButton, ("Page backward" ));
    QToolTip::add
        ( SearchButton, ("Searches etext for a word"));
    QToolTip::add
        ( lastBmkButton, ("Opens last set bookmark" ));
    QToolTip::add
        ( setBookmarkButton, ("Sets bookmark to current etext and page" ));
    QToolTip::add
        ( dictionaryButton, ("wwwebster dictionary lookup of highlighted word" ));
    QToolTip::add
        ( InfoBar, ("Click to search google.com on title" ));

}

/* STATUSBAR*/
void Gutenbrowser::initStatusBar() {
    statusBar = new QStatusBar( this, "Status Bar");
    topLayout->addWidget( statusBar, 0);
    statusBar->message(IDS_STATUS_DEFAULT, 2000);
}

void Gutenbrowser::initView() {
    // set the main widget here
    QFont defaultFont("charter",10,50,0);
    config->setGroup("Font");
    QFont font = config->readFontEntry( "Family", &defaultFont);

    splitter = new QSplitter( Qt::Horizontal, this, "Splitter" );

    splitter->setMargin(10);

    Lview = new MultiLine_Ex( splitter );

    if (useSplitter) {
        Rview = new MultiLine_Ex( splitter );
        Rview->setFont( font );
        Rview->setReadOnly( true);
        Rview->setFocusPolicy( QWidget::NoFocus);
    }

    Lview->setFont( font );
    Lview->setReadOnly( true);
    Lview->setFocusPolicy( QWidget::NoFocus);

    printer = new QPrinter;
    //    QBrush paper;
    //    QString pix_dir = local_library+"/pix/parchment.xpm";
    //    QString pix_dir = local_library+"/pix/parchment_2.xpm";
    //    QString pix_dir = local_library+"/pix/parchment_3.xpm";
    //    paper.setPixmap( QPixmap( pix_dir ) );
    //    Lview->setPaper( paper );
    //    Rview->setPaper( paper );
    //Lview->clearTableFlags (Tbl_vScrollBar|Tbl_hScrollBar);
    //  Lview->adjustSize ();
    //  ensureVisible(  -4, -4, 4, 4);
    //  center ( 0, 0, 4, 4 );
    //  Rview->adjustSize ();
    //  ensureVisible(  -4, -4, 4, 4);
    //  center ( 0, 0, 4, 4);
    //Lview->setMargin ( 10);
    //Rview->setMargin ( 10 );

    //visibleHeight ()
    //QScrollView::scrollBy ( int dx, int dy ) [slot]
    //QScrollView::contentsHeight () const

    edits->addWidget( splitter);

    topLayout->addLayout( edits, 10);


    QString fontStr, pointSizeStr, weightStr, italicStr, boldStr;
    int italic;
    bool bold;
    config->setGroup("Font");
    QFont font2;

#if defined(Q_WS_WIN)

    fontStr = config->readEntry( "Family", "Century Schoolbook");
#endif
#if defined(Q_WS_X11_)

    fontStr = config->readEntry( "Family", "helvetica");
#endif

    font2.setFamily( fontStr);
    pointSizeStr = config->readEntry( "Size", "10");
    weightStr=config->readEntry("Weight", "40" );
    italicStr= config->readEntry("Italic", "false" );
    boldStr= config->readEntry("Bold", "false");

    if(italicStr == "true")
        italic= true;
    else
        italic=false;
    if( boldStr == "true")
        bold = true;
    else
        bold=false;

    bool ok;
    int pointSize=pointSizeStr.toInt( &ok, 10);
    int weight=weightStr.toInt( &ok, 10);

    font2.setPointSize( pointSize);
    font2.setItalic( italic);
    font2.setWeight( weight);
    font2.setBold( bold);

    Lview->setFont( font2);

    if(useSplitter)
        Rview->setFont( font2);

    //    Lview->setMinimumSize( 495,640 );
    //    Rview->setMinimumSize( 495,640 );


}
