/*
 * Copyright (C) 2009, 2010 Hermann Meyer, James Warden, Andreas Degert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * ---------------------------------------------------------------------------
 *
 *    This is the 12ax7 tube table
 *    This file is part of the Guitarix Audio Engine
 *
 * ----------------------------------------------------------------------------
 */

struct tabled tubetable[] = {
	{ // Ri = 68k
	-5,5,200, {
	249.98706929,249.986851225,249.986629489,249.986404021,249.986174757,
	249.985941635,249.985704589,249.985463554,249.985218463,249.984969247,
	249.984715838,249.984458166,249.984196158,249.983929743,249.983658846,
	249.983383392,249.983103306,249.982818508,249.982528921,249.982234464,
	249.981935056,249.981630613,249.981321052,249.981006287,249.98068623,
	249.980360793,249.980029887,249.979693419,249.979351296,249.979003424,
	249.978649708,249.978290048,249.977924346,249.9775525,249.977174409,
	249.976789967,249.976399069,249.976001606,249.97559747,249.975186548,
	249.974768727,249.974343893,249.973911927,249.973472711,249.973026125,
	249.972572044,249.972110345,249.9716409,249.971163579,249.970678252,
	249.970184785,249.969683043,249.969172887,249.968654177,249.968126772,
	249.967590526,249.967045292,249.96649092,249.965927258,249.965354153,
	249.964771446,249.964178978,249.963576587,249.962964107,249.962341372,
	249.961708211,249.96106445,249.960409914,249.959744424,249.959067797,
	249.95837985,249.957680393,249.956969237,249.956246188,249.955511048,
	249.954763616,249.95400369,249.953231063,249.952445523,249.951646857,
	249.950834849,249.950009276,249.949169916,249.94831654,249.947448916,
	249.946566809,249.945669979,249.944758184,249.943831177,249.942888706,
	249.941930516,249.940956349,249.93996594,249.938959023,249.937935324,
	249.936894568,249.935836475,249.934760758,249.933667127,249.932555289,
	249.931424944,249.930275788,249.929107511,249.9279198,249.926712337,
	249.925484796,249.92423685,249.922968162,249.921678394,249.9203672,
	249.91903423,249.917679127,249.916301529,249.914901069,249.913477372,
	249.912030061,249.910558748,249.909063042,249.907542547,249.905996856,
	249.904425561,249.902828244,249.901204482,249.899553844,249.897875894,
	249.896170188,249.894436274,249.892673696,249.890881989,249.889060679,
	249.887209288,249.885327328,249.883414305,249.881469716,249.879493052,
	249.877483793,249.875441414,249.87336538,249.87125515,249.869110171,
	249.866929885,249.864713724,249.86246111,249.860171458,249.857844173,
	249.855478652,249.853074281,249.850630438,249.848146491,249.845621799,
	249.843055711,249.840447565,249.837796689,249.835102404,249.832364016,
	249.829580824,249.826752115,249.823877166,249.820955243,249.8179856,
	249.81496748,249.811900117,249.80878273,249.80561453,249.802394713,
	249.799122465,249.795796959,249.792417358,249.788982809,249.785492449,
	249.781945403,249.778340779,249.774677678,249.770955183,249.767172365,
	249.763328284,249.759421981,249.75545249,249.751418824,249.747319988,
	249.743154968,249.738922738,249.734622257,249.730252468,249.725812301,
	249.72130067,249.716716471,249.712058589,249.70732589,249.702517225,
	249.697631429,249.692667321,249.687623703,249.682499361,249.677293063,
	249.672003562,249.666629592,249.661169871,249.655623098,249.649987954,
	249.644263106,249.638447197,249.632538857,249.626536694,249.620439299,
	249.614245244,249.607953082,249.601561346,249.59506855,249.588473189,
	249.581773739,249.574968653,249.568056367,249.561035295,249.553903831,
	249.546660348,249.5393032,249.531830718,249.524241211,249.516532969,
	249.508704259,249.500753327,249.492678397,249.48447767,249.476149326,
	249.467691521,249.459102391,249.450380046,249.441522576,249.432528047,
	249.423394501,249.414119957,249.404702411,249.395139834,249.385430176,
	249.37557136,249.365561287,249.355397831,249.345078845,249.334602156,
	249.323965565,249.313166851,249.302203767,249.291074039,249.27977537,
	249.268305439,249.256661896,249.244842368,249.232844458,249.220665739,
	249.208303762,249.195756051,249.183020104,249.170093394,249.156973366,
	249.143657441,249.130143014,249.116427453,249.102508098,249.088382267,
	249.074047249,249.059500307,249.044738677,249.029759572,249.014560175,
	248.999137645,248.983489114,248.967611688,248.951502446,248.935158442,
	248.918576704,248.901754233,248.884688005,248.867374969,248.84981205,
	248.831996145,248.813924127,248.795592843,248.776999115,248.75813974,
	248.739011488,248.719611106,248.699935316,248.679980814,248.659744274,
	248.639222342,248.618411645,248.597308781,248.575910327,248.554212837,
	248.532212841,248.509906845,248.487291335,248.464362771,248.441117595,
	248.417552224,248.393663055,248.369446462,248.344898801,248.320016406,
	248.29479559,248.269232647,248.243323852,248.217065459,248.190453706,
	248.163484811,248.136154974,248.108460379,248.080397191,248.05196156,
	248.02314962,247.993957487,247.964381265,247.934417041,247.904060889,
	247.87330887,247.84215703,247.810601403,247.778638011,247.746262866,
	247.713471967,247.680261303,247.646626855,247.612564592,247.578070476,
	247.543140461,247.507770494,247.471956513,247.435694453,247.398980241,
	247.3618098,247.32417905,247.286083906,247.247520279,247.208484082,
	247.168971222,247.128977607,247.088499146,247.047531747,247.00607132,
	246.964113777,246.921655031,246.878691002,246.835217611,246.791230785,
	246.746726457,246.701700566,246.656149058,246.610067887,246.563453015,
	246.516300414,246.468606066,246.420365964,246.371576111,246.322232524,
	246.272331232,246.221868279,246.170839722,246.119241634,246.067070104,
	246.014321237,245.960991157,245.907076004,245.852571939,245.79747514,
	245.74178181,245.685488167,245.628590455,245.571084939,245.512967907,
	245.454235672,245.394884569,245.334910961,245.274311236,245.213081807,
	245.151219115,245.08871963,245.02557985,244.9617963,244.897365536,
	244.832284146,244.766548747,244.700155987,244.633102547,244.565385141,
	244.497000515,244.427945449,244.358216758,244.287811291,244.216725932,
	244.144957602,244.072503257,243.999359889,243.92552453,243.850994248,
	243.775766147,243.699837372,243.623205106,243.545866572,243.467819032,
	243.389059786,243.309586179,243.229395592,243.148485449,243.066853216,
	242.984496398,242.901412546,242.817599248,242.733054138,242.647774892,
	242.561759227,242.475004906,242.387509732,242.299271553,242.210288262,
	242.120557793,242.030078124,241.938847279,241.846863324,241.754124371,
	241.660628575,241.566374134,241.471359294,241.375582341,241.279041608,
	241.181735472,241.083662355,240.984820721,240.885209081,240.784825989,
	240.683670043,240.581739885,240.479034203,240.375551726,240.271291229,
	240.166251531,240.060431493,239.95383002,239.846446061,239.738278607,
	239.629326695,239.5195894,239.409065844,239.29775519,239.185656641,
	239.072769446,238.959092892,238.84462631,238.729369072,238.61332059,
	238.496480317,238.378847747,238.260422414,238.141203892,238.021191795,
	237.900385775,237.778785524,237.656390773,237.533201291,237.409216884,
	237.284437398,237.158862715,237.032492753,236.905327469,236.777366855,
	236.648610938,236.519059783,236.388713489,236.257572188,236.125636051,
	235.992905278,235.859380107,235.725060807,235.58994768,235.454041062,
	235.31734132,235.179848852,235.041564089,234.902487493,234.762619556,
	234.6219608,234.480511776,234.338273067,234.195245283,234.051429062,
	233.906825072,233.761434008,233.615256591,233.468293572,233.320545726,
	233.172013855,233.022698786,232.872601372,232.721722492,232.570063047,
	232.417623965,232.264406196,232.110410713,231.955638512,231.800090614,
	231.643768059,231.48667191,231.328803251,231.170163188,231.010752847,
	230.850573373,230.689625933,230.527911712,230.365431915,230.202187764,
	230.0381805,229.873411384,229.707881693,229.541592719,229.374545774,
	229.206742186,229.038183299,228.868870471,228.698805078,228.527988509,
	228.356422169,228.184107477,228.011045867,227.837238785,227.662687692,
	227.487394061,227.311359378,227.134585141,226.957072863,226.778824064,
	226.59984028,226.420123056,226.239673947,226.058494521,225.876586355,
	225.693951036,225.510590161,225.326505336,225.141698178,224.956170309,
	224.769923365,224.582958985,224.39527882,224.206884527,224.017777772,
	223.827960226,223.637433569,223.446199487,223.254259674,223.061615828,
	222.868269655,222.674222866,222.479477179,222.284034315,222.087896002,
	221.891063973,221.693539966,221.495325721,221.296422987,221.096833513,
	220.896559053,220.695601367,220.493962216,220.291643365,220.088646583,
	219.884973642,219.680626315,219.475606381,219.269915618,219.063555809,
	218.856528737,218.64883619,218.440479954,218.231461819,218.021783577,
	217.811447019,217.600453941,217.388806137,217.176505402,216.963553533,
	216.749952328,216.535703584,216.3208091,216.105270675,215.889090106,
	215.672269193,215.454809735,215.23671353,215.017982376,214.798618071,
	214.578622412,214.357997196,214.136744219,213.914865275,213.692362159,
	213.469236664,213.245490582,213.021125704,212.796143819,212.570546714,
	212.344336178,212.117513994,211.890081946,211.662041815,211.433395383,
	211.204144425,210.97429072,210.74383604,210.512782158,210.281130844,
	210.048883865,209.816042987,209.582609974,209.348586585,209.113974579,
	208.878775712,208.642991738,208.406624407,208.169675468,207.932146665,
	207.694039743,207.455356441,207.216098496,206.976267643,206.735865613,
	206.494894135,206.253354936,206.011249738,205.76858026,205.52534822,
	205.281555332,205.037203306,204.792293851,204.54682867,204.300809466,
	204.054237936,203.807115776,203.559444679,203.311226332,203.062462422,
	202.813154631,202.563304638,202.312914121,202.06198475,201.810518197,
	201.558516128,201.305980206,201.05291209,200.799313438,200.545185904,
	200.290531137,200.035350786,199.779646493,199.5234199,199.266672645,
	199.009406363,198.751622683,198.493323236,198.234509646,197.975183536,
	197.715346523,197.455000226,197.194146256,196.932786223,196.670921736,
	196.408554398,196.145685811,195.882317572,195.618451279,195.354088524,
	195.089230896,194.823879985,194.558037374,194.291704646,194.024883381,
	193.757575156,193.489781546,193.221504124,192.952744459,192.68350412,
	192.413784672,192.143587679,191.872914702,191.601767301,191.330147033,
	191.058055454,190.785494118,190.512464577,190.238968382,189.965007082,
	189.690582224,189.415695355,189.14034802,188.864541763,188.588278126,
	188.311558653,188.034384883,187.756758358,187.478680617,187.200153199,
	186.921177645,186.641755492,186.36188828,186.081577548,185.800824834,
	185.519631679,185.237999622,184.955930205,184.673424969,184.390485457,
	184.107113213,183.823309782,183.539076713,183.254415552,182.969327853,
	182.683815168,182.397879052,182.111521065,181.824742767,181.537545724,
	181.249931504,180.961901678,180.673457823,180.384601519,180.095334351,
	179.805657909,179.515573788,179.225083588,178.934188917,178.642891387,
	178.351192617,178.059094236,177.766597877,177.473705181,177.1804178,
	176.886737393,176.592665628,176.298204182,176.003354745,175.708119016,
	175.412498704,175.116495531,174.820111234,174.523347558,174.226206264,
	173.92868913,173.630797944,173.332534512,173.033900658,172.734898219,
	172.435529055,172.13579504,171.835698069,171.53524006,171.234422948,
	170.933248694,170.631719279,170.32983671,170.027603019,169.725020263,
	169.422090529,169.118815931,168.815198611,168.511240746,168.206944541,
	167.902312237,167.597346111,167.292048474,166.986421676,166.680468107,
	166.374190197,166.06759042,165.760671293,165.453435381,165.145885296,
	164.8380237,164.529853307,164.221376886,163.912597261,163.603517315,
	163.294139991,162.984468296,162.674505303,162.36425415,162.05371805,
	161.742900285,161.431804217,161.120433284,160.808791007,160.496880994,
	160.184706939,159.872272629,159.559581944,159.246638866,158.933447477,
	158.620011964,158.306336627,157.992425878,157.678284247,157.363916386,
	157.049327076,156.734521226,156.419503883,156.104280235,155.788855613,
	155.473235502,155.15742554,154.841431529,154.525259436,154.2089154,
	153.89240574,153.575736958,153.258915746,152.941948993,152.624843791,
	152.307607442,151.990247462,151.672771591,151.3551878,151.037504296,
	150.719729528,150.4018722,150.083941272,149.765945972,149.4478958,
	149.129800541,148.811670267,148.493515348,148.17534646,147.857174591,
	147.539011052,147.220867482,146.90275586,146.584688509,146.266678104,
	145.948737684,145.630880657,145.313120806,144.995472301,144.677949704,
	144.360567975,144.043342481,143.726289002,143.409423738,143.092763314,
	142.776324787,142.46012565,142.144183838,141.828517734,141.513146167,
	141.198088421,140.883364237,140.56899381,140.254997798,139.941397314,
	139.628213931,139.31546968,139.003187046,138.691388964,138.380098818,
	138.069340432,137.759138065,137.449516402,137.140500548,136.832116012,
	136.524388701,136.217344903,135.911011273,135.605414819,135.300582882,
	134.99654312,134.693323486,134.390952204,134.089457749,133.788868823,
	133.489214324,133.190523322,132.89282503,132.596148773,132.300523955,
	132.005980028,131.712546456,131.420252683,131.129128093,130.839201977,
	130.550503492,130.263061625,129.97690515,129.692062595,129.408562198,
	129.126431866,128.845699141,128.566391153,128.288534586,128.012155639,
	127.737279983,127.463932729,127.19213839,126.921920841,126.653303293,
	126.386308253,126.120957494,125.857272028,125.595272075,125.334977038,
	125.076405477,124.819575089,124.564502686,124.311204176,124.059694549,
	123.809987864,123.562097233,123.316034816,123.071811813,122.829438459,
	122.588924021,122.3502768,122.113504129,121.878612383,121.645606978,
	121.414492385,121.185272137,120.957948844,120.732524201,120.508999009,
	120.287373188,120.067645798,119.849815055,119.633878355,119.419832294,
	119.207672691,118.997394612,118.788992394,118.582459671,118.377789395,
	118.174973871,117.974004772,117.774873176,117.577569586,117.382083958,
	117.188405731,116.996523847,116.806426787,116.618102586,116.431538869,
	116.246722869,116.063641457,115.882281163,115.702628206,115.524668508,
	115.348387726,115.173771271,115.000804328,114.82947188,114.659758727,
	114.491649506,114.325128711,114.160180708,113.996789759,113.834940032,
	113.674615621,113.515800563,113.358478849,113.20263444,113.048251282,
	112.895313317,112.743804495,112.593708787,112.445010196,112.297692766,
	112.151740591,112.007137828,111.863868702,111.721917517,111.581268659,
	111.441906608,111.303815943,111.166981347,111.031387613,110.897019652,
	110.763862493,110.63190129,110.501121329,110.371508026,110.243046933,
	110.115723745,109.989524294,109.864434561,109.740440669,109.617528892,
	109.495685656,109.374897534,109.255151254,109.1364337,109.018731905,
	108.902033061,108.786324515,108.671593767,108.557828476,108.445016453,
	108.333145667,108.222204241,108.112180452,108.003062732,107.894839664,
	107.787499986,107.681032587,107.575426505,107.470670928,107.366755194,
	107.263668787,107.161401337,107.059942619,106.959282552,106.859411195,
	106.760318751,106.661995559,106.564432098,106.467618982,106.37154696,
	106.276206914,106.181589858,106.087686935,105.994489418,105.901988705,
	105.81017632,105.719043911,105.628583246,105.538786217,105.44964483,
	105.361151211,105.273297602,105.186076356,105.09947994,105.013500931,
	104.928132016,104.843365988,104.759195746,104.675614294,104.592614738,
	104.510190286,104.428334244,104.347040018,104.266301109,104.186111115,
	104.106463726,104.027352725,103.948771984,103.870715468,103.793177227,
	103.716151398,103.639632204,103.563613952,103.48809103,103.41305791,
	103.33850914,103.26443935,103.190843246,103.117715611,103.045051301,
	102.972845249,102.901092457,102.829788,102.758927024,102.688504742,
	102.618516438,102.54895746,102.479823222,102.411109205,102.342810952,
	102.274924068,102.207444221,102.140367139,102.07368861,102.007404481,
	101.941510654,101.876003092,101.810877811,101.746130883,101.681758433,
	101.617756641,101.554121738,101.490850007,101.427937781,101.365381444,
	101.303177428,101.241322214,101.179812331,101.118644352,101.057814898,
	100.997320637,100.937158279,100.877324577,100.817816329,100.758630377,
	100.6997636,100.641212922,100.582975306,100.525047756,100.467427312,
	100.410111057,100.353096108,100.296379621,100.23995879,100.183830844,
	100.127993045,100.072442696,100.017177128,99.9621937113,99.9074898464,
	99.8530629679,99.7989105427,99.7450300696,99.6914190787,99.6380751312,
	99.5849958187,99.5321787628,99.4796216147,99.4273220547,99.3752777916,
	99.3234865625,99.2719461323,99.2206542933,99.1696088648,99.1188076924,
	99.0682486481,99.0179296296,98.9678485599,98.918003387,98.8683920837,
	98.8190126467,98.769863097,98.7209414788,98.6722458598,98.6237743302,
	98.5755250031,98.5274960135,98.4796855184,98.4320916962,98.3847127468,
	98.3375468908,98.2905923695,98.2438474444,98.1973103972,98.1509795293,
	98.1048531614,98.0589296337,98.013207305,97.9676845528,97.922359773,
	97.8772313798,97.8322978049,97.7875574979,97.7430089255,97.6986505718,
	97.6544809376,97.6104985402,97.5667019136,97.5230896077,97.4796601886,
	97.4364122381,97.3933443532,97.3504551465,97.3077432458,97.2652072933,
	97.2228459464,97.1806578767,97.1386417702,97.0967963268,97.0551202605,
	97.0136122989,96.9722711833,96.931095668,96.8900845209,96.8492365225,
	96.8085504664,96.7680251586,96.7276594179,96.687452075,96.6474019731,
	96.6075079673,96.5677689244,96.528183723,96.4887512533,96.4494704166,
	96.4103401258,96.3713593045,96.3325268876,96.2938418206,96.2553030595,
	96.2169095712,96.1786603327,96.1405543314,96.1025905648,96.0647680402,
	96.0270857751,95.9895427965,95.9521381411,95.9148708551,95.8777399941,
	95.840744623,95.8038838156,95.767156655,95.7305622332,95.6940996508,
	95.6577680174,95.621566451,95.5854940781,95.5495500336,95.5137334607,
	95.4780435108,95.4424793434,95.4070401257,95.3717250333,95.3365332491,
	95.3014639639,95.2665163763,95.231689692,95.1969831244,95.1623958942,
	95.1279272293,95.0935763647,95.0593425426,95.0252250121,94.9912230293,
	94.957335857,94.9235627648,94.889903029,94.8563559325,94.8229207645,
	94.7895968211,94.7563834042,94.7232798225,94.6902853904,94.6573994289,
	94.6246212649,94.5919502312,94.5593856666,94.5269269159,94.4945733296,
	94.4623242638,94.4301790804,94.398137147,94.3661978366,94.3343605276,
	94.3026246041,94.2709894553,94.2394544758,94.2080190654,94.1766826291,
	94.145444577,94.1143043243,94.0832612913,94.052314903,94.0214645895,
	93.9907097857,93.9600499313,93.9294844707,93.899012853,93.8686345319,
	93.8383489659,93.8081556177,93.7780539548,93.7480434489,93.7181235762,
	93.6882938173,93.658553657,93.6289025843,93.5993400927,93.5698656795,
	93.5404788464,93.5111790989,93.4819659468,93.4528389037,93.4237974873,
	93.3948412191,93.3659696245,93.3371822327,93.3084785767,93.2798581933,
	93.2513206229,93.2228654096,93.1944921013,93.1662002492,93.1379894083,
	93.109859137,93.0818089971,93.0538385542,93.0259473769,92.9981350374,
	92.9704011112,92.9427451771,92.9151668171,92.8876656167,92.8602411644,
	92.8328930518,92.8056208739,92.7784242286,92.7513027171,92.7242559433,
	92.6972835146,92.670385041,92.6435601356,92.6168084145,92.5901294966,
	92.5635230038,92.5369885607,92.5105257949,92.4841343366,92.4578138189,
	92.4315638777,92.4053841514,92.3792742812,92.353233911,92.3272626873,
	92.3013602592,92.2755262785,92.2497603994,92.2240622787,92.1984315757,
	92.1728679522,92.1473710724,92.1219406032,92.0965762136,92.0712775751,
	92.0460443617,92.0208762495,91.9957729173,91.9707340457,91.9457593182,
	91.9208484199,91.8960010388,91.8712168645,91.8464955894,91.8218369075,
	91.7972405155,91.7727061118,91.7482333973,91.7238220746,91.6994718488,
	91.6751824268,91.6509535176,91.6267848322,91.6026760837,91.5786269871,
	91.5546372594,91.5307066197,91.5068347888,91.4830214895,91.4592664466,
	91.4355693866,91.4119300382,91.3883481315,91.3648233988,91.3413555741,
	91.3179443931,91.2945895935,91.2712909146,91.2480480975,91.224860885,
	91.2017290219,91.1786522542,91.1556303301,91.1326629992,91.1097500128,
	91.086891124,91.0640860873,91.041334659,91.0186365969,90.9959916605,
	90.9733996109,90.9508602106,90.9283732238,90.9059384162,90.883555555,
	90.8612244091,90.8389447485,90.8167163451,90.7945389721,90.7724124041,
	90.7503364174,90.7283107894,90.7063352991,90.6844097271,90.6625338551,
	90.6407074663,90.6189303453,90.5972022781,90.5755230521,90.5538924558,
	90.5323102793,90.510776314,90.4892903525,90.4678521887,90.4464616179,
	90.4251184365,90.4038224425,90.3825734349,90.3613712139,90.3402155812,
	90.3191063395,90.2980432928,90.2770262463,90.2560550065,90.2351293809,
	90.2142491783,90.1934142087,90.1726242833,90.1518792142,90.131178815,
	90.1105229001,90.0899112853,90.0693437874,90.0488202242,90.0283404148,
	90.0079041793,89.9875113389,89.9671617157,89.9468551333,89.9265914158,
	89.9063703888,89.8861918787,89.866055713,89.8459617203,89.8259097301,
	89.8058995729,89.7859310803,89.7660040849,89.7461184201,89.7262739206,
	89.7064704217,89.68670776,89.6669857728,89.6473042984,89.6276631762,
	89.6080622464,89.5885013501,89.5689803294,89.5494990274,89.5300572878,
	89.5106549554,89.491291876,89.4719678961,89.4526828632,89.4334366256,
	89.4142290324,89.3950599338,89.3759291805,89.3568366244,89.3377821181,
	89.3187655149,89.2997866691,89.2808454357,89.2619416708,89.2430752308,
	89.2242459734,89.2054537569,89.1866984403,89.1679798834,89.1492979471,
	89.1306524926,89.1120433822,89.0934704789,89.0749336464,89.056432749,
	89.0379676522,89.0195382218,89.0011443245,88.9827858277,88.9644625997,
	88.9461745092,88.927921426,88.9097032202,88.8915197629,88.8733709258,
	88.8552565813,88.8371766024,88.8191308631,88.8011192377,88.7831416014,
	88.7651978299,88.7472877998,88.7294113881,88.7115684728,88.6937589321,
	88.6759826453,88.658239492,88.6405293526,88.6228521081,88.6052076403,
	88.5875958312,88.5700165638,88.5524697217,88.5349551889,88.5174728502,
	88.5000225908,88.4826042967,88.4652178545,88.4478631512,88.4305400746,
	88.413248513,88.3959883551,88.3787594905,88.3615618091,88.3443952016,
	88.3272595591,88.3101547733,88.2930807364,88.2760373414,88.2590244815,
	88.2420420507,88.2250899434,88.2081680546,88.1912762799,88.1744145152,
	88.1575826573,88.1407806031,88.1240082504,88.1072654973,88.0905522424,
	88.0738683849,88.0572138245,88.0405884613,88.0239921962,88.0074249301,
	87.9908865649,87.9743770026,87.9578961459,87.941443898,87.9250201625,
	87.9086248434,87.8922578454,87.8759190734,87.859608433,87.8433258301,
	87.8270711713,87.8108443633,87.7946453135,87.7784739298,87.7623301204,
	87.746213794,87.7301248597,87.7140632271,87.6980288064,87.6820215078,
	87.6660412424,87.6500879215,87.6341614567,87.6182617604,87.6023887451,
	87.5865423238,87.57072241,87.5549289176,87.5391617608,87.5234208543,
	87.5077061131,87.4920174528,87.4763547894,87.4607180389,87.4451071183,
	87.4295219444,87.4139624349,87.3984285076,87.3829200807,87.3674370729,
	87.3519794032,87.3365469909,87.321139756,87.3057576185,87.2904004989,
	87.2750683183,87.2597609977,87.2444784589,87.2292206238,87.2139874149,
	87.1987787547,87.1835945665,87.1684347736,87.1532992998,87.1381880693,
	87.1231010065,87.1080380363,87.0929990838,87.0779840746,87.0629929344,
	87.0480255896,87.0330819666,87.0181619923,87.0032655939,86.988392699,
	86.9735432353,86.9587171311,86.9439143149,86.9291347155,86.9143782621,
	86.899644884,86.8849345112,86.8702470738,86.855582502,86.8409407267,
	86.8263216789,86.81172529,86.7971514915,86.7826002155,86.7680713942,
	86.7535649602,86.7390808462,86.7246189855,86.7101793115,86.695761758,
	86.681366259,86.6669927487,86.6526411619,86.6383114334,86.6240034983,
	86.6097172923,86.5954527509,86.5812098103,86.5669884067,86.5527884768,
	86.5386099573,86.5244527855,86.5103168987,86.4962022346,86.4821087312,
	86.4680363266,86.4539849594,86.4399545682,86.4259450922,86.4119564705,
	86.3979886428,86.3840415487,86.3701151284,86.356209322,86.3423240703,
	86.328459314,86.3146149941,86.3007910521,86.2869874293,86.2732040677,
	86.2594409093,86.2456978963,86.2319749714,86.2182720773,86.204589157,
	86.1909261539,86.1772830113,86.1636596731,86.1500560831,86.1364721857,
	86.1229079253,86.1093632464,86.0958380941,86.0823324135,86.0688461498,
	86.0553792488,86.0419316561,86.0285033179,86.0150941804,86.0017041901,
	85.9883332936,85.9749814379,85.9616485701,85.9483346376,85.935039588,
	85.9217633689,85.9085059285,85.8952672149,85.8820471765,85.868845762,
	85.8556629201,85.8424986001,85.829352751,85.8162253223,85.8031162638,
	85.7900255253,85.7769530568,85.7638988086,85.7508627312,85.7378447752,
	85.7248448915,85.7118630312,85.6988991455,85.6859531858,85.6730251039,
	85.6601148515,85.6472223807,85.6343476437,85.6214905929,85.608651181,
	85.5958293606,85.5830250847,85.5702383066,85.5574689796,85.5447170572,
	85.531982493,85.5192652411,85.5065652554,85.4938824903,85.4812169001,
	85.4685684394,85.4559370631,85.4433227262,85.4307253837,85.4181449909,
	85.4055815034,85.3930348768,85.380505067,85.36799203,85.3554957218,
	85.3430160989,85.3305531178,85.3181067352,85.3056769079,85.2932635929,
	85.2808667474,85.2684863287,85.2561222943,85.243774602,85.2314432095,
	85.2191280748,85.2068291561,85.1945464117,85.1822798,85.1700292797,
	85.1577948095,85.1455763484,85.1333738555,85.1211872901,85.1090166115,
	85.0968617793,85.0847227531,85.0725994929,85.0604919587,85.0484001106,
	85.036323909,85.0242633142,85.0122182869,85.0001887879,84.988174778,
	84.9761762183,84.96419307,84.9522252944,84.940272853,84.9283357074,
	84.9164138193,84.9045071507,84.8926156637,84.8807393203,84.8688780829,
	84.8570319141,84.8452007763,84.8333846323,84.821583445,84.8097971774,
	84.7980257927,84.7862692541,84.7745275251,84.7628005691,84.7510883499,
	84.7393908313,84.7277079772,84.7160397517,84.7043861189,84.6927470434,
	84.6811224894,84.6695124216,84.6579168048,84.6463356037,84.6347687833,
	84.6232163088,84.6116781453,84.6001542582,84.588644613,84.5771491752,
	84.5656679107,84.5542007852,84.5427477647,84.5313088153,84.5198839031,
	84.5084729946,84.4970760562,84.4856930544,84.4743239558,84.4629687274,
	84.4516273361,84.4402997488,84.4289859327,84.4176858551,84.4063994834,
	84.395126785,84.3838677276,84.372622279,84.3613904068,84.3501720792,
	84.3389672641,84.3277759297,84.3165980443,84.3054335764,84.2942824943,
	84.2831447667,84.2720203625,84.2609092503,84.2498113991,84.238726778,
	84.2276553561,84.2165971027,84.2055519872,84.194519979,84.1835010476,
	84.1724951629,84.1615022946,84.1505224125,84.1395554866,84.1286014871,
	84.1176603842,84.1067321481,84.0958167492,84.0849141581,84.0740243453,
	84.0631472816,84.0522829378,84.0414312847,84.0305922934,84.0197659349,
	84.0089521804,83.9981510014,83.987362369,83.9765862548,83.9658226305,
	83.9550714676,83.944332738,83.9336064135,83.922892466,83.9121908677,
	83.9015015907,83.8908246072,83.8801598895,83.8695074102,83.8588671416,
	83.8482390564,83.8376231274,83.8270193272,83.8164276289,83.8058480053,
	83.7952804295,83.7847248747,83.774181314,83.763649721,83.7531300688,
	83.7426223311,83.7321264815,83.7216424936,83.7111703411,83.700709998,
	83.6902614382,83.6798246356,83.6693995644,83.6589861988,83.648584513,
	83.6381944814,83.6278160785,83.6174492788,83.6070940568,83.5967503873,
	83.586418245,83.5760976048,83.5657884417,83.5554907305,83.5452044465,
	83.5349295648,83.5246660606,83.5144139094,83.5041730864,83.4939435673,
	83.4837253275,83.4735183427,83.4633225887,83.4531380413,83.4429646763,
	83.4328024696,83.4226513974,83.4125114358,83.4023825609,83.392264749,
	83.3821579764,83.3720622196,83.361977455,83.3519036592,83.3418408089,
	83.3317888807,83.3217478514,83.3117176979,83.3016983972,83.2916899262,
	83.281692262,83.2717053817,83.2617292627,83.251763882,83.2418092172,
	83.2318652457,83.2219319449,83.2120092924,83.2020972659,83.1921958431,
	83.1823050018,83.1724247198,83.162554975,83.1526957454,83.1428470091,
	83.1330087443,83.123180929,83.1133635416,83.1035565603,83.0937599636,
	83.08397373,83.0741978379,83.064432266,83.0546769929,83.0449319973,
	83.035197258,83.0254727539,83.0157584639,83.006054367,82.9963604422,
	82.9866766686,82.9770030254,82.9673394918,82.9576860472,82.9480426709,
	82.9384093423,82.9287860409,82.9191727463,82.9095694381,82.8999760959,
	82.8903926995,82.8808192286,82.8712556633,82.8617019832,82.8521581685,
	82.8426241992,82.8331000553,82.8235857171,82.8140811647,82.8045863785,
	82.7951013386,82.7856260257,82.77616042,82.7667045022,82.7572582527,
	82.7478216522,82.7383946815,82.7289773211,82.719569552,82.710171355,
	82.700782711,82.6914036009,82.6820340059,82.6726739069,82.6633232851,
	82.6539821217,82.644650398,82.6353280953,82.6260151948,82.6167116781,
	82.6074175266,82.5981327217,82.5888572452,82.5795910786,82.5703342036,
	82.5610866019,82.5518482554,82.5426191458,82.5333992551,82.5241885652,
	82.5149870582,82.505794716,82.4966115208,82.4874374547,82.4782724999,
	82.4691166388,82.4599698535,82.4508321266,82.4417034403,82.4325837772,
	82.4234731197,82.4143714505,82.4052787521,82.3961950073,82.3871201986,
	82.378054309,82.3689973211,82.3599492179,82.3509099823,82.3418795973,
	82.3328580457,82.3238453108,82.3148413756,82.3058462233,82.296859837,
	82.2878822
	}},
	{ // Ri = 250k
	-5,5,200, {
	249.98706929,249.986851225,249.986629489,249.986404021,249.986174757,
	249.985941635,249.985704589,249.985463554,249.985218463,249.984969247,
	249.984715838,249.984458166,249.984196158,249.983929743,249.983658846,
	249.983383392,249.983103306,249.982818508,249.982528921,249.982234464,
	249.981935056,249.981630613,249.981321052,249.981006287,249.98068623,
	249.980360793,249.980029887,249.979693419,249.979351296,249.979003424,
	249.978649708,249.978290048,249.977924346,249.9775525,249.977174409,
	249.976789967,249.976399069,249.976001606,249.97559747,249.975186548,
	249.974768727,249.974343893,249.973911927,249.973472711,249.973026125,
	249.972572044,249.972110345,249.9716409,249.971163579,249.970678252,
	249.970184785,249.969683043,249.969172887,249.968654177,249.968126772,
	249.967590526,249.967045292,249.96649092,249.965927258,249.965354153,
	249.964771446,249.964178978,249.963576587,249.962964107,249.962341372,
	249.961708211,249.96106445,249.960409914,249.959744424,249.959067797,
	249.95837985,249.957680393,249.956969237,249.956246188,249.955511048,
	249.954763616,249.95400369,249.953231063,249.952445523,249.951646857,
	249.950834849,249.950009276,249.949169916,249.94831654,249.947448916,
	249.946566809,249.945669979,249.944758184,249.943831177,249.942888706,
	249.941930516,249.940956349,249.93996594,249.938959023,249.937935324,
	249.936894568,249.935836475,249.934760758,249.933667127,249.932555289,
	249.931424944,249.930275788,249.929107511,249.9279198,249.926712337,
	249.925484796,249.92423685,249.922968162,249.921678394,249.9203672,
	249.91903423,249.917679127,249.916301529,249.914901069,249.913477372,
	249.912030061,249.910558748,249.909063042,249.907542547,249.905996856,
	249.904425561,249.902828244,249.901204482,249.899553844,249.897875894,
	249.896170188,249.894436274,249.892673696,249.890881989,249.889060679,
	249.887209288,249.885327328,249.883414305,249.881469716,249.879493052,
	249.877483793,249.875441414,249.87336538,249.87125515,249.869110171,
	249.866929885,249.864713724,249.86246111,249.860171458,249.857844173,
	249.855478652,249.853074281,249.850630438,249.848146491,249.845621799,
	249.843055711,249.840447565,249.837796689,249.835102404,249.832364016,
	249.829580824,249.826752115,249.823877166,249.820955243,249.8179856,
	249.81496748,249.811900117,249.80878273,249.80561453,249.802394713,
	249.799122465,249.795796959,249.792417358,249.788982809,249.785492449,
	249.781945403,249.778340779,249.774677678,249.770955183,249.767172365,
	249.763328284,249.759421981,249.75545249,249.751418824,249.747319988,
	249.743154968,249.738922738,249.734622257,249.730252468,249.725812301,
	249.72130067,249.716716471,249.712058589,249.70732589,249.702517225,
	249.697631429,249.692667321,249.687623703,249.682499361,249.677293063,
	249.672003562,249.666629592,249.661169871,249.655623098,249.649987954,
	249.644263106,249.638447197,249.632538857,249.626536694,249.620439299,
	249.614245244,249.607953082,249.601561346,249.59506855,249.588473189,
	249.581773739,249.574968653,249.568056367,249.561035295,249.553903831,
	249.546660348,249.5393032,249.531830718,249.524241211,249.516532969,
	249.508704259,249.500753327,249.492678397,249.48447767,249.476149326,
	249.467691521,249.459102391,249.450380046,249.441522576,249.432528047,
	249.423394501,249.414119957,249.404702411,249.395139834,249.385430176,
	249.37557136,249.365561287,249.355397831,249.345078845,249.334602156,
	249.323965565,249.313166851,249.302203767,249.291074039,249.27977537,
	249.268305439,249.256661896,249.244842368,249.232844458,249.220665739,
	249.208303762,249.195756051,249.183020104,249.170093394,249.156973366,
	249.143657441,249.130143014,249.116427453,249.102508098,249.088382267,
	249.074047249,249.059500307,249.044738677,249.029759572,249.014560175,
	248.999137645,248.983489114,248.967611688,248.951502446,248.935158442,
	248.918576704,248.901754233,248.884688005,248.867374969,248.84981205,
	248.831996145,248.813924127,248.795592843,248.776999115,248.75813974,
	248.739011488,248.719611106,248.699935316,248.679980814,248.659744274,
	248.639222342,248.618411645,248.597308781,248.575910327,248.554212837,
	248.532212841,248.509906845,248.487291335,248.464362771,248.441117595,
	248.417552224,248.393663055,248.369446462,248.344898801,248.320016406,
	248.29479559,248.269232647,248.243323852,248.217065459,248.190453706,
	248.163484811,248.136154974,248.108460379,248.080397191,248.05196156,
	248.02314962,247.993957487,247.964381265,247.934417041,247.90406089,
	247.87330887,247.84215703,247.810601403,247.778638011,247.746262866,
	247.713471967,247.680261304,247.646626855,247.612564592,247.578070476,
	247.543140462,247.507770494,247.471956513,247.435694453,247.398980241,
	247.361809801,247.32417905,247.286083906,247.24752028,247.208484082,
	247.168971222,247.128977608,247.088499147,247.047531748,247.006071321,
	246.964113777,246.921655032,246.878691002,246.835217611,246.791230786,
	246.746726458,246.701700567,246.656149059,246.610067888,246.563453016,
	246.516300415,246.468606067,246.420365965,246.371576112,246.322232525,
	246.272331233,246.22186828,246.170839723,246.119241635,246.067070105,
	246.014321238,245.960991158,245.907076005,245.85257194,245.797475142,
	245.741781811,245.685488168,245.628590456,245.57108494,245.512967909,
	245.454235673,245.394884571,245.334910963,245.274311238,245.213081809,
	245.151219118,245.088719633,245.025579852,244.961796302,244.897365539,
	244.832284149,244.76654875,244.70015599,244.633102551,244.565385144,
	244.497000518,244.427945453,244.358216762,244.287811295,244.216725936,
	244.144957607,244.072503262,243.999359895,243.925524536,243.850994253,
	243.775766153,243.699837378,243.623205113,243.545866579,243.467819039,
	243.389059794,243.309586187,243.2293956,243.148485458,243.066853225,
	242.984496408,242.901412556,242.817599259,242.733054149,242.647774903,
	242.561759239,242.475004919,242.387509745,242.299271568,242.210288277,
	242.120557808,242.03007814,241.938847296,241.846863343,241.75412439,
	241.660628595,241.566374155,241.471359316,241.375582364,241.279041632,
	241.181735498,241.083662381,240.984820749,240.88520911,240.78482602,
	240.683670075,240.581739919,240.479034238,240.375551763,240.271291268,
	240.166251571,240.060431535,239.953830064,239.846446107,239.738278656,
	239.629326745,239.519589453,239.4090659,239.297755248,239.185656702,
	239.072769509,238.959092958,238.84462638,238.729369145,238.613320666,
	238.496480396,238.37884783,238.260422501,238.141203983,238.02119189,
	237.900385875,237.778785628,237.656390882,237.533201405,237.409217004,
	237.284437524,237.158862846,237.03249289,236.905327613,236.777367005,
	236.648611095,236.519059947,236.38871366,236.257572368,236.125636239,
	235.992905475,235.859380313,235.725061022,235.589947905,235.454041297,
	235.317341565,235.179849108,235.041564357,234.902487774,234.762619849,
	234.621961106,234.480512096,234.338273402,234.195245633,234.051429428,
	233.906825454,233.761434407,233.615257009,233.468294009,233.320546182,
	233.172014331,233.022699284,232.872601892,232.721723035,232.570063615,
	232.417624559,232.264406816,232.110411361,231.955639189,231.800091321,
	231.643768797,231.486672681,231.328804057,231.17016403,231.010753726,
	230.850574292,230.689626893,230.527912715,230.365432962,230.202188857,
	230.038181642,229.873412577,229.707882938,229.541594019,229.374547132,
	229.206743604,229.038184779,228.868872017,228.698806692,228.527990194,
	228.356423928,228.184109314,228.011047785,227.837240787,227.662689782,
	227.487396243,227.311361655,227.134587519,226.957075345,226.778826655,
	226.599842984,226.420125878,226.239676893,226.058497596,225.876589564,
	225.693954385,225.510593656,225.326508984,225.141701984,224.956174281,
	224.769927509,224.58296331,224.395283333,224.206889237,224.017782686,
	223.827965353,223.637438918,223.446205069,223.254265497,223.061621903,
	222.868275994,222.674229479,222.479484077,222.284041512,222.08790351,
	221.891071805,221.693548135,221.495334244,221.296431876,221.096842785,
	220.896568725,220.695611455,220.493972738,220.29165434,220.08865803,
	219.88498558,219.680638766,219.475619366,219.269929161,219.063569932,
	218.856543466,218.648851549,218.440495971,218.231478522,218.021800994,
	217.811465182,217.60047288,217.388825884,217.176525993,216.963575003,
	216.749974714,216.535726925,216.320833437,216.105296048,215.88911656,
	215.672296774,215.45483849,215.236743508,215.018013629,214.798650652,
	214.578656378,214.358032605,214.136781131,213.914903754,213.692402271,
	213.469278477,213.245534168,213.021171136,212.796191175,212.570596077,
	212.344387629,212.117567622,211.890137843,211.662100076,211.433456105,
	211.204207714,210.974356681,210.743904787,210.512853806,210.281205515,
	210.048961685,209.816124088,209.582694492,209.348674664,209.114066368,
	208.878871366,208.643091418,208.406728281,208.169783711,207.93225946,
	207.694157278,207.455478915,207.216226114,206.97640062,206.736004172,
	206.49503851,206.253505367,206.011406477,205.768743571,205.525518376,
	205.281732618,205.037388018,204.792486297,204.547029172,204.301018358,
	204.054455568,203.80734251,203.559680893,203.31147242,203.062718793,
	202.813421712,202.563582874,202.313203973,202.062286701,201.810832747,
	201.558843799,201.306321542,201.053267658,200.799683826,200.545571726,
	200.290933032,200.035769418,199.780082556,199.523874114,199.26714576,
	199.00989916,198.752135977,198.493857873,198.235066508,197.97576354,
	197.715950626,197.455629421,197.19480158,196.933468754,196.671632596,
	196.409294756,196.146456882,195.883120624,195.619287629,195.354959544,
	195.090138015,194.824824689,194.559021212,194.292729229,194.025950385,
	193.758686328,193.490938703,193.222709157,192.953999338,192.684810894,
	192.415145475,192.145004731,191.874390314,191.603303879,191.331747082,
	191.059721579,190.787229033,190.514271105,190.240849462,189.966965773,
	189.69262171,189.417818949,189.14255917,188.866844059,188.590675304,
	188.314054599,188.036983645,187.759464146,187.481497813,187.203086365,
	186.924231527,186.64493503,186.365198614,186.085024028,185.804413028,
	185.523367379,185.241888858,184.95997925,184.677640352,184.394873972,
	184.11168193,183.828066057,183.544028199,183.259570217,182.974693983,
	182.689401387,182.403694334,182.117574747,181.831044563,181.544105742,
	181.25676026,180.969010115,180.680857324,180.392303929,180.103351992,
	179.814003602,179.524260869,179.234125934,178.943600962,178.652688148,
	178.361389716,178.069707923,177.777645057,177.485203439,177.192385426,
	176.899193414,176.605629834,176.311697159,176.017397903,175.722734622,
	175.42770992,175.132326446,174.836586898,174.540494025,174.244050629,
	173.947259568,173.650123755,173.352646164,173.054829832,172.756677859,
	172.458193411,172.159379726,171.860240112,171.560777954,171.260996712,
	170.960899932,170.660491239,170.359774348,170.058753063,169.757431286,
	169.455813011,169.153902337,168.851703468,168.549220714,168.246458503,
	167.943421374,167.640113993,167.336541149,167.032707762,166.728618886,
	166.424279716,166.119695592,165.814872003,165.509814594,165.204529171,
	164.899021704,164.593298336,164.287365388,163.981229364,163.674896958,
	163.36837506,163.061670761,162.754791362,162.447744379,162.140537551,
	161.833178847,161.525676469,161.218038867,160.91027474,160.602393044,
	160.294403003,159.986314114,159.678136154,159.369879193,159.061553594,
	158.753170027,158.444739474,158.13627324,157.827782957,157.519280595,
	157.21077847,156.90228925,156.593825964,156.285402011,155.977031166,
	155.668727586,155.360505823,155.052380826,154.744367948,154.436482957,
	154.128742038,153.821161801,153.513759285,153.206551968,152.899557763,
	152.592795032,152.286282581,151.980039672,151.674086016,151.368441781,
	151.063127591,150.758164527,150.453574123,150.149378371,149.84559971,
	149.542261029,149.239385659,148.936997368,148.635120356,148.333779243,
	148.032999061,147.732805244,147.433223619,147.134280384,146.836002101,
	146.538415678,146.241548349,145.945427656,145.650081429,145.355537765,
	145.061825,144.768971689,144.477006578,144.185958573,143.895856717,
	143.606730155,143.318608101,143.031519811,142.745494544,142.460561528,
	142.176749925,141.894088794,141.612607053,141.33233344,141.053296478,
	140.775524432,140.499045269,140.223886626,139.950075761,139.677639521,
	139.406604303,139.13699601,138.86884002,138.602161147,138.336983605,
	138.073330973,137.811226163,137.550691387,137.291748127,137.034417106,
	136.778718261,136.524670718,136.272292766,136.021601842,135.772614503,
	135.525346418,135.279812345,135.036026122,134.79400066,134.553747926,
	134.315278945,134.078603792,133.843731591,133.610670518,133.379427799,
	133.150009719,132.922421627,132.696667945,132.472752176,132.25067692,
	132.030443888,131.812053912,131.595506968,131.380802191,131.167937895,
	130.956911595,130.747720026,130.540359167,130.334824266,130.13110986,
	129.929209804,129.729117294,129.53082489,129.334324549,129.139607641,
	128.946664984,128.755486867,128.566063074,128.378382911,128.192435235,
	128.008208475,127.82569066,127.644869442,127.465732122,127.288265674,
	127.112456765,126.938291784,126.765756859,126.594837879,126.425520519,
	126.257790258,126.091632396,125.92703208,125.763974314,125.602443985,
	125.442425874,125.283904673,125.126865007,124.971291439,124.817168494,
	124.664480664,124.51321243,124.363348265,124.214872655,124.067770102,
	123.922025141,123.777622345,123.634546339,123.492781803,123.352313488,
	123.213126215,123.075204892,122.938534511,122.803100162,122.668887034,
	122.535880424,122.404065739,122.273428504,122.143954363,122.015629084,
	121.888438563,121.76236883,121.637406044,121.513536504,121.390746648,
	121.269023054,121.148352444,121.028721683,120.910117783,120.792527903,
	120.675939349,120.560339577,120.445716191,120.332056945,120.219349742,
	120.107582636,119.996743831,119.886821679,119.777804682,119.669681491,
	119.562440905,119.45607187,119.350563481,119.245904975,119.142085739,
	119.039095299,118.936923328,118.835559639,118.734994187,118.635217064,
	118.536218503,118.437988872,118.340518677,118.243798555,118.147819277,
	118.052571748,117.958046998,117.864236189,117.771130609,117.678721671,
	117.587000912,117.495959991,117.405590688,117.315884902,117.226834649,
	117.138432063,117.050669391,116.963538993,116.87703334,116.791145014,
	116.705866704,116.621191207,116.537111424,116.453620361,116.370711124,
	116.288376922,116.206611062,116.125406949,116.044758083,115.964658061,
	115.885100572,115.806079397,115.727588408,115.649621564,115.572172916,
	115.495236596,115.418806826,115.342877908,115.267444229,115.192500255,
	115.118040534,115.04405969,114.970552425,114.89751352,114.824937826,
	114.752820271,114.681155856,114.60993965,114.539166794,114.4688325,
	114.398932045,114.329460774,114.260414097,114.191787491,114.123576494,
	114.055776708,113.988383796,113.921393483,113.854801553,113.788603846,
	113.722796265,113.657374766,113.592335361,113.527674118,113.463387161,
	113.399470663,113.335920853,113.27273401,113.209906463,113.147434593,
	113.085314829,113.023543648,112.962117574,112.901033179,112.840287082,
	112.779875944,112.719796474,112.660045423,112.600619585,112.541515797,
	112.482730939,112.42426193,112.36610573,112.308259341,112.250719802,
	112.19348419,112.136549623,112.079913253,112.023572271,111.967523904,
	111.911765414,111.856294098,111.801107289,111.746202353,111.691576689,
	111.637227729,111.583152939,111.529349816,111.475815888,111.422548715,
	111.369545886,111.316805023,111.264323773,111.212099817,111.160130862,
	111.108414643,111.056948924,111.005731497,110.954760178,110.904032814,
	110.853547274,110.803301456,110.75329328,110.703520696,110.653981674,
	110.60467421,110.555596324,110.50674606,110.458121485,110.409720688,
	110.361541782,110.313582902,110.265842202,110.218317863,110.171008082,
	110.123911081,110.077025099,110.030348399,109.983879261,109.937615986,
	109.891556896,109.845700329,109.800044645,109.754588221,109.709329453,
	109.664266754,109.619398556,109.57472331,109.530239481,109.485945553,
	109.441840028,109.397921423,109.354188272,109.310639125,109.267272548,
	109.224087122,109.181081447,109.138254133,109.095603809,109.053129118,
	109.010828717,108.968701278,108.926745487,108.884960045,108.843343665,
	108.801895077,108.760613021,108.719496253,108.67854354,108.637753663,
	108.597125417,108.556657609,108.516349056,108.476198591,108.436205057,
	108.39636731,108.356684217,108.317154657,108.277777521,108.238551712,
	108.199476141,108.160549735,108.121771427,108.083140165,108.044654905,
	108.006314614,107.96811827,107.930064861,107.892153386,107.854382852,
	107.816752278,107.77926069,107.741907128,107.704690637,107.667610274,
	107.630665104,107.593854203,107.557176653,107.520631548,107.48421799,
	107.447935087,107.41178196,107.375757736,107.339861549,107.304092545,
	107.268449875,107.2329327,107.197540188,107.162271514,107.127125864,
	107.092102428,107.057200405,107.022419004,106.987757437,106.953214926,
	106.9187907,106.884483995,106.850294054,106.816220127,106.78226147,
	106.748417348,106.714687031,106.681069796,106.647564927,106.614171713,
	106.580889453,106.547717448,106.514655009,106.48170145,106.448856093,
	106.416118267,106.383487304,106.350962545,106.318543335,106.286229026,
	106.254018974,106.221912543,106.189909101,106.158008021,106.126208684,
	106.094510473,106.06291278,106.031414999,106.000016532,105.968716784,
	105.937515166,105.906411094,105.87540399,105.844493279,105.813678393,
	105.782958766,105.752333841,105.721803061,105.691365878,105.661021745,
	105.630770122,105.600610472,105.570542264,105.540564971,105.51067807,
	105.480881041,105.451173372,105.421554551,105.392024073,105.362581436,
	105.333226143,105.3039577,105.274775617,105.245679411,105.216668597,
	105.1877427,105.158901246,105.130143764,105.101469788,105.072878857,
	105.04437051,105.015944294,104.987599757,104.959336451,104.931153932,
	104.903051759,104.875029495,104.847086706,104.819222962,104.791437835,
	104.763730902,104.736101743,104.708549941,104.681075081,104.653676754,
	104.626354551,104.599108068,104.571936905,104.544840663,104.517818946,
	104.490871364,104.463997527,104.437197048,104.410469545,104.383814638,
	104.357231948,104.330721102,104.304281728,104.277913457,104.251615922,
	104.225388761,104.199231613,104.173144119,104.147125925,104.121176677,
	104.095296026,104.069483624,104.043739125,104.018062189,103.992452474,
	103.966909643,103.941433361,103.916023296,103.890679118,103.865400498,
	103.840187112,103.815038637,103.789954751,103.764935137,103.739979478,
	103.715087461,103.690258774,103.665493107,103.640790154,103.616149609,
	103.59157117,103.567054536,103.542599408,103.51820549,103.493872487,
	103.469600108,103.445388062,103.42123606,103.397143817,103.373111047,
	103.34913747,103.325222804,103.301366771,103.277569095,103.253829501,
	103.230147716,103.206523469,103.182956493,103.159446518,103.13599328,
	103.112596516,103.089255964,103.065971363,103.042742456,103.019568986,
	102.996450698,102.97338734,102.950378659,102.927424406,102.904524334,
	102.881678195,102.858885746,102.836146742,102.813460943,102.790828108,
	102.768247999,102.74572038,102.723245015,102.700821671,102.678450115,
	102.656130116,102.633861446,102.611643877,102.589477183,102.567361139,
	102.545295522,102.523280109,102.501314681,102.479399019,102.457532905,
	102.435716122,102.413948457,102.392229695,102.370559624,102.348938035,
	102.327364716,102.305839461,102.284362062,102.262932314,102.241550013,
	102.220214956,102.198926941,102.177685768,102.156491237,102.135343152,
	102.114241314,102.093185529,102.072175603,102.051211342,102.030292555,
	102.009419051,101.98859064,101.967807134,101.947068347,101.926374091,
	101.905724182,101.885118436,101.864556671,101.844038704,101.823564356,
	101.803133447,101.782745799,101.762401235,101.742099578,101.721840653,
	101.701624287,101.681450305,101.661318537,101.641228811,101.621180958,
	101.601174808,101.581210193,101.561286947,101.541404903,101.521563896,
	101.501763763,101.482004341,101.462285466,101.442606979,101.422968719,
	101.403370526,101.383812242,101.36429371,101.344814774,101.325375276,
	101.305975064,101.286613983,101.267291879,101.248008601,101.228763999,
	101.20955792,101.190390216,101.171260738,101.152169339,101.133115871,
	101.114100189,101.095122146,101.076181599,101.057278403,101.038412416,
	101.019583497,101.000791503,100.982036294,100.96331773,100.944635673,
	100.925989984,100.907380526,100.888807163,100.870269758,100.851768177,
	100.833302284,100.814871947,100.796477033,100.778117409,100.759792944,
	100.741503507,100.723248969,100.705029199,100.68684407,100.668693453,
	100.650577222,100.632495249,100.614447409,100.596433577,100.578453629,
	100.56050744,100.542594887,100.524715848,100.506870202,100.489057826,
	100.471278601,100.453532406,100.435819123,100.418138632,100.400490816,
	100.382875557,100.365292739,100.347742246,100.330223961,100.312737771,
	100.29528356,100.277861215,100.260470623,100.243111672,100.225784249,
	100.208488243,100.191223543,100.17399004,100.156787623,100.139616184,
	100.122475614,100.105365804,100.088286649,100.07123804,100.054219871,
	100.037232038,100.020274434,100.003346955,99.9864494965,99.9695819554,
	99.9527442284,99.935936213,99.9191578071,99.9024089092,99.8856894183,
	99.8689992338,99.8523382559,99.8357063851,99.8191035222,99.8025295689,
	99.7859844271,99.7694679993,99.7529801885,99.7365208981,99.7200900321,
	99.7036874949,99.6873131914,99.6709670269,99.6546489073,99.6383587388,
	99.6220964281,99.6058618826,99.5896550097,99.5734757178,99.5573239152,
	99.5411995111,99.5251024149,99.5090325364,99.492989786,99.4769740745,
	99.460985313,99.4450234132,99.4290882872,99.4131798474,99.3972980067,
	99.3814426785,99.3656137764,99.3498112147,99.3340349078,99.3182847708,
	99.3025607191,99.2868626683,99.2711905347,99.2555442348,99.2399236857,
	99.2243288047,99.2087595095,99.1932157183,99.1776973497,99.1622043225,
	99.146736556,99.1312939699,99.1158764842,99.1004840195,99.0851164964,
	99.0697738362,99.0544559603,99.0391627907,99.0238942497,99.0086502598,
	98.993430744,98.9782356258,98.9630648287,98.9479182768,98.9327958945,
	98.9176976065,98.902623338,98.8875730143,98.8725465613,98.857543905,
	98.8425649718,98.8276096887,98.8126779826,98.7977697811,98.7828850119,
	98.7680236031,98.7531854831,98.7383705808,98.7235788251,98.7088101455,
	98.6940644717,98.6793417336,98.6646418617,98.6499647867,98.6353104394,
	98.6206787511,98.6060696534,98.5914830783,98.5769189578,98.5623772246,
	98.5478578113,98.533360651,98.5188856772,98.5044328236,98.490002024,
	98.4755932127,98.4612063243,98.4468412937,98.4324980559,98.4181765464,
	98.4038767008,98.3895984552,98.3753417457,98.361106509,98.3468926817,
	98.332700201,98.3185290043,98.3043790291,98.2902502133,98.2761424952,
	98.2620558131,98.2479901058,98.2339453121,98.2199213714,98.205918223,
	98.1919358068,98.1779740627,98.164032931,98.1501123522,98.136212267,
	98.1223326165,98.108473342,98.0946343849,98.080815687,98.0670171904,
	98.0532388372,98.03948057,98.0257423315,98.0120240648,97.9983257129,
	97.9846472195,97.9709885281,97.9573495827,97.9437303276,97.930130707,
	97.9165506656,97.9029901484,97.8894491003,97.8759274667,97.8624251931,
	97.8489422254,97.8354785095,97.8220339916,97.8086086182,97.795202336,
	97.7818150918,97.7684468328,97.7550975062,97.7417670596,97.7284554407,
	97.7151625976,97.7018884783,97.6886330313,97.6753962052,97.6621779488,
	97.648978211,97.6357969412,97.6226340887,97.6094896032,97.5963634346,
	97.5832555327,97.570165848,97.5570943308,97.5440409318,97.5310056019,
	97.5179882919,97.5049889533,97.4920075374,97.4790439958,97.4660982804,
	97.4531703431,97.4402601362,97.427367612,97.4144927232,97.4016354224,
	97.3887956627,97.3759733971,97.3631685791,97.350381162,97.3376110997,
	97.3248583459,97.3121228548,97.2994045805,97.2867034775,97.2740195003,
	97.2613526038,97.2487027429,97.2360698727,97.2234539485,97.2108549257,
	97.1982727601,97.1857074075,97.1731588237,97.1606269651,97.1481117878,
	97.1356132485,97.1231313037,97.1106659104,97.0982170254,97.0857846061,
	97.0733686096,97.0609689935,97.0485857155,97.0362187333,97.0238680049,
	97.0115334885,96.9992151424,96.9869129251,96.974626795,96.9623567111,
	96.9501026322,96.9378645174,96.925642326,96.9134360174,96.901245551,
	96.8890708866,96.8769119841,96.8647688034,96.8526413048,96.8405294484,
	96.8284331947,96.8163525044,96.8042873382,96.792237657,96.7802034217,
	96.7681845937,96.7561811342,96.7441930046,96.7322201667,96.7202625821,
	96.7083202128,96.6963930208,96.6844809683,96.6725840175,96.660702131,
	96.6488352713,96.6369834012,96.6251464835,96.6133244813,96.6015173576,
	96.5897250758,96.5779475993,96.5661848916,96.5544369164,96.5427036375,
	96.5309850188,96.5192810244,96.5075916186,96.4959167655,96.4842564298,
	96.472610576,96.4609791688,96.449362173,96.4377595536,96.4261712758,
	96.4145973047,96.4030376057,96.3914921443,96.379960886,96.3684437966,
	96.3569408419,96.3454519879,96.3339772007,96.3225164464,96.3110696914,
	96.2996369022,96.2882180452,96.2768130873,96.2654219951,96.2540447357,
	96.242681276,96.2313315832,96.2199956245,96.2086733674,96.1973647793,
	96.1860698279,96.1747884809,96.1635207061,96.1522664715,96.1410257451,
	96.1297984951,96.1185846898,96.1073842976,96.096197287,96.0850236266,
	96.0738632851,96.0627162315,96.0515824345,96.0404618634,96.0293544871,
	96.018260275,96.0071791965,95.9961112211,95.9850563182,95.9740144577,
	95.9629856092,95.9519697427,95.9409668282,95.9299768358,95.9189997356,
	95.908035498,95.8970840934,95.8861454923,95.8752196653,95.8643065831,
	95.8534062165,95.8425185365,95.8316435139,95.82078112,95.8099313258,
	95.7990941028,95.7882694223,95.7774572558,95.7666575748,95.7558703512,
	95.7450955566,95.7343331628,95.723583142,95.7128454661,95.7021201073,
	95.6914070379,95.6807062301,95.6700176564,95.6593412894,95.6486771016,
	95.6380250658,95.6273851547,95.6167573413,95.6061415985,95.5955378994,
	95.5849462171,95.5743665249,95.5637987962,95.5532430042,95.5426991226,
	95.532167125,95.521646985,95.5111386764,95.500642173,95.4901574488,
	95.4796844778,95.4692232342,95.4587736921,95.4483358257,95.4379096096,
	95.4274950181,95.4170920257,95.406700607,95.3963207368,95.3859523898,
	95.375595541,95.3652501651,95.3549162373,95.3445937326,95.3342826263,
	95.3239828935,95.3136945097,95.3034174503,95.2931516907,95.2828972066,
	95.2726539735,95.2624219673,95.2522011637,95.2419915386,95.231793068,
	95.221605728,95.2114294947,95.2012643442,95.1911102528,95.1809671969,
	95.1708351529,95.1607140973,95.1506040066,95.1405048576,95.1304166269,
	95.1203392913,95.1102728277,95.100217213,95.0901724243,95.0801384386,
	95.070115233,95.0601027849,95.0501010715,95.0401100701,95.0301297583,
	95.0201601135,95.0102011132,95.0002527353,94.9903149573,94.9803877571,
	94.9704711125,94.9605650015,94.950669402,94.9407842921,94.93090965,
	94.9210454538,94.9111916818,94.9013483124,94.8915153239,94.8816926949,
	94.8718804038,94.8620784292,94.8522867499,94.8425053445,94.8327341919,
	94.8229732708,94.8132225604,94.8034820394,94.793751687,94.7840314824,
	94.7743214046,94.7646214329,94.7549315467,94.7452517252,94.7355819481,
	94.7259221946,94.7162724445,94.7066326772,94.6970028726,94.6873830104,
	94.6777730702,94.6681730321,94.658582876,94.6490025817,94.6394321295,
	94.6298714993,94.6203206714,94.610779626,94.6012483433,94.5917268037,
	94.5822149877,94.5727128756,94.563220448,94.5537376855,94.5442645687,
	94.5348010783,94.525347195,94.5159028997,94.5064681732,94.4970429965,
	94.4876273505,94.4782212162,94.4688245748,94.4594374074,94.4500596952,
	94.4406914195,94.4313325615,94.4219831026,94.4126430243,94.403312308,
	94.3939909353,94.3846788878,94.375376147,94.3660826947,94.3567985126,
	94.3475235826,94.3382578864,94.329001406,94.3197541234,94.3105160205,
	94.3012870794,94.2920672823,94.2828566112,94.2736550485,94.2644625763,
	94.255279177,94.2461048331,94.2369395268,94.2277832407,94.2186359572,
	94.2094976591,94.2003683288,94.1912479492,94.1821365028,94.1730339724,
	94.163940341,94.1548555913,94.1457797063,94.136712669,94.1276544623,
	94.1186050694,94.1095644733,94.1005326572,94.0915096044,94.082495298,
	94.0734897214,94.064492858,94.0555046911,94.0465252043,94.0375543809,
	94.0285922045,94.0196386587,94.0106937272,94.0017573936,93.9928296417,
	93.9839104552,93.974999818,93.9660977138,93.9572041267,93.9483190405,
	93.9394424393,93.9305743071,93.921714628,93.9128633861,93.9040205657,
	93.8951861508,93.8863601258,93.8775424751,93.8687331828,93.8599322335,
	93.8511396116,93.8423553016,93.8335792879,93.8248115552,93.816052088,
	93.8073008711,93.798557889,93.7898231266,93.7810965686,93.7723781999,
	93.7636680053
	}}
};
