/*
 * Copyright (C) 2009, 2010 Hermann Meyer, James Warden, Andreas Degert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * ---------------------------------------------------------------------------
 *
 *    This is the 12AU7 tube table
 *    This file is part of the Guitarix Audio Engine
 *
 * ----------------------------------------------------------------------------
 */

struct tabled tubetable3[] = {
	{ // Ri = 68k
	-5,5,200, {
	127.202255052,127.144735521,127.087208545,127.029674135,126.972132303,
	126.914583061,126.857026422,126.799462397,126.741890998,126.684312237,
	126.626726127,126.569132679,126.511531906,126.45392382,126.396308434,
	126.338685759,126.281055807,126.223418592,126.165774125,126.108122418,
	126.050463485,125.992797338,125.935123988,125.877443449,125.819755734,
	125.762060854,125.704358822,125.646649651,125.588933353,125.531209942,
	125.473479429,125.415741829,125.357997152,125.300245413,125.242486624,
	125.184720797,125.126947947,125.069168085,125.011381225,124.953587379,
	124.895786561,124.837978784,124.780164061,124.722342404,124.664513828,
	124.606678345,124.548835968,124.490986711,124.433130587,124.375267609,
	124.317397791,124.259521146,124.201637688,124.143747429,124.085850383,
	124.027946564,123.970035986,123.912118661,123.854194604,123.796263828,
	123.738326347,123.680382175,123.622431324,123.56447381,123.506509646,
	123.448538845,123.390561421,123.332577389,123.274586763,123.216589556,
	123.158585782,123.100575455,123.04255859,122.984535201,122.926505301,
	122.868468905,122.810426027,122.752376682,122.694320883,122.636258645,
	122.578189982,122.520114909,122.46203344,122.40394559,122.345851372,
	122.287750803,122.229643895,122.171530664,122.113411125,122.055285291,
	121.997153178,121.939014801,121.880870174,121.822719312,121.76456223,
	121.706398942,121.648229465,121.590053812,121.531871999,121.47368404,
	121.415489952,121.357289748,121.299083444,121.240871056,121.182652598,
	121.124428085,121.066197534,121.007960959,120.949718376,120.891469799,
	120.833215245,120.77495473,120.716688268,120.658415874,120.600137566,
	120.541853358,120.483563266,120.425267305,120.366965492,120.308657843,
	120.250344372,120.192025096,120.133700031,120.075369193,120.017032598,
	119.958690261,119.900342199,119.841988428,119.783628965,119.725263824,
	119.666893023,119.608516578,119.550134505,119.49174682,119.433353539,
	119.37495468,119.316550259,119.258140292,119.199724795,119.141303785,
	119.08287728,119.024445295,118.966007847,118.907564953,118.84911663,
	118.790662894,118.732203763,118.673739253,118.615269382,118.556794165,
	118.498313621,118.439827767,118.381336619,118.322840194,118.26433851,
	118.205831585,118.147319435,118.088802077,118.03027953,117.97175181,
	117.913218935,117.854680922,117.796137789,117.737589554,117.679036234,
	117.620477847,117.56191441,117.503345942,117.444772459,117.386193981,
	117.327610524,117.269022108,117.210428748,117.151830465,117.093227275,
	117.034619197,116.97600625,116.91738845,116.858765817,116.800138368,
	116.741506123,116.682869099,116.624227315,116.565580789,116.50692954,
	116.448273586,116.389612947,116.330947639,116.272277683,116.213603098,
	116.1549239,116.096240111,116.037551747,115.97885883,115.920161376,
	115.861459406,115.802752938,115.744041992,115.685326586,115.62660674,
	115.567882473,115.509153805,115.450420754,115.39168334,115.332941582,
	115.274195501,115.215445115,115.156690443,115.097931507,115.039168325,
	114.980400916,114.921629302,114.862853501,114.804073533,114.745289419,
	114.686501178,114.62770883,114.568912395,114.510111894,114.451307346,
	114.392498772,114.333686192,114.274869626,114.216049094,114.157224618,
	114.098396216,114.039563911,113.980727722,113.92188767,113.863043775,
	113.804196059,113.745344542,113.686489244,113.627630187,113.568767392,
	113.509900879,113.451030669,113.392156784,113.333279244,113.274398071,
	113.215513286,113.156624909,113.097732963,113.038837469,112.979938447,
	112.92103592,112.862129909,112.803220436,112.744307521,112.685391187,
	112.626471456,112.567548349,112.508621887,112.449692094,112.39075899,
	112.331822598,112.272882939,112.213940036,112.154993911,112.096044586,
	112.037092083,111.978136425,111.919177633,111.860215731,111.801250739,
	111.742282682,111.683311582,111.624337461,111.565360341,111.506380246,
	111.447397198,111.38841122,111.329422335,111.270430566,111.211435936,
	111.152438467,111.093438183,111.034435107,110.975429263,110.916420672,
	110.857409359,110.798395347,110.73937866,110.68035932,110.621337352,
	110.562312778,110.503285623,110.44425591,110.385223663,110.326188906,
	110.267151662,110.208111956,110.149069811,110.090025251,110.030978301,
	109.971928984,109.912877325,109.853823348,109.794767077,109.735708537,
	109.676647751,109.617584745,109.558519543,109.49945217,109.440382649,
	109.381311006,109.322237266,109.263161453,109.204083592,109.145003709,
	109.085921827,109.026837972,108.96775217,108.908664445,108.849574822,
	108.790483327,108.731389985,108.672294822,108.613197862,108.554099132,
	108.494998657,108.435896462,108.376792573,108.317687016,108.258579817,
	108.199471001,108.140360595,108.081248624,108.022135114,107.963020092,
	107.903903583,107.844785615,107.785666212,107.726545401,107.667423209,
	107.608299663,107.549174788,107.490048611,107.430921159,107.371792458,
	107.312662535,107.253531418,107.194399132,107.135265705,107.076131164,
	107.016995535,106.957858847,106.898721125,106.839582398,106.780442692,
	106.721302034,106.662160454,106.603017976,106.54387463,106.484730443,
	106.425585442,106.366439655,106.30729311,106.248145835,106.188997857,
	106.129849205,106.070699906,106.011549989,105.952399482,105.893248413,
	105.83409681,105.774944701,105.715792116,105.656639082,105.597485627,
	105.538331781,105.479177572,105.420023029,105.360868181,105.301713056,
	105.242557683,105.183402091,105.124246309,105.065090367,105.005934293,
	104.946778117,104.887621867,104.828465574,104.769309266,104.710152973,
	104.650996725,104.591840551,104.532684481,104.473528544,104.41437277,
	104.35521719,104.296061832,104.236906727,104.177751906,104.118597397,
	104.059443232,104.00028944,103.941136051,103.881983097,103.822830607,
	103.763678612,103.704527143,103.64537623,103.586225903,103.527076194,
	103.467927133,103.408778751,103.34963108,103.290484149,103.231337991,
	103.172192635,103.113048115,103.05390446,102.994761702,102.935619872,
	102.876479002,102.817339124,102.758200268,102.699062467,102.639925752,
	102.580790156,102.521655709,102.462522444,102.403390393,102.344259588,
	102.285130061,102.226001843,102.166874968,102.107749468,102.048625375,
	101.989502721,101.930381539,101.871261862,101.812143721,101.753027151,
	101.693912183,101.634798851,101.575687186,101.516577224,101.457468995,
	101.398362534,101.339257873,101.280155047,101.221054087,101.161955028,
	101.102857902,101.043762744,100.984669587,100.925578465,100.86648941,
	100.807402458,100.748317642,100.689234995,100.630154552,100.571076347,
	100.512000413,100.452926786,100.393855498,100.334786586,100.275720082,
	100.216656021,100.157594438,100.098535367,100.039478843,99.9804249014,
	99.9213735758,99.8623249014,99.8032789131,99.7442356459,99.6851951348,
	99.626157415,99.5671225215,99.5080904897,99.4490613547,99.390035152,
	99.3310119171,99.2719916853,99.2129744923,99.1539603737,99.0949493652,
	99.0359415025,98.9769368215,98.9179353582,98.8589371484,98.7999422282,
	98.7409506337,98.681962401,98.6229775665,98.5639961663,98.5050182369,
	98.4460438148,98.3870729363,98.3281056381,98.2691419569,98.2101819292,
	98.151225592,98.092272982,98.0333241361,97.9743790913,97.9154378847,
	97.8565005533,97.7975671344,97.7386376651,97.6797121827,97.6207907248,
	97.5618733286,97.5029600316,97.4440508716,97.3851458861,97.3262451127,
	97.2673485894,97.2084563538,97.149568444,97.0906848979,97.0318057536,
	96.972931049,96.9140608226,96.8551951123,96.7963339567,96.737477394,
	96.6786254626,96.6197782012,96.5609356482,96.5020978424,96.4432648223,
	96.3844366268,96.3256132947,96.2667948649,96.2079813764,96.1491728683,
	96.0903693795,96.0315709494,95.9727776171,95.9139894219,95.8552064032,
	95.7964286005,95.7376560531,95.6788888008,95.6201268831,95.5613703397,
	95.5026192104,95.443873535,95.3851333534,95.3263987056,95.2676696315,
	95.2089461714,95.1502283653,95.0915162534,95.0328098761,94.9741092737,
	94.9154144866,94.8567255554,94.7980425205,94.7393654225,94.6806943022,
	94.6220292003,94.5633701577,94.5047172151,94.4460704135,94.387429794,
	94.3287953976,94.2701672655,94.2115454388,94.1529299589,94.094320867,
	94.0357182045,93.977122013,93.918532334,93.859949209,93.8013726797,
	93.7428027879,93.6842395753,93.6256830838,93.5671333553,93.5085904318,
	93.4500543553,93.391525168,93.3330029121,93.2744876298,93.2159793634,
	93.1574781553,93.098984048,93.0404970839,92.9820173057,92.923544756,
	92.8650794774,92.8066215128,92.7481709051,92.689727697,92.6312919317,
	92.572863652,92.5144429013,92.4560297225,92.397624159,92.3392262541,
	92.2808360511,92.2224535935,92.1640789248,92.1057120886,92.0473531285,
	91.9890020883,91.9306590116,91.8723239425,91.8139969247,91.7556780023,
	91.6973672194,91.63906462,91.5807702484,91.5224841489,91.4642063657,
	91.4059369434,91.3476759263,91.289423359,91.2311792862,91.1729437526,
	91.1147168029,91.0564984821,90.9982888349,90.9400879065,90.8818957418,
	90.8237123861,90.7655378846,90.7073722826,90.6492156254,90.5910679586,
	90.5329293276,90.4747997782,90.4166793559,90.3585681067,90.3004660764,
	90.2423733109,90.1842898562,90.1262157586,90.0681510643,90.0100958195,
	89.9520500706,89.8940138642,89.8359872468,89.7779702652,89.719962966,
	89.6619653962,89.6039776027,89.5459996326,89.4880315331,89.4300733515,
	89.3721251352,89.3141869316,89.2562587884,89.1983407533,89.1404328741,
	89.0825351988,89.0246477754,88.9667706523,88.9089038776,88.8510474998,
	88.7932015676,88.7353661296,88.6775412346,88.6197269318,88.5619232702,
	88.5041302991,88.446348068,88.3885766264,88.3308160242,88.2730663111,
	88.2153275374,88.1575997532,88.099883009,88.0421773555,87.9844828434,
	87.9267995237,87.8691274477,87.8114666667,87.7538172323,87.6961791964,
	87.6385526111,87.5809375286,87.5233340014,87.4657420824,87.4081618245,
	87.350593281,87.2930365055,87.2354915517,87.1779584739,87.1204373264,
	87.062928164,87.0054310416,86.9479460146,86.8904731388,86.8330124701,
	86.775564065,86.7181279803,86.6607042731,86.6032930011,86.545894222,
	86.4885079945,86.4311343773,86.3737734298,86.3164252117,86.2590897832,
	86.2017672053,86.1444575392,86.0871608467,86.0298771904,85.9726066331,
	85.9153492385,85.858105071,85.8008741953,85.743656677,85.6864525825,
	85.6292619788,85.5720849335,85.5149215154,85.4577717937,85.4006358386,
	85.3435137212,85.2864055135,85.2293112884,85.1722311199,85.1151650827,
	85.058113253,85.0010757077,84.9440525249,84.8870437842,84.830049566,
	84.7730699521,84.7161050257,84.6591548713,84.6022195749,84.5452992237,
	84.4883939067,84.4315037144,84.3746287389,84.317769074,84.2609248154,
	84.2040960603,84.1472829082,84.0904854603,84.03370382,83.9769380928,
	83.9201883863,83.8634548107,83.8067374781,83.7500365035,83.6933520043,
	83.6366841005,83.580032915,83.5233985736,83.4667812049,83.4101809407,
	83.3535979161,83.2970322693,83.2404841423,83.1839536804,83.1274410328,
	83.0709463526,83.0144697967,82.9580115264,82.9015717072,82.8451505094,
	82.7887481075,82.7323646812,82.676000415,82.619655499,82.5633301282,
	82.5070245037,82.4507388321,82.3944733263,82.3382282053,82.2820036947,
	82.2258000269,82.1696174413,82.1134561847,82.0573165111,82.0011986828,
	81.9451029699,81.8890296512,81.8329790139,81.7769513547,81.7209469793,
	81.6649662036,81.6090093531,81.5530767642,81.4971687841,81.4412857711,
	81.3854280954,81.3295961391,81.2737902971,81.2180109771,81.1622586004,
	81.1065336021,81.0508364319,80.9951675546,80.9395274501,80.8839166148,
	80.8283355615,80.7727848202,80.7172649388,80.6617764836,80.60632004,
	80.550896213,80.4955056283,80.4401489323,80.3848267936,80.3295399031,
	80.2742889753,80.2190747483,80.1638979857,80.1087594762,80.0536600356,
	79.9986005067,79.9435817607,79.8886046981,79.8336702492,79.7787793757,
	79.7239330709,79.6691323614,79.6143783076,79.5596720049,79.5050145846,
	79.4504072153,79.3958511034,79.3413474946,79.2868976751,79.232502972,
	79.1781647554,79.1238844387,79.0696634799,79.0155033833,78.9614056998,
	78.9073720286,78.8534040181,78.7995033671,78.745671826,78.6919111977,
	78.6382233388,78.5846101608,78.5310736309,78.4776157733,78.4242386699,
	78.3709444615,78.3177353487,78.2646135927,78.2115815159,78.1586415033,
	78.1057960025,78.0530475247,78.0003986452,77.947852004,77.8954103058,
	77.8430763209,77.7908528846,77.738742898,77.6867493276,77.6348752053,
	77.5831236277,77.5314977563,77.4800008163,77.4286360961,77.3774069467,
	77.3263167799,77.2753690679,77.2245673409,77.1739151864,77.1234162467,
	77.0730742172,77.0228928441,76.9728759219,76.9230272907,76.8733508334,
	76.8238504726,76.7745301674,76.7253939097,76.6764457203,76.6276896455,
	76.5791297525,76.530770125,76.4826148588,76.4346680573,76.3869338259,
	76.3394162677,76.2921194775,76.245047537,76.1982045089,76.1515944315,
	76.1052213127,76.0590891244,76.0132017967,75.9675632117,75.9221771979,
	75.8770475238,75.8321778926,75.787571936,75.7432332085,75.6991651814,
	75.6553712381,75.6118546675,75.5686186599,75.5256663009,75.4830005672,
	75.4406243218,75.3985403095,75.3567511527,75.3152593478,75.2740672612,
	75.2331771266,75.1925910414,75.1523109648,75.1123387149,75.0726759671,
	75.0333242522,74.9942849556,74.9555593161,74.9171484253,74.8790532275,
	74.84127452,74.8038129532,74.7666690316,74.729843115,74.6933354196,
	74.6571460201,74.6212748514,74.5857217107,74.5504862605,74.5155680309,
	74.4809664224,74.4466807098,74.4127100446,74.3790534589,74.3457098694,
	74.3126780802,74.2799567878,74.2475445842,74.2154399613,74.183641315,
	74.1521469494,74.1209550808,74.0900638421,74.0594712869,74.0291753936,
	73.9991740699,73.9694651566,73.940046432,73.9109156157,73.8820703727,
	73.8535083174,73.8252270172,73.7972239966,73.7694967405,73.7420426981,
	73.7148592861,73.6879438923,73.6612938788,73.6349065851,73.608779331,
	73.5829094199,73.5572941414,73.5319307741,73.5068165879,73.481948847,
	73.4573248118,73.4329417415,73.408796896,73.3848875381,73.3612109353,
	73.337764362,73.3145451007,73.2915504439,73.2687776959,73.2462241737,
	73.2238872088,73.2017641484,73.1798523562,73.1581492141,73.1366521227,
	73.1153585028,73.0942657956,73.073371464,73.0526729932,73.0321678913,
	73.01185369,72.9917279452,72.9717882373,72.9520321718,72.9324573797,
	72.9130615179,72.8938422692,72.8747973428,72.8559244746,72.8372214272,
	72.8186859901,72.8003159797,72.7821092396,72.7640636405,72.7461770802,
	72.7284474836,72.7108728027,72.6934510167,72.6761801314,72.6590581798,
	72.6420832213,72.6252533423,72.6085666551,72.5920212986,72.5756154379,
	72.5593472636,72.5432149922,72.5272168657,72.5113511511,72.4956161407,
	72.4800101513,72.4645315244,72.4491786254,72.433949844,72.4188435934,
	72.4038583105,72.388992455,72.3742445097,72.3596129798,72.3450963931,
	72.3306932992,72.3164022693,72.3022218964,72.2881507943,72.2741875978,
	72.2603309624,72.2465795636,72.232932097,72.2193872781,72.2059438415,
	72.192600541,72.1793561494,72.1662094579,72.1531592761,72.1402044315,
	72.1273437694,72.1145761524,72.1019004605,72.0893155905,72.0768204558,
	72.0644139862,72.0520951278,72.0398628423,72.0277161072,72.0156539153,
	72.0036752745,71.9917792075,71.9799647519,71.9682309594,71.956576896,
	71.9450016415,71.9335042896,71.9220839473,71.9107397349,71.8994707857,
	71.888276246,71.8771552744,71.8661070421,71.8551307324,71.8442255407,
	71.8333906741,71.8226253513,71.8119288024,71.8013002686,71.7907390024,
	71.7802442669,71.7698153359,71.7594514938,71.7491520351,71.7389162647,
	71.7287434971,71.718633057,71.7085842785,71.6985965052,71.6886690901,
	71.6788013952,71.6689927918,71.6592426597,71.6495503876,71.6399153729,
	71.6303370213,71.6208147466,71.6113479711,71.6019361248,71.592578646,
	71.5832749802,71.574024581,71.5648269093,71.5556814334,71.5465876288,
	71.5375449783,71.5285529715,71.5196111052,71.5107188828,71.5018758143,
	71.4930814165,71.4843352126,71.4756367321,71.4669855107,71.4583810906,
	71.4498230196,71.4413108518,71.432844147,71.424422471,71.416045395,
	71.407712496,71.3994233563,71.3911775639,71.3829747119,71.3748143987,
	71.366696228,71.3586198085,71.3505847537,71.3425906823,71.3346372179,
	71.3267239885,71.3188506271,71.3110167714,71.3032220633,71.2954661496,
	71.2877486811,71.2800693133,71.2724277058,71.2648235225,71.2572564313,
	71.2497261043,71.2422322176,71.2347744514,71.2273524895,71.2199660198,
	71.212614734,71.2052983272,71.1980164986,71.1907689508,71.18355539,
	71.1763755258,71.1692290714,71.1621157434,71.1550352617,71.1479873495,
	71.1409717334,71.133988143,71.1270363112,71.1201159739,71.1132268703,
	71.1063687424,71.0995413353,71.0927443969,71.0859776782,71.0792409329,
	71.0725339177,71.0658563918,71.0592081174,71.0525888592,71.0459983846,
	71.0394364638,71.0329028693,71.0263973764,71.0199197628,71.0134698085,
	71.0070472963,71.0006520112,70.9942837405,70.9879422739,70.9816274037,
	70.9753389239,70.9690766313,70.9628403246,70.9566298047,70.9504448748,
	70.94428534,70.9381510078,70.9320416875,70.9259571906,70.9198973305,
	70.9138619226,70.9078507843,70.901863735,70.8959005958,70.8899611899,
	70.8840453422,70.8781528795,70.8722836304,70.8664374253,70.8606140963,
	70.8548134773,70.8490354038,70.8432797131,70.8375462442,70.8318348376,
	70.8261453356,70.8204775819,70.814831422,70.8092067028,70.8036032728,
	70.7980209821,70.7924596821,70.7869192259,70.7813994679,70.7759002642,
	70.7704214719,70.7649629499,70.7595245583,70.7541061588,70.748707614,
	70.7433287883,70.7379695473,70.7326297578,70.7273092879,70.722008007,
	70.7167257859,70.7114624965,70.7062180119,70.7009922065,70.6957849559,
	70.6905961368,70.6854256272,70.6802733061,70.6751390538,70.6700227516,
	70.664924282,70.6598435285,70.6547803758,70.6497347097,70.6447064169,
	70.6396953852,70.6347015035,70.6297246618,70.6247647509,70.6198216628,
	70.6148952904,70.6099855275,70.6050922689,70.6002154106,70.5953548492,
	70.5905104824,70.5856822089,70.580869928,70.5760735403,70.5712929469,
	70.5665280502,70.5617787532,70.5570449596,70.5523265745,70.5476235032,
	70.5429356523,70.5382629289,70.5336052413,70.5289624981,70.5243346092,
	70.5197214849,70.5151230364,70.5105391758,70.5059698158,70.5014148699,
	70.4968742524,70.4923478781,70.4878356629,70.4833375231,70.4788533759,
	70.4743831391,70.4699267312,70.4654840714,70.4610550798,70.4566396767,
	70.4522377835,70.447849322,70.4434742148,70.439112385,70.4347637566,
	70.4304282539,70.426105802,70.4217963266,70.4174997541,70.4132160112,
	70.4089450256,70.4046867254,70.4004410391,70.3962078961,70.3919872262,
	70.3877789598,70.3835830278,70.3793993618,70.3752278939,70.3710685566,
	70.3669212831,70.3627860071,70.3586626627,70.3545511847,70.3504515084,
	70.3463635694,70.3422873042,70.3382226493,70.3341695421,70.3301279203,
	70.3260977221,70.3220788863,70.3180713521,70.314075059,70.3100899473,
	70.3061159575,70.3021530306,70.2982011081,70.2942601321,70.2903300448,
	70.2864107891,70.2825023083,70.278604546,70.2747174464,70.270840954,
	70.2669750137,70.263119571,70.2592745716,70.2554399617,70.2516156878,
	70.2478016971,70.2439979368,70.2402043547,70.2364208989,70.2326475181,
	70.2288841612,70.2251307773,70.2213873163,70.2176537281,70.2139299631,
	70.2102159721,70.2065117062,70.2028171169,70.1991321561,70.1954567758,
	70.1917909286,70.1881345674,70.1844876454,70.180850116,70.1772219332,
	70.1736030512,70.1699934245,70.1663930079,70.1628017565,70.159219626,
	70.155646572,70.1520825507,70.1485275185,70.1449814321,70.1414442485,
	70.1379159251,70.1343964195,70.1308856895,70.1273836935,70.1238903898,
	70.1204057374,70.1169296952,70.1134622226,70.1100032792,70.1065528249,
	70.10311082,70.0996772248,70.0962520002,70.0928351069,70.0894265065,
	70.0860261602,70.08263403,70.0792500778,70.0758742659,70.072506557,
	70.0691469136,70.065795299,70.0624516764,70.0591160093,70.0557882615,
	70.052468397,70.0491563801,70.0458521752,70.0425557471,70.0392670607,
	70.0359860812,70.032712774,70.0294471048,70.0261890395,70.022938544,
	70.0196955847,70.0164601282,70.0132321412,70.0100115905,70.0067984435,
	70.0035926675,70.0003942301,69.997203099,69.9940192423,69.9908426281,
	69.987673225,69.9845110014,69.9813559263,69.9782079686,69.9750670975,
	69.9719332824,69.968806493,69.9656866989,69.9625738702,69.9594679771,
	69.9563689898,69.9532768789,69.9501916152,69.9471131695,69.9440415128,
	69.9409766166,69.9379184521,69.934866991,69.9318222051,69.9287840663,
	69.9257525469,69.922727619,69.9197092551,69.916697428,69.9136921103,
	69.9106932751,69.9077008955,69.9047149448,69.9017353964,69.898762224,
	69.8957954014,69.8928349024,69.8898807013,69.8869327721,69.8839910894,
	69.8810556276,69.8781263615,69.875203266,69.872286316,69.8693754867,
	69.8664707534,69.8635720915,69.8606794767,69.8577928846,69.8549122911,
	69.8520376723,69.8491690042,69.8463062633,69.843449426,69.8405984687,
	69.8377533682,69.8349141014,69.8320806452,69.8292529768,69.8264310733,
	69.8236149122,69.820804471,69.8179997272,69.8152006587,69.8124072433,
	69.809619459,69.806837284,69.8040606966,69.8012896751,69.798524198,
	69.7957642439,69.7930097917,69.7902608201,69.7875173082,69.7847792351,
	69.7820465799,69.7793193221,69.7765974411,69.7738809164,69.7711697277,
	69.7684638549,69.7657632778,69.7630679764,69.760377931,69.7576931216,
	69.7550135287,69.7523391328,69.7496699143,69.747005854,69.7443469326,
	69.741693131,69.7390444302,69.7364008113,69.7337622555,69.731128744,
	69.7285002583,69.7258767798,69.7232582901,69.720644771,69.7180362043,
	69.7154325717,69.7128338553,69.7102400373,69.7076510997,69.7050670248,
	69.7024877951,69.6999133929,69.6973438008,69.6947790015,69.6922189777,
	69.6896637122,69.6871131881,69.6845673881,69.6820262956,69.6794898936,
	69.6769581654,69.6744310945,69.6719086642,69.669390858,69.6668776597,
	69.6643690529,69.6618650215,69.6593655492,69.65687062,69.6543802181,
	69.6518943274,69.6494129323,69.646936017,69.6444635658,69.6419955633,
	69.6395319939,69.6370728423,69.6346180932,69.6321677312,69.6297217413,
	69.6272801083,69.6248428174,69.6224098534,69.6199812016,69.6175568472,
	69.6151367755,69.6127209718,69.6103094217,69.6079021105,69.605499024,
	69.6031001477,69.6007054674,69.5983149688,69.595928638,69.5935464607,
	69.5911684231,69.5887945111,69.586424711,69.5840590089,69.5816973912,
	69.5793398442,69.5769863543,69.5746369081,69.5722914919,69.5699500926,
	69.5676126967,69.565279291,69.5629498624,69.5606243976,69.5583028837,
	69.5559853076,69.5536716564,69.5513619173,69.5490560774,69.546754124,
	69.5444560444,69.542161826,69.5398714561,69.5375849224,69.5353022123,
	69.5330233135,69.5307482137,69.5284769005,69.5262093618,69.5239455854,
	69.5216855592,69.5194292712,69.5171767094,69.5149278619,69.5126827168,
	69.5104412624,69.5082034867,69.5059693782,69.5037389252,69.5015121161,
	69.4992889393,69.4970693835,69.4948534371,69.4926410887,69.4904323271,
	69.488227141,69.4860255191,69.4838274503,69.4816329235,69.4794419275,
	69.4772544515,69.4750704843,69.4728900152,69.4707130332,69.4685395275,
	69.4663694874,69.4642029021,69.462039761,69.4598800535,69.4577237689,
	69.4555708968,69.4534214266,69.451275348,69.4491326506,69.446993324,
	69.444857358,69.4427247423,69.4405954667,69.438469521,69.4363468952,
	69.4342275792,69.4321115629,69.4299988365,69.42788939,69.4257832134,
	69.4236802971,69.421580631,69.4194842056,69.4173910112,69.4153010379,
	69.4132142763,69.4111307167,69.4090503496,69.4069731655,69.404899155,
	69.4028283086,69.400760617,69.3986960708,69.3966346607,69.3945763775,
	69.392521212,69.390469155,69.3884201974,69.3863743301,69.384331544,
	69.3822918302,69.3802551795,69.3782215832,69.3761910323,69.374163518,
	69.3721390314,69.3701175638,69.3680991063,69.3660836504,69.3640711872,
	69.3620617083,69.360055205,69.3580516687,69.3560510909,69.3540534631,
	69.3520587769,69.3500670239,69.3480781956,69.3460922837,69.34410928,
	69.3421291761,69.3401519637,69.3381776348,69.3362061811,69.3342375944,
	69.3322718667,69.3303089899,69.328348956,69.3263917569,69.3244373848,
	69.3224858315,69.3205370893,69.3185911503,69.3166480066,69.3147076504,
	69.312770074,69.3108352696,69.3089032295,69.306973946,69.3050474114,
	69.3031236182,69.3012025588,69.2992842255,69.297368611,69.2954557076,
	69.293545508,69.2916380046,69.2897331902,69.2878310572,69.2859315985,
	69.2840348066,69.2821406742,69.2802491942,69.2783603593,69.2764741623,
	69.274590596,69.2727096534,69.2708313271,69.2689556103,69.2670824959,
	69.2652119768,69.263344046,69.2614786965,69.2596159215,69.2577557139,
	69.255898067,69.2540429739,69.2521904276,69.2503404215,69.2484929487,
	69.2466480025,69.2448055761,69.2429656629,69.2411282562,69.2392933493,
	69.2374609357,69.2356310086,69.2338035617,69.2319785882,69.2301560817,
	69.2283360358,69.2265184438,69.2247032995,69.2228905963,69.2210803279,
	69.2192724879,69.21746707,69.2156640679,69.2138634751,69.2120652856,
	69.210269493,69.2084760912,69.2066850738,69.2048964348,69.203110168,
	69.2013262672,69.1995447265,69.1977655395,69.1959887005,69.1942142031,
	69.1924420416,69.1906722099,69.1889047019,69.1871395119,69.1853766338,
	69.1836160617,69.1818577899,69.1801018123,69.1783481232,69.1765967169,
	69.1748475874,69.173100729,69.171356136,69.1696138026,69.1678737232,
	69.1661358921,69.1644003035,69.162666952,69.1609358317,69.1592069373,
	69.157480263,69.1557558033,69.1540335526,69.1523135056,69.1505956566,
	69.1488800002,69.1471665309,69.1454552434,69.1437461321,69.1420391917,
	69.1403344169,69.1386318022,69.1369313423,69.1352330319,69.1335368658,
	69.1318428385,69.130150945,69.1284611799,69.126773538,69.1250880141,
	69.1234046031,69.1217232997,69.1200440988,69.1183669953,69.1166919841,
	69.1150190601,69.1133482182,69.1116794534,69.1100127607,69.1083481349,
	69.1066855712,69.1050250645,69.1033666098,69.1017102023,69.100055837,
	69.098403509,69.0967532133,69.0951049452,69.0934586997,69.0918144721,
	69.0901722574,69.0885320509,69.0868938478,69.0852576434,69.0836234328,
	69.0819912113,69.0803609742,69.0787327168,69.0771064344,69.0754821223,
	69.0738597759,69.0722393905,69.0706209615,69.0690044844,69.0673899544,
	69.065777367,69.0641667177,69.0625580019,69.0609512151,69.0593463528,
	69.0577434105,69.0561423836,69.0545432678,69.0529460585,69.0513507514,
	69.049757342,69.0481658259,69.0465761987,69.0449884561,69.0434025936,
	69.041818607,69.0402364919,69.0386562439,69.0370778589,69.0355013325,
	69.0339266603,69.0323538383,69.0307828621,69.0292137275,69.0276464302,
	69.0260809661,69.0245173311,69.0229555208,69.0213955313,69.0198373582,
	69.0182809975,69.0167264451,69.0151736969,69.0136227488,69.0120735967,
	69.0105262365,69.0089806642,69.0074368758,69.0058948672,69.0043546345,
	69.0028161736,69.0012794806,68.9997445515,68.9982113823,68.9966799691,
	68.995150308,68.993622395,68.9920962263,68.990571798,68.9890491061,
	68.9875281469,68.9860089165,68.984491411,68.9829756266,68.9814615595,
	68.9799492059,68.978438562,68.976929624,68.9754223882,68.9739168508,
	68.9724130081,68.9709108564,68.9694103919,68.9679116109,68.9664145098,
	68.9649190848,68.9634253323,68.9619332487,68.9604428303,68.9589540734,
	68.9574669745,68.95598153,68.9544977362,68.9530155895,68.9515350864,
	68.9500562234,68.9485789968,68.9471034032,68.945629439,68.9441571007,
	68.9426863847,68.9412172877,68.9397498061,68.9382839364,68.9368196752,
	68.935357019,68.9338959644,68.932436508,68.9309786463,68.929522376,
	68.9280676936,68.9266145957,68.9251630791,68.9237131402,68.9222647759,
	68.9208179827,68.9193727572,68.9179290963,68.9164869965,68.9150464545,
	68.9136074672,68.9121700311,68.9107341431,68.9092997998,68.907866998,
	68.9064357345,68.9050060061,68.9035778095,68.9021511415,68.9007259989,
	68.8993023786,68.8978802773,68.8964596919,68.8950406192,68.8936230561,
	68.8922069994,68.890792446,68.8893793928,68.8879678367,68.8865577745,
	68.8851492032,68.8837421197,68.8823365209,68.8809324038,68.8795297653,
	68.8781286023,68.8767289119,68.8753306909,68.8739339364,68.8725386454,
	68.8711448149,68.8697524418,68.8683615232,68.8669720562,68.8655840377,
	68.8641974648,68.8628123346,68.8614286441,68.8600463904,68.8586655705,
	68.8572861817,68.8559082209,68.8545316853,68.853156572,68.8517828781,
	68.8504106007,68.8490397371,68.8476702843,68.8463022395,68.8449355998,
	68.8435703625,68.8422065248,68.8408440837,68.8394830366,68.8381233807,
	68.836765113,68.835408231,68.8340527318,68.8326986126,68.8313458707,
	68.8299945034,68.8286445079,68.8272958816,68.8259486216,68.8246027253,
	68.8232581899,68.8219150129,68.8205731915,68.8192327229,68.8178936047,
	68.816555834,68.8152194082,68.8138843248,68.812550581,68.8112181742,
	68.8098871018,68.8085573612,68.8072289498,68.8059018649,68.804576104,
	68.8032516645,68.8019285438,68.8006067394,68.7992862487,68.797967069,
	68.796649198,68.795332633,68.7940173715,68.7927034109,68.7913907488,
	68.7900793827,68.78876931,68.7874605283,68.786153035,68.7848468276,
	68.7835419038
	}},
	{ // Ri = 250k
	-5,5,200, {
	127.202255052,127.144735521,127.087208545,127.029674135,126.972132303,
	126.914583061,126.857026422,126.799462397,126.741890998,126.684312237,
	126.626726127,126.569132679,126.511531906,126.45392382,126.396308434,
	126.338685759,126.281055807,126.223418592,126.165774125,126.108122418,
	126.050463485,125.992797338,125.935123988,125.877443449,125.819755734,
	125.762060854,125.704358822,125.646649651,125.588933353,125.531209942,
	125.473479429,125.415741829,125.357997152,125.300245413,125.242486624,
	125.184720797,125.126947947,125.069168085,125.011381225,124.953587379,
	124.895786561,124.837978784,124.780164061,124.722342404,124.664513828,
	124.606678345,124.548835968,124.490986711,124.433130587,124.375267609,
	124.317397791,124.259521146,124.201637688,124.143747429,124.085850383,
	124.027946564,123.970035986,123.912118661,123.854194604,123.796263828,
	123.738326347,123.680382175,123.622431324,123.56447381,123.506509646,
	123.448538845,123.390561421,123.332577389,123.274586763,123.216589556,
	123.158585782,123.100575455,123.04255859,122.984535201,122.926505301,
	122.868468905,122.810426027,122.752376682,122.694320883,122.636258645,
	122.578189982,122.520114909,122.46203344,122.40394559,122.345851372,
	122.287750803,122.229643895,122.171530664,122.113411125,122.055285291,
	121.997153178,121.939014801,121.880870174,121.822719312,121.76456223,
	121.706398942,121.648229465,121.590053812,121.531871999,121.47368404,
	121.415489952,121.357289748,121.299083444,121.240871056,121.182652598,
	121.124428085,121.066197534,121.007960959,120.949718376,120.891469799,
	120.833215245,120.77495473,120.716688268,120.658415874,120.600137566,
	120.541853358,120.483563266,120.425267305,120.366965492,120.308657843,
	120.250344372,120.192025096,120.133700031,120.075369193,120.017032598,
	119.958690261,119.900342199,119.841988428,119.783628965,119.725263824,
	119.666893023,119.608516578,119.550134505,119.49174682,119.433353539,
	119.37495468,119.316550259,119.258140292,119.199724795,119.141303786,
	119.08287728,119.024445295,118.966007847,118.907564953,118.84911663,
	118.790662894,118.732203763,118.673739253,118.615269382,118.556794165,
	118.498313621,118.439827767,118.381336619,118.322840194,118.26433851,
	118.205831585,118.147319435,118.088802077,118.03027953,117.97175181,
	117.913218935,117.854680922,117.796137789,117.737589554,117.679036234,
	117.620477847,117.56191441,117.503345942,117.444772459,117.386193981,
	117.327610524,117.269022108,117.210428748,117.151830465,117.093227275,
	117.034619197,116.97600625,116.91738845,116.858765817,116.800138368,
	116.741506123,116.682869099,116.624227315,116.565580789,116.50692954,
	116.448273586,116.389612947,116.330947639,116.272277683,116.213603098,
	116.1549239,116.096240111,116.037551747,115.97885883,115.920161376,
	115.861459406,115.802752938,115.744041992,115.685326586,115.62660674,
	115.567882473,115.509153805,115.450420754,115.39168334,115.332941582,
	115.274195501,115.215445115,115.156690443,115.097931507,115.039168325,
	114.980400916,114.921629302,114.862853501,114.804073533,114.745289419,
	114.686501178,114.62770883,114.568912395,114.510111894,114.451307346,
	114.392498772,114.333686192,114.274869626,114.216049094,114.157224618,
	114.098396216,114.039563911,113.980727722,113.92188767,113.863043775,
	113.804196059,113.745344542,113.686489244,113.627630188,113.568767392,
	113.509900879,113.451030669,113.392156784,113.333279244,113.274398071,
	113.215513286,113.156624909,113.097732963,113.038837469,112.979938447,
	112.92103592,112.862129909,112.803220436,112.744307521,112.685391187,
	112.626471456,112.567548349,112.508621888,112.449692094,112.39075899,
	112.331822598,112.272882939,112.213940037,112.154993911,112.096044586,
	112.037092083,111.978136425,111.919177633,111.860215731,111.80125074,
	111.742282682,111.683311582,111.624337461,111.565360341,111.506380246,
	111.447397198,111.38841122,111.329422336,111.270430566,111.211435936,
	111.152438467,111.093438183,111.034435107,110.975429263,110.916420672,
	110.857409359,110.798395347,110.73937866,110.68035932,110.621337352,
	110.562312778,110.503285623,110.44425591,110.385223663,110.326188906,
	110.267151662,110.208111956,110.149069811,110.090025251,110.030978301,
	109.971928984,109.912877325,109.853823348,109.794767077,109.735708537,
	109.676647752,109.617584746,109.558519543,109.49945217,109.440382649,
	109.381311006,109.322237266,109.263161453,109.204083593,109.145003709,
	109.085921827,109.026837973,108.96775217,108.908664445,108.849574822,
	108.790483327,108.731389986,108.672294822,108.613197863,108.554099132,
	108.494998657,108.435896462,108.376792573,108.317687016,108.258579817,
	108.199471001,108.140360595,108.081248624,108.022135115,107.963020092,
	107.903903584,107.844785615,107.785666212,107.726545402,107.66742321,
	107.608299663,107.549174788,107.490048611,107.430921159,107.371792458,
	107.312662536,107.253531418,107.194399133,107.135265706,107.076131165,
	107.016995536,106.957858848,106.898721126,106.839582398,106.780442692,
	106.721302035,106.662160454,106.603017977,106.543874631,106.484730444,
	106.425585443,106.366439656,106.307293111,106.248145836,106.188997858,
	106.129849206,106.070699908,106.011549991,105.952399484,105.893248414,
	105.834096811,105.774944703,105.715792117,105.656639083,105.597485629,
	105.538331783,105.479177574,105.420023031,105.360868183,105.301713058,
	105.242557685,105.183402093,105.124246312,105.065090369,105.005934295,
	104.946778119,104.88762187,104.828465577,104.769309269,104.710152976,
	104.650996728,104.591840554,104.532684484,104.473528547,104.414372774,
	104.355217194,104.296061836,104.236906732,104.17775191,104.118597402,
	104.059443236,104.000289445,103.941136056,103.881983102,103.822830613,
	103.763678618,103.704527149,103.645376236,103.586225909,103.527076201,
	103.46792714,103.408778759,103.349631087,103.290484157,103.231337999,
	103.172192644,103.113048124,103.053904469,102.994761711,102.935619882,
	102.876479012,102.817339134,102.758200279,102.699062479,102.639925765,
	102.580790168,102.521655722,102.462522458,102.403390407,102.344259603,
	102.285130076,102.226001859,102.166874985,102.107749485,102.048625393,
	101.989502739,101.930381558,101.871261882,101.812143742,101.753027172,
	101.693912205,101.634798874,101.575687211,101.516577249,101.457469021,
	101.398362561,101.339257902,101.280155076,101.221054117,101.161955059,
	101.102857935,101.043762779,100.984669623,100.925578502,100.866489449,
	100.807402498,100.748317684,100.689235038,100.630154597,100.571076394,
	100.512000462,100.452926836,100.393855551,100.33478664,100.275720138,
	100.21665608,100.157594499,100.098535431,100.03947891,99.9804249704,
	99.9213736475,99.8623249759,99.8032789906,99.7442357264,99.6851952186,
	99.626157502,99.567122612,99.5080905837,99.4490614525,99.3900352536,
	99.3310120227,99.2719917951,99.2129746064,99.1539604923,99.0949494884,
	99.0359416307,98.9769369548,98.9179354966,98.8589372923,98.7999423778,
	98.7409507892,98.6819625626,98.6229777345,98.563996341,98.5050184185,
	98.4460440035,98.3870731325,98.328105842,98.2691421688,98.2101821495,
	98.151225821,98.09227322,98.0333243835,97.9743793485,97.915438152,
	97.8565008311,97.7975674231,97.7386379652,97.6797124948,97.6207910491,
	97.5618736657,97.5029603821,97.4440512358,97.3851462647,97.3262455062,
	97.2673489984,97.208456779,97.149568886,97.0906853573,97.031806231,
	96.9729315454,96.9140613384,96.8551956486,96.7963345141,96.7374779733,
	96.6786260648,96.6197788271,96.5609362988,96.5020985186,96.4432655252,
	96.3844373574,96.3256140541,96.2667956543,96.2079821969,96.1491737211,
	96.090370266,96.0315718708,95.9727785748,95.9139904174,95.8552074379,
	95.796429676,95.737657171,95.6788899628,95.6201280909,95.5613715951,
	95.5026205153,95.4438748913,95.3851347632,95.3264001709,95.2676711546,
	95.2089477545,95.1502300108,95.0915179637,95.0328116538,94.9741111215,
	94.9154164072,94.8567275516,94.7980445954,94.7393675792,94.6806965439,
	94.6220315304,94.5633725795,94.5047197323,94.44607303,94.3874325135,
	94.3287982243,94.2701702035,94.2115484926,94.152933133,94.0943241661,
	94.0357216337,93.9771255772,93.9185360386,93.8599530596,93.801376682,
	93.7428069478,93.684243899,93.6256875779,93.5671380264,93.5085952869,
	93.4500594017,93.3915304132,93.3330083638,93.2744932962,93.215985253,
	93.1574842769,93.0989904107,93.0405036972,92.9820241794,92.9235519003,
	92.8650869031,92.806629231,92.7481789271,92.689736035,92.631300598,
	92.5728726596,92.5144522635,92.4560394534,92.397634273,92.3392367663,
	92.2808469772,92.2224649498,92.1640907283,92.1057243567,92.0473658796,
	91.9890153414,91.9306727865,91.8723382596,91.8140118055,91.7556934689,
	91.6973832947,91.6390813282,91.5807876143,91.5225021983,91.4642251255,
	91.4059564416,91.3476961919,91.2894444223,91.2312011785,91.1729665065,
	91.1147404523,91.0565230622,90.9983143824,90.9401144593,90.8819233396,
	90.8237410699,90.7655676971,90.7074032682,90.6492478303,90.5911014307,
	90.5329641168,90.4748359361,90.4167169366,90.3586071659,90.3005066723,
	90.242415504,90.1843337093,90.1262613369,90.0681984356,90.0101450544,
	89.9521012424,89.8940670489,89.8360425236,89.7780277163,89.7200226769,
	89.6620274557,89.6040421032,89.54606667,89.4881012072,89.4301457658,
	89.3722003975,89.3142651538,89.2563400868,89.1984252488,89.1405206923,
	89.0826264704,89.0247426361,88.966869243,88.9090063449,88.8511539961,
	88.7933122511,88.7354811649,88.6776607928,88.6198511904,88.5620524139,
	88.5042645199,88.4464875652,88.3887216073,88.3309667042,88.2732229142,
	88.2154902961,88.1577689093,88.1000588138,88.04236007,87.9846727391,
	87.9269968825,87.8693325627,87.8116798425,87.7540387854,87.6964094557,
	87.6387919184,87.5811862391,87.5235924843,87.4660107213,87.408441018,
	87.3508834435,87.2933380675,87.2358049606,87.1782841946,87.1207758422,
	87.0632799768,87.0057966733,86.9483260074,86.8908680562,86.8334228976,
	86.7759906111,86.7185712772,86.661164978,86.6037717966,86.5463918178,
	86.4890251277,86.4316718142,86.3743319664,86.3170056754,86.2596930337,
	86.2023941359,86.145109078,86.0878379584,86.0305808771,85.9733379363,
	85.9161092405,85.8588948961,85.8016950119,85.7445096993,85.687339072,
	85.6301832461,85.5730423407,85.5159164775,85.4588057811,85.4017103791,
	85.3446304022,85.2875659842,85.2305172625,85.1734843777,85.1164674741,
	85.0594666999,85.0024822069,84.945514151,84.8885626925,84.8316279957,
	84.7747102297,84.717809568,84.6609261892,84.6040602768,84.5472120195,
	84.4903816116,84.4335692527,84.3767751485,84.3199995108,84.2632425574,
	84.2065045129,84.1497856085,84.0930860825,84.0364061805,83.9797461556,
	83.9231062687,83.866486789,83.809887994,83.75331017,83.6967536122,
	83.6402186255,83.5837055244,83.5272146335,83.470746288,83.4143008337,
	83.3578786281,83.3014800399,83.2451054504,83.1887552531,83.1324298546,
	83.0761296751,83.0198551485,82.9636067233,82.9073848632,82.8511900471,
	82.79502277,82.7388835436,82.682772897,82.6266913768,82.5706395482,
	82.5146179955,82.4586273228,82.4026681544,82.346741136,82.290846935,
	82.2349862413,82.1791597684,82.1233682537,82.0676124596,82.0118931742,
	81.9562112123,81.9005674161,81.844962656,81.7893978318,81.7338738734,
	81.6783917418,81.6229524301,81.5675569644,81.5122064049,81.456901847,
	81.4016444219,81.3464352983,81.291275683,81.2361668221,81.1811100021,
	81.1261065514,81.0711578405,81.0162652843,80.9614303422,80.90665452,
	80.8519393705,80.7972864951,80.7426975448,80.6881742212,80.6337182778,
	80.579331521,80.5250158115,80.470773065,80.4166052536,80.3625144069,
	80.3085026127,80.2545720181,80.2007248309,80.1469633197,80.0932898155,
	80.0397067122,79.9862164673,79.9328216025,79.8795247049,79.8263284265,
	79.7732354857,79.7202486668,79.6673708208,79.6146048653,79.5619537845,
	79.5094206291,79.4570085162,79.4047206287,79.352560215,79.3005305881,
	79.2486351248,79.1968772648,79.1452605095,79.0937884205,79.042464618,
	78.9912927792,78.9402766362,78.8894199741,78.838726628,78.7882004811,
	78.7378454614,78.6876655389,78.6376647223,78.5878470553,78.5382166134,
	78.4887774995,78.4395338398,78.3904897799,78.3416494797,78.2930171091,
	78.2445968429,78.1963928557,78.1484093165,78.1006503837,78.053120199,
	78.0058228821,77.958762525,77.9119431858,77.8653688829,77.819043589,
	77.7729712253,77.7271556551,77.6816006782,77.6363100247,77.591287349,
	77.5465362241,77.5020601362,77.4578624787,77.4139465467,77.3703155323,
	77.3269725192,77.2839204776,77.2411622604,77.1987005979,77.1565380947,
	77.1146772253,77.0731203307,77.0318696155,76.990927145,76.9502948426,
	76.909974488,76.8699677149,76.8302760101,76.7909007119,76.7518430099,
	76.7131039444,76.6746844061,76.636585137,76.5988067306,76.5613496329,
	76.5242141439,76.4874004191,76.4509084712,76.4147381725,76.3788892573,
	76.3433613242,76.3081538394,76.2732661397,76.2386974356,76.2044468146,
	76.1705132456,76.1368955816,76.1035925643,76.070602828,76.0379249031,
	76.0055572212,75.9734981182,75.9417458394,75.9102985434,75.8791543063,
	75.848311126,75.8177669265,75.7875195623,75.7575668221,75.7279064333,
	75.6985360662,75.6694533373,75.6406558142,75.6121410187,75.5839064308,
	75.5559494925,75.5282676111,75.5008581629,75.4737184964,75.4468459357,
	75.4202377835,75.3938913241,75.3678038265,75.3419725471,75.3163947322,
	75.291067621,75.2659884475,75.2411544433,75.2165628397,75.1922108698,
	75.1680957703,75.1442147838,75.1205651605,75.0971441596,75.0739490514,
	75.0509771182,75.0282256564,75.0056919772,74.9833734085,74.9612672952,
	74.9393710013,74.9176819098,74.8961974247,74.874914971,74.8538319958,
	74.8329459692,74.8122543847,74.7917547597,74.7714446366,74.7513215823,
	74.7313831897,74.7116270773,74.6920508898,74.6726522985,74.6534290013,
	74.634378723,74.6154992156,74.5967882581,74.578243657,74.5598632461,
	74.5416448865,74.5235864667,74.5056859027,74.4879411377,74.470350142,
	74.4529109135,74.4356214765,74.4184798829,74.4014842108,74.3846325653,
	74.3679230776,74.3513539054,74.3349232322,74.3186292676,74.3024702466,
	74.2864444294,74.2705501017,74.2547855738,74.2391491806,74.2236392814,
	74.2082542598,74.1929925227,74.177852501,74.1628326486,74.1479314424,
	74.133147382,74.1184789894,74.1039248086,74.0894834054,74.0751533673,
	74.0609333028,74.0468218415,74.0328176334,74.0189193491,74.0051256791,
	73.9914353336,73.9778470424,73.9643595544,73.9509716375,73.937682078,
	73.9244896808,73.9113932687,73.8983916822,73.8854837795,73.8726684358,
	73.8599445434,73.8473110113,73.8347667649,73.8223107457,73.8099419111,
	73.7976592344,73.785461704,73.7733483235,73.7613181117,73.7493701016,
	73.737503341,73.7257168917,73.7140098296,73.7023812443,73.6908302387,
	73.6793559292,73.6679574452,73.6566339291,73.6453845356,73.6342084321,
	73.6231047982,73.6120728253,73.6011117169,73.590220688,73.579398965,
	73.5686457855,73.5579603984,73.547342063,73.5367900498,73.5263036396,
	73.5158821233,73.5055248024,73.495230988,73.4850000013,73.474831173,
	73.4647238434,73.4546773621,73.4446910879,73.4347643887,73.4248966411,
	73.4150872306,73.4053355513,73.3956410057,73.3860030047,73.3764209671,
	73.3668943202,73.3574224987,73.3480049456,73.3386411111,73.3293304532,
	73.3200724372,73.3108665357,73.3017122285,73.2926090024,73.2835563511,
	73.2745537752,73.2656007821,73.2566968855,73.2478416058,73.2390344699,
	73.2302750107,73.2215627675,73.2128972856,73.2042781163,73.1957048168,
	73.1871769502,73.178694085,73.1702557957,73.1618616621,73.1535112694,
	73.1452042084,73.1369400749,73.12871847,73.1205389999,73.1124012759,
	73.104304914,73.0962495354,73.0882347658,73.0802602359,73.0723255807,
	73.0644304401,73.0565744583,73.0487572841,73.0409785705,73.0332379747,
	73.0255351586,73.0178697878,73.0102415321,73.0026500655,72.9950950659,
	72.9875762151,72.9800931987,72.9726457062,72.9652334309,72.9578560697,
	72.950513323,72.9432048951,72.9359304935,72.9286898295,72.9214826175,
	72.9143085755,72.9071674247,72.9000588896,72.8929826981,72.885938581,
	72.8789262723,72.8719455093,72.8649960321,72.8580775839,72.8511899108,
	72.844332762,72.8375058893,72.8307090475,72.8239419941,72.8172044895,
	72.8104962966,72.8038171811,72.7971669113,72.7905452582,72.7839519951,
	72.7773868982,72.7708497458,72.764340319,72.757858401,72.7514037776,
	72.7449762369,72.7385755693,72.7322015676,72.7258540266,72.7195327435,
	72.7132375179,72.7069681511,72.7007244468,72.694506211,72.6883132513,
	72.6821453778,72.6760024024,72.6698841391,72.6637904036,72.6577210139,
	72.6516757897,72.6456545528,72.6396571265,72.6336833363,72.6277330094,
	72.6218059746,72.6159020628,72.6100211064,72.6041629397,72.5983273985,
	72.5925143204,72.5867235447,72.5809549122,72.5752082655,72.5694834485,
	72.5637803071,72.5580986883,72.5524384409,72.5467994152,72.5411814629,
	72.5355844373,72.530008193,72.5244525861,72.5189174741,72.5134027161,
	72.5079081723,72.5024337044,72.4969791754,72.4915444497,72.4861293931,
	72.4807338724,72.475357756,72.4700009133,72.4646632153,72.4593445339,
	72.4540447423,72.448763715,72.4435013277,72.4382574572,72.4330319815,
	72.4278247797,72.4226357321,72.4174647202,72.4123116263,72.4071763341,
	72.4020587284,72.3969586948,72.3918761201,72.3868108923,72.3817629002,
	72.3767320336,72.3717181837,72.3667212421,72.3617411019,72.3567776569,
	72.3518308019,72.3469004328,72.3419864461,72.3370887397,72.332207212,
	72.3273417625,72.3224922916,72.3176587005,72.3128408914,72.3080387673,
	72.3032522319,72.2984811901,72.2937255474,72.2889852101,72.2842600854,
	72.2795500813,72.2748551066,72.2701750709,72.2655098845,72.2608594586,
	72.2562237051,72.2516025367,72.2469958667,72.2424036093,72.2378256794,
	72.2332619927,72.2287124653,72.2241770145,72.2196555578,72.2151480137,
	72.2106543013,72.2061743404,72.2017080515,72.1972553556,72.1928161746,
	72.1883904309,72.1839780475,72.1795789482,72.1751930572,72.1708202995,
	72.1664606008,72.1621138871,72.1577800852,72.1534591226,72.1491509271,
	72.1448554274,72.1405725526,72.1363022322,72.1320443967,72.1277989769,
	72.123565904,72.1193451101,72.1151365275,72.1109400894,72.1067557292,
	72.1025833809,72.0984229793,72.0942744593,72.0901377566,72.0860128072,
	72.0818995479,72.0777979156,72.073707848,72.0696292831,72.0655621596,
	72.0615064164,72.0574619931,72.0534288296,72.0494068663,72.0453960442,
	72.0413963045,72.0374075891,72.0334298402,72.0294630004,72.0255070128,
	72.0215618211,72.017627369,72.0137036011,72.009790462,72.0058878971,
	72.0019958519,71.9981142724,71.9942431051,71.9903822968,71.9865317947,
	71.9826915465,71.9788615,71.9750416037,71.9712318063,71.967432057,
	71.9636423053,71.959862501,71.9560925943,71.9523325359,71.9485822768,
	71.9448417681,71.9411109616,71.9373898094,71.9336782636,71.9299762771,
	71.9262838028,71.9226007941,71.9189272048,71.9152629889,71.9116081006,
	71.9079624947,71.9043261262,71.9006989504,71.8970809229,71.8934719996,
	71.8898721369,71.8862812912,71.8826994194,71.8791264786,71.8755624264,
	71.8720072205,71.8684608189,71.8649231799,71.8613942621,71.8578740245,
	71.8543624263,71.8508594268,71.8473649859,71.8438790635,71.8404016199,
	71.8369326157,71.8334720117,71.8300197691,71.826575849,71.8231402132,
	71.8197128235,71.816293642,71.8128826312,71.8094797536,71.806084972,
	71.8026982497,71.79931955,71.7959488366,71.7925860731,71.7892312238,
	71.785884253,71.7825451252,71.7792138052,71.775890258,71.7725744489,
	71.7692663434,71.7659659071,71.762673106,71.7593879063,71.7561102742,
	71.7528401764,71.7495775796,71.746322451,71.7430747576,71.7398344669,
	71.7366015466,71.7333759644,71.7301576886,71.7269466872,71.7237429288,
	71.7205463819,71.7173570156,71.7141747987,71.7109997006,71.7078316906,
	71.7046707384,71.7015168139,71.698369887,71.6952299278,71.6920969069,
	71.6889707947,71.685851562,71.6827391798,71.679633619,71.676534851,
	71.6734428473,71.6703575795,71.6672790193,71.6642071389,71.6611419102,
	71.6580833057,71.6550312978,71.6519858592,71.6489469627,71.6459145813,
	71.6428886881,71.6398692565,71.6368562598,71.6338496718,71.6308494663,
	71.6278556171,71.6248680983,71.6218868843,71.6189119494,71.6159432682,
	71.6129808154,71.6100245659,71.6070744946,71.6041305767,71.6011927875,
	71.5982611025,71.5953354972,71.5924159474,71.589502429,71.5865949179,
	71.5836933903,71.5807978225,71.577908191,71.5750244723,71.5721466431,
	71.5692746802,71.5664085606,71.5635482615,71.56069376,71.5578450334,
	71.5550020594,71.5521648155,71.5493332795,71.5465074292,71.5436872426,
	71.5408726979,71.5380637733,71.5352604472,71.532462698,71.5296705045,
	71.5268838452,71.5241026992,71.5213270452,71.5185568625,71.5157921303,
	71.5130328278,71.5102789345,71.5075304299,71.5047872938,71.5020495058,
	71.4993170459,71.4965898941,71.4938680305,71.4911514352,71.4884400887,
	71.4857339713,71.4830330636,71.4803373463,71.4776468,71.4749614057,
	71.4722811443,71.4696059969,71.4669359446,71.4642709687,71.4616110506,
	71.4589561717,71.4563063136,71.453661458,71.4510215867,71.4483866814,
	71.4457567242,71.4431316972,71.4405115824,71.4378963621,71.4352860186,
	71.4326805345,71.4300798922,71.4274840743,71.4248930635,71.4223068427,
	71.4197253947,71.4171487025,71.4145767492,71.412009518,71.409446992,
	71.4068891546,71.4043359893,71.4017874795,71.3992436089,71.3967043611,
	71.3941697198,71.3916396689,71.3891141924,71.3865932742,71.3840768985,
	71.3815650494,71.3790577112,71.3765548681,71.3740565047,71.3715626054,
	71.3690731547,71.3665881374,71.3641075382,71.3616313418,71.3591595332,
	71.3566920973,71.3542290191,71.3517702838,71.3493158765,71.3468657825,
	71.3444199871,71.3419784758,71.3395412339,71.3371082471,71.334679501,
	71.3322549813,71.3298346737,71.3274185641,71.3250066384,71.3225988825,
	71.3201952826,71.3177958246,71.3154004948,71.3130092795,71.3106221649,
	71.3082391374,71.3058601835,71.3034852898,71.3011144427,71.2987476289,
	71.2963848352,71.2940260482,71.2916712549,71.2893204422,71.286973597,
	71.2846307063,71.2822917573,71.279956737,71.2776256327,71.2752984317,
	71.2729751214,71.270655689,71.2683401221,71.2660284081,71.2637205347,
	71.2614164895,71.2591162602,71.2568198345,71.2545272002,71.2522383453,
	71.2499532575,71.247671925,71.2453943357,71.2431204777,71.2408503393,
	71.2385839085,71.2363211736,71.234062123,71.2318067451,71.2295550282,
	71.2273069608,71.2250625314,71.2228217287,71.2205845412,71.2183509577,
	71.2161209669,71.2138945576,71.2116717186,71.2094524388,71.2072367071,
	71.2050245127,71.2028158444,71.2006106914,71.1984090428,71.1962108879,
	71.1940162159,71.191825016,71.1896372776,71.1874529901,71.1852721429,
	71.1830947256,71.1809207276,71.1787501385,71.176582948,71.1744191456,
	71.1722587212,71.1701016646,71.1679479654,71.1657976135,71.163650599,
	71.1615069116,71.1593665414,71.1572294785,71.1550957128,71.1529652346,
	71.1508380339,71.1487141011,71.1465934263,71.1444759999,71.1423618121,
	71.1402508534,71.1381431141,71.1360385848,71.133937256,71.1318391181,
	71.1297441618,71.1276523777,71.1255637565,71.1234782889,71.1213959656,
	71.1193167774,71.1172407152,71.1151677698,71.1130979321,71.1110311931,
	71.1089675437,71.106906975,71.1048494781,71.102795044,71.1007436639,
	71.098695329,71.0966500304,71.0946077595,71.0925685075,71.0905322657,
	71.0884990255,71.0864687783,71.0844415156,71.0824172287,71.0803959093,
	71.0783775489,71.0763621389,71.0743496712,71.0723401372,71.0703335287,
	71.0683298374,71.066329055,71.0643311734,71.0623361844,71.0603440798,
	71.0583548515,71.0563684914,71.0543849915,71.0524043438,71.0504265403,
	71.048451573,71.0464794341,71.0445101156,71.0425436098,71.0405799088,
	71.0386190048,71.03666089,71.0347055568,71.0327529975,71.0308032044,
	71.0288561699,71.0269118863,71.0249703462,71.023031542,71.0210954661,
	71.0191621112,71.0172314698,71.0153035344,71.0133782977,71.0114557523,
	71.009535891,71.0076187064,71.0057041912,71.0037923382,71.0018831403,
	70.9999765902,70.9980726807,70.9961714049,70.9942727555,70.9923767255,
	70.9904833079,70.9885924957,70.9867042819,70.9848186595,70.9829356216,
	70.9810551613,70.9791772718,70.9773019462,70.9754291776,70.9735589594,
	70.9716912847,70.9698261468,70.9679635389,70.9661034545,70.9642458868,
	70.9623908292,70.9605382751,70.958688218,70.9568406512,70.9549955682,
	70.9531529626,70.9513128279,70.9494751575,70.9476399451,70.9458071843,
	70.9439768687,70.9421489919,70.9403235476,70.9385005294,70.9366799312,
	70.9348617467,70.9330459695,70.9312325936,70.9294216127,70.9276130206,
	70.9258068113,70.9240029785,70.9222015163,70.9204024184,70.918605679,
	70.9168112919,70.9150192512,70.9132295508,70.9114421849,70.9096571474,
	70.9078744325,70.9060940343,70.904315947,70.9025401645,70.9007666812,
	70.8989954913,70.8972265889,70.8954599683,70.8936956238,70.8919335496,
	70.89017374,70.8884161894,70.8866608922,70.8849078426,70.8831570351,
	70.8814084641,70.879662124,70.8779180092,70.8761761143,70.8744364337,
	70.8726989619,70.8709636935,70.869230623,70.867499745,70.865771054,
	70.8640445448,70.8623202118,70.8605980499,70.8588780535,70.8571602175,
	70.8554445365,70.8537310053,70.8520196185,70.850310371,70.8486032576,
	70.846898273,70.8451954121,70.8434946697,70.8417960407,70.8400995199,
	70.8384051023,70.8367127827,70.8350225561,70.8333344174,70.8316483616,
	70.8299643837,70.8282824787,70.8266026417,70.8249248675,70.8232491514,
	70.8215754884,70.8199038735,70.8182343019,70.8165667687,70.8149012691,
	70.8132377981,70.8115763511,70.8099169231,70.8082595094,70.8066041053,
	70.8049507059,70.8032993065,70.8016499024,70.8000024889,70.7983570614,
	70.796713615,70.7950721452,70.7934326474,70.7917951169,70.7901595491,
	70.7885259394,70.7868942832,70.785264576,70.7836368132,70.7820109903,
	70.7803871028,70.7787651462,70.777145116,70.7755270077,70.7739108169,
	70.7722965391,70.77068417,70.769073705,70.7674651399,70.7658584703,
	70.7642536917,70.7626507999,70.7610497905,70.7594506591,70.7578534016,
	70.7562580136,70.7546644907,70.7530728289,70.7514830237,70.7498950711,
	70.7483089667,70.7467247064,70.745142286,70.7435617013,70.7419829481,
	70.7404060224,70.7388309199,70.7372576365,70.7356861682,70.7341165109,
	70.7325486605,70.7309826128,70.729418364,70.7278559098,70.7262952464,
	70.7247363697,70.7231792756,70.7216239603,70.7200704198,70.71851865,
	70.716968647,70.715420407,70.713873926,70.7123292001,70.7107862253,
	70.7092449979,70.707705514,70.7061677696,70.704631761,70.7030974843,
	70.7015649357,70.7000341115,70.6985050077,70.6969776207,70.6954519467,
	70.6939279818,70.6924057225,70.6908851648,70.6893663052,70.68784914,
	70.6863336653,70.6848198776,70.6833077731,70.6817973482,70.6802885993,
	70.6787815228,70.6772761149,70.6757723721,70.6742702908,70.6727698674,
	70.6712710983,70.66977398,70.6682785089,70.6667846814,70.6652924941,
	70.6638019434,70.6623130257,70.6608257377,70.6593400758,70.6578560365,
	70.6563736163,70.6548928119,70.6534136197,70.6519360364,70.6504600585,
	70.6489856826,70.6475129053,70.6460417232,70.6445721329,70.6431041311,
	70.6416377145,70.6401728795,70.638709623,70.6372479416,70.635787832,
	70.6343292908,70.6328723148,70.6314169007,70.6299630452,70.6285107451,
	70.6270599971,70.6256107979,70.6241631444,70.6227170332,70.6212724612,
	70.6198294252,70.618387922,70.6169479483,70.6155095011,70.6140725771,
	70.6126371732,70.6112032863,70.6097709132,70.6083400508,70.6069106959,
	70.6054828456,70.6040564965,70.6026316458,70.6012082902,70.5997864268,
	70.5983660524,70.5969471641,70.5955297587,70.5941138333,70.5926993847,
	70.5912864101,70.5898749064,70.5884648705,70.5870562996,70.5856491906,
	70.5842435406,70.5828393466,70.5814366056,70.5800353147,70.578635471,
	70.5772370716,70.5758401135,70.5744445938,70.5730505096,70.5716578581,
	70.5702666363,70.5688768414,70.5674884705,70.5661015208,70.5647159894,
	70.5633318734,70.5619491701,70.5605678767,70.5591879902,70.5578095079,
	70.5564324271,70.5550567448,70.5536824584,70.552309565,70.550938062,
	70.5495679464,70.5481992157,70.546831867,70.5454658977,70.5441013049,
	70.542738086,70.5413762383,70.5400157591,70.5386566456,70.5372988952,
	70.5359425053,70.534587473,70.5332337959,70.5318814712,70.5305304963,
	70.5291808686,70.5278325853,70.526485644,70.5251400419,70.5237957765,
	70.5224528452,70.5211112453,70.5197709744,70.5184320297,70.5170944088,
	70.5157581091,70.514423128,70.513089463,70.5117571115,70.510426071,
	70.5090963391,70.507767913,70.5064407904,70.5051149688,70.5037904455,
	70.5024672183,70.5011452845,70.4998246417,70.4985052874,70.4971872191,
	70.4958704345,70.494554931,70.4932407063,70.4919277578,70.4906160832,
	70.48930568,70.4879965458,70.4866886782,70.4853820748,70.4840767332,
	70.4827726511,70.481469826,70.4801682555,70.4788679374,70.4775688692,
	70.4762710486,70.4749744732,70.4736791407,70.4723850488,70.4710921952,
	70.4698005774,70.4685101933,70.4672210404,70.4659331165,70.4646464193,
	70.4633609466
	}}
};
