/* gtkplotcanvas - gtkplot canvas widget for gtk+
 * Copyright 1999-2001  Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <gtk/gtk.h>
#include "gtkplot.h"
#include "gtkplotcanvas.h"
#include "gtkplotcanvaspixmap.h"
#include "gtkplotgdk.h"
#include "gtkplotps.h"

enum {
  ARG_0,
  ARG_PIXMAP,
  ARG_MASK,
};

static void gtk_plot_canvas_pixmap_init	(GtkPlotCanvasPixmap *pixmap);
static void gtk_plot_canvas_pixmap_class_init(GtkPlotCanvasChildClass *klass);
static void gtk_plot_canvas_pixmap_destroy	(GtkObject *object);
static void gtk_plot_canvas_pixmap_draw 	(GtkPlotCanvas *canvas,
						 GtkPlotCanvasChild *child);
static void gtk_plot_canvas_pixmap_move	(GtkPlotCanvas *canvas,
						 GtkPlotCanvasChild *child,
						 gdouble x, gdouble y);
static void gtk_plot_canvas_pixmap_resize	(GtkPlotCanvas *canvas,
						 GtkPlotCanvasChild *child,
						 gdouble x1, gdouble y1,
						 gdouble x2, gdouble y2);
static void gtk_plot_canvas_pixmap_get_arg      (GtkObject      *object,
                                                 GtkArg         *arg,
                                                 guint           arg_id);
static void gtk_plot_canvas_pixmap_set_arg      (GtkObject      *object,
                                                 GtkArg         *arg,
                                                 guint           arg_id);

static GtkPlotCanvasChildClass *parent_class = NULL;

GtkType
gtk_plot_canvas_pixmap_get_type (void)
{
  static GtkType plot_canvas_pixmap_type = 0;

  if (!plot_canvas_pixmap_type)
    {
      GtkTypeInfo plot_canvas_pixmap_info =
      {
	"GtkPlotCanvasPixmap",
	sizeof (GtkPlotCanvasPixmap),
	sizeof (GtkPlotCanvasPixmapClass),
	(GtkClassInitFunc) gtk_plot_canvas_pixmap_class_init,
	(GtkObjectInitFunc) gtk_plot_canvas_pixmap_init,
	/* reserved 1*/ NULL,
        /* reserved 2 */ NULL,
        (GtkClassInitFunc) NULL,
      };

      plot_canvas_pixmap_type = gtk_type_unique (gtk_plot_canvas_child_get_type(), &plot_canvas_pixmap_info);
    }
  return plot_canvas_pixmap_type;
}

GtkPlotCanvasChild*
gtk_plot_canvas_pixmap_new (GdkPixmap *_pixmap, GdkBitmap *mask)
{
  GtkPlotCanvasPixmap *pixmap;
                                                                                
  pixmap = gtk_type_new (gtk_plot_canvas_pixmap_get_type ());

  pixmap->pixmap = _pixmap;
  pixmap->mask = mask;

  if(_pixmap) gdk_pixmap_ref(_pixmap);
  if(mask) gdk_bitmap_ref(mask);
                                                                                
  return GTK_PLOT_CANVAS_CHILD (pixmap);
}

static void
gtk_plot_canvas_pixmap_init (GtkPlotCanvasPixmap *pixmap)
{
  pixmap->pixmap = NULL;
  pixmap->mask = NULL;
}

static void
gtk_plot_canvas_pixmap_destroy(GtkObject *object)
{
  GtkPlotCanvasPixmap *pixmap = GTK_PLOT_CANVAS_PIXMAP(object);

  if(pixmap->pixmap) gdk_pixmap_unref(pixmap->pixmap);
  if(pixmap->mask) gdk_bitmap_unref(pixmap->mask);
  pixmap->pixmap = NULL;
  pixmap->mask = NULL;
}

static void
gtk_plot_canvas_pixmap_class_init (GtkPlotCanvasChildClass *klass)
{
  GtkObjectClass *object_class = (GtkObjectClass *)klass;

  parent_class = gtk_type_class (gtk_plot_canvas_child_get_type ());

  object_class->destroy = gtk_plot_canvas_pixmap_destroy;
  object_class->get_arg = gtk_plot_canvas_pixmap_get_arg;
  object_class->set_arg = gtk_plot_canvas_pixmap_set_arg;
                                                                                
  gtk_object_add_arg_type ("GtkPlotCanvasPixmap::pixmap",
                           GTK_TYPE_POINTER,
                           GTK_ARG_READWRITE,
                           ARG_PIXMAP);
  gtk_object_add_arg_type ("GtkPlotCanvasPixmap::mask_bitmap",
                           GTK_TYPE_POINTER,
                           GTK_ARG_READWRITE,
                           ARG_MASK);

  klass->draw = gtk_plot_canvas_pixmap_draw; 
  klass->move = gtk_plot_canvas_pixmap_move; 
  klass->move_resize = gtk_plot_canvas_pixmap_resize; 
}

static void
gtk_plot_canvas_pixmap_get_arg (GtkObject      *object,
                               GtkArg         *arg,
                               guint           arg_id)
{
  GtkPlotCanvasPixmap *pixmap = GTK_PLOT_CANVAS_PIXMAP (object);
                                                                                
  switch(arg_id){
    case ARG_PIXMAP:
      GTK_VALUE_POINTER(*arg) = pixmap->pixmap;
      break;
    case ARG_MASK:
      GTK_VALUE_POINTER(*arg) = pixmap->mask;
      break;
  }
}
                                                                                
static void
gtk_plot_canvas_pixmap_set_arg (GtkObject      *object,
                               GtkArg         *arg,
                               guint           arg_id)
{
  GtkPlotCanvasPixmap *pixmap = GTK_PLOT_CANVAS_PIXMAP (object);
                                                                                
  switch(arg_id){
    case ARG_PIXMAP:
      if(pixmap->pixmap) gdk_pixmap_unref(pixmap->pixmap);
      pixmap->pixmap = (GdkPixmap *)GTK_VALUE_POINTER(*arg);
      if(pixmap->pixmap) gdk_pixmap_ref(pixmap->pixmap);
      break;
    case ARG_MASK:
      if(pixmap->mask) gdk_bitmap_unref(pixmap->mask);
      pixmap->mask = (GdkBitmap *)GTK_VALUE_POINTER(*arg);
      if(pixmap->mask) gdk_bitmap_ref(pixmap->mask);
      break;
  }
}

static void 
gtk_plot_canvas_pixmap_draw 		(GtkPlotCanvas *canvas,
					 GtkPlotCanvasChild *child)
{
  GtkPlotCanvasPixmap *pixmap = GTK_PLOT_CANVAS_PIXMAP(child);
  
  if(pixmap->pixmap){
    gdouble scale_x, scale_y;
    gint width, height;

    gdk_window_get_size(pixmap->pixmap, &width, &height);
    scale_x = (gdouble)child->allocation.width / (gdouble)width;
    scale_y = (gdouble)child->allocation.height / (gdouble)height;
    gtk_plot_pc_draw_pixmap(canvas->pc, pixmap->pixmap, pixmap->mask,
                            0, 0,
                            child->allocation.x,
                            child->allocation.y,
                            width,
                            height,
                            scale_x, scale_y);
  } else {
    GdkColormap *colormap = gdk_colormap_get_system();
    GdkColor black, white;

    gdk_color_black(colormap, &black);
    gdk_color_white(colormap, &white);
                                                                          
    gtk_plot_pc_set_color(canvas->pc, &white);
    gtk_plot_pc_draw_rectangle(canvas->pc, TRUE,
                         child->allocation.x, child->allocation.y,
                         child->allocation.width, child->allocation.height);
    gtk_plot_pc_set_color(canvas->pc, &black);
    gtk_plot_pc_draw_rectangle(canvas->pc, FALSE,
                         child->allocation.x, child->allocation.y,
                         child->allocation.width, child->allocation.height);
  }
}

static void 
gtk_plot_canvas_pixmap_move		(GtkPlotCanvas *canvas,
					 GtkPlotCanvasChild *child,
					 gdouble x, gdouble y)
{
  return;
}

static void 
gtk_plot_canvas_pixmap_resize	(GtkPlotCanvas *canvas,
					 GtkPlotCanvasChild *child,
					 gdouble x1, gdouble y1,
					 gdouble x2, gdouble y2)
{
  return;
}

