# -*- coding: utf-8 -*-
# -----------------------------------------------------------------------------
# Getting Things Gnome! - a personal organizer for the GNOME desktop
# Copyright (c) 2008-2012 - Lionel Dricot & Bertrand Rousseau
#
# This program is free software: you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License along with
# this program.  If not, see <http://www.gnu.org/licenses/>.
# -----------------------------------------------------------------------------
"""Various information about GTG. Should be updated for every release. 

Contains the information displayed in GTG's Credits."""

from GTG import _

NAME = "Getting Things GNOME!"
URL = "http://gtg.fritalk.com"
HELP_URI = "help:gtg"
TRANSLATE_URL = "https://translations.launchpad.net/gtg"
REPORT_BUG_URL = "https://bugs.launchpad.net/gtg/+filebug"
EMAIL = "gtg-contributors@lists.launchpad.net"
VERSION = '0.3'

SHORT_DESCRIPTION = \
 _('GTG is a personal tasks and TODO-list items organizer for the GNOME.')

# CREDITS
AUTHORS     = ["Main developers:", \
               "\tLionel Dricot <ploum@ploum.net>", \
               "\tBertrand Rousseau <bertrand.rousseau@gmail.com>", \
               "\tPaulo Cabido <paulo.cabido@gmail.com>", \
               "\tLuca Invernizzi <invernizzi.l@gmail.com>", \
               "\tKevin Mehall <km@kevinmehall.net>", \
               "\tLuca Falavigna <dktrkranz@debian.org>", \
               "\tIzidor Matušov <izidor.matusov@gmail.com>", \
               "Contributors:", \
               "\tAbdul Rauf <abdulraufhaseeb@gmail.com>", \
               "\tAbhiram <abhiram.ampabathina@gmail.com>", \
               "\tAlayn Gortazar <zutoin@gmail.com>", \
               "\tAlan Gomes <alangalvino@gmail.com>", \
               "\tAnant Gupta <anant718@hotmail.com>", \
               "\tAndrew Starr-Bochicchio <andrewsomething@ubuntu.com>", \
               "\tAntonio Roquentin <https://launchpad.net/~antonio-roquentin>", \
               "\tAntons Rebguns <arebgun@gmail.com>", \
               "\tBen Dowling <ben.m.dowling@gmail.com>", \
               "\tBrian Kennedy <ekspiulo@gmail.com>", \
               "\tBryce Harrington <bryce@bryceharrington.org>", \
               "\tCarl Chenet <chaica@ohmytux.com>", \
               "\tChris Johnston <chrisjohnston@ubuntu.com>", \
               "\tDaniel Neel <dneelyep@gmail.com>", \
               "\tdAnjou <>", \
               "\tDavid Planella <david.planella@jabber.org>", \
               "\tErin McLaughlin <emclaughlin1215@gmail.com>", \
               "\tFabio Prina <fabio@nimsh.com>", \
               "\tFrançois <>", \
               "\tGérôme Fournier <>", \
               "\thuxuan <i@huxuan.org>", \
               "\tIvan Evtukhovich <evtuhovich@gmail.com>", \
               "\tJean-François Fortin Tam <nekohayo@gmail.com>", \
               "\tJeff Oliver <kaiserfro@gmail.com>", \
               "\tJérôme Guelfucci <jerome.guelfucci@gmail.com>",      \
               "\tJoão Ascenso <joaoricardoascenso@gmail.com>", \
               "\tJonathan Barnoud <jonathan@barnoud.net>", \
               "\tJonathan Lange <jml@mumak.net>", \
               "\tKalle Persson <kalle@kallepersson.se>", \
               "\tKees Cook <kees@ubuntu.com>", \
               "\tMadhumitha Viswanathan <madhuvishy@gmail.com>", \
               "\tMarcos Lenharo <>", \
               "\tMarko Kevac <marko@kevac.org>", \
               "\tMarta Maria Casetti <mmcasetti@gmail.com>", \
               "\tMatthew Rasmus <tareth.ml@gmail.com>", \
               "\tMichael Vogt <michael.vogt@ubuntu.com>", \
               "\tNicolas Maître <nimai@skynet.be>", \
               "\tNimit Shah <nimit.svnit@gmail.com>", \
               "\tPaul Kishimoto <mail@paul.kishimoto.name>", \
               "\tRichard Klein <kleinric@gmail.com>", \
               "\tSaurabh Anand <saurabhanandiit@gmail.com>", \
               "\tStefan Handschuh <https://launchpad.net/~handschuh>", \
               "\tSteve Scheel <nmu.sscheel@gmail.com>", \
               "\tSong Yangyu <flyfy1@gmail.com>", \
               "\tThibault Fevry <ThibaultFevry@gmail.com>", \
               "\tViktor Nagy <viktor.nagy@toolpart.hu>", \
               "\tVolodymyr Floreskul <exufer@gmail.com>", \
               "\tWolter Hellmund <wolterh6@gmail.com>", \
               "\tZach Shepherd <eightball1989@gmail.com>", \
               "\tZimin Huang <ienjoycoding@gmail.com>", \
]
ARTISTS     = ["Kalle Persson <kalle@kallepersson.se>", \
                "Bertrand Rousseau <bertrand.rousseau@gmail.com>"]
ARTISTS.sort()
TRANSLATORS = \
"""Afrikaans:Arthur Rilke, Walter Leibbrandt, Wesley Channon
Albanian: Vilson Gjeci
Arabic: Ahmed Kotb, Ali AlNoaimi, Anas Almzoghy, Basher Aobasher, Islam Alshaikh, Kaïs Bejaoui
Asturian: Xuacu Saturio, ivarela
Basque: Asier Iturralde Sarasola, Oier Mees
Belarusian: Egor Kuryanovich, Iryna Nikanchuk 
Bengali: XFACT, nasir khan saikat
Brazilian: AdirKuhn, André Gondim, Belenos Govannnon, Daniel Tiecher, Djavan Fagundes, Douglas Santos, João Cruz Jr, João Santana, NeLaS, Nilton, Rafael Neri, Teylo Laundos Aguiar, Waldir Leoncio, andre felix
Bulgarian: Damyan Ivanov, Svetoslav Stefanov, i.raynov
Catalan: Carles Sala, David Planella, Juanma Hernández, Marc Recasens, Radina Matic, Siegfried Gevatter, anna marti
Chinese (simplified): Ang Gao, Anthony Fok, Eleanor Chen, Harold.luo, Heling Yao, Kyle WANG, Wylmer Wang, Xuan Hu, chars, 百草谷居士
Chinese (traditional): Andrew Liu, Anthony Fok, Po-Jen Hsu, Rex Tsai, Toomore
Croatian: Saša Teković
Czech: David Kovář, Jakub Kozisek, Jan Hrdina, Konki, Kuvaly [LCT], Ladislav Prskavec, Mailo, Martin Rotter, Martin Volf, Marv-CZ, Milos-kroulik-3, Roman Horník, Viktor
Danish: Aputsiaq Niels Janussen, Ask Hjorth Larsen, Mogens Isager, Peter Skov, mkjeldsen
Dutch: Emilien Klein, Foppe Benedictus, Hanssen, Heureka, Lionel Dricot, Lucas Vieites, Nathan, Rachid, Reinout van Schouwen, Tino Meinen, klap-in, puccha, rob
English (Canada): Itai Molenaar, Ken Sharp, Paul Kishimoto
English (United Kingdom): Alexandre COLLIGNON, Alfredo Hernández, Anthony Harrington, Bruce Cowan, Cyril, Jonathon Hodges, Lionel Dricot, Luca Invernizzi, Michael Keppler, Olly Betts, Philipp Kleinhenz, Robert Readman, Sid Roberts, ascenseur
Finnish: Heikki Mattila, Mika Tapojärvi
French: AkaiKen, Alexandre COLLIGNON, Bertrand Rousseau, Bruno Veilleux, Cyril, David Coeurjolly, Dominick Rivard, Emilien Klein, FrancoisSchoubben, François, Greizgh, Jibec, Lionel Dricot, Maxime Veroone, Nicolas Delvaux, Perniflosse, Philippe Le Toquin, Pititjo, Ptitphysik, Quentin Pagès, Rafik Ouerchefani, Raphaël, Sid Roberts, Simon Leblanc, Stanislas Michalak, Thibault Févry, Timothee Bernard, Yves Masson, bsaleil, gaetanpralong, sebz
Galician: Dario, Fran Diéguez, Jorge Álvarez, Miguel Anxo Bouzada, keko
Georgian: Giorgi Jvaridze
German: Abb, Alexandre COLLIGNON, Christoph-M. Lehmann, Daniel Dietrich, Daniel Winzen, Fabian Affolter, Gerfried Fuchs, Henry78, Izidor Matušov, Jan, Jens Maucher, Jonas Endersch, Marcel Stimberg, Michael Keppler, Philip Stewart, Raphael J. Schmid, Scott, Seraphyn, Thomas Pitlik, Tim Bordemann, gerber, schulz3000
Greek: Fotis Tsamis, George Chronis, Stathis Iosifidis 
Hebrew: Erik, Yaron
Hungarian: András Kárász, Crcsz Tibcr, Gabor Kelemen, Gergely Szarka, Krasznecz Zoltán, Muszela Balázs
Icelandic: Baldur, Palmar Thorsteinsson, Samúel Jón Gunnarsson
Indonesian: Andika Triwidada, Wayan Sudiarnata
Interlingua: Emilio Sepulveda 
Italian: Antonio Roquentin, Claudio Arseni, Dario Bertini, Davide Alberelli, Dennis Anfossi, Fabio Marconi, Francesco de Virgilio, Gianfranco, Luca Falavigna, Luca Invernizzi, Milo Casagrande, Radina Matic, jollyr0ger
Japanese: 9APPAT3CH, Chris Harrington, Hideki Yamane, Hiroshi Tagawa
Korean: khmirage
Lithuanian: Algimantas Margevičius, Mantas Kriaučiūnas, Rytis Ūsalis, aurisc4, jaro
Lojabn: David Futcher 
Malagasy: Thierry Andriamirado 
Malay: Ibrahim Elias, abuyop, itiknila, melayubuntu
Norwegian Bokmal: Gamlerik, Runar Ingebrigtsen, Terje Andre Arnøy, Øystein
Occitan (post 1500): Cédric VALMARY (Tot en òc)
Persian: Sepehr Lajevardi 
Polish: Jakub Kołakowski, Konrad, Piotr Hałas, Piotr Strębski, Radek Puła, Tomasz 'Zen' Napierala, Tomasz Maciejewski, btomasz, szczym, tomlee
Portuguese: Joel Patrão, Paulo Cabido, raul_pereira
Romanian: Adi Roiban, Lucian Adrian Grijincu
Russian: A. S. Popov, Alexander Semyonov, Alexey Ivanov, Alexey Kostyuk, Alexey Nedilko, Andrej Surkov, DmDr, Dmitry "Divius" Tantsur, Nergal, Nikita Putko, Oleg Koptev, Peter Romov, Serfer, Yevgeny Sysmanov, Yuriy Vidineev, a220, dueMiR, maxzda, mrk, wiz, Олег Малахов
Serbian: Miloš Mandarić, Мирослав Николић
Sinhalese: ජීවන්ත ලේකම්වසම් 
Slovak: Izidor Matušov, Milan Slovák, Slavko
Slovenian: Andrej Znidarsic, Igor2x, grofaty
Spanish: Adolfo Jayme Barrientos, Alberto Caso, Carlos Alberto Ospina, Denis Fuenzalida, DiegoJ, Grillo, Javier García Díaz, Javier Jardón, Javier Suárez, Jorge González, Jose R. Megia, Lionel Dricot, Nicolás M. Zahlut, Nukeador, Radina Matic, Rafael Soler - Domatix, Xuacu Saturio, ixzus, n_alex, perriman
Swedish: Christian Widell, Daniel Nylander, David Bengtsson, Erik Piehl Sylvén, Kalle Persson, Maxim Andersson, Nikke, Petri Rosenström, jens persson
Telugu: Arjuna Rao Chavala,     వీవెన్ (Veeven)
Thai: NullZer0, SiraNokyoongtong
Turkish: Aean, Ali KIBICI, Emre Ayca, Murat Gunes, Onur ALTINTAŞI, Yiğit Ateş
Ukrainian: Alex Chmyr, Gontsa, Pavel Druzyak, dueMiR, yvadim
"""

DOCUMENTERS = ["Radina Matic <radina.matic@gmail.com>"]
