/* More tool options
 *
 * gsumi version 0.9.2
 *
 * Copyright 1998 Owen Taylor <otaylor@gtk.org>
*/

#include <stdio.h>
#include "gsumi.h"

static GtkWidget *options_dialog = NULL;
static GtkWidget *use_threshhold_button;
static GtkWidget *threshhold_slider;
static GtkWidget *profile_widget;

static gdouble saved_threshhold;
static gint saved_use_threshhold;
static gdouble saved_profile[32];

static ToolInfo *current_tool;

static void options_dialog_update (void);
static gint options_dialog_delete_cb (GtkWidget *widget);
static void options_dialog_threshhold_cb (GtkAdjustment *adj);
static void options_dialog_use_threshhold_toggled (GtkWidget *widget);
static void options_dialog_snarf_profile (GtkWidget *widget);

static void options_dialog_close_cb (GtkWidget *widget);
static gint options_dialog_revert_cb (GtkWidget *widget);
static gint options_dialog_delete_cb (GtkWidget *widget);

#define CURVE_RANGE 150.

void 
options_dialog_create (void)
{
  GtkWidget *button;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkWidget *main_vbox;
  GtkWidget *curve;

  if (!options_dialog)
    {
      options_dialog = gtk_dialog_new ();
      gtk_signal_connect (GTK_OBJECT (options_dialog), "delete_event",
			  GTK_SIGNAL_FUNC(options_dialog_delete_cb), 
			  NULL);

      main_vbox = gtk_vbox_new (FALSE, 4);
      gtk_container_border_width (GTK_CONTAINER (main_vbox), 5);
      gtk_box_pack_start (GTK_BOX(GTK_DIALOG (options_dialog)->vbox),
			  main_vbox, TRUE, TRUE, 0);
      gtk_widget_show (main_vbox);
      
      use_threshhold_button = gtk_check_button_new_with_label ("Simulate clicks from pressure");
      gtk_box_pack_start (GTK_BOX(main_vbox),
			  use_threshhold_button, FALSE, FALSE, 0);
      gtk_widget_show (use_threshhold_button);
      gtk_signal_connect (GTK_OBJECT (use_threshhold_button), "toggled",
			  GTK_SIGNAL_FUNC(options_dialog_use_threshhold_toggled),
			  NULL);

      adj = (GtkAdjustment *)gtk_adjustment_new (0.0, 0.0, 1.0, 0.1, 0.01, 0.0);
      label = gtk_label_new ("Threshhold:");
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_box_pack_start (GTK_BOX(main_vbox),
			  label, FALSE, FALSE, 0);
      gtk_widget_show (label);

      threshhold_slider = gtk_hscale_new(adj);
      gtk_box_pack_start (GTK_BOX(main_vbox),
			  threshhold_slider, FALSE, FALSE, 0);
      gtk_scale_set_digits (GTK_SCALE (threshhold_slider), 2);
      gtk_widget_show (threshhold_slider);
      gtk_signal_connect (GTK_OBJECT (adj), "value_changed",
			  GTK_SIGNAL_FUNC (options_dialog_threshhold_cb), NULL);
      label = gtk_label_new ("Pressure response:");
      gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
      gtk_box_pack_start (GTK_BOX(main_vbox),
			  label, FALSE, FALSE, 0);
      gtk_widget_show (label);
      profile_widget = gtk_gamma_curve_new();
      curve = GTK_GAMMA_CURVE(profile_widget)->curve;
      gtk_curve_set_range (GTK_CURVE (curve),
			   0.0, CURVE_RANGE, 0.0, CURVE_RANGE);
      gtk_box_pack_start (GTK_BOX(main_vbox), profile_widget, TRUE, TRUE, 0);
      gtk_widget_show (profile_widget);

      gtk_signal_connect_after (GTK_OBJECT (curve),
				"button_press_event",
				GTK_SIGNAL_FUNC(options_dialog_snarf_profile),
				NULL);
      gtk_signal_connect_after (GTK_OBJECT (curve),
				"motion_notify_event",
				GTK_SIGNAL_FUNC(options_dialog_snarf_profile),
				NULL);

      button = gtk_button_new_with_label ("Close");
      gtk_signal_connect (GTK_OBJECT (button), "clicked",
			  GTK_SIGNAL_FUNC(options_dialog_close_cb),
			  NULL);
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT);
      gtk_box_pack_start (GTK_BOX(GTK_DIALOG (options_dialog)->action_area),
			  button, TRUE, TRUE, 0);
      gtk_widget_grab_default (button);
      gtk_widget_show (button);

      button = gtk_button_new_with_label ("Revert");
      gtk_signal_connect (GTK_OBJECT (button), "clicked",
			  GTK_SIGNAL_FUNC(options_dialog_revert_cb),
			  NULL);
      gtk_box_pack_start (GTK_BOX(GTK_DIALOG (options_dialog)->action_area),
			  button, TRUE, TRUE, 0);
      gtk_widget_show (button);
    }
  
  if (!GTK_WIDGET_VISIBLE (options_dialog))
    {
      gtk_widget_show (options_dialog);
      if (current_tool)
	options_dialog_set_current_device (current_tool->id);
    }
  else
    gtk_widget_hide (options_dialog);
}

#define BUFSIZE 64
void 
options_dialog_set_current_device (guint32 deviceid)
{
  int i;
  
  for (i=0; i<num_tools; i++)
    if (tools[i]->id == deviceid)
      {
	current_tool = tools[i];
	break;
      }

  if (current_tool)
    {
      char buf[BUFSIZE] = "Options - ";
      saved_threshhold = current_tool->threshhold;
      saved_use_threshhold = saved_threshhold;
      memcpy (saved_profile, current_tool->profile,
	      sizeof(float) * 32);
      
      if (options_dialog)
	{
	  strncat(buf,current_tool->name,BUFSIZE-strlen(buf)-1);
	  buf[BUFSIZE-1] = '\0';
	  gtk_window_set_title (GTK_WINDOW (options_dialog), buf);
	}

      options_dialog_update();
    }
}

static void
options_dialog_update (void)
{
  GtkCurve *curve;
  gint i;

  if (options_dialog)
    {
      GtkAdjustment *adj = gtk_range_get_adjustment (GTK_RANGE (threshhold_slider));
      
      gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (use_threshhold_button),
				   current_tool->use_threshhold);

      adj->value = current_tool->threshhold;
      gtk_signal_emit_by_name (GTK_OBJECT (adj), "value_changed");

      curve = GTK_CURVE (GTK_GAMMA_CURVE(profile_widget)->curve);

      gtk_curve_set_curve_type(curve, GTK_CURVE_TYPE_SPLINE);

      if (curve->ctlpoint)
	g_free (curve->ctlpoint);

      curve->num_ctlpoints=32;
      curve->ctlpoint = g_malloc (sizeof(*curve->ctlpoint) * 32);
      for (i=0 ; i<32; i++)
	{
	  curve->ctlpoint[i][0] = i*CURVE_RANGE/31.;
	  curve->ctlpoint[i][1] = CURVE_RANGE * current_tool->profile[i];
	}
      gtk_curve_set_curve_type(curve, GTK_CURVE_TYPE_FREE);
    }
}

#define RADIUS 3		/* from GtkCurve */

static void
options_dialog_threshhold_cb (GtkAdjustment *adj)
{
  GdkRectangle rect;
  GtkWidget *curve = GTK_GAMMA_CURVE (profile_widget)->curve;

  current_tool->threshhold = adj->value;

  if (GTK_WIDGET_DRAWABLE (curve))
    gtk_widget_draw (curve, NULL);
}

static void
options_dialog_use_threshhold_toggled (GtkWidget *widget)
{
  current_tool->use_threshhold = GTK_TOGGLE_BUTTON (widget)->active;
}

static void
options_dialog_snarf_profile (GtkWidget *widget)
{
  gfloat tmp_profile[32];
  int i;

  gtk_curve_get_vector (GTK_CURVE (GTK_GAMMA_CURVE (profile_widget)->curve),
			32, tmp_profile);
  
  for (i=0; i<32; i++)
    {
      current_tool->profile[i] = tmp_profile[i]/CURVE_RANGE;
    }
}

static void
options_dialog_close_cb (GtkWidget *widget)
{
  gtk_widget_hide (options_dialog);
}

static gint
options_dialog_revert_cb (GtkWidget *widget)
{
  current_tool->threshhold = saved_threshhold;
  current_tool->use_threshhold = saved_use_threshhold;
  memcpy (current_tool->profile, saved_profile,
	  sizeof(float) * 32);

  options_dialog_update();
  
  return TRUE;
}

static gint
options_dialog_delete_cb (GtkWidget *widget)
{

  gtk_widget_hide (options_dialog);
  
  return TRUE;
}

