/* GStreamer process transform
 * Copyright (C) <2006> Mark Nauwelaerts <mnauw@users.sourceforge.net>

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1307, USA.
 */


#ifndef __GST_PROC_TRANS_H__
#define __GST_PROC_TRANS_H__

#include <gst/gst.h>

#define GST_TYPE_PROC_TRANS \
  gst_proc_trans_get_type ()
#define GST_PROC_TRANS(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), GST_TYPE_PROC_TRANS, GstProcTrans))
#define GST_PROC_TRANS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), GST_TYPE_PROC_TRANS, GstProcTransClass))
#define GST_PROC_TRANS_GET_CLASS(obj)\
  (G_TYPE_INSTANCE_GET_CLASS((obj), GST_TYPE_PROC_TRANS, GstProcTransClass))
#define GST_IS_PROC_TRANS(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), GST_TYPE_PROC_TRANS))
#define GST_IS_PROC_TRANS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), GST_TYPE_PROC_TRANS))
#define GST_PROC_TRANS_CAST(obj)    ((GstProcTrans *)(obj))


/**
 * GST_PROC_TRANS_SINK_NAME:
 *
 * the name of the templates for the sink pad
 */
#define GST_PROC_TRANS_SINK_NAME    "sink"
/**
 * GST_PROC_TRANS_SRC_NAME:
 *
 * the name of the templates for the source pad
 */
#define GST_PROC_TRANS_SRC_NAME     "src"

/**
 * GST_PROC_TRANS_SRC_PAD:
 * @obj: process transform instance
 *
 * Gives the pointer to the source #GstPad object of the element.
 */
#define GST_PROC_TRANS_SRC_PAD(obj)         (GST_PROC_TRANS_CAST (obj)->srcpad)

/**
 * GST_PROC_TRANS_SINK_PAD:
 * @obj: process transform instance
 *
 * Gives the pointer to the sink #GstPad object of the element.
 */
#define GST_PROC_TRANS_SINK_PAD(obj)        (GST_PROC_TRANS_CAST (obj)->sinkpad)

typedef struct _GstProcTrans GstProcTrans;
typedef struct _GstProcTransClass GstProcTransClass;

/**
 * GstProcTrans:
 * @parent: the parent element.
 *
 * The opaque #GstProcTrans data structure.
 */
struct _GstProcTrans {
  GstElement parent;

  /*< protected >*/
  /* pads */
  GstPad *srcpad;
  GstPad *sinkpad;

  /* prop info */
  /* these are initialized by base element;
   * intermediate management is for the inheritor;
   * are cleaned up by base element */
  gchar *cmd;
  GArray* args;

  /*< private >*/
  guint blocksize;

  /* communication */
  int readpipe[2];
  int writepipe[2];
  GPid pid;

  /* flow result obtained by task */
  GstFlowReturn srcresult;
};

/**
 * GstProcTransClass:
 * @set_caps: Optional.  Notify the subclass of new incaps,
 *            we should try to set @outcaps on source pad upon return.
 *            Note that @incaps can be NULL,
 *            and *@outcaps can also be left NULL in which case no caps are set.
 */
struct _GstProcTransClass {
  GstElementClass parent_class;

  /*< public >*/
  /* virtual methods for subclasses */

  gboolean      (*set_caps)     (GstProcTrans *trans, GstCaps *incaps,
                                 GstCaps **outcaps);

};

GType           gst_proc_trans_get_type         (void);

#endif /* __GST_PROC_TRANS_H__ */
