/* GStreamer Plugin
 * Copyright (C) 2006 Mark Nauwelaerts <mnauw@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "plugin-entrans.h"

struct _elements_entry
{
  gchar *name;
    GType (*type) (void);
};

static struct _elements_entry _elements[] = {
  {"fields", gst_fields_get_type},
  {"dam", gst_dam_get_type},
  {"stamp", gst_stamp_get_type},
  {"shift", gst_shift_get_type},
  {"boxscale", gst_box_scale_get_type},
  {"bufferjoin", gst_buffer_join_get_type},
  {NULL, 0}
};

static gboolean
plugin_init (GstPlugin * plugin)
{
  gint i = 0;

  oil_init ();

  while (_elements[i].name) {
    if (!gst_element_register (plugin, _elements[i].name,
            GST_RANK_NONE, (_elements[i].type) ()))
      return FALSE;
    i++;
  }

  return TRUE;
}

GST_PLUGIN_DEFINE (GST_VERSION_MAJOR,
    GST_VERSION_MINOR,
    "entrans",
    "generic pipeline elements and video transformers",
    plugin_init, VERSION, "LGPL", GST_PACKAGE_NAME, GST_PACKAGE_ORIGIN);
