<?xml version='1.0'?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'
                xml:lang="en">


<!-- ==================================================================== -->

<!-- import docbook2X stylesheet ... -->


<xsl:import href="file:///usr/share/docbook2X/xslt/man/docbook.xsl" />


<!-- ... and then customize and/or override -->

<!-- fix for quoting -->
<xsl:template match="quote">
  <xsl:variable name="depth" select="ancestor::quote" />

  <xsl:choose>
    <xsl:when test="count($depth) mod 2 = 0">
      <xsl:call-template name="gentext-text">
        <xsl:with-param name="key" select="'start-quote'" />
      </xsl:call-template>
      <xsl:call-template name="inline-plain"/>
      <xsl:call-template name="gentext-text">
        <xsl:with-param name="key" select="'end-quote'" />
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="gentext-text">
        <xsl:with-param name="key" select="'nested-start-quote'" />
      </xsl:call-template>
      <xsl:call-template name="inline-plain"/>
      <xsl:call-template name="gentext-text">
        <xsl:with-param name="key" select="'nested-end-quote'" />
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>




<!-- modify xref generation -->

<!-- make sure we have this test; is present in later versions -->

<xsl:template name="test-same-man-page">
  <xsl:param name="target" />
  <xsl:param name="node" select="." />

  <xsl:variable name="target-refentry" 
                select="$target/ancestor-or-self::refentry[1]" />
  <xsl:variable name="node-refentry" 
                select="$node/ancestor-or-self::refentry[1]" />

  <xsl:value-of select="$target-refentry
                        and count($target-refentry | $node-refentry) =
                            count($node-refentry)" />
</xsl:template>


<!-- override xref generation -->

<xsl:template match="xref">
  <xsl:variable name="target" select="key('id', @linkend)"/>

  <xsl:call-template name="check-idref">
    <xsl:with-param name="target" select="$target" />
    <xsl:with-param name="bad-content">
      <xsl:call-template name="gentext-rendering">
        <xsl:with-param name="key" select="'dangling-xref'" />
        <xsl:with-param name="content" select="string(@linkend)" />
      </xsl:call-template>
    </xsl:with-param>
    <xsl:with-param name="content">
      <xsl:variable name="same-man-page">
        <xsl:call-template name="test-same-man-page">
          <xsl:with-param name="target" select="$target" />
        </xsl:call-template>
      </xsl:variable>

      <!-- Do not refer to man page
           if current page and target page are the same;
           just use title in that case. -->
      <xsl:choose>
        <xsl:when test="$same-man-page = 'false'">
          <xsl:apply-templates select="$target" mode="xref-to" />
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates select="$target" mode="for-title" />
        </xsl:otherwise>
      </xsl:choose>
    </xsl:with-param>
  </xsl:call-template>
</xsl:template>


<xsl:template match="ulink">
  <xsl:choose>
    <xsl:when test="@type = 'http'">
      <xsl:apply-templates />
    </xsl:when>
    <xsl:otherwise>
      <xsl:apply-imports />
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- ==================================================================== -->

</xsl:stylesheet>
