//*****************************************************************************
//                              CmdNgSpiceTR.hpp                              *
//                             ------------------                             *
// Description : This class contains values associated with the NG-Spice      *
//               TRANSIENT command. It inherits from the class CmdBase.       *
// Started     : 15/10/2007                                                   *
// Last Update : 13/05/2009                                                   *
// Copyright   : (C) 2007 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDNGSPICETR_HPP
#define CMDNGSPICETR_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "gnucap/commands/CmdGnuCapTR.hpp"
#include "utility/ConvertType.hpp"

struct CmdGnuCapTR;

// Local Macro and Constant Declarations

//*****************************************************************************

struct CmdNgSpiceTR : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    wxString    m_osStart;  // The sweep start value
    wxString    m_osStop;   // The sweep stop  value
    wxString    m_osStep;   // The sweep step  value
    eInitCType  m_eInitC;   // The initial conditions

             CmdNgSpiceTR( void );
    virtual ~CmdNgSpiceTR( );

    virtual  bool  bClear   ( void );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

    CmdNgSpiceTR & operator = ( const CmdGnuCapTR & roCmdTR );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDNGSPICETR_HPP
