//*****************************************************************************
//                               NbkNgSpice.hpp                               *
//                              ----------------                              *
//  Description : Provides a container class for the analysis configuration   *
//                panels for the different analyses provided by NG-Spice      *
//                electronic circuit simulator.                               *
//  Started     : 08/05/2004                                                  *
//  Last Update : 30/06/2009                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef NBKNGSPICE_HPP
#define NBKNGSPICE_HPP

// System Includes


// wxWindows Includes

#include <wx/wx.h>
#include <wx/tooltip.h> // ???

// Application Includes

#include "TypeDefs.hpp"
#include "base/NbkSimrBase.hpp"
#include "ngspice/dialogs/DlgNgsCfgOPT.hpp"
#include "ngspice/panels/PnlNgSpiceDC.hpp"
#include "ngspice/panels/PnlNgSpiceAC.hpp"
#include "ngspice/panels/PnlNgSpiceTR.hpp"

// Local Constant Declarations


//*****************************************************************************

class NbkNgSpice : public NbkSimrBase
{
  private :

    // Analysis pages
    PnlNgSpiceDC * m_poPnlNgSpiceDC;
    PnlNgSpiceAC * m_poPnlNgSpiceAC;
    PnlNgSpiceTR * m_poPnlNgSpiceTR;

    // OPTIONS line setup dialog
    DlgNgsCfgOPT   m_oDlgCfgOPT;

  public :

    NbkNgSpice( wxWindow * poParent, wxWindowID oWinID );
    NbkNgSpice( void );
   ~NbkNgSpice( );

    virtual  bool  bClear( void );

    virtual  bool  bLoad( const SimnBase & roSimn );
    virtual  bool  bSave(       SimnBase & roSimn );

    virtual  bool  bSetPage( const wxChar * psAnalysis );
    virtual  bool  bSetPage(       eCmdType  eAnalysis );

    virtual  const  wxString & rosGetPage( void );
    virtual         eCmdType     eGetPage( void );

    // Event handlers
    void  OnBtnOptions( wxCommandEvent & roEvtCmd );

    // Leave this as the last line as private access is envoked by macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // NBKNGSPICE_HPP
