//*****************************************************************************
//                              DlgGcpCfgOPT.cpp                              *
//                             ------------------                             *
//  Started     : 14/09/2006                                                  *
//  Last Update : 10/06/2009                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "gnucap/dialogs/DlgGcpCfgOPT.hpp"

//*****************************************************************************
// Implement an event table.

BEGIN_EVENT_TABLE( DlgGcpCfgOPT, wxDialog )

  EVT_BUTTON( ID_BTN_OK,       DlgGcpCfgOPT::OnBtnOk       )
  EVT_BUTTON( ID_BTN_DEFAULTS, DlgGcpCfgOPT::OnBtnDefaults )
  EVT_BUTTON( ID_BTN_CANCEL,   DlgGcpCfgOPT::OnBtnCancel   )

END_EVENT_TABLE( )

//*****************************************************************************
// Constructor.
//
// Argument List:
//   poWin - A pointer to the dialog parent window

DlgGcpCfgOPT::DlgGcpCfgOPT( wxWindow * poWin ) :
                wxDialog( poWin, -1, wxT(""), wxDefaultPosition, wxDefaultSize,
                          wxDEFAULT_DIALOG_STYLE, wxDialogNameStr )
{
  SetTitle( wxT(" GNU-Cap OPTIONS Command Setup") );
  Initialize( );
  bClear( );
}

//*****************************************************************************
// Destructor.

DlgGcpCfgOPT::~DlgGcpCfgOPT( )
{
}

//*****************************************************************************
// Initialize object attributes.

void  DlgGcpCfgOPT::Initialize( void )
{
  // Call all the initialization functions
  Create( );
  ToolTips( );

  // Layout the of the display objects
  DoLayout( );
}

//*****************************************************************************
// Create the display objects.

void  DlgGcpCfgOPT::Create( void )
{
  wxPanel * poPnlLHS, * poPnlMID, * poPnlRHS, * poPnlRHS_Opts, * poPnlBtns;
  wxPanel * poPnl1;

  // Create the necessary panel objects
  poPnlLHS      = new wxPanel( this );
  poPnlMID      = new wxPanel( this );
  poPnlRHS      = new wxPanel( this );
  poPnlRHS_Opts = new wxPanel( poPnlRHS );
  poPnlBtns     = new wxPanel( poPnlRHS );

  // Create the PnlValue controls
  m_oPnlABSTOL  .bCreate( poPnlLHS,      ID_PNL_ABSTOL,   75 );
  m_oPnlCHGTOL  .bCreate( poPnlLHS,      ID_PNL_CHGTOL,   75 );
  m_oPnlDAMPMAX .bCreate( poPnlLHS,      ID_PNL_DAMPMAX,  75 );
  m_oPnlDAMPMIN .bCreate( poPnlLHS,      ID_PNL_DAMPMIN,  75 );
  m_oPnlDAMPST  .bCreate( poPnlLHS,      ID_PNL_DAMPST,   75 );
  m_oPnlDEFAD   .bCreate( poPnlLHS,      ID_PNL_DEFAD,    75 );
  m_oPnlDEFAS   .bCreate( poPnlLHS,      ID_PNL_DEFAS,    75 );
  m_oPnlDEFL    .bCreate( poPnlLHS,      ID_PNL_DEFL,     75 );
  m_oPnlDEFW    .bCreate( poPnlLHS,      ID_PNL_DEFW,     75 );
  m_oPnlDTMIN   .bCreate( poPnlLHS,      ID_PNL_DTMIN,    75 );
  m_oPnlDTRATIO .bCreate( poPnlLHS,      ID_PNL_DTRATIO,  75 );
  m_oPnlFLOOR   .bCreate( poPnlLHS,      ID_PNL_FLOOR,    75 );
  m_oPnlGMIN    .bCreate( poPnlLHS,      ID_PNL_GMIN,     75 );
  m_oPnlHARMS   .bCreate( poPnlLHS,      ID_PNL_HARMS,    75 );
  m_oPnlITL1    .bCreate( poPnlLHS,      ID_PNL_ITL1,     75 );
  m_oPnlITL2    .bCreate( poPnlLHS,      ID_PNL_ITL2,     75 );
  m_oPnlITL4    .bCreate( poPnlMID,      ID_PNL_ITL4,     75 );
  m_oPnlITL7    .bCreate( poPnlMID,      ID_PNL_ITL7,     75 );
  m_oPnlITL8    .bCreate( poPnlMID,      ID_PNL_ITL8,     75 );
  m_oPnlLIMIT   .bCreate( poPnlMID,      ID_PNL_LIMIT,    75 );
  m_oPnlNUMDGT  .bCreate( poPnlMID,      ID_PNL_NUMDGT,   75 );
  m_oPnlRELTOL  .bCreate( poPnlMID,      ID_PNL_RELTOL,   75 );
  m_oPnlSEED    .bCreate( poPnlMID,      ID_PNL_SEED,     75 );
  m_oPnlSHORT   .bCreate( poPnlMID,      ID_PNL_SHORT,    75 );
  m_oPnlTEMPAMB .bCreate( poPnlMID,      ID_PNL_TEMPAMB,  75 );
  m_oPnlTNOM    .bCreate( poPnlMID,      ID_PNL_TNOM,     75 );
  m_oPnlTRANSITS.bCreate( poPnlMID,      ID_PNL_TRANSITS, 75 );
  m_oPnlTRREJECT.bCreate( poPnlMID,      ID_PNL_TRREJECT, 75 );
  m_oPnlTRSTEPG .bCreate( poPnlMID,      ID_PNL_TRSTEPG,  75 );
  m_oPnlTRSTEPS .bCreate( poPnlMID,      ID_PNL_TRSTEPS,  75 );
  m_oPnlTRTOL   .bCreate( poPnlMID,      ID_PNL_TRTOL,    75 );
  m_oPnlVFLOOR  .bCreate( poPnlMID,      ID_PNL_VFLOOR,   75 );
  m_oPnlVMAX    .bCreate( poPnlRHS_Opts, ID_PNL_VMAX,     75 );
  m_oPnlVMIN    .bCreate( poPnlRHS_Opts, ID_PNL_VMIN,     75 );
  m_oPnlVNTOL   .bCreate( poPnlRHS_Opts, ID_PNL_VNTOL,    75 );
  m_oPnlWCZERO  .bCreate( poPnlRHS_Opts, ID_PNL_WCZERO,   75 );

  m_oPnlABSTOL  .bSetName( wxT("ABSTOL")   );
  m_oPnlCHGTOL  .bSetName( wxT("CHGTOL")   );
  m_oPnlDAMPMAX .bSetName( wxT("DAMPMAX")  );
  m_oPnlDAMPMIN .bSetName( wxT("DAMPMIN")  );
  m_oPnlDAMPST  .bSetName( wxT("DAMPST")   );
  m_oPnlDEFAD   .bSetName( wxT("DEFAD")    );
  m_oPnlDEFAS   .bSetName( wxT("DEFAS")    );
  m_oPnlDEFL    .bSetName( wxT("DEFL")     );
  m_oPnlDEFW    .bSetName( wxT("DEFW")     );
  m_oPnlDTMIN   .bSetName( wxT("DTMIN")    );
  m_oPnlDTRATIO .bSetName( wxT("DTRATIO")  );
  m_oPnlFLOOR   .bSetName( wxT("FLOOR")    );
  m_oPnlGMIN    .bSetName( wxT("GMIN")     );
  m_oPnlHARMS   .bSetName( wxT("HARMS")    );
  m_oPnlITL1    .bSetName( wxT("ITL1")     );
  m_oPnlITL2    .bSetName( wxT("ITL2")     );
  m_oPnlITL4    .bSetName( wxT("ITL4")     );
  m_oPnlITL7    .bSetName( wxT("ITL7")     );
  m_oPnlITL8    .bSetName( wxT("ITL8")     );
  m_oPnlLIMIT   .bSetName( wxT("LIMIT")    );
  m_oPnlNUMDGT  .bSetName( wxT("NUMDGT")   );
  m_oPnlRELTOL  .bSetName( wxT("RELTOL")   );
  m_oPnlSEED    .bSetName( wxT("SEED")     );
  m_oPnlSHORT   .bSetName( wxT("SHORT")    );
  m_oPnlTEMPAMB .bSetName( wxT("TEMPAMB")  );
  m_oPnlTNOM    .bSetName( wxT("TNOM")     );
  m_oPnlTRANSITS.bSetName( wxT("TRANSITS") );
  m_oPnlTRREJECT.bSetName( wxT("TRREJECT") );
  m_oPnlTRSTEPG .bSetName( wxT("TRSTEPG")  );
  m_oPnlTRSTEPS .bSetName( wxT("TRSTEPS")  );
  m_oPnlTRTOL   .bSetName( wxT("TRTOL")    );
  m_oPnlVFLOOR  .bSetName( wxT("VFLOOR")   );
  m_oPnlVMAX    .bSetName( wxT("VMAX")     );
  m_oPnlVMIN    .bSetName( wxT("VMIN")     );
  m_oPnlVNTOL   .bSetName( wxT("VNTOL")    );
  m_oPnlWCZERO  .bSetName( wxT("WCZERO")   );

  m_oPnlTEMPAMB .bSetUnitsType( eUNITS_TEMP );
  m_oPnlTNOM    .bSetUnitsType( eUNITS_TEMP );
  m_oPnlVMIN    .bSetUnitsType( eUNITS_VOLT );
  m_oPnlVMAX    .bSetUnitsType( eUNITS_VOLT );
  m_oPnlVNTOL   .bSetUnitsType( eUNITS_VOLT );

  m_oPnlVNTOL   .bSetDefUnits( wxT("uV") );

  m_oPnlABSTOL  .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlCHGTOL  .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDAMPST  .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlDEFAD   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDEFAS   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDEFL    .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDEFW    .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDTMIN   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlDTRATIO .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlFLOOR   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlGMIN    .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlHARMS   .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL1    .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL2    .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL4    .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL7    .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlITL8    .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlLIMIT   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlNUMDGT  .bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlSHORT   .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlTRANSITS.bSetVarType( SpinCtrl::eVAR_INT );
  m_oPnlVFLOOR  .bSetVarType( SpinCtrl::eVAR_SCI );
  m_oPnlWCZERO  .bSetVarType( SpinCtrl::eVAR_SCI );

  m_oPnlABSTOL  .bShowUnits( FALSE );
  m_oPnlCHGTOL  .bShowUnits( FALSE );
  m_oPnlDAMPMAX .bShowUnits( FALSE );
  m_oPnlDAMPMIN .bShowUnits( FALSE );
  m_oPnlDAMPST  .bShowUnits( FALSE );
  m_oPnlDEFAD   .bShowUnits( FALSE );
  m_oPnlDEFAS   .bShowUnits( FALSE );
  m_oPnlDEFL    .bShowUnits( FALSE );
  m_oPnlDEFW    .bShowUnits( FALSE );
  m_oPnlDTMIN   .bShowUnits( FALSE );
  m_oPnlDTRATIO .bShowUnits( FALSE );
  m_oPnlFLOOR   .bShowUnits( FALSE );
  m_oPnlGMIN    .bShowUnits( FALSE );
  m_oPnlHARMS   .bShowUnits( FALSE );
  m_oPnlITL1    .bShowUnits( FALSE );
  m_oPnlITL2    .bShowUnits( FALSE );
  m_oPnlITL4    .bShowUnits( FALSE );
  m_oPnlITL7    .bShowUnits( FALSE );
  m_oPnlITL8    .bShowUnits( FALSE );
  m_oPnlLIMIT   .bShowUnits( FALSE );
  m_oPnlNUMDGT  .bShowUnits( FALSE );
  m_oPnlRELTOL  .bShowUnits( FALSE );
  m_oPnlSEED    .bShowUnits( FALSE );
  m_oPnlSHORT   .bShowUnits( FALSE );
  m_oPnlTRANSITS.bShowUnits( FALSE );
  m_oPnlTRREJECT.bShowUnits( FALSE );
  m_oPnlTRSTEPG .bShowUnits( FALSE );
  m_oPnlTRSTEPS .bShowUnits( FALSE );
  m_oPnlTRTOL   .bShowUnits( FALSE );
  m_oPnlVFLOOR  .bShowUnits( FALSE );
  m_oPnlWCZERO  .bShowUnits( FALSE );

  m_oPnlABSTOL  .bSetRange( 1.00E-14, 9.99E-11 );
  m_oPnlCHGTOL  .bSetRange( 1.00E-16, 9.99E-13 );
  m_oPnlDAMPMAX .bSetRange( 0.00,     1.0      );
  m_oPnlDAMPMIN .bSetRange( 0.00,     1.0      );
  m_oPnlDAMPST  .bSetRange( 0,        37       );
  m_oPnlDEFAD   .bSetRange( 1.00E-14, 9.99E-10 );
  m_oPnlDEFAS   .bSetRange( 1.00E-14, 9.99E-10 );
  m_oPnlDEFL    .bSetRange( 1.00E-08, 9.99E-02 );
  m_oPnlDEFW    .bSetRange( 1.00E-08, 9.99E-02 );
  m_oPnlDTMIN   .bSetRange( 1.00E-14, 9.99E-12 );
  m_oPnlDTRATIO .bSetRange( 1.00E-10, 9.99E+10 );
  m_oPnlFLOOR   .bSetRange( 1.00E-23, 9.99E-19 );
  m_oPnlGMIN    .bSetRange( 1.00E-14, 9.99E-11 );
  m_oPnlHARMS   .bSetRange( 1,        100      );
  m_oPnlITL1    .bSetRange( 0,        1000     );
  m_oPnlITL2    .bSetRange( 0,        1000     );
  m_oPnlITL4    .bSetRange( 0,        1000     );
  m_oPnlITL7    .bSetRange( 0,        1000     );
  m_oPnlITL8    .bSetRange( 0,        1000     );
  m_oPnlLIMIT   .bSetRange( 1.00E-10, 9.99E+10 );
  m_oPnlNUMDGT  .bSetRange( 3,        20       );
  m_oPnlRELTOL  .bSetRange( 0.01,     100.0    );
  m_oPnlSEED    .bSetRange( 0.00,     10.0     );
  m_oPnlSHORT   .bSetRange( 1.00E-09, 9.99E-05 );
  m_oPnlTRANSITS.bSetRange( 1,        100      );
  m_oPnlTRREJECT.bSetRange( 0.01,     100.0    );
  m_oPnlTRSTEPG .bSetRange( 0.01,     100.0    );
  m_oPnlTRSTEPS .bSetRange( 0.01,     100.0    );
  m_oPnlTRTOL   .bSetRange( 0.01,     100.0    );
  m_oPnlVFLOOR  .bSetRange( 1.00E-17, 9.99E-13 );
  m_oPnlWCZERO  .bSetRange( 1.00E-09, 9.99E-08 );

  m_oPnlDAMPMAX .bSetIncSz( 0.01, 0.1  );
  m_oPnlDAMPMIN .bSetIncSz( 0.01, 0.1  );
  m_oPnlDAMPST  .bSetIncSz( 1,    1    );
  m_oPnlHARMS   .bSetIncSz( 1,    10   );
  m_oPnlITL1    .bSetIncSz( 1,    100  );
  m_oPnlITL2    .bSetIncSz( 1,    100  );
  m_oPnlITL4    .bSetIncSz( 1,    100  );
  m_oPnlITL7    .bSetIncSz( 1,    100  );
  m_oPnlITL8    .bSetIncSz( 1,    100  );
  m_oPnlNUMDGT  .bSetIncSz( 1,    1    );
  m_oPnlRELTOL  .bSetIncSz( 0.01, 10.0 );
  m_oPnlSEED    .bSetIncSz( 0.01, 1.0  );
  m_oPnlTRANSITS.bSetIncSz( 1,    10   );
  m_oPnlTRREJECT.bSetIncSz( 0.01, 10.0 );
  m_oPnlTRSTEPG .bSetIncSz( 0.01, 10.0 );
  m_oPnlTRSTEPS .bSetIncSz( 0.01, 10.0 );
  m_oPnlTRTOL   .bSetIncSz( 0.01, 10.0 );

  m_oPnlABSTOL  .bSetUnits( wxT("Amp")       );
  m_oPnlCHGTOL  .bSetUnits( wxT("Coulomb")   );
  m_oPnlDEFAD   .bSetUnits( wxT("Sq. Meter") );
  m_oPnlDEFAS   .bSetUnits( wxT("Sq. Meter") );
  m_oPnlDEFL    .bSetUnits( wxT("Meter")     );
  m_oPnlDEFW    .bSetUnits( wxT("Meter")     );
  m_oPnlDTMIN   .bSetUnits( wxT("Sec")       );
  m_oPnlGMIN    .bSetUnits( wxT("Ohm")       );
  m_oPnlLIMIT   .bSetUnits( wxT("Volt")      );
  m_oPnlRELTOL  .bSetUnits( wxT("%")         );
  m_oPnlVFLOOR  .bSetUnits( wxT("Volt")      );

  // Create the choice box controls
  poPnl1 = new wxPanel( poPnlRHS_Opts );
  m_oLblMETHOD.Create( poPnl1, ID_UNUSED, wxT("METHOD"), wxDefaultPosition,
                       wxSize( 80, -1 ), wxST_NO_AUTORESIZE );
  m_oChoMETHOD.Create( poPnl1, ID_CHO_METHOD, wxDefaultPosition,
                       wxSize( 95, -1 ) );
  m_oChoMETHOD.Append( wxT("Euler") );
  m_oChoMETHOD.Append( wxT("EulerOnly") );
  m_oChoMETHOD.Append( wxT("Trap") );
  m_oChoMETHOD.Append( wxT("TrapOnly") );
  m_oChoMETHOD.SetSelection( 0 );

  poPnl1 = new wxPanel( poPnlRHS_Opts );
  m_oLblMODE  .Create( poPnl1, ID_UNUSED, wxT("MODE"),     wxDefaultPosition,
                       wxSize( 80, -1 ), wxST_NO_AUTORESIZE );
  m_oChoMODE  .Create( poPnl1, ID_CHO_MODE, wxDefaultPosition,
                       wxSize( 95, -1 ) );
  m_oChoMODE  .Append( wxT("Analog") );
  m_oChoMODE  .Append( wxT("Digital") );
  m_oChoMODE  .Append( wxT("Mixed") );
  m_oChoMODE  .SetSelection( 0 );

  poPnl1 = new wxPanel( poPnlRHS_Opts );
  m_oLblORDER .Create( poPnl1, ID_UNUSED, wxT("ORDER"),   wxDefaultPosition,
                       wxSize( 80, -1 ), wxST_NO_AUTORESIZE );
  m_oChoORDER .Create( poPnl1, ID_CHO_ORDER, wxDefaultPosition,
                       wxSize( 95, -1 ) );
  m_oChoORDER .Append( wxT("Forward") );
  m_oChoORDER .Append( wxT("Reverse") );
  m_oChoORDER .Append( wxT("Auto") );
  m_oChoORDER .SetSelection( 0 );

  // Create the check box controls
  poPnl1 = new wxPanel( poPnlRHS_Opts );
  m_oCbxBYPASS  .Create( poPnl1, ID_CBX_BYPASS,   wxT("BYPASS   \t\t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxCSTRAY  .Create( poPnl1, ID_CBX_CSTRAY,   wxT("CSTRAY   \t\t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxINCMODE .Create( poPnl1, ID_CBX_INCMODE,  wxT("INCMODE  \t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxLUBYPASS.Create( poPnl1, ID_CBX_LUBYPASS, wxT("LUBYPASS \t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxRSTRAY  .Create( poPnl1, ID_CBX_RSTRAY,   wxT("RSTRAY   \t\t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxTRACEL  .Create( poPnl1, ID_CBX_TRACEL,   wxT("TRACEL   \t\t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );
  m_oCbxVBYPASS .Create( poPnl1, ID_CBX_VBYPASS,  wxT("VBYPASS  \t\t  "),
                         wxDefaultPosition, wxSize( -1, PNLVALUE_HT ),
                         wxALIGN_RIGHT );

  // Create the buttons
  m_oBtnOk      .Create( poPnlBtns, ID_BTN_OK,       wxT("OK") );
  m_oBtnDefaults.Create( poPnlBtns, ID_BTN_DEFAULTS, wxT("Defaults") );
  m_oBtnCancel  .Create( poPnlBtns, ID_BTN_CANCEL,   wxT("Cancel") );

// (15/10/2008) I suspect that the following just fixes a bug in wxWidgets, the
// back-ground of the parent window isn't inherited by it's children
m_oChoMETHOD  .GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
m_oChoMODE    .GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
m_oChoORDER   .GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
m_oCbxBYPASS  .GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
m_oCbxCSTRAY  .GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
m_oCbxINCMODE .GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
m_oCbxLUBYPASS.GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
m_oCbxRSTRAY  .GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
m_oCbxTRACEL  .GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
m_oCbxVBYPASS .GetParent()->SetBackgroundColour( this->GetBackgroundColour() ); // ???
}

//*****************************************************************************
// Initialize the tool tips.

void  DlgGcpCfgOPT::ToolTips( void )
{
  // Define tool tips for each control
  m_oPnlABSTOL  .SetToolTip( wxT("Absolute current error tolerance") );
  m_oPnlCHGTOL  .SetToolTip( wxT("Charge tolerance") );
  m_oPnlDAMPMAX .SetToolTip( wxT("Normal Newton damping factor (when all is well)") );
  m_oPnlDAMPMIN .SetToolTip( wxT("Newton damping factor when there's a problem") );
  m_oPnlDAMPST  .SetToolTip( wxT("Damping strategy") );
  m_oPnlDEFAD   .SetToolTip( wxT("MOS drain diffusion area") );
  m_oPnlDEFAS   .SetToolTip( wxT("MOS source diffusion area") );
  m_oPnlDEFL    .SetToolTip( wxT("MOS channel length") );
  m_oPnlDEFW    .SetToolTip( wxT("MOS channel width") );
  m_oPnlDTMIN   .SetToolTip( wxT("Minimum time step") );
  m_oPnlDTRATIO .SetToolTip( wxT("Ratio between the minimum and maximum time step") );
  m_oPnlFLOOR   .SetToolTip( wxT("Effective zero value") );
  m_oPnlGMIN    .SetToolTip( wxT("Minimum allowable conductance") );
  m_oPnlHARMS   .SetToolTip( wxT("Harmonics in Fourier analysis") );
  m_oPnlITL1    .SetToolTip( wxT("DC iteration limit") );
  m_oPnlITL2    .SetToolTip( wxT("DC transfer curve iteration limit") );
  m_oPnlITL4    .SetToolTip( wxT("Transient analysis timepoint iteration limit") );
  m_oPnlITL7    .SetToolTip( wxT("Worst case analysis iteration limit") );
  m_oPnlITL8    .SetToolTip( wxT("Convergence diagnostic iteration threshold") );
  m_oPnlLIMIT   .SetToolTip( wxT("Internal differential branch voltage limit") );
  m_oPnlNUMDGT  .SetToolTip( wxT("Number of digits to print for analysis results") );
  m_oPnlRELTOL  .SetToolTip( wxT("Relative error tolerance") );
  m_oPnlSEED    .SetToolTip( wxT("Seed used by the random number generator") );
  m_oPnlSHORT   .SetToolTip( wxT("Resistance of voltage source or short") );
  m_oPnlTEMPAMB .SetToolTip( wxT("Ambient temp. of circuit") );
  m_oPnlTNOM    .SetToolTip( wxT("Nominal temp. at which device parameters measured") );
  m_oPnlTRANSITS.SetToolTip( wxT("Mixed mode transition count") );
  m_oPnlTRREJECT.SetToolTip( wxT("Transient error rejection threshold") );
  m_oPnlTRSTEPG .SetToolTip( wxT("Maximum internal step size growth in transient analysis") );
  m_oPnlTRSTEPS .SetToolTip( wxT("Amount to decrease the transient step size by when convergence fails") );
  m_oPnlTRTOL   .SetToolTip( wxT("Transient analysis error tolerance") );
  m_oPnlVFLOOR  .SetToolTip( wxT("Effective zero value for voltage probes") );
  m_oPnlVMAX    .SetToolTip( wxT("Positive node voltage limit") );
  m_oPnlVMIN    .SetToolTip( wxT("Negative node voltage limit") );
  m_oPnlVNTOL   .SetToolTip( wxT("Absolute voltage error tolerance") );
  m_oPnlWCZERO  .SetToolTip( wxT("Worst case zero window") );

  m_oChoMETHOD.GetParent( )->SetToolTip( wxT("Numerical integration method") );
  m_oChoMODE  .GetParent( )->SetToolTip( wxT("Simulation mode selection") );
  m_oChoORDER .GetParent( )->SetToolTip( wxT("Equation ordering") );

  m_oCbxBYPASS  .SetToolTip( wxT("Bypass model evaluation if appropriate") );
  m_oCbxCSTRAY  .SetToolTip( wxT("Include capacitance in device models") );
  m_oCbxINCMODE .SetToolTip( wxT("Incrementally update the matrix") );
  m_oCbxLUBYPASS.SetToolTip( wxT("Bypass parts of LU decomposition if appropriate") );
  m_oCbxRSTRAY  .SetToolTip( wxT("Include series resistance in device models") );
  m_oCbxTRACEL  .SetToolTip( wxT("Use a queue to only load changed elements to the matrix") );
  m_oCbxVBYPASS .SetToolTip( wxT("Check only voltage to bypass model evaluation") );
}

//*****************************************************************************
// Layout the dialog display objects.

void  DlgGcpCfgOPT::DoLayout( void )
{
  wxBoxSizer  * poSzrDlg;
  wxPanel     * poPnlLHS, * poPnlMID, * poPnlRHS, * poPnlRHS_Opts, * poPnlBtns;
  wxPanel     * poPnlMETHOD, * poPnlMODE, * poPnlORDER, * poPnlCbxs;
  wxBoxSizer  * poSzrLHS, * poSzrMID, * poSzrRHS, * poSzrRHS_Opts, * poSzrBtns;
  wxBoxSizer  * poSzrMETHOD, * poSzrMODE, * poSzrORDER, * poSzrCbxs;
  wxSizerFlags  oFlags;

  // Get pointers to the various panels
  poPnlBtns     = (wxPanel *) m_oBtnOk    .GetParent( );
  poPnlLHS      = (wxPanel *) m_oPnlABSTOL.GetParent( );
  poPnlMID      = (wxPanel *) m_oPnlNUMDGT.GetParent( );
  poPnlRHS      = (wxPanel *) poPnlBtns  ->GetParent( );
  poPnlRHS_Opts = (wxPanel *) m_oPnlWCZERO.GetParent( );
  poPnlMETHOD   = (wxPanel *) m_oChoMETHOD.GetParent( );
  poPnlMODE     = (wxPanel *) m_oChoMODE  .GetParent( );
  poPnlORDER    = (wxPanel *) m_oChoORDER .GetParent( );
  poPnlCbxs     = (wxPanel *) m_oCbxBYPASS.GetParent( );

  // Create sizers to associate with the panels
  poSzrDlg      = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrLHS      = new wxStaticBoxSizer( wxVERTICAL, poPnlLHS );
  poSzrMID      = new wxStaticBoxSizer( wxVERTICAL, poPnlMID );
  poSzrRHS      = new wxBoxSizer      ( wxVERTICAL );
  poSzrRHS_Opts = new wxStaticBoxSizer( wxVERTICAL, poPnlRHS_Opts );
  poSzrBtns     = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrMETHOD   = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrMODE     = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrORDER    = new wxBoxSizer      ( wxHORIZONTAL );
  poSzrCbxs     = new wxBoxSizer      ( wxVERTICAL );

  // Set the sizers to the panels
                 SetSizer( poSzrDlg );
  poPnlLHS     ->SetSizer( poSzrLHS );
  poPnlMID     ->SetSizer( poSzrMID );
  poPnlRHS     ->SetSizer( poSzrRHS );
  poPnlRHS_Opts->SetSizer( poSzrRHS_Opts );
  poPnlBtns    ->SetSizer( poSzrBtns );
  poPnlMETHOD  ->SetSizer( poSzrMETHOD );
  poPnlMODE    ->SetSizer( poSzrMODE );
  poPnlORDER   ->SetSizer( poSzrORDER );
  poPnlCbxs    ->SetSizer( poSzrCbxs );

  // Layout the choice control panels
  oFlags.Align( wxALIGN_CENTER );
  oFlags.Border( wxTOP | wxBOTTOM, 1 );
  poSzrMETHOD->Add( &m_oLblMETHOD, oFlags );
  poSzrMETHOD->Add( &m_oChoMETHOD, oFlags );
  poSzrMETHOD->SetSizeHints( poPnlMETHOD );
  poSzrMODE  ->Add( &m_oLblMODE,   oFlags );
  poSzrMODE  ->Add( &m_oChoMODE,   oFlags );
  poSzrMODE  ->SetSizeHints( poPnlMODE );
  poSzrORDER ->Add( &m_oLblORDER,  oFlags );
  poSzrORDER ->Add( &m_oChoORDER,  oFlags );
  poSzrORDER ->SetSizeHints( poPnlORDER );

  // Layout the check box panel
  oFlags.Align( wxALIGN_LEFT );
  oFlags.Border( wxTOP, 3 );
  poSzrCbxs->Add( &m_oCbxBYPASS,   oFlags );
  oFlags.Border( wxTOP, 8 );
  poSzrCbxs->Add( &m_oCbxCSTRAY,   oFlags );
  poSzrCbxs->Add( &m_oCbxINCMODE,  oFlags );
  poSzrCbxs->Add( &m_oCbxLUBYPASS, oFlags );
  poSzrCbxs->Add( &m_oCbxRSTRAY,   oFlags );
  poSzrCbxs->Add( &m_oCbxTRACEL,   oFlags );
  poSzrCbxs->Add( &m_oCbxVBYPASS,  oFlags );
  poSzrCbxs->SetSizeHints( poPnlCbxs );

  // Layout the left hand panel
  oFlags.Align( wxALIGN_LEFT );
  oFlags.Border( wxLEFT | wxRIGHT | wxTOP, 10 );
  poSzrLHS->Add( &m_oPnlABSTOL,  oFlags );
  oFlags.Border( wxLEFT,                   10 );
  poSzrLHS->Add( &m_oPnlCHGTOL,  oFlags );
  poSzrLHS->Add( &m_oPnlDAMPMAX, oFlags );
  poSzrLHS->Add( &m_oPnlDAMPMIN, oFlags );
  poSzrLHS->Add( &m_oPnlDAMPST,  oFlags );
  poSzrLHS->Add( &m_oPnlDEFAD,   oFlags );
  poSzrLHS->Add( &m_oPnlDEFAS,   oFlags );
  poSzrLHS->Add( &m_oPnlDEFL,    oFlags );
  poSzrLHS->Add( &m_oPnlDEFW,    oFlags );
  poSzrLHS->Add( &m_oPnlDTMIN,   oFlags );
  poSzrLHS->Add( &m_oPnlDTRATIO, oFlags );
  poSzrLHS->Add( &m_oPnlFLOOR,   oFlags );
  poSzrLHS->Add( &m_oPnlGMIN,    oFlags );
  poSzrLHS->Add( &m_oPnlHARMS,   oFlags );
  poSzrLHS->Add( &m_oPnlITL1,    oFlags );
  oFlags.Border( wxLEFT | wxBOTTOM,        10 );
  poSzrLHS->Add( &m_oPnlITL2,    oFlags );
  poSzrLHS->SetSizeHints( poPnlLHS );

  // Layout the middle panel
  oFlags.Align( wxALIGN_LEFT );
  oFlags.Border( wxLEFT | wxRIGHT | wxTOP, 10 );
  poSzrMID->Add( &m_oPnlITL4,     oFlags );
  oFlags.Border( wxLEFT,                   10 );
  poSzrMID->Add( &m_oPnlITL7,     oFlags );
  poSzrMID->Add( &m_oPnlITL8,     oFlags );
  poSzrMID->Add( &m_oPnlLIMIT,    oFlags );
  poSzrMID->Add( &m_oPnlNUMDGT,   oFlags );
  poSzrMID->Add( &m_oPnlRELTOL,   oFlags );
  poSzrMID->Add( &m_oPnlSEED,     oFlags );
  poSzrMID->Add( &m_oPnlSHORT,    oFlags );
  poSzrMID->Add( &m_oPnlTEMPAMB,  oFlags );
  poSzrMID->Add( &m_oPnlTNOM,     oFlags );
  poSzrMID->Add( &m_oPnlTRANSITS, oFlags );
  poSzrMID->Add( &m_oPnlTRREJECT, oFlags );
  poSzrMID->Add( &m_oPnlTRSTEPG,  oFlags );
  poSzrMID->Add( &m_oPnlTRSTEPS,  oFlags );
  poSzrMID->Add( &m_oPnlTRTOL,    oFlags );
  oFlags.Border( wxLEFT | wxBOTTOM,        10 );
  poSzrMID->Add( &m_oPnlVFLOOR,   oFlags );
  poSzrMID->SetSizeHints( poPnlMID );

  // Layout the right hand options panel
  oFlags.Align( wxALIGN_LEFT );
  oFlags.Border( wxLEFT | wxTOP | wxRIGHT, 10 );
  poSzrRHS_Opts->Add( &m_oPnlVMAX,   oFlags );
  oFlags.Border( wxLEFT,                   10 );
  poSzrRHS_Opts->Add( &m_oPnlVMIN,   oFlags );
  poSzrRHS_Opts->Add( &m_oPnlVNTOL,  oFlags );
  poSzrRHS_Opts->Add( &m_oPnlWCZERO, oFlags );
  poSzrRHS_Opts->Add( poPnlMETHOD,   oFlags );
  poSzrRHS_Opts->Add( poPnlMODE,     oFlags );
  poSzrRHS_Opts->Add( poPnlORDER,    oFlags );
  oFlags.Border( wxLEFT | wxBOTTOM,         8 );
  poSzrRHS_Opts->Add( poPnlCbxs,     oFlags );
  poSzrRHS_Opts->SetSizeHints( poPnlRHS_Opts );

  // Layout the buttons panel
  oFlags.Border( wxTOP | wxBOTTOM, 0 );
  oFlags.Align( wxALIGN_RIGHT );
  poSzrBtns->Add( &m_oBtnOk,       oFlags );
  poSzrBtns->AddSpacer( 10 );
  oFlags.Align( wxALIGN_CENTER );
  poSzrBtns->Add( &m_oBtnDefaults, oFlags );
  poSzrBtns->AddSpacer( 10 );
  oFlags.Align( wxALIGN_LEFT );
  poSzrBtns->Add( &m_oBtnCancel,   oFlags );
  poSzrBtns->SetSizeHints( poPnlBtns );

  // Layout the right hand panel
  oFlags.Align( wxALIGN_TOP );
  oFlags.Border( wxALL, 0 );
  poSzrRHS->Add( poPnlRHS_Opts, oFlags );
  oFlags.Align( wxALIGN_BOTTOM | wxALIGN_CENTER_HORIZONTAL );
  oFlags.Border( wxTOP, 25 );
  poSzrRHS->Add( poPnlBtns,     oFlags );
  poSzrRHS->SetSizeHints( poPnlRHS );

  // Layout the overall dialog
  oFlags.Align( wxALIGN_TOP | wxALIGN_CENTER_HORIZONTAL );
  oFlags.Border( wxALL,            15 );
  GetSizer( )->Add( poPnlLHS, oFlags );
  oFlags.Border( wxTOP | wxBOTTOM, 15 );
  GetSizer( )->Add( poPnlMID, oFlags );
  oFlags.Border( wxALL,            15 );
  GetSizer( )->Add( poPnlRHS, oFlags );
  GetSizer( )->SetSizeHints( this );
}

//*****************************************************************************
// Get a pointer to a value panel associated with a control ID number.
//
// Argument List:
//   iPnlID - The control ID number
//
// Return Values:
//   Success - A pointer to the value panel
//   Failure - NULL

PnlValue * DlgGcpCfgOPT::poGetPanel( int iPnlID )
{
  switch( iPnlID )
  {
    case ID_PNL_ABSTOL   : return( &m_oPnlABSTOL   );
    case ID_PNL_CHGTOL   : return( &m_oPnlCHGTOL   );
    case ID_PNL_DAMPMAX  : return( &m_oPnlDAMPMAX  );
    case ID_PNL_DAMPMIN  : return( &m_oPnlDAMPMIN  );
    case ID_PNL_DAMPST   : return( &m_oPnlDAMPST   );
    case ID_PNL_DEFAD    : return( &m_oPnlDEFAD    );
    case ID_PNL_DEFAS    : return( &m_oPnlDEFAS    );
    case ID_PNL_DEFL     : return( &m_oPnlDEFL     );
    case ID_PNL_DEFW     : return( &m_oPnlDEFW     );
    case ID_PNL_DTMIN    : return( &m_oPnlDTMIN    );
    case ID_PNL_DTRATIO  : return( &m_oPnlDTRATIO  );
    case ID_PNL_FLOOR    : return( &m_oPnlFLOOR    );
    case ID_PNL_GMIN     : return( &m_oPnlGMIN     );
    case ID_PNL_HARMS    : return( &m_oPnlHARMS    );
    case ID_PNL_ITL1     : return( &m_oPnlITL1     );
    case ID_PNL_ITL2     : return( &m_oPnlITL2     );
    case ID_PNL_ITL4     : return( &m_oPnlITL4     );
    case ID_PNL_ITL7     : return( &m_oPnlITL7     );
    case ID_PNL_ITL8     : return( &m_oPnlITL8     );
    case ID_PNL_LIMIT    : return( &m_oPnlLIMIT    );
    case ID_PNL_NUMDGT   : return( &m_oPnlNUMDGT   );
    case ID_PNL_RELTOL   : return( &m_oPnlRELTOL   );
    case ID_PNL_SEED     : return( &m_oPnlSEED     );
    case ID_PNL_SHORT    : return( &m_oPnlSHORT    );
    case ID_PNL_TEMPAMB  : return( &m_oPnlTEMPAMB  );
    case ID_PNL_TNOM     : return( &m_oPnlTNOM     );
    case ID_PNL_TRANSITS : return( &m_oPnlTRANSITS );
    case ID_PNL_TRREJECT : return( &m_oPnlTRREJECT );
    case ID_PNL_TRSTEPG  : return( &m_oPnlTRSTEPG  );
    case ID_PNL_TRSTEPS  : return( &m_oPnlTRSTEPS  );
    case ID_PNL_TRTOL    : return( &m_oPnlTRTOL    );
    case ID_PNL_VFLOOR   : return( &m_oPnlVFLOOR   );
    case ID_PNL_VMAX     : return( &m_oPnlVMAX     );
    case ID_PNL_VMIN     : return( &m_oPnlVMIN     );
    case ID_PNL_VNTOL    : return( &m_oPnlVNTOL    );
    case ID_PNL_WCZERO   : return( &m_oPnlWCZERO   );
    default              : return( NULL );
  }
}

//*****************************************************************************
// Set the values in the value panel controls.
//
// Argument List :
//   rosCmdOPT - A reference to an OPTION command object

void  DlgGcpCfgOPT::SetValues( CmdGnuCapOPT & roCmdOPT )
{
  double  df1;
  int     i1;

  SetEvtHandlerEnabled( FALSE );

  m_oPnlABSTOL  .bSetValue( roCmdOPT.m_osABSTOL   );
  m_oPnlCHGTOL  .bSetValue( roCmdOPT.m_osCHGTOL   );
  m_oPnlDAMPMAX .bSetValue( roCmdOPT.m_osDAMPMAX  );
  m_oPnlDAMPMIN .bSetValue( roCmdOPT.m_osDAMPMIN  );
  m_oPnlDAMPST  .bSetValue( roCmdOPT.m_osDAMPST   );
  m_oPnlDEFAD   .bSetValue( roCmdOPT.m_osDEFAD    );
  m_oPnlDEFAS   .bSetValue( roCmdOPT.m_osDEFAS    );
  m_oPnlDEFL    .bSetValue( roCmdOPT.m_osDEFL     );
  m_oPnlDEFW    .bSetValue( roCmdOPT.m_osDEFW     );
  m_oPnlDTMIN   .bSetValue( roCmdOPT.m_osDTMIN    );
  m_oPnlDTRATIO .bSetValue( roCmdOPT.m_osDTRATIO  );
  m_oPnlFLOOR   .bSetValue( roCmdOPT.m_osFLOOR    );
  m_oPnlGMIN    .bSetValue( roCmdOPT.m_osGMIN     );
  m_oPnlHARMS   .bSetValue( roCmdOPT.m_osHARMS    );
  m_oPnlITL1    .bSetValue( roCmdOPT.m_osITL1     );
  m_oPnlITL2    .bSetValue( roCmdOPT.m_osITL2     );
  m_oPnlITL4    .bSetValue( roCmdOPT.m_osITL4     );
  m_oPnlITL7    .bSetValue( roCmdOPT.m_osITL7     );
  m_oPnlITL8    .bSetValue( roCmdOPT.m_osITL8     );
  m_oPnlLIMIT   .bSetValue( roCmdOPT.m_osLIMIT    );
  m_oPnlNUMDGT  .bSetValue( roCmdOPT.m_osNUMDGT   );
  m_oPnlSEED    .bSetValue( roCmdOPT.m_osSEED     );
  m_oPnlSHORT   .bSetValue( roCmdOPT.m_osSHORT    );
  m_oPnlTEMPAMB .bSetValue( roCmdOPT.m_osTEMPAMB  );
  m_oPnlTNOM    .bSetValue( roCmdOPT.m_osTNOM     );
  m_oPnlTRANSITS.bSetValue( roCmdOPT.m_osTRANSITS );
  m_oPnlTRREJECT.bSetValue( roCmdOPT.m_osTRREJECT );
  m_oPnlTRSTEPG .bSetValue( roCmdOPT.m_osTRSTEPG  );
  m_oPnlTRSTEPS .bSetValue( roCmdOPT.m_osTRSTEPS  );
  m_oPnlTRTOL   .bSetValue( roCmdOPT.m_osTRTOL    );
  m_oPnlVFLOOR  .bSetValue( roCmdOPT.m_osVFLOOR   );
  m_oPnlVMAX    .bSetValue( roCmdOPT.m_osVMAX     );
  m_oPnlVMIN    .bSetValue( roCmdOPT.m_osVMIN     );
  m_oPnlVNTOL   .bSetValue( roCmdOPT.m_osVNTOL    );
  m_oPnlWCZERO  .bSetValue( roCmdOPT.m_osWCZERO   );

  ConvertType::bStrToDFlt ( roCmdOPT.m_osRELTOL, &df1 );
  m_oPnlRELTOL  .bSetValue( df1 * 100.0 );

  for( i1=0; i1<(int)m_oChoMETHOD.GetCount( ); i1++ )
    if( m_oChoMETHOD.GetString( i1 ).IsSameAs( roCmdOPT.m_osMETHOD, FALSE ) )
      { m_oChoMETHOD.SetSelection( i1 ); break; }

  for( i1=0; i1<(int)m_oChoMODE.GetCount( ); i1++ )
    if( m_oChoMODE.GetString( i1 ).IsSameAs( roCmdOPT.m_osMODE, FALSE ) )
      { m_oChoMODE.SetSelection( i1 ); break; }

  for( i1=0; i1<(int)m_oChoORDER.GetCount( ); i1++ )
    if( m_oChoORDER.GetString( i1 ).IsSameAs( roCmdOPT.m_osORDER, FALSE ) )
      { m_oChoORDER.SetSelection( i1 ); break; }

  m_oCbxBYPASS  .SetValue( roCmdOPT.m_bBYPASS   );
  m_oCbxCSTRAY  .SetValue( roCmdOPT.m_bCSTRAY   );
  m_oCbxINCMODE .SetValue( roCmdOPT.m_bINCMODE  );
  m_oCbxLUBYPASS.SetValue( roCmdOPT.m_bLUBYPASS );
  m_oCbxRSTRAY  .SetValue( roCmdOPT.m_bRSTRAY   );
  m_oCbxTRACEL  .SetValue( roCmdOPT.m_bTRACEL   );
  m_oCbxVBYPASS .SetValue( roCmdOPT.m_bVBYPASS  );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Get the values from the value panel controls.
//
// Argument List :
//   rosCmdOPT - A reference to an OPTION command object

void  DlgGcpCfgOPT::GetValues( CmdGnuCapOPT & roCmdOPT )
{
  SetEvtHandlerEnabled( FALSE );

  roCmdOPT.m_osABSTOL   = m_oPnlABSTOL  .rosGetValue( );
  roCmdOPT.m_osCHGTOL   = m_oPnlCHGTOL  .rosGetValue( );
  roCmdOPT.m_osDAMPMAX  = m_oPnlDAMPMAX .rosGetValue( );
  roCmdOPT.m_osDAMPMIN  = m_oPnlDAMPMIN .rosGetValue( );
  roCmdOPT.m_osDAMPST   = m_oPnlDAMPST  .rosGetValue( );
  roCmdOPT.m_osDEFAD    = m_oPnlDEFAD   .rosGetValue( );
  roCmdOPT.m_osDEFAS    = m_oPnlDEFAS   .rosGetValue( );
  roCmdOPT.m_osDEFL     = m_oPnlDEFL    .rosGetValue( );
  roCmdOPT.m_osDEFW     = m_oPnlDEFW    .rosGetValue( );
  roCmdOPT.m_osDTMIN    = m_oPnlDTMIN   .rosGetValue( );
  roCmdOPT.m_osDTRATIO  = m_oPnlDTRATIO .rosGetValue( );
  roCmdOPT.m_osFLOOR    = m_oPnlFLOOR   .rosGetValue( );
  roCmdOPT.m_osGMIN     = m_oPnlGMIN    .rosGetValue( );
  roCmdOPT.m_osHARMS    = m_oPnlHARMS   .rosGetValue( );
  roCmdOPT.m_osITL1     = m_oPnlITL1    .rosGetValue( );
  roCmdOPT.m_osITL2     = m_oPnlITL2    .rosGetValue( );
  roCmdOPT.m_osITL4     = m_oPnlITL4    .rosGetValue( );
  roCmdOPT.m_osITL7     = m_oPnlITL7    .rosGetValue( );
  roCmdOPT.m_osITL8     = m_oPnlITL8    .rosGetValue( );
  roCmdOPT.m_osLIMIT    = m_oPnlLIMIT   .rosGetValue( );
  roCmdOPT.m_osNUMDGT   = m_oPnlNUMDGT  .rosGetValue( );
  roCmdOPT.m_osSEED     = m_oPnlSEED    .rosGetValue( );
  roCmdOPT.m_osSHORT    = m_oPnlSHORT   .rosGetValue( );
  roCmdOPT.m_osTEMPAMB  = m_oPnlTEMPAMB .rosGetValue( );
  roCmdOPT.m_osTNOM     = m_oPnlTNOM    .rosGetValue( );
  roCmdOPT.m_osTRANSITS = m_oPnlTRANSITS.rosGetValue( );
  roCmdOPT.m_osTRREJECT = m_oPnlTRREJECT.rosGetValue( );
  roCmdOPT.m_osTRSTEPG  = m_oPnlTRSTEPG .rosGetValue( );
  roCmdOPT.m_osTRSTEPS  = m_oPnlTRSTEPS .rosGetValue( );
  roCmdOPT.m_osTRTOL    = m_oPnlTRTOL   .rosGetValue( );
  roCmdOPT.m_osVFLOOR   = m_oPnlVFLOOR  .rosGetValue( );
  roCmdOPT.m_osVMAX     = m_oPnlVMAX    .rosGetValue( );
  roCmdOPT.m_osVMIN     = m_oPnlVMIN    .rosGetValue( );
  roCmdOPT.m_osVNTOL    = m_oPnlVNTOL   .rosGetValue( );
  roCmdOPT.m_osWCZERO   = m_oPnlWCZERO  .rosGetValue( );

  ConvertType::bFltToStr( m_oPnlRELTOL.dfGetValue()/100.0, roCmdOPT.m_osRELTOL );

  roCmdOPT.m_osMETHOD = m_oChoMETHOD.GetStringSelection( ).Upper( );
  roCmdOPT.m_osMODE   = m_oChoMODE  .GetStringSelection( ).Upper( );
  roCmdOPT.m_osORDER  = m_oChoORDER .GetStringSelection( ).Upper( );

  roCmdOPT.m_bBYPASS   = m_oCbxBYPASS  .GetValue( );
  roCmdOPT.m_bCSTRAY   = m_oCbxCSTRAY  .GetValue( );
  roCmdOPT.m_bINCMODE  = m_oCbxINCMODE .GetValue( );
  roCmdOPT.m_bLUBYPASS = m_oCbxLUBYPASS.GetValue( );
  roCmdOPT.m_bRSTRAY   = m_oCbxRSTRAY  .GetValue( );
  roCmdOPT.m_bTRACEL   = m_oCbxTRACEL  .GetValue( );
  roCmdOPT.m_bVBYPASS  = m_oCbxVBYPASS .GetValue( );

  roCmdOPT.bFormat( );

  SetEvtHandlerEnabled( TRUE );
}

//*****************************************************************************
// Set the values in the value panel controls.
//
// Argument List :
//   roCmdOPT - A reference to an OPTION command object
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgGcpCfgOPT::bSetValues( CmdGnuCapOPT & roCmdOPT )
{
  SetValues( roCmdOPT );
  m_oCmdOPT = roCmdOPT;

  return( TRUE );
}

//*****************************************************************************
// Get the values from the value panel controls.
//
// Argument List :
//   roCmdOPT - A reference to an OPTION command object
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  DlgGcpCfgOPT::bGetValues( CmdGnuCapOPT & roCmdOPT )
{
  GetValues( roCmdOPT );

  return( TRUE );
}

//*****************************************************************************
// Reset all dialog settings to defaults.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  DlgGcpCfgOPT::bClear( void )
{
  m_oCmdOPT.bClear( );

  SetValues( m_oCmdOPT );

  return( TRUE );
}

//*****************************************************************************
// Set a value panel control's value.
//
// Argument List:
//   iPnlID   - Value panel control identifier
//   rosValue - The value to set
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  DlgGcpCfgOPT::bSetValue( int iPnlID, const wxString & rosValue )
{
  PnlValue * poPnlValue;

  // Get a pointer to the appropriate value panel
  poPnlValue = poGetPanel( iPnlID );
  if( poPnlValue == NULL )                  return( FALSE );

  // Set the panel value
  if( ! poPnlValue->bSetValue( rosValue ) ) return( FALSE );

  // Create the OPTIONS command string
  m_oCmdOPT.bFormat( );

  return( TRUE );
}

//*****************************************************************************
// Get a value panel control's value.
//
// Argument List:
//   iPnlID - Value panel control identifier
//
// Return Values:
//   Success - The panel value
//   Failure - 0.0

const wxString & DlgGcpCfgOPT::rosGetValue( int iPnlID )
{
  static  wxString  osEmpty;
  PnlValue * poPnlValue;

  poPnlValue = poGetPanel( iPnlID );
  if( poPnlValue == NULL ) return( osEmpty );

  return( poPnlValue->rosGetValue( ) );
}

//*****************************************************************************
//
//                             Event Handlers
//
//*****************************************************************************
// Ok button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgGcpCfgOPT::OnBtnOk( wxCommandEvent & roEvtCmd )
{
  GetValues( m_oCmdOPT );
  EndModal( wxID_OK );
}

//*****************************************************************************
// Defaults button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgGcpCfgOPT::OnBtnDefaults( wxCommandEvent & roEvtCmd )
{
  bClear( );
}

//*****************************************************************************
// Cancel button event handler.
//
// Argument List:
//   roEvtCmd - An object holding information about the event (not used)

void  DlgGcpCfgOPT::OnBtnCancel( wxCommandEvent & roEvtCmd )
{
  SetValues( m_oCmdOPT );
  EndModal( wxID_CANCEL );
}

//*****************************************************************************
