//*****************************************************************************
//                               PnlAnaBase.hpp                               *
//                              ----------------                              *
// Description : This class derives from the wxPanel class and provides a     *
//               base class for all analysis panel classes.                   *
// Started     : 26/04/2004                                                   *
// Last Update : 19/08/2009                                                   *
// Copyright   : (C) 2004 by MSWaters                                         *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef PNLANABASE_HPP
#define PNLANABASE_HPP

// System Includes

#include <iostream>

// wxWindows Library Includes

#include <wx/wx.h>

// Application Includes

#include "TypeDefs.hpp"
#include "netlist/Component.hpp"
#include "utility/PnlValue.hpp"

// Local Constant Declarations


//*****************************************************************************

class PnlAnaBase : public wxPanel
{
  public :

    // Enumerated type for the various groups of display controls
    enum  eTypeCtlGrp
    {
      eCTLGRP_BASE,
      eCTLGRP_SCALE,
      eCTLGRP_INITC,
      eCTLGRP_SIGSRC,
      eCTLGRP_CPXPRT,
      eCTLGRP_TEMP,

      eCTLGRP_FST = eCTLGRP_BASE,
      eCTLGRP_LST = eCTLGRP_TEMP
    };

  protected :

    // Error message
    wxString     m_osErrMsg;

    // Sweep settings
    wxStaticBox  m_oSbxSwpPars;
    PnlValue     m_oPnlStart;
    PnlValue     m_oPnlStop;
    PnlValue     m_oPnlStep;

    // Step scale specifier
    wxRadioBox   m_oRbxScale;

    // Initial conditions
    wxRadioBox   m_oRbxInitC;

    // Parameters to be calculated
    wxStaticBox  m_oSbxCalcPars;
    wxCheckBox   m_oCbxVoltage;
    wxCheckBox   m_oCbxCurrent;
    wxCheckBox   m_oCbxPower;
    wxCheckBox   m_oCbxResist;

    // Complex Parts
    wxStaticBox  m_oSbxCpxPrt;
    wxCheckBox   m_oCbxMag;
    wxCheckBox   m_oCbxPhase;
    wxCheckBox   m_oCbxReal;
    wxCheckBox   m_oCbxImag;
    wxCheckBox   m_oCbxMagDb;

    // Input signal source, value and units
    wxStaticBox  m_oSbxSrc;
    wxChoice     m_oChoSrcName;
    PnlValue     m_oPnlSrcLvl;

    // .OPTIONS configuration dialog button
    wxButton     m_oBtnOPTIONS;

    // Analysis temperature
    wxStaticBox  m_oSbxTemp;
    PnlValue     m_oPnlTemp;

    // The simulator engine and analysis types of the panel
    eSimrType    m_eSimEng;
    eCmdType     m_eAnaType;

    // Functions to create the display objects
    void  CreateBase  ( void );
    void  CreateScale ( void );
    void  CreateInitC ( void );
    void  CreateSrc   ( void );
    void  CreateCpxPrt( void );
    void  CreateTemp  ( void );
    bool  bIsCreated  ( enum eTypeCtlGrp eCtlGrp );

    virtual  void  InitScale( void ) { }

    bool  bSetScale   ( eScaleType eScale );
    bool  bSetInitC   ( eInitCType eInitC );
    void  LoadSrcNames( ArrayComponent & roaCpnts, wxString osPrefixes );
    bool  bSetSrcCpnt ( Component & roCpnt );

  public :

    PnlAnaBase( wxWindow * poWin );
   ~PnlAnaBase( );

    bool  bClear( void );
    bool  bIsOk ( void ) { return( m_osErrMsg.IsEmpty( ) ); }

    bool  bSetSimrEng( eSimrType eSimrEng );
    bool  bSetAnaType( eCmdType  eAnaType );

    eSimrType  eGetSimrEng( void ) { return( m_eSimEng ); }
    eCmdType   eGetAnaType( void ) { return( m_eAnaType ); }

    const wxString & rosGetErrMsg( void ) { return( m_osErrMsg ); }
          void          SetErrMsg( const wxString & rosErrMsg )
                                     { if( bIsOk( ) ) m_osErrMsg = rosErrMsg; }

    friend  class  FrmMain;
    friend  class  NbkGnuCap;
    friend  class  NbkNgSpice;

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum ePnlItemID
    {
      ID_PNL_START = 1,
      ID_PNL_STOP,
      ID_PNL_STEP,

      ID_RBX_SCALE,
      ID_RBX_INITC,

      ID_CHO_SRCNAME,
      ID_PNL_SRCLVL,

      ID_CBX_MAG,
      ID_CBX_PHASE,
      ID_CBX_REAL,
      ID_CBX_IMAG,
      ID_CBX_MAGDB,

      ID_CBX_VOLT,
      ID_CBX_CURR,
      ID_CBX_PWR,
      ID_CBX_RES,

      ID_BTN_OPTIONS,

      ID_PNL_TEMP,

      ID_UNUSED,        // Assigned to controls for which events are not used

      ID_FST = ID_PNL_START,
      ID_LST = ID_PNL_TEMP
    };
};

//*****************************************************************************

#endif // PNLANABASE_HPP
