//*****************************************************************************
//                                  ChoUnits.hpp                              *
//                                 --------------                             *
//                                                                            *
//  Description : This class is intended to provide useful functionality for  *
//                managing the units associated with some variable. It is     *
//                particular aimed at parameters to do with electronics.      *
//  Started     : 27/03/2004                                                  *
//  Last Update : 06/09/2007                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CHOUNITS_HPP
#define CHOUNITS_HPP

// System Includes

#include <iostream>
#include <cmath>
#include <cfloat>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/string.h>
#include <wx/wxchar.h>

// Application Includes

#include "utility/ConvertType.hpp"

// Local Constant Declarations


//*****************************************************************************

class ChoUnits : public wxChoice
{
  public:

    // The various number types supported by this class
    enum eUnitsType
    {
      eUNITS_NONE = 0, // No units specified
      eUNITS_CAP,      // Capacitance
      eUNITS_IND,      // Inductance
      eUNITS_RES,      // Resistance
      eUNITS_VOLT,     // Voltage
      eUNITS_CURR,     // Current
      eUNITS_TIME,     // Time
      eUNITS_FREQ,     // Frequency
      eUNITS_PHASE,    // Phase
      eUNITS_TEMP,     // Temperature
      eUNITS_SCLR,     // Scalar

      eUNITS_INVALID,

      eUNITS_FST = eUNITS_NONE,
      eUNITS_LST = eUNITS_SCLR
    };
  
  private:

    eUnitsType  m_eUnitsType;
    wxString    m_osDefUnits;

  public:

    ChoUnits( void );
   ~ChoUnits( );

    bool  bCreate( wxWindow * poWin, wxWindowID oWinID, int iWidth=-1 );
    bool  bIsCreated( void ) { return( GetParent( )!=NULL ? TRUE : FALSE ); }

    bool  bClear( void );

    bool  bSetUnitsType( eUnitsType eUType );
    bool  bSetDefUnits ( const wxString rosUnits );
    bool  bSetUnits    ( const wxString rosUnits );
    bool  bSetUnits    ( int iExponent );

          eUnitsType   eGetUnitsType( void ) { return( m_eUnitsType ); }
    const wxString & rosGetDefUnits ( void ) { return( m_osDefUnits ); }
    const wxString & rosGetUnits    ( void );
          int          iGetUnits    ( void );

    // These functions take a value and return it including the selected units
          long        liGetValue( float fValue );
          double      dfGetValue( float fValue );
    const wxString & rosGetValue( float fValue );
};

//*****************************************************************************

#endif // CHOUNITS_HPP
