//*****************************************************************************
//                              CmdNgSpiceOPT.hpp                             *
//                             -------------------                            *
//  Description : This class contains values associated with the NG-SPICE     *
//                OPTIONS command. It inherits from the class CmdBase.        *
//  Started     : 23/08/2006                                                  *
//  Last Update : 04/10/2007                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDNGSPICEOPT_HPP
#define CMDNGSPICEOPT_HPP

// System Includes

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "utility/ConvertType.hpp"

// Local Macro and Constant Declarations

#define  NG_ABSTOL   (float) 1.0E-12
#define  NG_BADMOS3  FALSE
#define  NG_CHGTOL   (float) 1.0E-14
#define  NG_DEFAD    (float) 0.0
#define  NG_DEFAS    (float) 0.0
#define  NG_DEFL     (float) 100.0E-06
#define  NG_DEFW     (float) 100.0E-06
#define  NG_GMIN     (float) 1.0E-12
#define  NG_ITL1     (int)   100
#define  NG_ITL2     (int)   50
#define  NG_ITL4     (int)   10
#define  NG_METHOD   wxT("TRAP")
#define  NG_PIVREL   (float) 1.0E-03
#define  NG_PIVTOL   (float) 1.0E-13
#define  NG_RELTOL   (float) 0.001
#define  NG_TEMP     (float) 27.0
#define  NG_TNOM     (float) 27.0
#define  NG_TRTOL    (float) 7.0
#define  NG_VNTOL    (float) 1.0E-06

//*****************************************************************************

class CmdNgSpiceOPT : public CmdBase
{
  protected:

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

  public:

    // Options used by NG-Spice and GNU-Cap
    float     m_fABSTOL;  // Abs. current error tolerance
    float     m_fCHGTOL;  // Charge tolerance
    float     m_fDEFAD;   // MOS drain diffusion area
    float     m_fDEFAS;   // MOS source diffusion area
    float     m_fDEFL;    // MOS channel length
    float     m_fDEFW;    // MOS channel width
    float     m_fGMIN;    // Minimum allowable conductance
    int       m_iITL1;    // DC iteration limit
    int       m_iITL2;    // DC transfer curve iteration limit
    int       m_iITL4;    // TR analysis timepoint iteration limit
    wxString  m_osMETHOD; // Numerical integration method
    float     m_fRELTOL;  // Relative error tolerance
    float     m_fTNOM;    // Nominal temp. at which device parameters measured
    float     m_fTRTOL;   // TR error tolerance
    float     m_fVNTOL;   // Abs. voltage error tolerance

    // Options specific to NG-Spice
    bool      m_bBADMOS3; // Use MOS3 model with "kappa" discontinuity
    float     m_fPIVREL;  // Relative ratio of largest column entry and an acceptable pivot value
    float     m_fPIVTOL;  // Abs. min. value for matrix entry as pivot
    float     m_fTEMP;    // Operating temperature of circuit

              CmdNgSpiceOPT( void );
    virtual  ~CmdNgSpiceOPT( );

    bool  bClear( void );
};

//*****************************************************************************

#endif // CMDNGSPICEOPT_HPP
