//*****************************************************************************
//                                FrmMain.hpp                                 *
//                               -------------                                *
//  Description : The main frame used to contain the applications display     *
//                objects.                                                    *
//  Started     : 18/08/2003                                                  *
//  Last Update : 25/10/2007                                                  *
//  Copyright   : (C) 2003 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef FRMMAIN_HPP
#define FRMMAIN_HPP

// System Includes

#include <iostream>

// wxWindows Includes

#include <wx/wx.h>
#include <wx/config.h>
#include <wx/process.h>
#include <wx/cursor.h>
#include <wx/tooltip.h>
#include <wx/gbsizer.h>
#include <wx/progdlg.h>

// Application Includes

class FrmMain;  // Only line required to compile FrmMain.o

#include "TypeDefs.hpp"
#include "main/FileTasks.hpp"
#include "main/HelpTasks.hpp"
#include "main/NbkTxtCtls.hpp"
#include "main/DlgPrefs.hpp"
#include "gnucap/NbkGnuCap.hpp"
#include "ngspice/NbkNgSpice.hpp"
#include "netlist/NetList.hpp"
#include "netlist/Simulation.hpp"
#include "process/PrcGnuCap.hpp"
#include "process/PrcNgSpice.hpp"
#include "process/PrcGWave.hpp"

// Local Constant Declarations


//*****************************************************************************

class FrmMain : public wxFrame
{
  private:

    bool          m_bIsOpen;    // Flag indicating when the frame has closed
    wxConfig    * m_poConfig;   // Pointer to the configuration object
    const wxApp * m_poApp;      // Pointer to the frames parent application
    FileTasks     m_oFileTsks;  // Class to handler file operations
    HelpTasks     m_oHelpTsks;  // Class to handler help operations
    Simulation    m_oSim;       // Simulation object
    PrcSimrBase * m_poPrcSimr;  // Pointer to the simulator process
    PrcGWave      m_oPrcGWave;  // Object to view simulation results
    DlgPrefs      m_oDlgPrefs;  // The application preferences dialog
    wxString      m_osErrMsg;   // An object wide error message string

    // Display control objects
    NbkSimrBase * m_poNbkSimr;
    wxStaticText  m_oLblNodes;
    wxListBox     m_oLbxNodes;
    wxStaticText  m_oLblCpnts;
    wxListBox     m_oLbxCpnts;
    NbkTxtCtls    m_oNbkTxtCtls;

    // Object initialization functions
    void  InitMenuBar ( void );
    void  InitToolBar ( void );
    void  InitLstBoxs ( void );
    void  InitSimrEng ( void );
    void  InitNbkTCtls( void );
    void  InitStatBar ( void );
    void  InitToolTips( void );
    void  InitLogFiles( void );
    void  InitPosnSize( void );
    void  DoLayout( void );

    bool  bLoadSim  ( bool bReload=FALSE );  // Load   from Simulation object
    bool  bReloadSim( void );                // Reload from Simulation object
    bool  bSaveSim  ( void );                // Save   to   Simulation object

    void  DlgErrMsg( const wxString & rosTitle, const wxString & rosMsg );

    // Check that helper utilities are present & accounted for
    bool  bIsOkSimEng( PrcSimrBase * poPrcSimr );
    bool  bIsOkGWave ( PrcGWave    * poPrcGWave );

  public:

    FrmMain( const wxApp * poApp=NULL );
   ~FrmMain( );

    bool  bIsOpen( void ) { return( m_bIsOpen ); }

    bool  bClear( void );     // Clear the object attributes
    void  Initialize( void ); // This function calls the initialization funcs

    // Event handlers
    void  OnOpen     ( wxCommandEvent  & roEvtCmd );
    void  OnImport   ( wxCommandEvent  & roEvtCmd );
    void  OnReload   ( wxCommandEvent  & roEvtCmd );
    void  OnClose    ( wxCommandEvent  & roEvtCmd );
    void  OnAppExit  ( wxCommandEvent  & roEvtCmd );
    void  OnSimCreate( wxCommandEvent  & roEvtCmd );
    void  OnSimRun   ( wxCommandEvent  & roEvtCmd );
    void  OnSimStop  ( wxCommandEvent  & roEvtCmd );
    void  OnPlot     ( wxCommandEvent  & roEvtCmd );
    void  OnSelSimr  ( wxCommandEvent  & roEvtCmd );
    void  OnPrefs    ( wxCommandEvent  & roEvtCmd );
    void  OnManual   ( wxCommandEvent  & roEvtCmd );
    void  OnAbout    ( wxCommandEvent  & roEvtCmd );
    void  OnTbrEnter ( wxCommandEvent  & roEvtCmd );
    void  OnSysExit  ( wxCloseEvent    & roEvtClose );

    friend  class  AppGSpiceUI;
    friend  class  FileTasks;

    // In order to be able to react to a menu command, it must be given a
    // unique identifier such as a const or an enum.
    enum eFrmItemID
    {
      ID_MNU_OPEN = 1,
      ID_MNU_IMPORT,
      ID_MNU_RELOAD,
      ID_MNU_CLOSE,
      ID_MNU_EXIT,
      ID_MNU_CREATE,
      ID_MNU_RUN,
      ID_MNU_STOP,
      ID_MNU_PLOT,
      ID_MNU_GNUCAP,
      ID_MNU_NGSPICE,
      ID_MNU_PREFS,
      ID_MNU_MANUAL,
      ID_MNU_ABOUT,

      ID_TOOLBAR,
      ID_TBR_OPEN,
      ID_TBR_IMPORT,
      ID_TBR_RELOAD,
      ID_TBR_CLOSE,
      ID_TBR_CREATE,
      ID_TBR_RUN,
      ID_TBR_STOP,
      ID_TBR_PLOT,
      ID_TBR_HELP,

      ID_LBX_NODES,
      ID_LBX_CPNTS,

      ID_NBK_ANALYS,
      ID_NBK_TXTCTLS,

      ID_UNUSED,      // Assigned to controls for which events are not used

      ID_FST = ID_MNU_OPEN,
      ID_LST = ID_NBK_TXTCTLS
    };

    // Leave this as the last line as private access is envoked by this macro
    DECLARE_EVENT_TABLE( )
};

//*****************************************************************************

#endif // FRMMAIN_HPP
