//*****************************************************************************
//                              CmdGnuCapOPT.cpp                              *
//                             ------------------                             *
//  Started     : 11/09/2006                                                  *
//  Last Update : 16/10/2007                                                  *
//  Copyright   : (C) 2006 by M.S.Waters                                      *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "gnucap/commands/CmdGnuCapOPT.hpp"

//*****************************************************************************
// Constructor.

CmdGnuCapOPT::CmdGnuCapOPT( void )
{
  bClear( );
}

//*****************************************************************************
// Destructor.

CmdGnuCapOPT::~CmdGnuCapOPT( )
{
}

//*****************************************************************************
// Parse the OPTIONS command string.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdGnuCapOPT::bParse( void )
{
  wxStringTokenizer  ostk1;
  wxString           os1, os2;
  size_t             szt1;
  long               li1;
  double             df1;

  // Tokenize the command string
  ostk1.SetString( *this );
  if( ostk1.CountTokens( ) < 2 ) return( FALSE );

  // Clear object attributes but keep the command string
  bClear( );
  *((wxString *) this) = ostk1.GetString( );

  // Check command type
  os1 = ostk1.GetNextToken( ).Left( 8 ).Upper( );
  if( os1 != wxT(".OPTIONS") )   return( FALSE );
  m_osName = wxT("OPTIONS");

  m_bIsOk = TRUE;

  // Extract each parameter value
  while( ostk1.HasMoreTokens( ) )
  {
    // Extract the field name and the associated value
    os1 = ostk1.GetNextToken( );
    os2 = wxT("");
    if( (szt1=os1.find( wxT("=") )) != wxString::npos )
    {
      os2 = os1.Right( os1.Length( )-szt1-1 );
      os1 = os1.Left( szt1 );
      ConvertType::bStrToInt( os2, &li1 );
      ConvertType::bStrToFlt( os2, &df1 );
    }

    // Set the display control value
    if(      os1 == wxT("ABSTOL")   ) m_fABSTOL   = (float) df1;
    else if( os1 == wxT("BYPASS")   ) m_bBYPASS   = TRUE;
    else if( os1 == wxT("CHGTOL")   ) m_fCHGTOL   = (float) df1;
    else if( os1 == wxT("CSTRAY" )  ) m_bCSTRAY   = TRUE;
    else if( os1 == wxT("DAMPMAX")  ) m_fDAMPMAX  = (float) df1;
    else if( os1 == wxT("DAMPMIN")  ) m_fDAMPMIN  = (float) df1;
    else if( os1 == wxT("DAMPST")   ) m_iDAMPST   = (int)   li1;
    else if( os1 == wxT("DEFAD")    ) m_fDEFAD    = (float) df1;
    else if( os1 == wxT("DEFAS")    ) m_fDEFAS    = (float) df1;
    else if( os1 == wxT("DEFL")     ) m_fDEFL     = (float) df1;
    else if( os1 == wxT("DEFW")     ) m_fDEFW     = (float) df1;
    else if( os1 == wxT("DTMIN")    ) m_fDTMIN    = (float) df1;
    else if( os1 == wxT("DTRATIO")  ) m_fDTRATIO  = (float) df1;
    else if( os1 == wxT("FLOOR")    ) m_fFLOOR    = (float) df1;
    else if( os1 == wxT("GMIN")     ) m_fGMIN     = (float) df1;
    else if( os1 == wxT("HARMS")    ) m_iHARMS    = (int)   li1;
    else if( os1 == wxT("INCMODE")  ) m_bINCMODE  = TRUE;
    else if( os1 == wxT("ITL1")     ) m_iITL1     = (int)   li1;
    else if( os1 == wxT("ITL2")     ) m_iITL2     = (int)   li1;
    else if( os1 == wxT("ITL4")     ) m_iITL4     = (int)   li1;
    else if( os1 == wxT("ITL7")     ) m_iITL7     = (int)   li1;
    else if( os1 == wxT("ITL8")     ) m_iITL8     = (int)   li1;
    else if( os1 == wxT("LIMIT")    ) m_fLIMIT    = (float) df1;
    else if( os1 == wxT("LUBYPASS") ) m_bLUBYPASS = TRUE;
    else if( os1 == wxT("METHOD")   ) m_osMETHOD  = os2;
    else if( os1 == wxT("MODE")     ) m_osMODE    = os2;
    else if( os1 == wxT("NOBYP")    ) m_bBYPASS   = FALSE;
    else if( os1 == wxT("NOCSTRAY") ) m_bCSTRAY   = FALSE;
    else if( os1 == wxT("NOINC")    ) m_bINCMODE  = FALSE;
    else if( os1 == wxT("NOLUBYP")  ) m_bLUBYPASS = FALSE;
    else if( os1 == wxT("NORSTRAY") ) m_bRSTRAY   = FALSE;
    else if( os1 == wxT("NOTRACEL") ) m_bTRACEL   = FALSE;
    else if( os1 == wxT("NOVBYP")   ) m_bVBYPASS  = FALSE;
    else if( os1 == wxT("NUMDGT")   ) m_iNUMDGT   = (int)   li1;
    else if( os1 == wxT("ORDER")    ) m_osORDER   = os2;
    else if( os1 == wxT("RELTOL")   ) m_fRELTOL   = (float) df1;
    else if( os1 == wxT("RSTRAY")   ) m_bRSTRAY   = TRUE;
    else if( os1 == wxT("SEED")     ) m_fSEED     = (float) df1;
    else if( os1 == wxT("SHORT")    ) m_fSHORT    = (float) df1;
    else if( os1 == wxT("TEMPAMB")  ) m_fTEMPAMB  = (float) df1;
    else if( os1 == wxT("TNOM")     ) m_fTNOM     = (float) df1;
    else if( os1 == wxT("TRACEL")   ) m_bTRACEL   = TRUE;
    else if( os1 == wxT("TRANSITS") ) m_iTRANSITS = (int)   li1;
    else if( os1 == wxT("TRREJECT") ) m_fTRREJECT = (float) df1;
    else if( os1 == wxT("TRSTEPG")  ) m_fTRSTEPG  = (float) df1;
    else if( os1 == wxT("TRSTEPS")  ) m_fTRSTEPS  = (float) df1;
    else if( os1 == wxT("TRTOL")    ) m_fTRTOL    = (float) df1;
    else if( os1 == wxT("VBYPASS")  ) m_bVBYPASS  = TRUE;
    else if( os1 == wxT("VFLOOR")   ) m_fVFLOOR   = (float) df1;
    else if( os1 == wxT("VMAX")     ) m_fVMAX     = (float) df1;
    else if( os1 == wxT("VMIN")     ) m_fVMIN     = (float) df1;
    else if( os1 == wxT("VNTOL")    ) m_fVNTOL    = (float) df1;
    else if( os1 == wxT("WCZERO")   ) m_fWCZERO   = (float) df1;
    else m_bIsOk = FALSE;
  }

  m_bIsOk = TRUE;

  return( TRUE );
}

//*****************************************************************************
// Format the OPTIONS command string.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdGnuCapOPT::bFormat( void )
{
  wxString  os1;

  m_bIsOk = FALSE;

  os1 = wxT(".OPTIONS NOPAGE");

  if( m_fABSTOL   != GC_ABSTOL )
    os1 << wxT(" ABSTOL=")   << wxString::Format( wxT("%.2E"), m_fABSTOL );
  if( m_bBYPASS   != GC_BYPASS )
    os1 << ( m_bBYPASS ? wxT("BYPASS") : wxT("NOBYP") );
  if( m_fCHGTOL   != GC_CHGTOL )
    os1 << wxT(" CHGTOL=")   << wxString::Format( wxT("%.2E"), m_fCHGTOL );
  if( m_bCSTRAY   != GC_CSTRAY )
    os1 << ( m_bCSTRAY ? wxT("CSTRAY") : wxT("NOCSTRAY") );
  if( m_fDAMPMAX  != GC_DAMPMAX )
    os1 << wxT(" DAMPMAX=")  << wxString::Format( wxT("%.2f"), m_fDAMPMAX );
  if( m_fDAMPMIN  != GC_DAMPMIN )
    os1 << wxT(" DAMPMIN=")  << wxString::Format( wxT("%.2f"), m_fDAMPMIN );
  if( m_iDAMPST   != GC_DAMPST )
    os1 << wxT(" DAMPST=")   << m_iDAMPST;
  if( m_fDEFAD    != GC_DEFAD )
    os1 << wxT(" DEFAD=")    << wxString::Format( wxT("%.2E"), m_fDEFAD );
  if( m_fDEFAS    != GC_DEFAS )
    os1 << wxT(" DEFAS=")    << wxString::Format( wxT("%.2E"), m_fDEFAS );
  if( m_fDEFL     != GC_DEFL )
    os1 << wxT(" DEFL=")     << wxString::Format( wxT("%.2E"), m_fDEFL );
  if( m_fDEFW     != GC_DEFW )
    os1 << wxT(" DEFW=")     << wxString::Format( wxT("%.2E"), m_fDEFW );
  if( m_fDTMIN    != GC_DTMIN )
    os1 << wxT(" DTMIN=")    << wxString::Format( wxT("%.2E"), m_fDTMIN );
  if( m_fDTRATIO  != GC_DTRATIO )
    os1 << wxT(" DTRATIO=")  << wxString::Format( wxT("%.2E"), m_fDTRATIO );
  if( m_fFLOOR    != GC_FLOOR )
    os1 << wxT(" FLOOR=")    << wxString::Format( wxT("%.2E"), m_fFLOOR );
  if( m_fGMIN     != GC_GMIN )
    os1 << wxT(" GMIN=")     << wxString::Format( wxT("%.2E"), m_fGMIN );
  if( m_iHARMS    != GC_HARMS )
    os1 << wxT(" HARMS=")    << m_iHARMS;
  if( m_bINCMODE  != GC_INCMODE )
    os1 << ( m_bINCMODE ? wxT("INCMODE") : wxT("NOINC") );
  if( m_iITL1     != GC_ITL1 )
    os1 << wxT(" ITL1=")     << m_iITL1;
  if( m_iITL2     != GC_ITL2 )
    os1 << wxT(" ITL2=")     << m_iITL2;
  if( m_iITL4     != GC_ITL4 )
    os1 << wxT(" ITL4=")     << m_iITL4;
  if( m_iITL7     != GC_ITL7 )
    os1 << wxT(" ITL7=")     << m_iITL7;
  if( m_iITL8     != GC_ITL8 )
    os1 << wxT(" ITL8=")     << m_iITL8;
  if( m_fLIMIT    != GC_LIMIT )
    os1 << wxT(" LIMIT=")    << wxString::Format( wxT("%.2f"), m_fLIMIT );
  if( m_bLUBYPASS != GC_LUBYPASS )
    os1 << ( m_bLUBYPASS ? wxT("LUBYP") : wxT("NOLUBYP") );
  if( m_osMETHOD  != GC_METHOD )
    os1 << wxT(" METHOD=")   << m_osMETHOD.Upper( );
  if( m_osMODE    != GC_MODE )
    os1 << wxT(" MODE=")     << m_osMODE.Upper( );
  if( m_iNUMDGT   != GC_NUMDGT )
    os1 << wxT(" NUMDGT=")   << m_iNUMDGT;
  if( m_osORDER   != GC_ORDER )
    os1 << wxT(" ORDER=")    << m_osORDER.Upper( );
  if( m_fRELTOL   !=  GC_RELTOL )
    os1 << wxT(" RELTOL=")   << wxString::Format( wxT("%.4f"), m_fRELTOL );
  if( m_bRSTRAY   != GC_RSTRAY )
    os1 << ( m_bRSTRAY ? wxT("RSTRAY") : wxT("NORSTRAY") );
  if( m_fSEED     != GC_SEED )
    os1 << wxT(" SEED=")     << wxString::Format( wxT("%.2f"), m_fSEED );
  if( m_fSHORT    != GC_SHORT )
    os1 << wxT(" SHORT=")    << wxString::Format( wxT("%.2E"), m_fSHORT );
  if( m_fTEMPAMB  !=  GC_TEMPAMB )
    os1 << wxT(" TEMPAMB=")  << wxString::Format( wxT("%.2f"), m_fTEMPAMB );
  if( m_fTNOM     != GC_TNOM )
    os1 << wxT(" TNOM=")     << wxString::Format( wxT("%.2f"), m_fTNOM );
  if( m_bTRACEL   != GC_TRACEL )
    os1 << ( m_bTRACEL ? wxT("TRACEL") : wxT("NOTRACEL") );
  if( m_iTRANSITS != GC_TRANSITS )
    os1 << wxT(" TRANSITS=") << m_iTRANSITS;
  if( m_fTRREJECT != GC_TRREJECT )
    os1 << wxT(" TRREJECT=") << wxString::Format( wxT("%.2f"), m_fTRREJECT );
  if( m_fTRSTEPG  !=  GC_TRSTEPG )
    os1 << wxT(" TRSTEPG=")  << wxString::Format( wxT("%.2f"), m_fTRSTEPG );
  if( m_fTRSTEPS  !=  GC_TRSTEPS )
    os1 << wxT(" TRSTEPS=")  << wxString::Format( wxT("%.2f"), m_fTRSTEPS );
  if( m_fTRTOL    !=  GC_TRTOL )
    os1 << wxT(" TRTOL=")    << wxString::Format( wxT("%.2f"), m_fTRTOL );
  if( m_bVBYPASS  != GC_VBYPASS )
    os1 << ( m_bVBYPASS ? wxT("VBYPASS") : wxT("NOVBYP") );
  if( m_fVFLOOR   !=  GC_VFLOOR )
    os1 << wxT(" VFLOOR=")   << wxString::Format( wxT("%.2E"), m_fVFLOOR );
  if( m_fVMAX     !=   GC_VMAX )
    os1 << wxT(" VMAX=")     << wxString::Format( wxT("%.2f"), m_fVMAX );
  if( m_fVMIN     !=  GC_VMIN )
    os1 << wxT(" VMIN=")     << wxString::Format( wxT("%.2f"), m_fVMIN );
  if( m_fVNTOL    !=  GC_VNTOL )
    os1 << wxT(" VNTOL=")    << wxString::Format( wxT("%.2E"), m_fVNTOL );
  if( m_fWCZERO   != GC_WCZERO )
    os1 << wxT(" WCZERO=")   << wxString::Format( wxT("%.2E"), m_fWCZERO );

  m_bIsOk = TRUE;
  *((wxString *) this) = os1;

  return( TRUE );
}

//*****************************************************************************
// Clear the object attributes.
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  CmdGnuCapOPT::bClear( void )
{
  CmdBase::bClear( );

  m_fABSTOL   = GC_ABSTOL;
  m_fCHGTOL   = GC_CHGTOL;
  m_fDEFAD    = GC_DEFAD;
  m_fDEFAS    = GC_DEFAS;
  m_fDEFL     = GC_DEFL;
  m_fDEFW     = GC_DEFW;
  m_fGMIN     = GC_GMIN;
  m_iITL1     = GC_ITL1;
  m_iITL2     = GC_ITL2;
  m_iITL4     = GC_ITL4;
  m_osMETHOD  = GC_METHOD;
  m_fRELTOL   = GC_RELTOL;
  m_fTNOM     = GC_TNOM;
  m_fTRTOL    = GC_TRTOL;
  m_fVNTOL    = GC_VNTOL;

  m_iNUMDGT   = GC_NUMDGT;
  m_iITL7     = GC_ITL7;
  m_iITL8     = GC_ITL8;
  m_fSEED     = GC_SEED;
  m_fWCZERO   = GC_WCZERO;
  m_fDAMPMAX  = GC_DAMPMAX;
  m_fDAMPMIN  = GC_DAMPMIN;
  m_iDAMPST   = GC_DAMPST;
  m_fFLOOR    = GC_FLOOR;
  m_fVFLOOR   = GC_VFLOOR;
  m_fTEMPAMB  = GC_TEMPAMB;
  m_fSHORT    = GC_SHORT;
  m_iTRANSITS = GC_TRANSITS;
  m_osORDER   = GC_ORDER;
  m_osMODE    = GC_MODE;
  m_bBYPASS   = GC_BYPASS;
  m_bVBYPASS  = GC_VBYPASS;
  m_bLUBYPASS = GC_LUBYPASS;
  m_bINCMODE  = GC_INCMODE;
  m_bTRACEL   = GC_TRACEL;
  m_fLIMIT    = GC_LIMIT;
  m_fVMIN     = GC_VMIN;
  m_fVMAX     = GC_VMAX;
  m_fDTMIN    = GC_DTMIN;
  m_fDTRATIO  = GC_DTRATIO;
  m_bRSTRAY   = GC_RSTRAY;
  m_bCSTRAY   = GC_CSTRAY;
  m_iHARMS    = GC_HARMS;
  m_fTRSTEPG  = GC_TRSTEPG;
  m_fTRSTEPS  = GC_TRSTEPS;
  m_fTRREJECT = GC_TRREJECT;

  return( TRUE );
}

//*****************************************************************************
