#!/usr/bin/env python
#
# Copyright (C) 2009 Martin Owens
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

from GroundControl import __appname__, __version__
from distutils.core import setup
from distutils.command.install_lib  import install_lib
from DistUtilsExtra.command import *
from fnmatch import fnmatch

import os, platform

MODULE = 'GroundControl'

# remove MANIFEST. distutils doesn't properly update it
# when the contents of directories change.
if os.path.exists('MANIFEST'): os.remove('MANIFEST')

if platform.system() == 'FreeBSD':
        man_dir = 'man'
else:
        man_dir = 'share/man'

TOP_BUILDDIR='.'
INTLTOOL_MERGE='intltool-merge'
desktop_in='groundcontrol.desktop.in'
desktop_data='groundcontrol.desktop'

class groundcontrol_build_i18n(build_i18n.build_i18n):
    def run(self):
         build_i18n.build_i18n.run(self)
         # Build the desktop file
         os.system ("C_ALL=C " + INTLTOOL_MERGE + " -d -u -c " + TOP_BUILDDIR +
             "/po/.intltool-merge-cache " + TOP_BUILDDIR + "/po " +
             desktop_in + " " + desktop_data)

def listfiles(*dirs):
        dir, pattern = os.path.split(os.path.join(*dirs))
        return [os.path.join(dir, filename)
                for filename in os.listdir(os.path.abspath(dir))
                        if filename[0] != '.' and fnmatch(filename, pattern)]

# Generate a standard share dir
SDIR = 'share/%s/' % __appname__

setup(
        name             = __appname__,
        version          = __version__,
        description      = 'Ground Control - Launchpad Desktop Integration',
        long_description = "Integrates the Launchpad service stack with the desktop.",
        author           = 'Martin Owens',
        author_email     = 'doctormo@ubuntu.com',
        url              = 'https://code.launchpad.net/groundcontrol',
        platforms        = 'linux',
        license          = 'GPLv3',
        packages         = [ MODULE ],
        scripts          = listfiles( 'bin', 'lp-*' ),
        data_files       = [
            ( SDIR, listfiles( 'bin', '*.py' ) ),
            ( SDIR + 'glade', listfiles( 'glade', '*.glade' ) ),
            ( SDIR + 'pixmaps', listfiles( 'pixmaps', '*.svg' ) ),
            ( SDIR + 'pixmaps/chicons', listfiles( 'pixmaps/chicons', '*.svg' ) ),
            ( SDIR + 'pixmaps/status', listfiles( 'pixmaps/status', '*.svg' ) ),
            ( SDIR + 'pixmaps/person', listfiles( 'pixmaps/person', '*.svg' ) ),
            ( SDIR + 'pixmaps/project', listfiles( 'pixmaps/project', '*.svg' ) ),
            ( SDIR + 'pixmaps/bugs', listfiles( 'pixmaps/bugs', '*.svg' ) ),
            ( SDIR + 'pixmaps/animation', listfiles( 'pixmaps/animation', '*.svg' ) ),
            ( 'lib/nautilus/extensions-2.0/python/',  [ 'nautilus-groundcontrol.py' ] ),
            ( 'share/applications/', [ 'groundcontrol.desktop' ] ),
            ( 'share/pixmaps/', [ 'pixmaps/groundcontrol.svg' ] ),
            ( os.path.join(man_dir, 'man1'),  listfiles( 'doc',     '*.1' ) ),
        ],
        cmdclass={
                   'build'       : build_extra.build_extra,
                   'build_i18n'  : groundcontrol_build_i18n,
                 },
    )

