#!/usr/bin/python
#
# Copyright 2009 Martin Owens
#
# This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>
#
"""Small app for viewing change commits."""

# Import standard python libs
import gtk
import sys

from GroundControl.commiter import CommitChanges
from GroundControl.bazaar import BzrBranch, CommitStatusApp

def commit(**kwargs):
    print "Got er: %s" % kwargs
    CommitStatusApp(start_loop=True, **kwargs)

if __name__ == '__main__':
    branch = BzrBranch(sys.argv[1])
    res = CommitChanges(branch=branch, project=None,
        callback=commit,
        start_loop=True)



