// -*- c++ -*-
//------------------------------------------------------------------------------
//                               MyPropertyBox.cpp
//------------------------------------------------------------------------------
// $Id: MyPropertyBox.cpp,v 1.7 2006/12/11 03:07:22 vlg Exp $
//------------------------------------------------------------------------------
//  Copyright (c) 2002-2004 by Vladislav Grinchenko
//
//  This program is free software; you can redistribute it and/or
//  modify it under the terms of the GNU General Public License
//  as published by the Free Software Foundation; either version
//  2 of the License, or (at your option) any later version.
//------------------------------------------------------------------------------
// Date: Sun May 30 10:16:48 EDT 2004
//------------------------------------------------------------------------------

#include "MyPropertyBox.h"

/*******************************************************************************
 Class member functions
*******************************************************************************/

MyPropertyBox::
MyPropertyBox (const std::string& title_) 
	:
#ifdef IS_HILDON
	Hildon::AppView ("Perferences"),
#endif
	m_notebook (manage (new Gtk::Notebook)),
	m_property_changed (false)
{
	trace_with_mask("MyPropertyBox::MyPropertyBox",GUITRACE);

#ifdef IS_HILDON
	/** 
	 * Dialog box holds both vbox and action_area
	 */
	Gtk::VBox* dialog_box = manage (new Gtk::VBox (false, 2));
	add (*dialog_box);

    m_vbox = manage (new Gtk::VBox (false, 2));
	dialog_box->pack_start (*m_vbox, Gtk::PACK_EXPAND_WIDGET, 1);

	m_action_area = manage (new Gtk::HButtonBox);
    m_action_area->set_homogeneous ();
    m_action_area->set_spacing (8);
	m_action_area->set_layout (Gtk::BUTTONBOX_END);
	dialog_box->pack_start (*m_action_area, Gtk::PACK_SHRINK, 1);
#endif

#ifdef IS_HILDON
	set_size_request (672, 396);
#else
	set_size_request (-1,-1);
#endif

	set_title (title_.c_str ());

	m_close_button = manage (new Gtk::Button ("Close"));
	get_action_area ()->pack_start (*m_close_button);
	m_close_button->signal_clicked ().connect (
		sigc::mem_fun (*this, &MyPropertyBox::on_close_clicked));

	m_apply_button = manage (new Gtk::Button ("Apply"));
	get_action_area ()->pack_start (*m_apply_button);
	m_apply_button->signal_clicked ().connect (
		sigc::mem_fun (*this, &MyPropertyBox::on_apply_clicked));
	m_apply_button->set_sensitive (false);

#ifdef IS_HILDON
	/** Trap 'on virtual keyboard close' event to restore
	 *  original size of the dialog
	 */
	HILDONAPPWIN->signal_im_close ().connect (
		mem_fun (*this, &MyPropertyBox::hildon_im_close_cb));
#endif

	m_notebook->set_show_border ();	// to draw a bevel around the pages
	m_notebook->set_scrollable ();  // set the tab label area scrollable

	get_vbox ()->pack_start (*m_notebook);

	show_all_children ();
}

gint
MyPropertyBox::
append_page (Gtk::Widget& child_, const std::string& tab_label_)
{
	trace_with_mask("MyPropertyBox::append_page",GUITRACE);
	m_notebook->pages ().push_back (
		Gtk::Notebook_Helpers::TabElem (child_, tab_label_));
	return 0;
}

/**
 * Make Apply button sensitive and remember that something 
 * has changed.
 */
void
MyPropertyBox::
changed ()
{
	trace_with_mask("MyPropertyBox::changed",GUITRACE);

	m_apply_button->set_sensitive (true);
	m_property_changed = true;
}

void
MyPropertyBox::
on_apply_clicked ()
{
	trace_with_mask("MyPropertyBox::on_apply_clicked",GUITRACE);

	if (m_property_changed) {
		apply_impl ();
		m_property_changed = false;
	}
	m_apply_button->set_sensitive (false);
}

void
MyPropertyBox::
on_close_clicked ()
{
	trace_with_mask("MyPropertyBox::on_close_clicked",GUITRACE);
	close_impl ();
	m_apply_button->set_sensitive (false);
}

#ifdef IS_HILDON
void
MyPropertyBox::
hildon_im_close_cb ()
{
    trace_with_mask("MyPropertyBox(hildon)::hildon_im_close_cb",GUITRACE);

	set_size_request (672, 396);
}
#endif
