/*
 * Copyright © 2007 Intel Corporation
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>

#include "interface.h"
#include "support.h"

#include "grandr.h"

GtkWidget *root_window;
struct ScreenInfo *screen_info;
GtkListStore *output_store;
GtkListStore *mode_store;
GtkListStore *center_store, *left_store, *right_store, *above_store, *below_store;
GtkListStore *hotkey_store;

static void
check_server_randr_version (Display *dpy)
{
	int major, minor;
	
	if (!XRRQueryVersion (dpy, &major, &minor)) {
		fprintf (stderr, "RandR extension missing\n");
		exit (1);
	}
	
	if (major < 1 || (major >= 1 && minor < 2)) {
		fprintf (stderr, "Server RandR version before 1.2\n");
		exit (1);
	}
}

int
main (int argc, char *argv[])
{
	Display *display;
	int i;

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  g_thread_init (NULL);
  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
	add_pixmap_directory("pixmaps");
	add_pixmap_directory("../pixmaps");
  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  root_window = create_main_win ();
  gtk_widget_show (root_window);
	
	display = XOpenDisplay(NULL);
	
	check_server_randr_version (display);
	
	screen_info = read_screen_info(display);
	
	
	output_store = create_output_store ();
	set_output_store (output_store, "output_iview");
	fill_output_store (output_store, screen_info, 1, OUTPUT_CONNECTED);
	
	left_store = create_output_store ();
	set_output_store (left_store, "left_iview");
	
	right_store = create_output_store ();
	set_output_store (right_store, "right_iview");
	
	above_store = create_output_store ();
	set_output_store (above_store, "above_iview");
	
	below_store = create_output_store ();
	set_output_store (below_store, "below_iview");
	
	center_store = create_output_store ();
	set_output_store (center_store, "center_iview");
	
	mode_store = create_mode_store ();
	set_mode_store (mode_store, "modes_combo");
	
	set_basic_views (screen_info->outputs[0]);
	set_rotation_views (screen_info->outputs[0]->cur_crtc);
	set_output_layout (screen_info);
	
	hotkey_store = create_hotkey_store ();
	set_hotkey_store (hotkey_store, HOTKEY_TREEVIEW_NAME);
	fill_hotkey_store (hotkey_store);
	set_hotkeys_view (hotkey_store);

	//free_screen_info(screen_info);
	
  gtk_main ();
  return 0;
}

