/* lowlevel.c
 * Contains functions for manipulating the radio card through
 * the kernel interface
 */

/* (c) 1998-2000 by Keith Wesolowski (wesolows@foobazco.org)

 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version. 

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details. 

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
 */ 

#include <unistd.h>
#include <math.h>
#include <fcntl.h>
#include <linux/videodev.h>
#include <sys/ioctl.h>
#include "gradio.h" 

extern radio_status gr_stat;

/* Determine and return the appropriate frequency multiplier for
   the first tuner on the open video device with handle FD. */
double gradio_get_freq_fact (void) 
{
    struct video_tuner tuner;
    tuner.tuner = 0;
    if (ioctl (gr_stat.fd, VIDIOCGTUNER, &tuner) < 0)
	return .016;
    if ((tuner.flags & VIDEO_TUNER_LOW) == 0)
	return .016;
    return 16;
}

int gradio_setfreq (int fr)
{
    struct video_tuner v;
    struct video_audio va;
    unsigned long xl_freq;

    if (fr > gr_stat.freq_max)
	fr = gr_stat.freq_max;
    if (fr < gr_stat.freq_min)
	fr = gr_stat.freq_min;

    xl_freq = (unsigned long)(fr*gradio_get_freq_fact ()
			      + 0.5);
    va.volume = gr_stat.vol * (65535/(GR_VOL_MAX-GR_VOL_MIN));
    va.audio = 0;
    va.flags = VIDEO_AUDIO_VOLUME|(gr_stat.muted ? VIDEO_AUDIO_MUTE : 0);

    v.tuner = 0;
    ioctl (gr_stat.fd, VIDIOCSFREQ, &xl_freq);
    ioctl (gr_stat.fd, VIDIOCGTUNER, &v);
    ioctl (gr_stat.fd, VIDIOCSAUDIO, &va);
    gr_stat.tuned = (v.signal != 0);
    return (gr_stat.freq = fr);
}

int gradio_setvol (int lvl)
{
    struct video_audio va;
    if (lvl > GR_VOL_MAX)
	lvl = GR_VOL_MAX;
    if (lvl < GR_VOL_MIN)
	lvl = GR_VOL_MIN;

    va.flags = VIDEO_AUDIO_VOLUME|(gr_stat.muted ? VIDEO_AUDIO_MUTE : 0);
    va.audio = 0;
    va.volume = rint (lvl * (65535./(GR_VOL_MAX-GR_VOL_MIN)));
    ioctl (gr_stat.fd, VIDIOCSAUDIO, &va);
    return (gr_stat.vol = lvl);
}

void gradio_mute (int state)
{
	struct video_audio va;
	if (state)
	    va.flags = VIDEO_AUDIO_MUTE;
	else {
	    va.volume = rint (gr_stat.vol * (65535./(GR_VOL_MAX-GR_VOL_MIN)));
	    va.flags = VIDEO_AUDIO_VOLUME;
	}
	va.audio = 0;
	ioctl (gr_stat.fd, VIDIOCSAUDIO, &va);
	gr_stat.muted = state;
}
