#include "pos2img.h"
#include "ShogiGraphic.h"
#include <protocol/TBinaryProtocol.h>
#include <server/TSimpleServer.h>
#include <transport/TServerSocket.h>
#include <transport/TBufferTransports.h>
#include <boost/program_options.hpp>
#include <boost/filesystem.hpp>
#include <iostream>

using namespace facebook::thrift;
using namespace facebook::thrift::protocol;
using namespace facebook::thrift::transport;
using namespace facebook::thrift::server;
namespace bf = boost::filesystem;

using boost::shared_ptr;

/** Global variables the come from command line options */
std::string a_dir("."); /// directory to put generated image files
int port = 9090; /// Port for the server to listen

class ShogiGraphicHandler : virtual public ShogiGraphicIf {
 public:
  ShogiGraphicHandler() {
    // Your initialization goes here
  }

  void usi2png(std::string& _return, const std::string& usi) {
    const bf::path dir(a_dir);
    ProcessBoard pb(dir);
    const std::string& file_name = pb.generate(usi);
    _return.append(file_name);
  }

};

int main(int argc, char **argv) {
  namespace bp = boost::program_options;

  bp::options_description generic;
  generic.add_options()
    ("port",   bp::value<int>(&port)->default_value(9090),
               "Port for the server to listen")
    ("dir,d",  bp::value<std::string>(&a_dir)->default_value("."), 
               "Directory to put out files")
    ("help,h", "Show help message")
    ;

  bp::options_description command_line_options;
  command_line_options.add(generic);
  
  bp::options_description visible("Allowed options");
  visible.add(generic);

  bp::positional_options_description command_line_args;

  bp::variables_map vm;
  try
  {
    bp::store(bp::command_line_parser(argc, argv).
              options(command_line_options).positional(command_line_args).run(), 
              vm);
    bp::notify(vm);
    if (vm.count("help") || argc < 2)
    {
      std::cout << visible << std::endl;
      return 0;
    }
  } 
  catch (std::exception& e)
  {
    std::cerr << e.what() << std::endl;
    std::cout << command_line_options << std::endl;
    return 1;
  }

  const bf::path dir = bf::system_complete(bf::path(a_dir));
  if (!bf::exists(dir))
  {
    std::cerr << "ERROR: Directory not found: " << dir << std::endl;
    std::cout << command_line_options << std::endl;
    return 1;
  }

  shared_ptr<ShogiGraphicHandler> handler(new ShogiGraphicHandler());
  shared_ptr<TProcessor> processor(new ShogiGraphicProcessor(handler));
  shared_ptr<TServerTransport> serverTransport(new TServerSocket(port));
  shared_ptr<TTransportFactory> transportFactory(new TBufferedTransportFactory());
  shared_ptr<TProtocolFactory> protocolFactory(new TBinaryProtocolFactory());

  TSimpleServer server(processor, serverTransport, transportFactory, protocolFactory);
  server.serve();
  return 0;
}
