# tests/test_persistconfig.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.persistconfig import PersistConfig
from gozerbot.plugins import plugins
import unittest

cfg = PersistConfig()

class test_persistconfig(unittest.TestCase):
    
    def test_persistconfig(self):
        cfg.define('stringtest', "mekker")
        cfg.set("stringtest", 'bla')
        a = cfg.get("stringtest")
        self.assertEqual(a, "bla")

    def test_persistconfig2(self):
        cfg.define('stringtest', "mekker")
        cfg.set("stringtest", 'bla')
        a = cfg.get("stringtest")
        a = 'miep'
        b = cfg.get("stringtest")
        self.assertEqual(b, "bla")

    def test_persistconfig3(self):
        cfg.define('stringtest2', "")
        cfg.set("stringtest2", 'bla')
        a = cfg.get("stringtest2")
        self.assertEqual(a, "bla")

    def test_persistconfig4(self):
        cfg.define('stringtest3', "")
        cfg.set("stringtest3", 'bla')
        plugins.reload('tests', 'test_persistconfig')
        a = cfg.get("stringtest3")
        self.assertEqual(a, "bla")

    def test_persistconfig3(self):
        cfg.define('stringtest4', "")
        cfg.set("stringtest4", u'bla')
        a = cfg.get("stringtest4")
        self.assertEqual(a, "bla")
