# tests/test_ipv6.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.ircevent import Ircevent
from gozerbot.bot import Bot
from gozerbot.generic import getwho
from gozerbot.config import config
import unittest, time

class test_ipv6(unittest.TestCase):
    b = Bot('bla')

    def test_ipv6_userhost(self):
        ii = Ircevent().parse(self.b, ':qqa!~qqa@2001:888:1218:2180:0:0:0:aaaf \
PRIVMSG #bartbot :bla')
        self.assertEqual(ii.userhost, 'qqa@2001:888:1218:2180:0:0:0:aaaf')

    def test_ipv6_getwho(self):
        self.b.fakein(':localhost 311  bartbot dunk ~bart \
2001:888:1218:2180:0:0:0:aaaf * :bart')
        a = getwho(self.b, 'dunk')
        self.assertEqual(a, 'bart@2001:888:1218:2180:0:0:0:aaaf')

    def test_ipv6_getwho2(self):
        self.b.fakein(':localhost 311  bartbot dunk ~bart ::aaaf * :bart')
        a = getwho(self.b, 'dunk')
        self.assertEqual(a, 'bart@::aaaf')
