# tests/test_ignore.py
#
#

__copyright__ = 'this file is in the public domain'

from gozerbot.bot import Bot
from gozerbot.generic import stringinlist, waitforqueue
from gozerbot.plugins import plugins
import unittest, Queue

plugins.reload('gozerplugs.plugs', 'ignore')

class test_ignore(unittest.TestCase):
    b = Bot()
    b.userhosts['test'] = 'test@test'
    b.userhosts['test2'] = 'test2@test2'

    def test_ignore(self):
        result = self.b.test('ignore')
        self.assert_(stringinlist('<nick> <seconds>', result))

    def test_ignore2(self):
        result = self.b.test('ignore mekker 1000')
        self.assert_(stringinlist("can't get userhost", result))

    def test_ignore3(self):
        result = self.b.test('ignore test 100')
        self.assert_(stringinlist("OPER", result))

    def test_ignore4(self):
        result = self.b.test('ignore test2 100')
        self.b.test('ignore-del test2')
        self.assert_(stringinlist("ignoring", result))

    def test_ignore_del(self):
        result = self.b.test('ignore-del')
        self.assert_(stringinlist('<nick>', result))

    def test_ignore_del2(self):
        result = self.b.test('ignore-del mekker')
        self.assert_(stringinlist("can't get userhost", result))

    def test_ignore_del3(self):
        result = self.b.test('ignore-del test')
        self.assert_(stringinlist("can't remove", result))

    def test_ignore_del4(self):
        self.b.test('ignore test2 1000')
        result = self.b.test('ignore-del test2')
        self.assert_(stringinlist("removed", result))

    def test_ignore_list(self):
        self.b.test('ignore test2 1000')
        result = self.b.test('ignore-list')
        self.b.test('ignore-del test2')
        self.assert_(stringinlist("test2", result))
