# dbplugs/infoitem.py
#
#
#

""" information items """

__copyright__ = 'this file is in the public domain'

from gozerbot.generic import handle_exception, cchar, rlog
from gozerbot.commands import cmnds
from gozerbot.examples import examples
from gozerbot.redispatcher import rebefore, reafter
from gozerbot.aliases import aliases
from gozerbot.plughelp import plughelp
from gozerbot.callbacks import callbacks
from gozerbot.users import users
from gozerbot.db import db
import time

plughelp.add('infoitem', 'also known as factoids .. info can be retrieved \
by keyword or searched')

class Infoitems(object):

    """ information items """
 
    def add(self, item, description, userhost, ttime):
        """ add an item """
        item = item.lower()
        result = db.execute(""" INSERT INTO infoitems(item, description, \
userhost, time) VALUES(%s, %s, %s, %s) """, (item, description, \
userhost, ttime))
        return result

    def get(self, item):
        """ get infoitems """
        item = item.lower()
        result = db.execute(""" SELECT indx, item, description FROM \
infoitems WHERE item = %s """, item)
        return result

    def delete(self, indexnr):
        """ delete item with indexnr  """
        result = db.execute(""" DELETE FROM infoitems WHERE indx = %s """, \
indexnr)
        return result

    def deltxt(self, item, txt):
        """ delete item with matching txt """
        result = db.execute(""" DELETE FROM infoitems WHERE item = %s AND \
description LIKE %s """, (item, '%%%s%%' % txt))
        return result

    def size(self):
        """ return number of items """
        result = db.execute(""" SELECT COUNT(*) FROM infoitems """)
        return result[0][0]

    def searchitem(self, search):
        """ search items """
        result = db.execute(""" SELECT indx, item, description \
FROM infoitems WHERE item LIKE %s """, '%%%s%%' % search)
        return result

    def searchdescr(self, search):
        """ search descriptions """
        result = db.execute(""" SELECT indx, item, description \
FROM infoitems WHERE description LIKE %s """, '%%%s%%' % search)
        return result

info = Infoitems()

def size():
    """ return number of infoitems """
    return info.size()

def search(what, queue):
    """ search infoitems descriptions """
    rlog(10, 'infoitem', 'searched for %s' % what)
    result = info.searchdescr(what)
    if not result:
        return
    for i in result:
        queue.put_nowait("%s" % i[2])

def infopre(bot, ievent):
    """ info command precondition """
    cc = cchar(bot, ievent)
    if ievent.origtxt and cc == ievent.origtxt[0] and not ievent.usercmnd \
and ievent.txt:
        return 1

def infocb(bot, ievent):
    """ info command callback """
    if users.allowed(ievent.userhost, 'USER'):
        data = info.get(ievent.txt)
        if data:
            res = []
            for i in data:
                res.append(i[2])
            ievent.reply("infoitems for %s: " % ievent.txt, res, dot=True)

callbacks.add('PRIVMSG', infocb, infopre)

def handle_infosize(bot, ievent):
    """ info-size .. show number of information items """
    ievent.reply("we have %s infoitems" % info.size())

cmnds.add('info-size', handle_infosize, ['USER', 'WEB', 'ANON'])
examples.add('info-size', 'show number of infoitems', 'info-size')

def handle_addinfoitem(bot, ievent):
    """ <item> = <description> .. add information item """
    try:
        (what, description) = ievent.groups
    except ValueError:
        ievent.missing('<item> <description>')
        return
    if len(description) < 3:
        ievent.reply('i need at least 3 chars for the description')
        return
    what = what.strip()
    result = 0
    try:
        result = info.add(what, description, ievent.userhost, time.time())
    except Exception, ex:
        handle_exception()
        ievent.reply('ERROR: %s' % str(ex))
        return
    if result:
        ievent.reply('item added')
    else:
        ievent.reply('add failed')

rebefore.add(10, '^(.+?)\s+=\s+(.+)$', handle_addinfoitem, ['USER', 'ANON'], \
allowqueue=False)
examples.add('=', 'add description to item', 'dunk = top')

def handle_question(bot, ievent):
    """ <item> ? .. ask for information item """
    try:
        item = ievent.groups[0]
    except IndexError:
        ievent.reply('i need a argument')
        return
    item = item.strip().lower()
    result = info.get(item)
    if result:
        res = []
        for i in result:
            res.append(i[2])
        ievent.reply("infoitems for %s: " % item, res, dot=True)
    else:
        ievent.reply('no infoitems known for %s' % item)

reafter.add(10, '^(.+)\?$', handle_question, ['USER', 'WEB', 'JCOLL', 'ANON'])
reafter.add(10, '^\?(.+)$', handle_question, ['USER', 'WEB', 'JCOLL', 'ANON'])
examples.add('?', 'show infoitems of <what>', '1) test? 2) ?test')

def handle_forget(bot, ievent):
    """ info-forget <item> <txttomatch> .. remove information item """
    if '%' in ievent.rest:
        ievent.reply('no %')
        return
    if len(ievent.args) == 1:
        ievent.missing('<item> <txttomatch> (min 3 chars)')
        return
    try:
        what = ' '.join(ievent.args[:-1])
        txt = ievent.args[-1]
    except (ValueError, IndexError):
        ievent.missing('<item> <txttomatch> (min 3 chars)')
        return
    if len(txt) < 3:
        ievent.reply('i need a mask with at least 3 characters')
        return
    what = what.strip().lower()
    result = 0
    try:
        result = info.deltxt(what, txt)
    except Exception, ex:
        handle_exception()
        ievent.reply('ERROR: %s' % str(ex))
        return
    if result:
        ievent.reply('%s item(s) deleted' % result)
    else:
        ievent.reply('no items deleted')

cmnds.add('info-forget', handle_forget, ['FORGET', 'OPER', 'INFOITEM'])
examples.add('info-forget', 'info-forget <item> <txt> .. forget <item> \
containing <txt>', 'info-forget dunk bla')
aliases.data['forget'] = 'info-forget'

def handle_searchinfo(bot, ievent):
    """ info-si <txt> .. search information items keys """
    if not ievent.rest:
        ievent.missing('<txt>')
        return
    else:
        what = ievent.rest
    what = what.strip().lower()
    result = info.searchitem(what)
    if result:
        res = []
        for i in result:
            res.append("[%s] %s" % (i[1], i[2]))
        ievent.reply("the following matches %s: " % what, res, dot=True)
    else:
        ievent.reply('none found')

cmnds.add('info-si', handle_searchinfo, ['USER', 'WEB', 'ANON'])
examples.add('info-si', 'info-si <txt> .. search the infoitems keys', \
'info-si test')
aliases.data['si'] = 'info-si'

def handle_searchdescr(bot, ievent):
    """ info-sd <txt> .. search information descriptions """
    if not ievent.rest:
        ievent.missing('<txt>')
        return
    else:
        what = ievent.rest
    what = what.strip().lower()
    result = info.searchdescr(what)
    if result:
        res = []
        for i in result:
            res.append("[%s] %s" % (i[1], i[2]))
        ievent.reply("the following matches %s: " % what, res, dot=True)
    else:
        ievent.reply('none found')

cmnds.add('info-sd', handle_searchdescr, ['USER', 'WEB', 'ANON'])
examples.add('info-sd', 'info-sd <txt> ..  search description of infoitems', \
'info-sd http')
aliases.data['sd'] = 'info-sd'
aliases.data['sl'] = 'info-sd'
