# let gozerbot authenticate to NickServ
# Wijnand 'tehmaze' Modderman
# BSD License

__author__ = "Wijnand 'tehmaze' Modderman - http://tehmaze.com"
__license__ ='BSD'

from gozerbot.callbacks import callbacks
from gozerbot.commands import cmnds
from gozerbot.datadir import datadir
from gozerbot.fleet import fleet
from gozerbot.pdod import Pdod
from gozerbot.plughelp import plughelp
import os

plughelp.add('nickserv', 'authenticate the bot through (nick)services')

class NSAuth(Pdod):
    def __init__(self):
        Pdod.__init__(self, os.path.join(datadir, 'nickserv'))

    def add(self, bot, **kwargs):
        options = {
            'nickserv': 'NickServ',
            'identify': 'IDENTIFY',
        }
        options.update(kwargs)
        assert options.has_key('password'), 'A password must be set'
        for key in options.keys():
            Pdod.set(self, bot.name, key, options[key])
        self.save()

    def remove(self, bot):
        if self.has_key(bot.name):
            del self[bot.name]
            self.save()

    def has(self, bot):
        return self.has_key(bot.name)

    def identify(self, bot):
        if self.has_key(bot.name) and self.has_key2(bot.name, 'nickserv'):
            bot.sendraw('PRIVMSG %s :%s %s' % (self.get(bot.name, 'nickserv'), 
                self.get(bot.name, 'identify'), self.get(bot.name, 'password')))

    def listbots(self):
        all = []
        for bot in self.data.keys():
            all.append((bot, self.data[bot]['nickserv']))
        return all

    def handle_001(self, bot, ievent):
        self.identify(bot)

nsauth = NSAuth()
callbacks.add('001', nsauth.handle_001)

def handle_nsadd(bot, ievent):
    if len(ievent.args) < 1:
        ievent.missing('<password> [<nickserv nick>] [<identify command>]')
        return
    if nsauth.has(bot):
        ievent.reply('replacing previous configuration')
    options = {}
    if len(ievent.args) >= 1:
        options.update({'password': ievent.args[0]})
    if len(ievent.args) >= 2:
        options.update({'nickserv': ievent.args[1]})
    if len(ievent.args) >= 3:
        options.update({'identify': ' '.join(ievent.args[2:])})
    nsauth.add(bot, **options)
    ievent.reply('ok')

cmnds.add('ns-add', handle_nsadd, 'OPER')

def handle_nsdel(bot, ievent):
    if len(ievent.args) != 1:
        ievent.missing('<fleet name>')
        return
    fbot = fleet.byname(ievent.args[0])
    if not fbot:
        ievent.reply('fleet not found')
        return
    if not nsauth.has(fbot):
        ievent.reply('nickserv not configured on %s' % fbot.name)
        return
    nsauth.remove(fbot)
    ievent.reply('ok')

cmnds.add('ns-del', handle_nsdel, 'OPER')

def handle_nsauth(bot, ievent):
    if len(ievent.args) != 1:
        ievent.missing('<fleet name>')
        return
    fbot = fleet.byname(ievent.args[0])
    if not fbot:
        ievent.reply('fleet not found')
        return
    if not nsauth.has(fbot):
        ievent.reply('nickserv not configured on %s' % fbot.name)
        return
    nsauth.identify(fbot)
    ievent.reply('ok')

cmnds.add('ns-auth', handle_nsauth, 'OPER')

def handle_nslist(bot, ievent):
    all = dict(nsauth.listbots())
    rpl = []
    for bot in all.keys():
        rpl.append('%s: authenticating through %s' % (bot, all[bot]))
    rpl.sort()
    ievent.reply(' .. '.join(rpl))

cmnds.add('ns-list', handle_nslist, 'OPER')

